/*
 * Copyright 2015 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
/**
 * Measure width of a string displayed with styles provided by `className`.
 * Should only be used if measuring can't be done with existing DOM elements.
 */
function measureTextWidth(text, className) {
    if (className === void 0) { className = ""; }
    var span = document.createElement("span");
    span.classList.add(className);
    span.innerHTML = text;
    document.body.appendChild(span);
    var spanWidth = span.offsetWidth;
    span.remove();
    return spanWidth + "px";
}
exports.measureTextWidth = measureTextWidth;
function padWithZeroes(str, minLength) {
    if (str.length < minLength) {
        return "" + stringRepeat("0", minLength - str.length) + str;
    }
    else {
        return str;
    }
}
exports.padWithZeroes = padWithZeroes;
function stringRepeat(str, numTimes) {
    return new Array(numTimes + 1).join(str);
}

//# sourceMappingURL=data:application/json;base64,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
