/*
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var classNames = require("classnames");
var moment = require("moment");
var React = require("react");
var core_1 = require("@blueprintjs/core");
var datePicker_1 = require("./datePicker");
var datePickerCore_1 = require("./datePickerCore");
var DateInput = (function (_super) {
    __extends(DateInput, _super);
    function DateInput(props, context) {
        var _this = this;
        _super.call(this, props, context);
        this.displayName = "Blueprint.DateInput";
        this.inputRef = null;
        this.getDateString = function (value) {
            if (_this.isNull(value)) {
                return "";
            }
            if (value.isValid()) {
                if (_this.dateIsInRange(value)) {
                    return value.format(_this.props.format);
                }
                else {
                    return _this.props.outOfRangeMessage;
                }
            }
            return _this.props.invalidDateMessage;
        };
        this.handleClosePopover = function () {
            _this.setState({ isOpen: false });
        };
        this.handleDateChange = function (date, hasUserManuallySelectedDate) {
            var hasMonthChanged = date !== null && !_this.isNull(_this.state.value) && _this.state.value.isValid() &&
                date.getMonth() !== _this.state.value.toDate().getMonth();
            var isOpen = !(_this.props.closeOnSelection && hasUserManuallySelectedDate && !hasMonthChanged);
            if (_this.props.value === undefined) {
                _this.setState({ isInputFocused: false, isOpen: isOpen, value: moment(date) });
            }
            else {
                _this.setState({ isInputFocused: false, isOpen: isOpen });
            }
            core_1.Utils.safeInvoke(_this.props.onChange, date);
        };
        this.handleIconClick = function (e) {
            if (_this.state.isOpen) {
                if (_this.inputRef != null) {
                    _this.inputRef.blur();
                }
            }
            else {
                _this.setState({ isOpen: true });
                e.stopPropagation();
                if (_this.inputRef != null) {
                    _this.inputRef.focus();
                }
            }
        };
        this.handleInputFocus = function () {
            var valueString = _this.isNull(_this.state.value) ? "" : _this.state.value.format(_this.props.format);
            if (_this.props.openOnFocus) {
                _this.setState({ isInputFocused: true, isOpen: true, valueString: valueString });
            }
            else {
                _this.setState({ isInputFocused: true, valueString: valueString });
            }
        };
        this.handleInputClick = function (e) {
            if (_this.props.openOnFocus) {
                e.stopPropagation();
            }
        };
        this.handleInputChange = function (e) {
            var valueString = e.target.value;
            var value = moment(valueString, _this.props.format);
            if (value.isValid() && _this.dateIsInRange(value)) {
                if (_this.props.value === undefined) {
                    _this.setState({ value: value, valueString: valueString });
                }
                else {
                    _this.setState({ valueString: valueString });
                }
                core_1.Utils.safeInvoke(_this.props.onChange, value.toDate());
            }
            else {
                _this.setState({ valueString: valueString });
            }
        };
        this.handleInputBlur = function () {
            var valueString = _this.state.valueString;
            var value = moment(valueString, _this.props.format);
            if (valueString !== _this.getDateString(_this.state.value) && (!value.isValid() || !_this.dateIsInRange(value))) {
                if (_this.props.value === undefined) {
                    _this.setState({ isInputFocused: false, value: value, valueString: null });
                }
                else {
                    _this.setState({ isInputFocused: false });
                }
                if (!value.isValid()) {
                    core_1.Utils.safeInvoke(_this.props.onError, new Date(undefined));
                }
                else if (!_this.dateIsInRange(value)) {
                    core_1.Utils.safeInvoke(_this.props.onError, value.toDate());
                }
                else {
                    core_1.Utils.safeInvoke(_this.props.onChange, value.toDate());
                }
            }
            else {
                _this.setState({ isInputFocused: false });
            }
        };
        this.setInputRef = function (el) {
            _this.inputRef = el;
        };
        var defaultValue = this.props.defaultValue ? moment(this.props.defaultValue) : moment(null);
        this.state = {
            isInputFocused: false,
            isOpen: false,
            value: this.props.value !== undefined ? moment(this.props.value) : defaultValue,
            valueString: null,
        };
    }
    DateInput.prototype.render = function () {
        var dateString = this.state.isInputFocused ? this.state.valueString : this.getDateString(this.state.value);
        var date = this.state.isInputFocused ? moment(this.state.valueString, this.props.format) : this.state.value;
        var popoverContent = (React.createElement(datePicker_1.DatePicker, __assign({}, this.props, {canClearSelection: this.props.canClearSelection, defaultValue: null, onChange: this.handleDateChange, value: this.validAndInRange(this.state.value) ? this.state.value.toDate() : null})));
        var inputClasses = classNames({
            "pt-intent-danger": !(this.validAndInRange(date) || this.isNull(date) || dateString === ""),
        });
        var calendarIcon = (React.createElement(core_1.Button, {className: core_1.Classes.MINIMAL, disabled: this.props.disabled, iconName: "calendar", intent: core_1.Intent.PRIMARY, onClick: this.handleIconClick}));
        return (React.createElement(core_1.Popover, {autoFocus: false, content: popoverContent, enforceFocus: false, inline: true, isOpen: this.state.isOpen, onClose: this.handleClosePopover, popoverClassName: "pt-dateinput-popover", position: this.props.popoverPosition}, 
            React.createElement(core_1.InputGroup, {className: inputClasses, disabled: this.props.disabled, inputRef: this.setInputRef, type: "text", onBlur: this.handleInputBlur, onChange: this.handleInputChange, onClick: this.handleInputClick, onFocus: this.handleInputFocus, placeholder: this.props.format, rightElement: calendarIcon, value: dateString})
        ));
    };
    DateInput.prototype.componentWillReceiveProps = function (nextProps) {
        if (nextProps.value !== this.props.value) {
            this.setState({ value: moment(nextProps.value) });
        }
        _super.prototype.componentWillReceiveProps.call(this, nextProps);
    };
    DateInput.prototype.validAndInRange = function (value) {
        return value.isValid() && this.dateIsInRange(value);
    };
    DateInput.prototype.isNull = function (value) {
        return value.parsingFlags().nullInput;
    };
    DateInput.prototype.dateIsInRange = function (value) {
        return value.isBetween(this.props.minDate, this.props.maxDate, "day", "[]");
    };
    DateInput.defaultProps = {
        closeOnSelection: true,
        disabled: false,
        format: "YYYY-MM-DD",
        invalidDateMessage: "Invalid date",
        maxDate: datePickerCore_1.getDefaultMaxDate(),
        minDate: datePickerCore_1.getDefaultMinDate(),
        openOnFocus: true,
        outOfRangeMessage: "Out of range",
        popoverPosition: core_1.Position.BOTTOM,
    };
    return DateInput;
}(core_1.AbstractComponent));
exports.DateInput = DateInput;

//# sourceMappingURL=data:application/json;base64,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
