/*
 * Copyright 2015 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var core_1 = require("@blueprintjs/core");
var classNames = require("classnames");
var React = require("react");
var Classes = require("./common/classes");
var Utils = require("./common/utils");
var DatePickerCaption = (function (_super) {
    __extends(DatePickerCaption, _super);
    function DatePickerCaption() {
        var _this = this;
        _super.apply(this, arguments);
        this.monthArrowRefHandler = function (r) { return _this.monthArrow = r; };
        this.yearArrowRefHandler = function (r) { return _this.yearArrow = r; };
        this.handleMonthSelectChange = function (e) {
            var month = parseInt(e.target.value, 10);
            core_1.Utils.safeInvoke(_this.props.onMonthChange, month);
        };
        this.handleYearSelectChange = function (e) {
            var year = parseInt(e.target.value, 10);
            core_1.Utils.safeInvoke(_this.props.onYearChange, year);
        };
    }
    DatePickerCaption.prototype.render = function () {
        var _a = this.props, date = _a.date, locale = _a.locale, localeUtils = _a.localeUtils, minDate = _a.minDate, maxDate = _a.maxDate;
        var minYear = minDate.getFullYear();
        var maxYear = maxDate.getFullYear();
        var displayMonth = date.getMonth();
        var displayYear = date.getFullYear();
        // build the list of available months, limiting based on minDate and maxDate as necessary
        var months = localeUtils.getMonths(locale);
        var startMonth = (displayYear === minYear) ? minDate.getMonth() : 0;
        var endMonth = (displayYear === maxYear) ? maxDate.getMonth() + 1 : undefined;
        var monthOptionElements = months.map(function (name, i) {
            return React.createElement("option", {key: i, value: i.toString()}, name);
        }).slice(startMonth, endMonth);
        var years = [minYear];
        for (var year = minYear + 1; year <= maxYear; ++year) {
            years.push(year);
        }
        var yearOptionElements = years.map(function (year, i) {
            return React.createElement("option", {key: i, value: year.toString()}, year);
        });
        this.displayedMonthText = months[displayMonth];
        this.displayedYearText = displayYear.toString();
        var caretClasses = classNames("pt-icon-standard", "pt-icon-caret-down", Classes.DATEPICKER_CAPTION_CARET);
        return (React.createElement("div", {className: Classes.DATEPICKER_CAPTION}, 
            React.createElement("div", {className: Classes.DATEPICKER_CAPTION_SELECT}, 
                React.createElement("select", {className: Classes.DATEPICKER_MONTH_SELECT, onChange: this.handleMonthSelectChange, value: displayMonth.toString()}, monthOptionElements), 
                React.createElement("span", {className: caretClasses, ref: this.monthArrowRefHandler})), 
            React.createElement("div", {className: Classes.DATEPICKER_CAPTION_SELECT}, 
                React.createElement("select", {className: Classes.DATEPICKER_YEAR_SELECT, onChange: this.handleYearSelectChange, value: displayYear.toString()}, yearOptionElements), 
                React.createElement("span", {className: caretClasses, ref: this.yearArrowRefHandler}))));
    };
    DatePickerCaption.prototype.componentDidMount = function () {
        this.positionArrows();
    };
    DatePickerCaption.prototype.componentDidUpdate = function () {
        this.positionArrows();
    };
    DatePickerCaption.prototype.positionArrows = function () {
        var textClass = "pt-datepicker-caption-measure";
        var monthWidth = Utils.measureTextWidth(this.displayedMonthText, textClass);
        this.monthArrow.setAttribute("style", "left:" + monthWidth);
        var yearWidth = Utils.measureTextWidth(this.displayedYearText, textClass);
        this.yearArrow.setAttribute("style", "left:" + yearWidth);
    };
    return DatePickerCaption;
}(React.Component));
exports.DatePickerCaption = DatePickerCaption;

//# sourceMappingURL=data:application/json;base64,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
