/*
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
exports.DISABLED_MODIFIER = "disabled";
exports.OUTSIDE_MODIFIER = "outside";
exports.SELECTED_MODIFIER = "selected";
exports.SELECTED_RANGE_MODIFIER = "selected-range";
// modifiers the user can't set because they are used by Blueprint or react-day-picker
exports.DISALLOWED_MODIFIERS = [exports.DISABLED_MODIFIER, exports.OUTSIDE_MODIFIER, exports.SELECTED_MODIFIER, exports.SELECTED_RANGE_MODIFIER];
function getDefaultMaxDate() {
    var date = new Date();
    date.setFullYear(date.getFullYear());
    date.setMonth(11, 31);
    return date;
}
exports.getDefaultMaxDate = getDefaultMaxDate;
function getDefaultMinDate() {
    var date = new Date();
    date.setFullYear(date.getFullYear() - 20);
    date.setMonth(0, 1);
    return date;
}
exports.getDefaultMinDate = getDefaultMinDate;
function combineModifiers(baseModifiers, userModifiers) {
    var modifiers = baseModifiers;
    if (userModifiers != null) {
        modifiers = {};
        for (var _i = 0, _a = Object.keys(userModifiers); _i < _a.length; _i++) {
            var key = _a[_i];
            if (exports.DISALLOWED_MODIFIERS.indexOf(key) === -1) {
                modifiers[key] = userModifiers[key];
            }
        }
        for (var _b = 0, _c = Object.keys(baseModifiers); _b < _c.length; _b++) {
            var key = _c[_b];
            modifiers[key] = baseModifiers[key];
        }
    }
    return modifiers;
}
exports.combineModifiers = combineModifiers;

//# sourceMappingURL=data:application/json;base64,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
