/*
 * Copyright 2015 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
 * and https://github.com/palantir/blueprint/blob/master/PATENTS
 */
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var core_1 = require("@blueprintjs/core");
var classNames = require("classnames");
var React = require("react");
var Classes = require("./common/classes");
var Utils = require("./common/utils");
var DatePickerCaption = (function (_super) {
    tslib_1.__extends(DatePickerCaption, _super);
    function DatePickerCaption() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.containerRefHandler = function (r) { return _this.containerElement = r; };
        _this.monthArrowRefHandler = function (r) { return _this.monthArrowElement = r; };
        _this.yearArrowRefHandler = function (r) { return _this.yearArrowElement = r; };
        _this.handleMonthSelectChange = function (e) {
            var month = parseInt(e.target.value, 10);
            core_1.Utils.safeInvoke(_this.props.onMonthChange, month);
        };
        _this.handleYearSelectChange = function (e) {
            var year = parseInt(e.target.value, 10);
            core_1.Utils.safeInvoke(_this.props.onYearChange, year);
        };
        return _this;
    }
    DatePickerCaption.prototype.render = function () {
        var _a = this.props, date = _a.date, locale = _a.locale, localeUtils = _a.localeUtils, minDate = _a.minDate, maxDate = _a.maxDate;
        var minYear = minDate.getFullYear();
        var maxYear = maxDate.getFullYear();
        var displayMonth = date.getMonth();
        var displayYear = date.getFullYear();
        // build the list of available months, limiting based on minDate and maxDate as necessary
        var months = localeUtils.getMonths(locale);
        var startMonth = (displayYear === minYear) ? minDate.getMonth() : 0;
        var endMonth = (displayYear === maxYear) ? maxDate.getMonth() + 1 : undefined;
        var monthOptionElements = months.map(function (name, i) {
            return React.createElement("option", { key: i, value: i.toString() }, name);
        }).slice(startMonth, endMonth);
        var years = [minYear];
        for (var year = minYear + 1; year <= maxYear; ++year) {
            years.push(year);
        }
        var yearOptionElements = years.map(function (year, i) {
            return React.createElement("option", { key: i, value: year.toString() }, year);
        });
        // allow out-of-bounds years but disable the option. this handles the Dec 2016 case in #391.
        if (displayYear > maxYear) {
            yearOptionElements.push(React.createElement("option", { key: "next", disabled: true, value: displayYear.toString() }, displayYear));
        }
        this.displayedMonthText = months[displayMonth];
        this.displayedYearText = displayYear.toString();
        var caretClasses = classNames("pt-icon-standard", "pt-icon-caret-down", Classes.DATEPICKER_CAPTION_CARET);
        return (React.createElement("div", { className: Classes.DATEPICKER_CAPTION, ref: this.containerRefHandler },
            React.createElement("div", { className: Classes.DATEPICKER_CAPTION_SELECT },
                React.createElement("select", { className: Classes.DATEPICKER_MONTH_SELECT, onChange: this.handleMonthSelectChange, value: displayMonth.toString() }, monthOptionElements),
                React.createElement("span", { className: caretClasses, ref: this.monthArrowRefHandler })),
            React.createElement("div", { className: Classes.DATEPICKER_CAPTION_SELECT },
                React.createElement("select", { className: Classes.DATEPICKER_YEAR_SELECT, onChange: this.handleYearSelectChange, value: displayYear.toString() }, yearOptionElements),
                React.createElement("span", { className: caretClasses, ref: this.yearArrowRefHandler }))));
    };
    DatePickerCaption.prototype.componentDidMount = function () {
        this.positionArrows();
    };
    DatePickerCaption.prototype.componentDidUpdate = function () {
        this.positionArrows();
    };
    DatePickerCaption.prototype.positionArrows = function () {
        // pass our container element to the measureTextWidth utility to ensure
        // that we're measuring the width of text as sized within this component.
        var textClass = "pt-datepicker-caption-measure";
        var monthWidth = Utils.measureTextWidth(this.displayedMonthText, textClass, this.containerElement);
        this.monthArrowElement.setAttribute("style", "left:" + monthWidth);
        var yearWidth = Utils.measureTextWidth(this.displayedYearText, textClass, this.containerElement);
        this.yearArrowElement.setAttribute("style", "left:" + yearWidth);
    };
    return DatePickerCaption;
}(React.Component));
exports.DatePickerCaption = DatePickerCaption;

//# sourceMappingURL=datePickerCaption.js.map
