import { DateRange, DateRangeBoundary } from "./common/dateUtils";
export interface IDateRangeSelectionState {
    /**
     * The boundary that would be modified by clicking the provided `day`.
     */
    boundary?: DateRangeBoundary;
    /**
     * The date range that would be selected after clicking the provided `day`.
     */
    dateRange: DateRange;
}
export declare class DateRangeSelectionStrategy {
    /**
     * Returns the new date-range and the boundary that would be affected if `day` were clicked. The
     * affected boundary may be different from the provided `boundary` in some cases. For example,
     * clicking a particular boundary's selected date will always deselect it regardless of which
     * `boundary` you provide to this function (because it's simply a more intuitive interaction).
     */
    static getNextState(currentRange: DateRange, day: Date, allowSingleDayRange: boolean, boundary?: DateRangeBoundary): IDateRangeSelectionState;
    private static getNextStateForBoundary(currentRange, day, allowSingleDayRange, boundary);
    private static getDefaultNextState(selectedRange, day, allowSingleDayRange);
    private static getOtherBoundary(boundary);
    private static getBoundaryDate(boundary, dateRange);
    private static isOverlappingOtherBoundary(boundary, boundaryDate, otherBoundaryDate);
    private static createRangeForBoundary(boundary, boundaryDate, otherBoundaryDate);
    private static createRange(a, b, allowSingleDayRange);
}
