/*
 * Copyright 2015 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
 * and https://github.com/palantir/blueprint/blob/master/PATENTS
 */
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var classNames = require("classnames");
var React = require("react");
var core_1 = require("@blueprintjs/core");
var Classes = require("./common/classes");
var DateUtils = require("./common/dateUtils");
var datePicker_1 = require("./datePicker");
var timePicker_1 = require("./timePicker");
var DateTimePicker = (function (_super) {
    tslib_1.__extends(DateTimePicker, _super);
    function DateTimePicker(props, context) {
        var _this = _super.call(this, props, context) || this;
        _this.handleDateChange = function (dateValue, isUserChange) {
            if (_this.props.value === undefined) {
                _this.setState({ dateValue: dateValue });
            }
            var value = DateUtils.getDateTime(dateValue, _this.state.timeValue);
            core_1.Utils.safeInvoke(_this.props.onChange, value, isUserChange);
        };
        _this.handleTimeChange = function (timeValue) {
            if (_this.props.value === undefined) {
                _this.setState({ timeValue: timeValue });
            }
            var value = DateUtils.getDateTime(_this.state.dateValue, timeValue);
            core_1.Utils.safeInvoke(_this.props.onChange, value, true);
        };
        var initialValue = (_this.props.value !== undefined) ? _this.props.value : _this.props.defaultValue;
        _this.state = {
            dateValue: initialValue,
            timeValue: initialValue,
        };
        return _this;
    }
    DateTimePicker.prototype.render = function () {
        var value = DateUtils.getDateTime(this.state.dateValue, this.state.timeValue);
        return (React.createElement("div", { className: classNames(Classes.DATETIMEPICKER, this.props.className) },
            React.createElement(datePicker_1.DatePicker, tslib_1.__assign({}, this.props.datePickerProps, { canClearSelection: this.props.canClearSelection, onChange: this.handleDateChange, value: value })),
            React.createElement(timePicker_1.TimePicker, tslib_1.__assign({}, this.props.timePickerProps, { onChange: this.handleTimeChange, value: value }))));
    };
    DateTimePicker.prototype.componentWillReceiveProps = function (nextProps) {
        if (this.props.value === nextProps.value) {
            return;
        }
        else if (nextProps.value != null) {
            this.setState({
                dateValue: nextProps.value,
                timeValue: nextProps.value,
            });
        }
        else {
            // clear only the date to remove the selected-date style in the calendar
            this.setState({ dateValue: null });
        }
    };
    return DateTimePicker;
}(core_1.AbstractComponent));
DateTimePicker.defaultProps = {
    canClearSelection: true,
    defaultValue: new Date(),
};
DateTimePicker.displayName = "Blueprint.DateTimePicker";
exports.DateTimePicker = DateTimePicker;

//# sourceMappingURL=dateTimePicker.js.map
