(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("DayPicker"), require("moment"), require("classNames"), require("React"), require("Blueprint.Core"));
	else if(typeof define === 'function' && define.amd)
		define(["DayPicker", "moment", "classNames", "React", "Blueprint.Core"], factory);
	else if(typeof exports === 'object')
		exports["Datetime"] = factory(require("DayPicker"), require("moment"), require("classNames"), require("React"), require("Blueprint.Core"));
	else
		root["Blueprint"] = root["Blueprint"] || {}, root["Blueprint"]["Datetime"] = factory(root["DayPicker"], root["moment"], root["classNames"], root["React"], root["Blueprint.Core"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_2__, __WEBPACK_EXTERNAL_MODULE_4__, __WEBPACK_EXTERNAL_MODULE_7__, __WEBPACK_EXTERNAL_MODULE_8__, __WEBPACK_EXTERNAL_MODULE_9__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
	 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
	 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
	 * and https://github.com/palantir/blueprint/blob/master/PATENTS
	 */
	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	var classes = __webpack_require__(1);
	// re-exporting these symbols to preserve compatility
	var react_day_picker_1 = __webpack_require__(2);
	exports.IDatePickerLocaleUtils = react_day_picker_1.LocaleUtils;
	exports.Classes = classes;
	var dateUtils_1 = __webpack_require__(3);
	exports.DateRangeBoundary = dateUtils_1.DateRangeBoundary;
	var dateInput_1 = __webpack_require__(5);
	exports.DateInput = dateInput_1.DateInput;
	var datePicker_1 = __webpack_require__(11);
	exports.DatePicker = datePicker_1.DatePicker;
	exports.DatePickerFactory = datePicker_1.DatePickerFactory;
	var dateTimePicker_1 = __webpack_require__(15);
	exports.DateTimePicker = dateTimePicker_1.DateTimePicker;
	var dateRangeInput_1 = __webpack_require__(17);
	exports.DateRangeInput = dateRangeInput_1.DateRangeInput;
	var dateRangePicker_1 = __webpack_require__(18);
	exports.DateRangePicker = dateRangePicker_1.DateRangePicker;
	exports.DateRangePickerFactory = dateRangePicker_1.DateRangePickerFactory;
	var timePicker_1 = __webpack_require__(16);
	exports.TimePicker = timePicker_1.TimePicker;
	exports.TimePickerFactory = timePicker_1.TimePickerFactory;
	exports.TimePickerPrecision = timePicker_1.TimePickerPrecision;
	
	//# sourceMappingURL=index.js.map


/***/ }),
/* 1 */
/***/ (function(module, exports) {

	/*
	 * Copyright 2015 Palantir Technologies, Inc. All rights reserved.
	 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
	 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
	 * and https://github.com/palantir/blueprint/blob/master/PATENTS
	 */
	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.DATEPICKER = "pt-datepicker";
	exports.DATEPICKER_CAPTION = "pt-datepicker-caption";
	exports.DATEPICKER_CAPTION_CARET = "pt-datepicker-caption-caret";
	exports.DATEPICKER_CAPTION_SELECT = "pt-datepicker-caption-select";
	exports.DATEPICKER_DAY = "DayPicker-Day";
	exports.DATEPICKER_DAY_DISABLED = "DayPicker-Day--disabled";
	exports.DATEPICKER_DAY_OUTSIDE = "DayPicker-Day--outside";
	exports.DATEPICKER_DAY_SELECTED = "DayPicker-Day--selected";
	exports.DATEPICKER_FOOTER = "pt-datepicker-footer";
	exports.DATEPICKER_MONTH_SELECT = "pt-datepicker-month-select";
	exports.DATEPICKER_YEAR_SELECT = "pt-datepicker-year-select";
	exports.DATERANGEPICKER = "pt-daterangepicker";
	exports.DATERANGEPICKER_CONTIGUOUS = "pt-daterangepicker-contiguous";
	exports.DATERANGEPICKER_SINGLE_MONTH = "pt-daterangepicker-single-month";
	exports.DATERANGEPICKER_DAY_SELECTED_RANGE = "DayPicker-Day--selected-range";
	exports.DATERANGEPICKER_DAY_HOVERED_RANGE = "DayPicker-Day--hovered-range";
	exports.DATERANGEPICKER_SHORTCUTS = "pt-daterangepicker-shortcuts";
	exports.DATETIMEPICKER = "pt-datetimepicker";
	exports.TIMEPICKER = "pt-timepicker";
	exports.TIMEPICKER_ARROW_BUTTON = "pt-timepicker-arrow-button";
	exports.TIMEPICKER_ARROW_ROW = "pt-timepicker-arrow-row";
	exports.TIMEPICKER_DIVIDER_TEXT = "pt-timepicker-divider-text";
	exports.TIMEPICKER_HOUR = "pt-timepicker-hour";
	exports.TIMEPICKER_INPUT = "pt-timepicker-input";
	exports.TIMEPICKER_INPUT_ROW = "pt-timepicker-input-row";
	exports.TIMEPICKER_MILLISECOND = "pt-timepicker-millisecond";
	exports.TIMEPICKER_MINUTE = "pt-timepicker-minute";
	exports.TIMEPICKER_SECOND = "pt-timepicker-second";
	
	//# sourceMappingURL=classes.js.map


/***/ }),
/* 2 */
/***/ (function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_2__;

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 * Copyright 2015 Palantir Technologies, Inc. All rights reserved.
	 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
	 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
	 * and https://github.com/palantir/blueprint/blob/master/PATENTS
	 */
	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	var moment = __webpack_require__(4);
	var DateRangeBoundary;
	(function (DateRangeBoundary) {
	    DateRangeBoundary[DateRangeBoundary["START"] = 0] = "START";
	    DateRangeBoundary[DateRangeBoundary["END"] = 1] = "END";
	})(DateRangeBoundary = exports.DateRangeBoundary || (exports.DateRangeBoundary = {}));
	;
	function areEqual(date1, date2) {
	    if (date1 == null && date2 == null) {
	        return true;
	    }
	    else if (date1 == null || date2 == null) {
	        return false;
	    }
	    else {
	        return date1.getTime() === date2.getTime();
	    }
	}
	exports.areEqual = areEqual;
	function areRangesEqual(dateRange1, dateRange2) {
	    if (dateRange1 == null && dateRange2 == null) {
	        return true;
	    }
	    else if (dateRange1 == null || dateRange2 == null) {
	        return false;
	    }
	    else {
	        var start1 = dateRange1[0], end1 = dateRange1[1];
	        var start2 = dateRange2[0], end2 = dateRange2[1];
	        var areStartsEqual = (start1 == null && start2 == null) || areSameDay(start1, start2);
	        var areEndsEqual = (end1 == null && end2 == null) || areSameDay(end1, end2);
	        return areStartsEqual && areEndsEqual;
	    }
	}
	exports.areRangesEqual = areRangesEqual;
	function areSameDay(date1, date2) {
	    return date1 != null
	        && date2 != null
	        && date1.getDate() === date2.getDate()
	        && date1.getMonth() === date2.getMonth()
	        && date1.getFullYear() === date2.getFullYear();
	}
	exports.areSameDay = areSameDay;
	function areSameMonth(date1, date2) {
	    return date1 != null
	        && date2 != null
	        && date1.getMonth() === date2.getMonth()
	        && date1.getFullYear() === date2.getFullYear();
	}
	exports.areSameMonth = areSameMonth;
	function areSameTime(date1, date2) {
	    return date1 != null
	        && date2 != null
	        && date1.getHours() === date2.getHours()
	        && date1.getMinutes() === date2.getMinutes()
	        && date1.getSeconds() === date2.getSeconds()
	        && date1.getMilliseconds() === date2.getMilliseconds();
	}
	exports.areSameTime = areSameTime;
	function clone(d) {
	    return new Date(d.getTime());
	}
	exports.clone = clone;
	function isDayInRange(date, dateRange, exclusive) {
	    if (exclusive === void 0) { exclusive = false; }
	    if (date == null) {
	        return false;
	    }
	    var day = clone(date);
	    var start = clone(dateRange[0]);
	    var end = clone(dateRange[1]);
	    day.setHours(0, 0, 0, 0);
	    start.setHours(0, 0, 0, 0);
	    end.setHours(0, 0, 0, 0);
	    return start <= day && day <= end
	        && (!exclusive
	            || !areSameDay(start, day) && !areSameDay(day, end));
	}
	exports.isDayInRange = isDayInRange;
	function isDayRangeInRange(innerRange, outerRange) {
	    return (innerRange[0] == null || isDayInRange(innerRange[0], outerRange))
	        && (innerRange[1] == null || isDayInRange(innerRange[1], outerRange));
	}
	exports.isDayRangeInRange = isDayRangeInRange;
	function isMonthInRange(date, dateRange) {
	    if (date == null) {
	        return false;
	    }
	    var day = clone(date);
	    var start = clone(dateRange[0]);
	    var end = clone(dateRange[1]);
	    day.setDate(1);
	    start.setDate(1);
	    end.setDate(1);
	    day.setHours(0, 0, 0, 0);
	    start.setHours(0, 0, 0, 0);
	    end.setHours(0, 0, 0, 0);
	    return start <= day && day <= end;
	}
	exports.isMonthInRange = isMonthInRange;
	exports.isTimeEqualOrGreaterThan = function (time, timeToCompare) { return time.getTime() >= timeToCompare.getTime(); };
	exports.isTimeEqualOrSmallerThan = function (time, timeToCompare) { return time.getTime() <= timeToCompare.getTime(); };
	function isTimeInRange(date, minDate, maxDate) {
	    var time = getDateOnlyWithTime(date);
	    var minTime = getDateOnlyWithTime(minDate);
	    var maxTime = getDateOnlyWithTime(maxDate);
	    var isTimeGreaterThanMinTime = exports.isTimeEqualOrGreaterThan(time, minTime);
	    var isTimeSmallerThanMaxTime = exports.isTimeEqualOrSmallerThan(time, maxTime);
	    if (exports.isTimeEqualOrSmallerThan(maxTime, minTime)) {
	        return isTimeGreaterThanMinTime || isTimeSmallerThanMaxTime;
	    }
	    return isTimeGreaterThanMinTime && isTimeSmallerThanMaxTime;
	}
	exports.isTimeInRange = isTimeInRange;
	function getTimeInRange(time, minTime, maxTime) {
	    if (areSameTime(minTime, maxTime)) {
	        return maxTime;
	    }
	    else if (isTimeInRange(time, minTime, maxTime)) {
	        return time;
	    }
	    else if (isTimeSameOrAfter(time, maxTime)) {
	        return maxTime;
	    }
	    return minTime;
	}
	exports.getTimeInRange = getTimeInRange;
	/**
	 * Returns true if the time part of `date` is later than or equal to the time
	 * part of `dateToCompare`. The day, month, and year parts will not be compared.
	 */
	function isTimeSameOrAfter(date, dateToCompare) {
	    var time = getDateOnlyWithTime(date);
	    var timeToCompare = getDateOnlyWithTime(dateToCompare);
	    return exports.isTimeEqualOrGreaterThan(time, timeToCompare);
	}
	exports.isTimeSameOrAfter = isTimeSameOrAfter;
	/**
	 * @returns a Date at the exact time-wise midpoint between startDate and endDate
	 */
	function getDateBetween(dateRange) {
	    var start = dateRange[0].getTime();
	    var end = dateRange[1].getTime();
	    var middle = start + (end - start) * 0.5;
	    return new Date(middle);
	}
	exports.getDateBetween = getDateBetween;
	function getDateTime(date, time) {
	    if (date === null) {
	        return null;
	    }
	    else if (time === null) {
	        return new Date(date.getFullYear(), date.getMonth(), date.getDate(), 0, 0, 0, 0);
	    }
	    else {
	        return new Date(date.getFullYear(), date.getMonth(), date.getDate(), time.getHours(), time.getMinutes(), time.getSeconds(), time.getMilliseconds());
	    }
	}
	exports.getDateTime = getDateTime;
	function getDateOnlyWithTime(date) {
	    return new Date(0, 0, 0, date.getHours(), date.getMinutes(), date.getSeconds(), date.getMilliseconds());
	}
	exports.getDateOnlyWithTime = getDateOnlyWithTime;
	function isMomentNull(momentDate) {
	    return momentDate.parsingFlags().nullInput;
	}
	exports.isMomentNull = isMomentNull;
	function isMomentValidAndInRange(momentDate, minDate, maxDate) {
	    return momentDate.isValid() && isMomentInRange(momentDate, minDate, maxDate);
	}
	exports.isMomentValidAndInRange = isMomentValidAndInRange;
	function isMomentInRange(momentDate, minDate, maxDate) {
	    return momentDate.isBetween(minDate, maxDate, "day", "[]");
	}
	exports.isMomentInRange = isMomentInRange;
	/**
	 * Translate a Date object into a moment, adjusting the local timezone into the moment one.
	 * This is a no-op unless moment-timezone's setDefault has been called.
	 */
	function fromDateToMoment(date) {
	    if (date == null) {
	        // moment(undefined) is equivalent to moment(), which returns the current date and time when
	        // invoked. thus, we need to explicitly return moment(null).
	        return moment(null);
	    }
	    else if (typeof date === "string") {
	        return moment(date);
	    }
	    else {
	        return moment([
	            date.getFullYear(),
	            date.getMonth(),
	            date.getDate(),
	            date.getHours(),
	            date.getMinutes(),
	            date.getSeconds(),
	            date.getMilliseconds(),
	        ]);
	    }
	}
	exports.fromDateToMoment = fromDateToMoment;
	/**
	 * Translate a moment into a Date object, adjusting the moment timezone into the local one.
	 * This is a no-op unless moment-timezone's setDefault has been called.
	 */
	function fromMomentToDate(momentDate) {
	    if (momentDate == null) {
	        return undefined;
	    }
	    else {
	        return new Date(momentDate.year(), momentDate.month(), momentDate.date(), momentDate.hours(), momentDate.minutes(), momentDate.seconds(), momentDate.milliseconds());
	    }
	}
	exports.fromMomentToDate = fromMomentToDate;
	/**
	 * Translate a DateRange into a MomentDateRange, adjusting the local timezone
	 * into the moment one (a no-op unless moment-timezone's setDefault has been
	 * called).
	 */
	function fromDateRangeToMomentDateRange(dateRange) {
	    if (dateRange == null) {
	        return undefined;
	    }
	    return [
	        fromDateToMoment(dateRange[0]),
	        fromDateToMoment(dateRange[1]),
	    ];
	}
	exports.fromDateRangeToMomentDateRange = fromDateRangeToMomentDateRange;
	/**
	 * Translate a MomentDateRange into a DateRange, adjusting the moment timezone
	 * into the local one. This is a no-op unless moment-timezone's setDefault has
	 * been called.
	 */
	function fromMomentDateRangeToDateRange(momentDateRange) {
	    if (momentDateRange == null) {
	        return undefined;
	    }
	    return [
	        fromMomentToDate(momentDateRange[0]),
	        fromMomentToDate(momentDateRange[1]),
	    ];
	}
	exports.fromMomentDateRangeToDateRange = fromMomentDateRangeToDateRange;
	function getDatePreviousMonth(date) {
	    if (date.getMonth() === 0 /* JANUARY */) {
	        return new Date(date.getFullYear() - 1, 11 /* DECEMBER */);
	    }
	    else {
	        return new Date(date.getFullYear(), date.getMonth() - 1);
	    }
	}
	exports.getDatePreviousMonth = getDatePreviousMonth;
	function getDateNextMonth(date) {
	    if (date.getMonth() === 11 /* DECEMBER */) {
	        return new Date(date.getFullYear() + 1, 0 /* JANUARY */);
	    }
	    else {
	        return new Date(date.getFullYear(), date.getMonth() + 1);
	    }
	}
	exports.getDateNextMonth = getDateNextMonth;
	/**
	 * Returns a date string in the provided format localized to the provided locale.
	 */
	function toLocalizedDateString(momentDate, format, locale) {
	    var adjustedMomentDate = (locale != null) ? momentDate.locale(locale) : momentDate;
	    return adjustedMomentDate.format(format);
	}
	exports.toLocalizedDateString = toLocalizedDateString;
	
	//# sourceMappingURL=dateUtils.js.map


/***/ }),
/* 4 */
/***/ (function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_4__;

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
	 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
	 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
	 * and https://github.com/palantir/blueprint/blob/master/PATENTS
	 */
	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	var tslib_1 = __webpack_require__(6);
	var classNames = __webpack_require__(7);
	var moment = __webpack_require__(4);
	var React = __webpack_require__(8);
	var core_1 = __webpack_require__(9);
	var dateUtils_1 = __webpack_require__(3);
	var errors_1 = __webpack_require__(10);
	var datePicker_1 = __webpack_require__(11);
	var datePickerCore_1 = __webpack_require__(14);
	var dateTimePicker_1 = __webpack_require__(15);
	var DateInput = (function (_super) {
	    tslib_1.__extends(DateInput, _super);
	    function DateInput(props, context) {
	        var _this = _super.call(this, props, context) || this;
	        _this.inputRef = null;
	        _this.getDateString = function (value) {
	            if (dateUtils_1.isMomentNull(value)) {
	                return "";
	            }
	            if (value.isValid()) {
	                if (_this.isMomentInRange(value)) {
	                    return dateUtils_1.toLocalizedDateString(value, _this.props.format, _this.props.locale);
	                }
	                else {
	                    return _this.props.outOfRangeMessage;
	                }
	            }
	            return _this.props.invalidDateMessage;
	        };
	        _this.handleClosePopover = function (e) {
	            var _a = _this.props.popoverProps, popoverProps = _a === void 0 ? {} : _a;
	            core_1.Utils.safeInvoke(popoverProps.onClose, e);
	            _this.setState({ isOpen: false });
	        };
	        _this.handleDateChange = function (date, hasUserManuallySelectedDate) {
	            var prevMomentDate = _this.state.value;
	            var momentDate = dateUtils_1.fromDateToMoment(date);
	            // this change handler was triggered by a change in month, day, or (if enabled) time. for UX
	            // purposes, we want to close the popover only if the user explicitly clicked a day within
	            // the current month.
	            var isOpen = (!hasUserManuallySelectedDate
	                || _this.hasMonthChanged(prevMomentDate, momentDate)
	                || _this.hasTimeChanged(prevMomentDate, momentDate)
	                || !_this.props.closeOnSelection);
	            if (_this.props.value === undefined) {
	                _this.setState({ isInputFocused: false, isOpen: isOpen, value: momentDate });
	            }
	            else {
	                _this.setState({ isInputFocused: false, isOpen: isOpen });
	            }
	            core_1.Utils.safeInvoke(_this.props.onChange, date === null ? null : dateUtils_1.fromMomentToDate(momentDate));
	        };
	        _this.handleInputFocus = function (e) {
	            var valueString;
	            if (dateUtils_1.isMomentNull(_this.state.value)) {
	                valueString = "";
	            }
	            else {
	                valueString = dateUtils_1.toLocalizedDateString(_this.state.value, _this.props.format, _this.props.locale);
	            }
	            if (_this.props.openOnFocus) {
	                _this.setState({ isInputFocused: true, isOpen: true, valueString: valueString });
	            }
	            else {
	                _this.setState({ isInputFocused: true, valueString: valueString });
	            }
	            _this.safeInvokeInputProp("onFocus", e);
	        };
	        _this.handleInputClick = function (e) {
	            if (_this.props.openOnFocus) {
	                e.stopPropagation();
	            }
	            _this.safeInvokeInputProp("onClick", e);
	        };
	        _this.handleInputChange = function (e) {
	            var valueString = e.target.value;
	            var value = _this.createMoment(valueString);
	            if (value.isValid() && _this.isMomentInRange(value)) {
	                if (_this.props.value === undefined) {
	                    _this.setState({ value: value, valueString: valueString });
	                }
	                else {
	                    _this.setState({ valueString: valueString });
	                }
	                core_1.Utils.safeInvoke(_this.props.onChange, dateUtils_1.fromMomentToDate(value));
	            }
	            else {
	                if (valueString.length === 0) {
	                    core_1.Utils.safeInvoke(_this.props.onChange, null);
	                }
	                _this.setState({ valueString: valueString });
	            }
	            _this.safeInvokeInputProp("onChange", e);
	        };
	        _this.handleInputBlur = function (e) {
	            var valueString = _this.state.valueString;
	            var value = _this.createMoment(valueString);
	            if (valueString.length > 0
	                && valueString !== _this.getDateString(_this.state.value)
	                && (!value.isValid() || !_this.isMomentInRange(value))) {
	                if (_this.props.value === undefined) {
	                    _this.setState({ isInputFocused: false, value: value, valueString: null });
	                }
	                else {
	                    _this.setState({ isInputFocused: false });
	                }
	                if (!value.isValid()) {
	                    core_1.Utils.safeInvoke(_this.props.onError, new Date(undefined));
	                }
	                else if (!_this.isMomentInRange(value)) {
	                    core_1.Utils.safeInvoke(_this.props.onError, dateUtils_1.fromMomentToDate(value));
	                }
	                else {
	                    core_1.Utils.safeInvoke(_this.props.onChange, dateUtils_1.fromMomentToDate(value));
	                }
	            }
	            else {
	                if (valueString.length === 0) {
	                    _this.setState({ isInputFocused: false, value: moment(null), valueString: null });
	                }
	                else {
	                    _this.setState({ isInputFocused: false });
	                }
	            }
	            _this.safeInvokeInputProp("onBlur", e);
	        };
	        _this.setInputRef = function (el) {
	            _this.inputRef = el;
	            var _a = _this.props.inputProps, inputProps = _a === void 0 ? {} : _a;
	            core_1.Utils.safeInvoke(inputProps.inputRef, el);
	        };
	        var defaultValue = _this.props.defaultValue ? dateUtils_1.fromDateToMoment(_this.props.defaultValue) : moment(null);
	        _this.state = {
	            isInputFocused: false,
	            isOpen: false,
	            value: _this.props.value !== undefined ? dateUtils_1.fromDateToMoment(_this.props.value) : defaultValue,
	            valueString: null,
	        };
	        return _this;
	    }
	    DateInput.prototype.render = function () {
	        var _a = this.state, value = _a.value, valueString = _a.valueString;
	        var dateString = this.state.isInputFocused ? valueString : this.getDateString(value);
	        var date = this.state.isInputFocused ? this.createMoment(valueString) : value;
	        var dateValue = this.isMomentValidAndInRange(value) ? dateUtils_1.fromMomentToDate(value) : null;
	        var popoverContent = this.props.timePrecision === undefined
	            ? React.createElement(datePicker_1.DatePicker, tslib_1.__assign({}, this.props, { onChange: this.handleDateChange, value: dateValue }))
	            : React.createElement(dateTimePicker_1.DateTimePicker, { onChange: this.handleDateChange, value: dateValue, datePickerProps: this.props, timePickerProps: { precision: this.props.timePrecision } });
	        // assign default empty object here to prevent mutation
	        var _b = this.props, _c = _b.inputProps, inputProps = _c === void 0 ? {} : _c, _d = _b.popoverProps, popoverProps = _d === void 0 ? {} : _d;
	        // exclude ref (comes from HTMLInputProps typings, not InputGroup)
	        var ref = inputProps.ref, htmlInputProps = tslib_1.__rest(inputProps, ["ref"]);
	        var inputClasses = classNames({
	            "pt-intent-danger": !(this.isMomentValidAndInRange(date) || dateUtils_1.isMomentNull(date) || dateString === ""),
	        }, inputProps.className);
	        return (React.createElement(core_1.Popover, tslib_1.__assign({ inline: true, isOpen: this.state.isOpen && !this.props.disabled, position: this.props.popoverPosition }, popoverProps, { autoFocus: false, enforceFocus: false, content: popoverContent, onClose: this.handleClosePopover, popoverClassName: classNames("pt-dateinput-popover", popoverProps.popoverClassName) }),
	            React.createElement(core_1.InputGroup, tslib_1.__assign({ autoComplete: "off", placeholder: this.props.format, rightElement: this.props.rightElement }, htmlInputProps, { className: inputClasses, disabled: this.props.disabled, inputRef: this.setInputRef, type: "text", onBlur: this.handleInputBlur, onChange: this.handleInputChange, onClick: this.handleInputClick, onFocus: this.handleInputFocus, value: dateString }))));
	    };
	    DateInput.prototype.componentWillReceiveProps = function (nextProps) {
	        _super.prototype.componentWillReceiveProps.call(this, nextProps);
	        if (nextProps.value !== this.props.value) {
	            this.setState({ value: dateUtils_1.fromDateToMoment(nextProps.value) });
	        }
	    };
	    DateInput.prototype.validateProps = function (props) {
	        if (props.popoverPosition !== DateInput.defaultProps.popoverPosition) {
	            console.warn(errors_1.DATEINPUT_WARN_DEPRECATED_POPOVER_POSITION);
	        }
	        if (props.openOnFocus !== DateInput.defaultProps.openOnFocus) {
	            console.warn(errors_1.DATEINPUT_WARN_DEPRECATED_OPEN_ON_FOCUS);
	        }
	    };
	    DateInput.prototype.createMoment = function (valueString) {
	        // Locale here used for parsing, does not set the locale on the moment itself
	        return moment(valueString, this.props.format, this.props.locale);
	    };
	    DateInput.prototype.isMomentValidAndInRange = function (value) {
	        return dateUtils_1.isMomentValidAndInRange(value, this.props.minDate, this.props.maxDate);
	    };
	    DateInput.prototype.isMomentInRange = function (value) {
	        return dateUtils_1.isMomentInRange(value, this.props.minDate, this.props.maxDate);
	    };
	    DateInput.prototype.shouldCheckForDateChanges = function (prevMomentDate, nextMomentDate) {
	        return nextMomentDate != null && !dateUtils_1.isMomentNull(prevMomentDate) && prevMomentDate.isValid();
	    };
	    DateInput.prototype.hasMonthChanged = function (prevMomentDate, nextMomentDate) {
	        return this.shouldCheckForDateChanges(prevMomentDate, nextMomentDate)
	            && nextMomentDate.month() !== prevMomentDate.month();
	    };
	    DateInput.prototype.hasTimeChanged = function (prevMomentDate, nextMomentDate) {
	        return this.shouldCheckForDateChanges(prevMomentDate, nextMomentDate)
	            && this.props.timePrecision != null
	            && (nextMomentDate.hours() !== prevMomentDate.hours()
	                || nextMomentDate.minutes() !== prevMomentDate.minutes()
	                || nextMomentDate.seconds() !== prevMomentDate.seconds()
	                || nextMomentDate.milliseconds() !== prevMomentDate.milliseconds());
	    };
	    /** safe wrapper around invoking input props event handler (prop defaults to undefined) */
	    DateInput.prototype.safeInvokeInputProp = function (name, e) {
	        var _a = this.props.inputProps, inputProps = _a === void 0 ? {} : _a;
	        core_1.Utils.safeInvoke(inputProps[name], e);
	    };
	    return DateInput;
	}(core_1.AbstractComponent));
	DateInput.defaultProps = {
	    closeOnSelection: true,
	    disabled: false,
	    format: "YYYY-MM-DD",
	    invalidDateMessage: "Invalid date",
	    maxDate: datePickerCore_1.getDefaultMaxDate(),
	    minDate: datePickerCore_1.getDefaultMinDate(),
	    openOnFocus: true,
	    outOfRangeMessage: "Out of range",
	    popoverPosition: core_1.Position.BOTTOM,
	};
	DateInput.displayName = "Blueprint.DateInput";
	exports.DateInput = DateInput;
	
	//# sourceMappingURL=dateInput.js.map


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/* WEBPACK VAR INJECTION */(function(global) {/*! *****************************************************************************
	Copyright (c) Microsoft Corporation. All rights reserved.
	Licensed under the Apache License, Version 2.0 (the "License"); you may not use
	this file except in compliance with the License. You may obtain a copy of the
	License at http://www.apache.org/licenses/LICENSE-2.0
	
	THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
	KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
	WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
	MERCHANTABLITY OR NON-INFRINGEMENT.
	
	See the Apache Version 2.0 License for specific language governing permissions
	and limitations under the License.
	***************************************************************************** */
	/* global global, define, System, Reflect, Promise */
	var __extends;
	var __assign;
	var __rest;
	var __decorate;
	var __param;
	var __metadata;
	var __awaiter;
	var __generator;
	var __exportStar;
	var __values;
	var __read;
	var __spread;
	var __await;
	var __asyncGenerator;
	var __asyncDelegator;
	var __asyncValues;
	(function (factory) {
	    var root = typeof global === "object" ? global : typeof self === "object" ? self : typeof this === "object" ? this : {};
	    if (true) {
	        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports], __WEBPACK_AMD_DEFINE_RESULT__ = function (exports) { factory(createExporter(root, createExporter(exports))); }.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	    }
	    else if (typeof module === "object" && typeof module.exports === "object") {
	        factory(createExporter(root, createExporter(module.exports)));
	    }
	    else {
	        factory(createExporter(root));
	    }
	    function createExporter(exports, previous) {
	        return function (id, v) { return exports[id] = previous ? previous(id, v) : v; };
	    }
	})
	(function (exporter) {
	    var extendStatics = Object.setPrototypeOf ||
	        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
	        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
	
	    __extends = function (d, b) {
	        extendStatics(d, b);
	        function __() { this.constructor = d; }
	        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	    };
	
	    __assign = Object.assign || function (t) {
	        for (var s, i = 1, n = arguments.length; i < n; i++) {
	            s = arguments[i];
	            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
	        }
	        return t;
	    };
	
	    __rest = function (s, e) {
	        var t = {};
	        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
	            t[p] = s[p];
	        if (s != null && typeof Object.getOwnPropertySymbols === "function")
	            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
	                t[p[i]] = s[p[i]];
	        return t;
	    };
	
	    __decorate = function (decorators, target, key, desc) {
	        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
	        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
	        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
	        return c > 3 && r && Object.defineProperty(target, key, r), r;
	    };
	
	    __param = function (paramIndex, decorator) {
	        return function (target, key) { decorator(target, key, paramIndex); }
	    };
	
	    __metadata = function (metadataKey, metadataValue) {
	        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
	    };
	
	    __awaiter = function (thisArg, _arguments, P, generator) {
	        return new (P || (P = Promise))(function (resolve, reject) {
	            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
	            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
	            function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
	            step((generator = generator.apply(thisArg, _arguments || [])).next());
	        });
	    };
	
	    __generator = function (thisArg, body) {
	        var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
	        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
	        function verb(n) { return function (v) { return step([n, v]); }; }
	        function step(op) {
	            if (f) throw new TypeError("Generator is already executing.");
	            while (_) try {
	                if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
	                if (y = 0, t) op = [0, t.value];
	                switch (op[0]) {
	                    case 0: case 1: t = op; break;
	                    case 4: _.label++; return { value: op[1], done: false };
	                    case 5: _.label++; y = op[1]; op = [0]; continue;
	                    case 7: op = _.ops.pop(); _.trys.pop(); continue;
	                    default:
	                        if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
	                        if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
	                        if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
	                        if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
	                        if (t[2]) _.ops.pop();
	                        _.trys.pop(); continue;
	                }
	                op = body.call(thisArg, _);
	            } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
	            if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
	        }
	    };
	
	    __exportStar = function (m, exports) {
	        for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	    };
	
	    __values = function (o) {
	        var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
	        if (m) return m.call(o);
	        return {
	            next: function () {
	                if (o && i >= o.length) o = void 0;
	                return { value: o && o[i++], done: !o };
	            }
	        };
	    };
	
	    __read = function (o, n) {
	        var m = typeof Symbol === "function" && o[Symbol.iterator];
	        if (!m) return o;
	        var i = m.call(o), r, ar = [], e;
	        try {
	            while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
	        }
	        catch (error) { e = { error: error }; }
	        finally {
	            try {
	                if (r && !r.done && (m = i["return"])) m.call(i);
	            }
	            finally { if (e) throw e.error; }
	        }
	        return ar;
	    };
	
	    __spread = function () {
	        for (var ar = [], i = 0; i < arguments.length; i++)
	            ar = ar.concat(__read(arguments[i]));
	        return ar;
	    };
	
	    __await = function (v) {
	        return this instanceof __await ? (this.v = v, this) : new __await(v);
	    };
	
	    __asyncGenerator = function (thisArg, _arguments, generator) {
	        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
	        var g = generator.apply(thisArg, _arguments || []), i, q = [];
	        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
	        function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
	        function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
	        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);  }
	        function fulfill(value) { resume("next", value); }
	        function reject(value) { resume("throw", value); }
	        function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
	    };
	
	    __asyncDelegator = function (o) {
	        var i, p;
	        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
	        function verb(n, f) { if (o[n]) i[n] = function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; }; }
	    };
	
	    __asyncValues = function (o) {
	        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
	        var m = o[Symbol.asyncIterator];
	        return m ? m.call(o) : typeof __values === "function" ? __values(o) : o[Symbol.iterator]();
	    };
	
	    exporter("__extends", __extends);
	    exporter("__assign", __assign);
	    exporter("__rest", __rest);
	    exporter("__decorate", __decorate);
	    exporter("__param", __param);
	    exporter("__metadata", __metadata);
	    exporter("__awaiter", __awaiter);
	    exporter("__generator", __generator);
	    exporter("__exportStar", __exportStar);
	    exporter("__values", __values);
	    exporter("__read", __read);
	    exporter("__spread", __spread);
	    exporter("__await", __await);
	    exporter("__asyncGenerator", __asyncGenerator);
	    exporter("__asyncDelegator", __asyncDelegator);
	    exporter("__asyncValues", __asyncValues);
	});
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ }),
/* 7 */
/***/ (function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_7__;

/***/ }),
/* 8 */
/***/ (function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_8__;

/***/ }),
/* 9 */
/***/ (function(module, exports) {

	module.exports = Blueprint.Core;

/***/ }),
/* 10 */
/***/ (function(module, exports) {

	/*
	 * Copyright 2015 Palantir Technologies, Inc. All rights reserved.
	 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
	 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
	 * and https://github.com/palantir/blueprint/blob/master/PATENTS
	 */
	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	var ns = "[Blueprint]";
	exports.DATEPICKER_DEFAULT_VALUE_INVALID = ns + " <DatePicker> defaultValue must be within minDate and maxDate bounds.";
	exports.DATEPICKER_INITIAL_MONTH_INVALID = ns + " <DatePicker> initialMonth must be within minDate and maxDate bounds.";
	exports.DATEPICKER_MAX_DATE_INVALID = ns + " <DatePicker> maxDate must be later than minDate.";
	exports.DATEPICKER_VALUE_INVALID = ns + " <DatePicker> value prop must be within minDate and maxDate bounds.";
	exports.DATERANGEPICKER_DEFAULT_VALUE_INVALID = exports.DATEPICKER_DEFAULT_VALUE_INVALID.replace("DatePicker", "DateRangePicker");
	exports.DATERANGEPICKER_INITIAL_MONTH_INVALID = exports.DATEPICKER_INITIAL_MONTH_INVALID.replace("DatePicker", "DateRangePicker");
	exports.DATERANGEPICKER_MAX_DATE_INVALID = exports.DATEPICKER_MAX_DATE_INVALID.replace("DatePicker", "DateRangePicker");
	exports.DATERANGEPICKER_VALUE_INVALID = exports.DATEPICKER_VALUE_INVALID.replace("DatePicker", "DateRangePicker");
	exports.DATERANGEPICKER_PREFERRED_BOUNDARY_TO_MODIFY_INVALID = "<DateRangePicker> preferredBoundaryToModify must be a valid DateRangeBoundary if defined.";
	exports.DATEINPUT_WARN_DEPRECATED_POPOVER_POSITION = ns + " DEPRECATION: <DateInput> popoverPosition is deprecated. Use popoverProps.position.";
	exports.DATEINPUT_WARN_DEPRECATED_OPEN_ON_FOCUS = ns + " DEPRECATION: <DateInput> openOnFocus is deprecated. This feature will be removed in the next major version.";
	exports.DATERANGEINPUT_NULL_VALUE = ns + " <DateRangeInput> value cannot be null. Pass undefined to clear the value and operate in " +
	    "uncontrolled mode, or pass [null, null] to clear the value and continue operating in controlled mode.";
	
	//# sourceMappingURL=errors.js.map


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 * Copyright 2015 Palantir Technologies, Inc. All rights reserved.
	 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
	 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
	 * and https://github.com/palantir/blueprint/blob/master/PATENTS
	 */
	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	var tslib_1 = __webpack_require__(6);
	var core_1 = __webpack_require__(9);
	var classNames = __webpack_require__(7);
	var React = __webpack_require__(8);
	var ReactDayPicker = __webpack_require__(2);
	var Classes = __webpack_require__(1);
	var DateUtils = __webpack_require__(3);
	var Errors = __webpack_require__(10);
	var datePickerCaption_1 = __webpack_require__(12);
	var datePickerCore_1 = __webpack_require__(14);
	var DatePicker = (function (_super) {
	    tslib_1.__extends(DatePicker, _super);
	    function DatePicker(props, context) {
	        var _this = _super.call(this, props, context) || this;
	        _this.ignoreNextMonthChange = false;
	        _this.disabledDays = function (day) { return !DateUtils.isDayInRange(day, [_this.props.minDate, _this.props.maxDate]); };
	        _this.renderCaption = function (props) { return (React.createElement(datePickerCaption_1.DatePickerCaption, tslib_1.__assign({}, props, { maxDate: _this.props.maxDate, minDate: _this.props.minDate, onMonthChange: _this.handleMonthSelectChange, onYearChange: _this.handleYearSelectChange }))); };
	        _this.handleDayClick = function (day, modifiers) {
	            var newValue = day;
	            if (_this.props.canClearSelection && modifiers.selected) {
	                newValue = null;
	            }
	            if (_this.props.value === undefined) {
	                // component is uncontrolled
	                if (!modifiers.disabled) {
	                    var displayMonth = day.getMonth();
	                    var displayYear = day.getFullYear();
	                    var selectedDay = day.getDate();
	                    _this.setState({ displayMonth: displayMonth, displayYear: displayYear, selectedDay: selectedDay, value: newValue });
	                }
	            }
	            if (!modifiers.disabled) {
	                core_1.Utils.safeInvoke(_this.props.onChange, newValue, true);
	                if (_this.state.value != null && _this.state.value.getMonth() !== day.getMonth()) {
	                    _this.ignoreNextMonthChange = true;
	                }
	            }
	            else {
	                // rerender base component to get around bug where you can navigate past bounds by clicking days
	                _this.forceUpdate();
	            }
	        };
	        _this.handleMonthChange = function (newDate) {
	            var displayMonth = newDate.getMonth();
	            var displayYear = newDate.getFullYear();
	            var value = _this.state.value;
	            if (value !== null) {
	                value = _this.computeValidDateInSpecifiedMonthYear(displayYear, displayMonth);
	                if (_this.ignoreNextMonthChange) {
	                    _this.ignoreNextMonthChange = false;
	                }
	                else {
	                    // if handleDayClick just got run, it means the user selected a date in a new month,
	                    // so don't run onChange again
	                    core_1.Utils.safeInvoke(_this.props.onChange, value, false);
	                }
	            }
	            _this.setStateWithValueIfUncontrolled({ displayMonth: displayMonth, displayYear: displayYear }, value);
	        };
	        _this.handleMonthSelectChange = function (displayMonth) {
	            var value = _this.state.value;
	            if (value !== null) {
	                value = _this.computeValidDateInSpecifiedMonthYear(value.getFullYear(), displayMonth);
	                core_1.Utils.safeInvoke(_this.props.onChange, value, false);
	            }
	            _this.setStateWithValueIfUncontrolled({ displayMonth: displayMonth }, value);
	        };
	        _this.handleYearSelectChange = function (displayYear) {
	            var _a = _this.state, displayMonth = _a.displayMonth, value = _a.value;
	            if (value !== null) {
	                value = _this.computeValidDateInSpecifiedMonthYear(displayYear, displayMonth);
	                core_1.Utils.safeInvoke(_this.props.onChange, value, false);
	                displayMonth = value.getMonth();
	            }
	            else {
	                var _b = _this.props, minDate = _b.minDate, maxDate = _b.maxDate;
	                var minYear = minDate.getFullYear();
	                var maxYear = maxDate.getFullYear();
	                var minMonth = minDate.getMonth();
	                var maxMonth = maxDate.getMonth();
	                if (displayYear === minYear && displayMonth < minMonth) {
	                    displayMonth = minMonth;
	                }
	                else if (displayYear === maxYear && displayMonth > maxMonth) {
	                    displayMonth = maxMonth;
	                }
	            }
	            _this.setStateWithValueIfUncontrolled({ displayMonth: displayMonth, displayYear: displayYear }, value);
	        };
	        _this.handleClearClick = function () {
	            if (_this.props.value === undefined) {
	                _this.setState({ value: null });
	            }
	            core_1.Utils.safeInvoke(_this.props.onChange, null, true);
	        };
	        _this.handleTodayClick = function () {
	            var value = new Date();
	            var displayMonth = value.getMonth();
	            var displayYear = value.getFullYear();
	            var selectedDay = value.getDate();
	            if (_this.props.value === undefined) {
	                _this.setState({ displayMonth: displayMonth, displayYear: displayYear, selectedDay: selectedDay, value: value });
	            }
	            else {
	                _this.setState({ displayMonth: displayMonth, displayYear: displayYear, selectedDay: selectedDay });
	            }
	            core_1.Utils.safeInvoke(_this.props.onChange, value, true);
	        };
	        var value = null;
	        if (props.value !== undefined) {
	            value = props.value;
	        }
	        else if (props.defaultValue != null) {
	            value = props.defaultValue;
	        }
	        var selectedDay;
	        if (value !== null) {
	            selectedDay = value.getDate();
	        }
	        var initialMonth;
	        var today = new Date();
	        if (props.initialMonth != null) {
	            initialMonth = props.initialMonth;
	        }
	        else if (value != null) {
	            initialMonth = value;
	        }
	        else if (DateUtils.isDayInRange(today, [props.minDate, props.maxDate])) {
	            initialMonth = today;
	        }
	        else {
	            initialMonth = DateUtils.getDateBetween([props.minDate, props.maxDate]);
	        }
	        _this.state = {
	            displayMonth: initialMonth.getMonth(),
	            displayYear: initialMonth.getFullYear(),
	            selectedDay: selectedDay,
	            value: value,
	        };
	        return _this;
	    }
	    DatePicker.prototype.render = function () {
	        var _a = this.props, className = _a.className, locale = _a.locale, localeUtils = _a.localeUtils, maxDate = _a.maxDate, minDate = _a.minDate, showActionsBar = _a.showActionsBar;
	        var _b = this.state, displayMonth = _b.displayMonth, displayYear = _b.displayYear;
	        return (React.createElement("div", { className: classNames(Classes.DATEPICKER, className) },
	            React.createElement(ReactDayPicker, { canChangeMonth: true, captionElement: this.renderCaption, disabledDays: this.disabledDays, enableOutsideDays: true, fromMonth: minDate, locale: locale, localeUtils: localeUtils, modifiers: this.props.modifiers, month: new Date(displayYear, displayMonth), onDayClick: this.handleDayClick, onMonthChange: this.handleMonthChange, selectedDays: this.state.value, toMonth: maxDate }),
	            showActionsBar ? this.renderOptionsBar() : null));
	    };
	    DatePicker.prototype.componentWillReceiveProps = function (nextProps) {
	        if (nextProps.value !== this.props.value) {
	            var _a = this.state, displayMonth = _a.displayMonth, displayYear = _a.displayYear, selectedDay = _a.selectedDay;
	            if (nextProps.value != null) {
	                displayMonth = nextProps.value.getMonth();
	                displayYear = nextProps.value.getFullYear();
	                selectedDay = nextProps.value.getDate();
	            }
	            this.setState({ displayMonth: displayMonth, displayYear: displayYear, selectedDay: selectedDay, value: nextProps.value });
	        }
	        _super.prototype.componentWillReceiveProps.call(this, nextProps);
	    };
	    DatePicker.prototype.validateProps = function (props) {
	        var defaultValue = props.defaultValue, initialMonth = props.initialMonth, maxDate = props.maxDate, minDate = props.minDate, value = props.value;
	        if (defaultValue != null && !DateUtils.isDayInRange(defaultValue, [minDate, maxDate])) {
	            throw new Error(Errors.DATEPICKER_DEFAULT_VALUE_INVALID);
	        }
	        if (initialMonth != null && !DateUtils.isMonthInRange(initialMonth, [minDate, maxDate])) {
	            throw new Error(Errors.DATEPICKER_INITIAL_MONTH_INVALID);
	        }
	        if (maxDate != null
	            && minDate != null
	            && maxDate < minDate
	            && !DateUtils.areSameDay(maxDate, minDate)) {
	            throw new Error(Errors.DATEPICKER_MAX_DATE_INVALID);
	        }
	        if (value != null && !DateUtils.isDayInRange(value, [minDate, maxDate])) {
	            throw new Error(Errors.DATEPICKER_VALUE_INVALID);
	        }
	    };
	    DatePicker.prototype.renderOptionsBar = function () {
	        return (React.createElement("div", { className: Classes.DATEPICKER_FOOTER },
	            React.createElement(core_1.Button, { className: "pt-minimal pt-datepicker-footer-button", onClick: this.handleTodayClick, text: "Today" }),
	            React.createElement(core_1.Button, { className: "pt-minimal pt-datepicker-footer-button", onClick: this.handleClearClick, text: "Clear" })));
	    };
	    DatePicker.prototype.computeValidDateInSpecifiedMonthYear = function (displayYear, displayMonth) {
	        var _a = this.props, minDate = _a.minDate, maxDate = _a.maxDate;
	        var maxDaysInMonth = new Date(displayYear, displayMonth + 1, 0).getDate();
	        var selectedDay = this.state.selectedDay;
	        if (selectedDay > maxDaysInMonth) {
	            selectedDay = maxDaysInMonth;
	        }
	        // matches the underlying react-day-picker timestamp behavior
	        var value = new Date(displayYear, displayMonth, selectedDay, 12);
	        if (value < minDate) {
	            value = minDate;
	        }
	        else if (value > maxDate) {
	            value = maxDate;
	        }
	        return value;
	    };
	    DatePicker.prototype.setStateWithValueIfUncontrolled = function (newState, value) {
	        if (this.props.value === undefined) {
	            // uncontrolled mode means we track value in state
	            newState.value = value;
	        }
	        return this.setState(newState);
	    };
	    return DatePicker;
	}(core_1.AbstractComponent));
	DatePicker.defaultProps = {
	    canClearSelection: true,
	    maxDate: datePickerCore_1.getDefaultMaxDate(),
	    minDate: datePickerCore_1.getDefaultMinDate(),
	    showActionsBar: false,
	};
	DatePicker.displayName = "Blueprint.DatePicker";
	exports.DatePicker = DatePicker;
	exports.DatePickerFactory = React.createFactory(DatePicker);
	
	//# sourceMappingURL=datePicker.js.map


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 * Copyright 2015 Palantir Technologies, Inc. All rights reserved.
	 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
	 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
	 * and https://github.com/palantir/blueprint/blob/master/PATENTS
	 */
	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	var tslib_1 = __webpack_require__(6);
	var core_1 = __webpack_require__(9);
	var classNames = __webpack_require__(7);
	var React = __webpack_require__(8);
	var Classes = __webpack_require__(1);
	var Utils = __webpack_require__(13);
	var DatePickerCaption = (function (_super) {
	    tslib_1.__extends(DatePickerCaption, _super);
	    function DatePickerCaption() {
	        var _this = _super !== null && _super.apply(this, arguments) || this;
	        _this.containerRefHandler = function (r) { return _this.containerElement = r; };
	        _this.monthArrowRefHandler = function (r) { return _this.monthArrowElement = r; };
	        _this.yearArrowRefHandler = function (r) { return _this.yearArrowElement = r; };
	        _this.handleMonthSelectChange = function (e) {
	            var month = parseInt(e.target.value, 10);
	            core_1.Utils.safeInvoke(_this.props.onMonthChange, month);
	        };
	        _this.handleYearSelectChange = function (e) {
	            var year = parseInt(e.target.value, 10);
	            core_1.Utils.safeInvoke(_this.props.onYearChange, year);
	        };
	        return _this;
	    }
	    DatePickerCaption.prototype.render = function () {
	        var _a = this.props, date = _a.date, locale = _a.locale, localeUtils = _a.localeUtils, minDate = _a.minDate, maxDate = _a.maxDate;
	        var minYear = minDate.getFullYear();
	        var maxYear = maxDate.getFullYear();
	        var displayMonth = date.getMonth();
	        var displayYear = date.getFullYear();
	        // build the list of available months, limiting based on minDate and maxDate as necessary
	        var months = localeUtils.getMonths(locale);
	        var startMonth = (displayYear === minYear) ? minDate.getMonth() : 0;
	        var endMonth = (displayYear === maxYear) ? maxDate.getMonth() + 1 : undefined;
	        var monthOptionElements = months.map(function (name, i) {
	            return React.createElement("option", { key: i, value: i.toString() }, name);
	        }).slice(startMonth, endMonth);
	        var years = [minYear];
	        for (var year = minYear + 1; year <= maxYear; ++year) {
	            years.push(year);
	        }
	        var yearOptionElements = years.map(function (year, i) {
	            return React.createElement("option", { key: i, value: year.toString() }, year);
	        });
	        // allow out-of-bounds years but disable the option. this handles the Dec 2016 case in #391.
	        if (displayYear > maxYear) {
	            yearOptionElements.push(React.createElement("option", { key: "next", disabled: true, value: displayYear.toString() }, displayYear));
	        }
	        this.displayedMonthText = months[displayMonth];
	        this.displayedYearText = displayYear.toString();
	        var caretClasses = classNames("pt-icon-standard", "pt-icon-caret-down", Classes.DATEPICKER_CAPTION_CARET);
	        return (React.createElement("div", { className: Classes.DATEPICKER_CAPTION, ref: this.containerRefHandler },
	            React.createElement("div", { className: Classes.DATEPICKER_CAPTION_SELECT },
	                React.createElement("select", { className: Classes.DATEPICKER_MONTH_SELECT, onChange: this.handleMonthSelectChange, value: displayMonth.toString() }, monthOptionElements),
	                React.createElement("span", { className: caretClasses, ref: this.monthArrowRefHandler })),
	            React.createElement("div", { className: Classes.DATEPICKER_CAPTION_SELECT },
	                React.createElement("select", { className: Classes.DATEPICKER_YEAR_SELECT, onChange: this.handleYearSelectChange, value: displayYear.toString() }, yearOptionElements),
	                React.createElement("span", { className: caretClasses, ref: this.yearArrowRefHandler }))));
	    };
	    DatePickerCaption.prototype.componentDidMount = function () {
	        this.positionArrows();
	    };
	    DatePickerCaption.prototype.componentDidUpdate = function () {
	        this.positionArrows();
	    };
	    DatePickerCaption.prototype.positionArrows = function () {
	        // pass our container element to the measureTextWidth utility to ensure
	        // that we're measuring the width of text as sized within this component.
	        var textClass = "pt-datepicker-caption-measure";
	        var monthWidth = Utils.measureTextWidth(this.displayedMonthText, textClass, this.containerElement);
	        this.monthArrowElement.setAttribute("style", "left:" + monthWidth);
	        var yearWidth = Utils.measureTextWidth(this.displayedYearText, textClass, this.containerElement);
	        this.yearArrowElement.setAttribute("style", "left:" + yearWidth);
	    };
	    return DatePickerCaption;
	}(React.Component));
	exports.DatePickerCaption = DatePickerCaption;
	
	//# sourceMappingURL=datePickerCaption.js.map


/***/ }),
/* 13 */
/***/ (function(module, exports) {

	/*
	 * Copyright 2015 Palantir Technologies, Inc. All rights reserved.
	 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
	 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
	 * and https://github.com/palantir/blueprint/blob/master/PATENTS
	 */
	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	/**
	 * Measure width of a string displayed with styles provided by `className`.
	 * Should only be used if measuring can't be done with existing DOM elements.
	 */
	function measureTextWidth(text, className, containerElement) {
	    if (className === void 0) { className = ""; }
	    if (containerElement === void 0) { containerElement = document.body; }
	    var span = document.createElement("span");
	    span.classList.add(className);
	    span.textContent = text;
	    containerElement.appendChild(span);
	    var spanWidth = span.offsetWidth;
	    span.remove();
	    return spanWidth + "px";
	}
	exports.measureTextWidth = measureTextWidth;
	function padWithZeroes(str, minLength) {
	    if (str.length < minLength) {
	        return "" + stringRepeat("0", minLength - str.length) + str;
	    }
	    else {
	        return str;
	    }
	}
	exports.padWithZeroes = padWithZeroes;
	function stringRepeat(str, numTimes) {
	    return new Array(numTimes + 1).join(str);
	}
	
	//# sourceMappingURL=utils.js.map


/***/ }),
/* 14 */
/***/ (function(module, exports) {

	/*
	 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
	 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
	 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
	 * and https://github.com/palantir/blueprint/blob/master/PATENTS
	 */
	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.DISABLED_MODIFIER = "disabled";
	exports.HOVERED_RANGE_MODIFIER = "hovered-range";
	exports.OUTSIDE_MODIFIER = "outside";
	exports.SELECTED_MODIFIER = "selected";
	exports.SELECTED_RANGE_MODIFIER = "selected-range";
	// modifiers the user can't set because they are used by Blueprint or react-day-picker
	exports.DISALLOWED_MODIFIERS = [
	    exports.DISABLED_MODIFIER,
	    exports.HOVERED_RANGE_MODIFIER,
	    exports.OUTSIDE_MODIFIER,
	    exports.SELECTED_MODIFIER,
	    exports.SELECTED_RANGE_MODIFIER,
	];
	function getDefaultMaxDate() {
	    var date = new Date();
	    date.setFullYear(date.getFullYear());
	    date.setMonth(11 /* DECEMBER */, 31);
	    return date;
	}
	exports.getDefaultMaxDate = getDefaultMaxDate;
	function getDefaultMinDate() {
	    var date = new Date();
	    date.setFullYear(date.getFullYear() - 20);
	    date.setMonth(0 /* JANUARY */, 1);
	    return date;
	}
	exports.getDefaultMinDate = getDefaultMinDate;
	function combineModifiers(baseModifiers, userModifiers) {
	    var modifiers = baseModifiers;
	    if (userModifiers != null) {
	        modifiers = {};
	        for (var _i = 0, _a = Object.keys(userModifiers); _i < _a.length; _i++) {
	            var key = _a[_i];
	            if (exports.DISALLOWED_MODIFIERS.indexOf(key) === -1) {
	                modifiers[key] = userModifiers[key];
	            }
	        }
	        for (var _b = 0, _c = Object.keys(baseModifiers); _b < _c.length; _b++) {
	            var key = _c[_b];
	            modifiers[key] = baseModifiers[key];
	        }
	    }
	    return modifiers;
	}
	exports.combineModifiers = combineModifiers;
	
	//# sourceMappingURL=datePickerCore.js.map


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 * Copyright 2015 Palantir Technologies, Inc. All rights reserved.
	 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
	 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
	 * and https://github.com/palantir/blueprint/blob/master/PATENTS
	 */
	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	var tslib_1 = __webpack_require__(6);
	var classNames = __webpack_require__(7);
	var React = __webpack_require__(8);
	var core_1 = __webpack_require__(9);
	var Classes = __webpack_require__(1);
	var DateUtils = __webpack_require__(3);
	var datePicker_1 = __webpack_require__(11);
	var timePicker_1 = __webpack_require__(16);
	var DateTimePicker = (function (_super) {
	    tslib_1.__extends(DateTimePicker, _super);
	    function DateTimePicker(props, context) {
	        var _this = _super.call(this, props, context) || this;
	        _this.handleDateChange = function (dateValue, isUserChange) {
	            if (_this.props.value === undefined) {
	                _this.setState({ dateValue: dateValue });
	            }
	            var value = DateUtils.getDateTime(dateValue, _this.state.timeValue);
	            core_1.Utils.safeInvoke(_this.props.onChange, value, isUserChange);
	        };
	        _this.handleTimeChange = function (timeValue) {
	            if (_this.props.value === undefined) {
	                _this.setState({ timeValue: timeValue });
	            }
	            var value = DateUtils.getDateTime(_this.state.dateValue, timeValue);
	            core_1.Utils.safeInvoke(_this.props.onChange, value, true);
	        };
	        var initialValue = (_this.props.value !== undefined) ? _this.props.value : _this.props.defaultValue;
	        _this.state = {
	            dateValue: initialValue,
	            timeValue: initialValue,
	        };
	        return _this;
	    }
	    DateTimePicker.prototype.render = function () {
	        var value = DateUtils.getDateTime(this.state.dateValue, this.state.timeValue);
	        return (React.createElement("div", { className: classNames(Classes.DATETIMEPICKER, this.props.className) },
	            React.createElement(datePicker_1.DatePicker, tslib_1.__assign({}, this.props.datePickerProps, { canClearSelection: this.props.canClearSelection, onChange: this.handleDateChange, value: value })),
	            React.createElement(timePicker_1.TimePicker, tslib_1.__assign({}, this.props.timePickerProps, { onChange: this.handleTimeChange, value: value }))));
	    };
	    DateTimePicker.prototype.componentWillReceiveProps = function (nextProps) {
	        if (this.props.value === nextProps.value) {
	            return;
	        }
	        else if (nextProps.value != null) {
	            this.setState({
	                dateValue: nextProps.value,
	                timeValue: nextProps.value,
	            });
	        }
	        else {
	            // clear only the date to remove the selected-date style in the calendar
	            this.setState({ dateValue: null });
	        }
	    };
	    return DateTimePicker;
	}(core_1.AbstractComponent));
	DateTimePicker.defaultProps = {
	    canClearSelection: true,
	    defaultValue: new Date(),
	};
	DateTimePicker.displayName = "Blueprint.DateTimePicker";
	exports.DateTimePicker = DateTimePicker;
	
	//# sourceMappingURL=dateTimePicker.js.map


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 * Copyright 2015 Palantir Technologies, Inc. All rights reserved.
	 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
	 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
	 * and https://github.com/palantir/blueprint/blob/master/PATENTS
	 */
	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	var tslib_1 = __webpack_require__(6);
	var core_1 = __webpack_require__(9);
	var classNames = __webpack_require__(7);
	var React = __webpack_require__(8);
	var Classes = __webpack_require__(1);
	var DateUtils = __webpack_require__(3);
	var Utils = __webpack_require__(13);
	var TimePickerPrecision;
	(function (TimePickerPrecision) {
	    TimePickerPrecision[TimePickerPrecision["MINUTE"] = 0] = "MINUTE";
	    TimePickerPrecision[TimePickerPrecision["SECOND"] = 1] = "SECOND";
	    TimePickerPrecision[TimePickerPrecision["MILLISECOND"] = 2] = "MILLISECOND";
	})(TimePickerPrecision = exports.TimePickerPrecision || (exports.TimePickerPrecision = {}));
	var DEFAULT_MIN_HOUR = 0;
	var DEFAULT_MIN_MINUTE = 0;
	var DEFAULT_MIN_SECOND = 0;
	var DEFAULT_MIN_MILLISECOND = 0;
	var DEFAULT_MAX_HOUR = 23;
	var DEFAULT_MAX_MINUTE = 59;
	var DEFAULT_MAX_SECOND = 59;
	var DEFAULT_MAX_MILLISECOND = 999;
	function getDefaultMinTime() {
	    return new Date(0, 0, 0, DEFAULT_MIN_HOUR, DEFAULT_MIN_MINUTE, DEFAULT_MIN_SECOND, DEFAULT_MIN_MILLISECOND);
	}
	exports.getDefaultMinTime = getDefaultMinTime;
	function getDefaultMaxTime() {
	    return new Date(0, 0, 0, DEFAULT_MAX_HOUR, DEFAULT_MAX_MINUTE, DEFAULT_MAX_SECOND, DEFAULT_MAX_MILLISECOND);
	}
	exports.getDefaultMaxTime = getDefaultMaxTime;
	var TimePicker = (function (_super) {
	    tslib_1.__extends(TimePicker, _super);
	    function TimePicker(props, context) {
	        var _this = _super.call(this, props, context) || this;
	        // begin method definitions: event handlers
	        _this.getInputBlurHandler = function (unit) { return function (e) {
	            var text = getStringValueFromInputEvent(e);
	            _this.updateTime(parseInt(text, 10), unit);
	        }; };
	        _this.getInputChangeHandler = function (unit) { return function (e) {
	            var TWO_DIGITS = /^\d{0,2}$/;
	            var THREE_DIGITS = /^\d{0,3}$/;
	            var text = getStringValueFromInputEvent(e);
	            var isValid = false;
	            switch (unit) {
	                case TimeUnit.HOUR:
	                case TimeUnit.MINUTE:
	                case TimeUnit.SECOND:
	                    isValid = TWO_DIGITS.test(text);
	                    break;
	                case TimeUnit.MS:
	                    isValid = THREE_DIGITS.test(text);
	                    break;
	                default:
	                    throw Error("Invalid TimeUnit");
	            }
	            if (isValid) {
	                switch (unit) {
	                    case TimeUnit.HOUR:
	                        _this.updateState({ hourText: text });
	                        break;
	                    case TimeUnit.MINUTE:
	                        _this.updateState({ minuteText: text });
	                        break;
	                    case TimeUnit.SECOND:
	                        _this.updateState({ secondText: text });
	                        break;
	                    case TimeUnit.MS:
	                        _this.updateState({ millisecondText: text });
	                        break;
	                    default: throw Error("Invalid TimeUnit");
	                }
	            }
	        }; };
	        _this.getInputKeyDownHandler = function (unit) { return function (e) {
	            handleKeyEvent(e, (_a = {},
	                _a[core_1.Keys.ARROW_UP] = function () { return _this.incrementTime(unit); },
	                _a[core_1.Keys.ARROW_DOWN] = function () { return _this.decrementTime(unit); },
	                _a[core_1.Keys.ENTER] = function () {
	                    e.currentTarget.blur();
	                },
	                _a));
	            var _a;
	        }; };
	        _this.handleFocus = function (e) {
	            if (_this.props.selectAllOnFocus) {
	                e.currentTarget.select();
	            }
	        };
	        if (props.value != null) {
	            _this.state = _this.getFullStateFromValue(props.value);
	        }
	        else if (props.defaultValue != null) {
	            _this.state = _this.getFullStateFromValue(props.defaultValue);
	        }
	        else {
	            _this.state = _this.getFullStateFromValue(props.minTime);
	        }
	        return _this;
	    }
	    TimePicker.prototype.render = function () {
	        var _this = this;
	        var shouldRenderSeconds = this.props.precision >= TimePickerPrecision.SECOND;
	        var shouldRenderMilliseconds = this.props.precision >= TimePickerPrecision.MILLISECOND;
	        var classes = classNames(Classes.TIMEPICKER, this.props.className, (_a = {},
	            _a[core_1.Classes.DISABLED] = this.props.disabled,
	            _a));
	        /* tslint:disable:max-line-length */
	        return (React.createElement("div", { className: classes },
	            React.createElement("div", { className: Classes.TIMEPICKER_ARROW_ROW },
	                this.maybeRenderArrowButton(true, Classes.TIMEPICKER_HOUR, function () { return _this.incrementTime(TimeUnit.HOUR); }),
	                this.maybeRenderArrowButton(true, Classes.TIMEPICKER_MINUTE, function () { return _this.incrementTime(TimeUnit.MINUTE); }),
	                shouldRenderSeconds ? this.maybeRenderArrowButton(true, Classes.TIMEPICKER_SECOND, function () { return _this.incrementTime(TimeUnit.SECOND); }) : null,
	                shouldRenderMilliseconds ? this.maybeRenderArrowButton(true, Classes.TIMEPICKER_MILLISECOND, function () { return _this.incrementTime(TimeUnit.MS); }) : null),
	            React.createElement("div", { className: Classes.TIMEPICKER_INPUT_ROW },
	                this.renderInput(Classes.TIMEPICKER_HOUR, TimeUnit.HOUR, this.state.hourText),
	                this.renderDivider(),
	                this.renderInput(Classes.TIMEPICKER_MINUTE, TimeUnit.MINUTE, this.state.minuteText),
	                shouldRenderSeconds ? this.renderDivider() : null,
	                shouldRenderSeconds ? this.renderInput(Classes.TIMEPICKER_SECOND, TimeUnit.SECOND, this.state.secondText) : null,
	                shouldRenderMilliseconds ? this.renderDivider(".") : null,
	                shouldRenderMilliseconds ? this.renderInput(Classes.TIMEPICKER_MILLISECOND, TimeUnit.MS, this.state.millisecondText) : null),
	            React.createElement("div", { className: Classes.TIMEPICKER_ARROW_ROW },
	                this.maybeRenderArrowButton(false, Classes.TIMEPICKER_HOUR, function () { return _this.decrementTime(TimeUnit.HOUR); }),
	                this.maybeRenderArrowButton(false, Classes.TIMEPICKER_MINUTE, function () { return _this.decrementTime(TimeUnit.MINUTE); }),
	                shouldRenderSeconds ? this.maybeRenderArrowButton(false, Classes.TIMEPICKER_SECOND, function () { return _this.decrementTime(TimeUnit.SECOND); }) : null,
	                shouldRenderMilliseconds ? this.maybeRenderArrowButton(false, Classes.TIMEPICKER_MILLISECOND, function () { return _this.decrementTime(TimeUnit.MS); }) : null)));
	        var _a;
	        /* tslint:enable:max-line-length */
	    };
	    TimePicker.prototype.componentWillReceiveProps = function (nextProps) {
	        var didMinTimeChange = nextProps.minTime !== this.props.minTime;
	        var didMaxTimeChange = nextProps.maxTime !== this.props.maxTime;
	        var didBoundsChange = didMinTimeChange || didMaxTimeChange;
	        if (didBoundsChange) {
	            var timeInRange = DateUtils.getTimeInRange(this.state.value, nextProps.minTime, nextProps.maxTime);
	            this.setState(this.getFullStateFromValue(timeInRange));
	        }
	        if (nextProps.value != null && !DateUtils.areSameTime(nextProps.value, this.props.value)) {
	            this.setState(this.getFullStateFromValue(nextProps.value));
	        }
	    };
	    // begin method definitions: rendering
	    TimePicker.prototype.maybeRenderArrowButton = function (isDirectionUp, className, onClick) {
	        var classes = classNames(Classes.TIMEPICKER_ARROW_BUTTON, className, "pt-icon-standard", {
	            "pt-icon-chevron-down": !isDirectionUp,
	            "pt-icon-chevron-up": isDirectionUp,
	        });
	        return this.props.showArrowButtons ? React.createElement("span", { className: classes, onClick: onClick }) : null;
	    };
	    TimePicker.prototype.renderDivider = function (text) {
	        if (text === void 0) { text = ":"; }
	        return React.createElement("span", { className: Classes.TIMEPICKER_DIVIDER_TEXT }, text);
	    };
	    TimePicker.prototype.renderInput = function (className, unit, value) {
	        return (React.createElement("input", { className: classNames(Classes.TIMEPICKER_INPUT, className), onBlur: this.getInputBlurHandler(unit), onChange: this.getInputChangeHandler(unit), onFocus: this.handleFocus, onKeyDown: this.getInputKeyDownHandler(unit), value: value, disabled: this.props.disabled }));
	    };
	    // begin method definitions: state modification
	    /**
	     * Generates a full ITimePickerState object with all text fields set to formatted strings based on value
	     */
	    TimePicker.prototype.getFullStateFromValue = function (value) {
	        var timeInRange = DateUtils.getTimeInRange(value, this.props.minTime, this.props.maxTime);
	        /* tslint:disable:object-literal-sort-keys */
	        return {
	            hourText: formatTime(timeInRange.getHours(), TimeUnit.HOUR),
	            minuteText: formatTime(timeInRange.getMinutes(), TimeUnit.MINUTE),
	            secondText: formatTime(timeInRange.getSeconds(), TimeUnit.SECOND),
	            millisecondText: formatTime(timeInRange.getMilliseconds(), TimeUnit.MS),
	            value: timeInRange,
	        };
	        /* tslint:enable:object-literal-sort-keys */
	    };
	    TimePicker.prototype.incrementTime = function (unit) {
	        if (this.props.disabled) {
	            return;
	        }
	        var newTime = getTimeUnit(this.state.value, unit) + 1;
	        this.updateTime(loopTime(newTime, unit), unit);
	    };
	    TimePicker.prototype.decrementTime = function (unit) {
	        if (this.props.disabled) {
	            return;
	        }
	        var newTime = getTimeUnit(this.state.value, unit) - 1;
	        this.updateTime(loopTime(newTime, unit), unit);
	    };
	    TimePicker.prototype.updateTime = function (time, unit) {
	        var newValue = DateUtils.clone(this.state.value);
	        var _a = this.props, minTime = _a.minTime, maxTime = _a.maxTime;
	        if (isTimeValid(time, unit)) {
	            setTimeUnit(time, newValue, unit);
	            if (DateUtils.isTimeInRange(newValue, minTime, maxTime)) {
	                this.updateState({ value: newValue });
	            }
	            else if (!DateUtils.areSameTime(this.state.value, minTime)) {
	                this.updateState(this.getFullStateFromValue(newValue));
	            }
	        }
	        else {
	            // reset to last known good state
	            this.updateState(this.getFullStateFromValue(this.state.value));
	        }
	    };
	    TimePicker.prototype.updateState = function (state) {
	        var newState = state;
	        var hasNewValue = newState.value != null
	            && !DateUtils.areSameTime(newState.value, this.state.value);
	        if (this.props.value == null) {
	            // component is uncontrolled
	            if (hasNewValue) {
	                newState = this.getFullStateFromValue(newState.value);
	            }
	            this.setState(newState);
	        }
	        else {
	            // component is controlled, and there's a new value
	            // so set inputs' text based off of _old_ value and later fire onChange with new value
	            if (hasNewValue) {
	                this.setState(this.getFullStateFromValue(this.state.value));
	            }
	            else {
	                // no new value, this means only text has changed (from user typing)
	                // we want inputs to change, so update state with new text for the inputs
	                // but don't change actual value
	                this.setState(tslib_1.__assign({}, newState, { value: DateUtils.clone(this.state.value) }));
	            }
	        }
	        if (hasNewValue) {
	            core_1.Utils.safeInvoke(this.props.onChange, newState.value);
	        }
	    };
	    return TimePicker;
	}(React.Component));
	TimePicker.defaultProps = {
	    disabled: false,
	    maxTime: getDefaultMaxTime(),
	    minTime: getDefaultMinTime(),
	    precision: TimePickerPrecision.MINUTE,
	    selectAllOnFocus: false,
	    showArrowButtons: false,
	};
	TimePicker.displayName = "Blueprint.TimePicker";
	exports.TimePicker = TimePicker;
	var TimeUnit;
	(function (TimeUnit) {
	    TimeUnit[TimeUnit["HOUR"] = 0] = "HOUR";
	    TimeUnit[TimeUnit["MINUTE"] = 1] = "MINUTE";
	    TimeUnit[TimeUnit["SECOND"] = 2] = "SECOND";
	    TimeUnit[TimeUnit["MS"] = 3] = "MS";
	})(TimeUnit || (TimeUnit = {}));
	function formatTime(time, unit) {
	    switch (unit) {
	        case TimeUnit.HOUR:
	            return time.toString();
	        case TimeUnit.MINUTE:
	        case TimeUnit.SECOND:
	            return Utils.padWithZeroes(time.toString(), 2);
	        case TimeUnit.MS:
	            return Utils.padWithZeroes(time.toString(), 3);
	        default:
	            throw Error("Invalid TimeUnit");
	    }
	}
	function getStringValueFromInputEvent(e) {
	    return e.currentTarget.value;
	}
	function getTimeUnit(date, unit) {
	    switch (unit) {
	        case TimeUnit.HOUR: return date.getHours();
	        case TimeUnit.MINUTE: return date.getMinutes();
	        case TimeUnit.SECOND: return date.getSeconds();
	        case TimeUnit.MS: return date.getMilliseconds();
	        default: throw Error("Invalid TimeUnit");
	    }
	}
	function handleKeyEvent(e, actions, preventDefault) {
	    if (preventDefault === void 0) { preventDefault = true; }
	    for (var _i = 0, _a = Object.keys(actions); _i < _a.length; _i++) {
	        var k = _a[_i];
	        var key = Number(k);
	        if (e.which === key) {
	            if (preventDefault) {
	                e.preventDefault();
	            }
	            actions[key]();
	        }
	    }
	}
	function isTimeValid(time, unit) {
	    return time != null && !isNaN(time) && minTime(unit) <= time && time <= maxTime(unit);
	}
	function loopTime(time, unit) {
	    var max = maxTime(unit);
	    var min = minTime(unit);
	    if (time > max) {
	        return min;
	    }
	    else if (time < min) {
	        return max;
	    }
	    return time;
	}
	function minTime(unit) {
	    var min = (_a = {},
	        _a[TimeUnit.HOUR] = DEFAULT_MIN_HOUR,
	        _a[TimeUnit.MINUTE] = DEFAULT_MIN_MINUTE,
	        _a[TimeUnit.SECOND] = DEFAULT_MIN_SECOND,
	        _a[TimeUnit.MS] = DEFAULT_MIN_MILLISECOND,
	        _a);
	    return min[unit];
	    var _a;
	}
	function maxTime(unit) {
	    var max = (_a = {},
	        _a[TimeUnit.HOUR] = DEFAULT_MAX_HOUR,
	        _a[TimeUnit.MINUTE] = DEFAULT_MAX_MINUTE,
	        _a[TimeUnit.SECOND] = DEFAULT_MAX_SECOND,
	        _a[TimeUnit.MS] = DEFAULT_MAX_MILLISECOND,
	        _a);
	    return max[unit];
	    var _a;
	}
	function setTimeUnit(time, date, unit) {
	    switch (unit) {
	        case TimeUnit.HOUR:
	            date.setHours(time);
	            break;
	        case TimeUnit.MINUTE:
	            date.setMinutes(time);
	            break;
	        case TimeUnit.SECOND:
	            date.setSeconds(time);
	            break;
	        case TimeUnit.MS:
	            date.setMilliseconds(time);
	            break;
	        default: throw Error("Invalid TimeUnit");
	    }
	}
	exports.TimePickerFactory = React.createFactory(TimePicker);
	
	//# sourceMappingURL=timePicker.js.map


/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 * Copyright 2017 Palantir Technologies, Inc. All rights reserved.
	 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
	 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
	 * and https://github.com/palantir/blueprint/blob/master/PATENTS
	 */
	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	var tslib_1 = __webpack_require__(6);
	var classNames = __webpack_require__(7);
	var moment = __webpack_require__(4);
	var React = __webpack_require__(8);
	var core_1 = __webpack_require__(9);
	var dateUtils_1 = __webpack_require__(3);
	var Errors = __webpack_require__(10);
	var datePickerCore_1 = __webpack_require__(14);
	var dateRangePicker_1 = __webpack_require__(18);
	;
	;
	var DateRangeInput = (function (_super) {
	    tslib_1.__extends(DateRangeInput, _super);
	    function DateRangeInput(props, context) {
	        var _this = _super.call(this, props, context) || this;
	        _this.refHandlers = {
	            endInputRef: function (ref) {
	                _this.endInputRef = ref;
	                core_1.Utils.safeInvoke(_this.props.endInputProps.inputRef, ref);
	            },
	            startInputRef: function (ref) {
	                _this.startInputRef = ref;
	                core_1.Utils.safeInvoke(_this.props.startInputProps.inputRef, ref);
	            },
	        };
	        _this.renderInputGroup = function (boundary) {
	            var inputProps = _this.getInputProps(boundary);
	            // don't include `ref` in the returned HTML props, because passing it to the InputGroup
	            // leads to TS typing errors.
	            var ref = inputProps.ref, htmlProps = tslib_1.__rest(inputProps, ["ref"]);
	            var handleInputEvent = (boundary === dateUtils_1.DateRangeBoundary.START)
	                ? _this.handleStartInputEvent
	                : _this.handleEndInputEvent;
	            var classes = classNames((_a = {},
	                _a[core_1.Classes.INTENT_DANGER] = _this.isInputInErrorState(boundary),
	                _a), inputProps.className);
	            return (React.createElement(core_1.InputGroup, tslib_1.__assign({ autoComplete: "off" }, htmlProps, { className: classes, disabled: _this.props.disabled, inputRef: _this.getInputRef(boundary), onBlur: handleInputEvent, onChange: handleInputEvent, onClick: handleInputEvent, onFocus: handleInputEvent, onKeyDown: handleInputEvent, onMouseDown: handleInputEvent, placeholder: _this.getInputPlaceholderString(boundary), value: _this.getInputDisplayString(boundary) })));
	            var _a;
	        };
	        // Callbacks - DateRangePicker
	        // ===========================
	        _this.handleDateRangePickerChange = function (selectedRange) {
	            // ignore mouse events in the date-range picker if the popover is animating closed.
	            if (!_this.state.isOpen) {
	                return;
	            }
	            var _a = dateUtils_1.fromDateRangeToMomentDateRange(selectedRange), selectedStart = _a[0], selectedEnd = _a[1];
	            var isOpen = true;
	            var isStartInputFocused;
	            var isEndInputFocused;
	            var startHoverString;
	            var endHoverString;
	            if (dateUtils_1.isMomentNull(selectedStart)) {
	                // focus the start field by default or if only an end date is specified
	                isStartInputFocused = true;
	                isEndInputFocused = false;
	                // for clarity, hide the hover string until the mouse moves over a different date
	                startHoverString = null;
	            }
	            else if (dateUtils_1.isMomentNull(selectedEnd)) {
	                // focus the end field if a start date is specified
	                isStartInputFocused = false;
	                isEndInputFocused = true;
	                endHoverString = null;
	            }
	            else if (_this.props.closeOnSelection) {
	                isOpen = false;
	                isStartInputFocused = false;
	                isEndInputFocused = false;
	            }
	            else if (_this.state.lastFocusedField === dateUtils_1.DateRangeBoundary.START) {
	                // keep the start field focused
	                isStartInputFocused = true;
	                isEndInputFocused = false;
	            }
	            else {
	                // keep the end field focused
	                isStartInputFocused = false;
	                isEndInputFocused = true;
	            }
	            var baseStateChange = {
	                isOpen: isOpen,
	                isEndInputFocused: isEndInputFocused,
	                isStartInputFocused: isStartInputFocused,
	                startHoverString: startHoverString,
	                endHoverString: endHoverString,
	                endInputString: _this.getFormattedDateString(selectedEnd),
	                startInputString: _this.getFormattedDateString(selectedStart),
	                wasLastFocusChangeDueToHover: false,
	            };
	            if (_this.isControlled()) {
	                _this.setState(baseStateChange);
	            }
	            else {
	                _this.setState(tslib_1.__assign({}, baseStateChange, { selectedEnd: selectedEnd, selectedStart: selectedStart }));
	            }
	            core_1.Utils.safeInvoke(_this.props.onChange, selectedRange);
	        };
	        _this.handleDateRangePickerHoverChange = function (hoveredRange, _hoveredDay, hoveredBoundary) {
	            // ignore mouse events in the date-range picker if the popover is animating closed.
	            if (!_this.state.isOpen) {
	                return;
	            }
	            if (hoveredRange == null) {
	                // undo whatever focus changes we made while hovering over various calendar dates
	                var isEndInputFocused = (_this.state.boundaryToModify === dateUtils_1.DateRangeBoundary.END);
	                _this.setState({
	                    isEndInputFocused: isEndInputFocused,
	                    endHoverString: null,
	                    isStartInputFocused: !isEndInputFocused,
	                    lastFocusedField: _this.state.boundaryToModify,
	                    startHoverString: null,
	                });
	            }
	            else {
	                var _a = dateUtils_1.fromDateRangeToMomentDateRange(hoveredRange), hoveredStart = _a[0], hoveredEnd = _a[1];
	                var isStartInputFocused = (hoveredBoundary != null)
	                    ? hoveredBoundary === dateUtils_1.DateRangeBoundary.START
	                    : _this.state.isStartInputFocused;
	                var isEndInputFocused = (hoveredBoundary != null)
	                    ? hoveredBoundary === dateUtils_1.DateRangeBoundary.END
	                    : _this.state.isEndInputFocused;
	                _this.setState({
	                    isStartInputFocused: isStartInputFocused,
	                    isEndInputFocused: isEndInputFocused,
	                    endHoverString: _this.getFormattedDateString(hoveredEnd),
	                    lastFocusedField: (isStartInputFocused) ? dateUtils_1.DateRangeBoundary.START : dateUtils_1.DateRangeBoundary.END,
	                    shouldSelectAfterUpdate: _this.props.selectAllOnFocus,
	                    startHoverString: _this.getFormattedDateString(hoveredStart),
	                    wasLastFocusChangeDueToHover: true,
	                });
	            }
	        };
	        // Callbacks - Input
	        // =================
	        // instantiate these two functions once so we don't have to for each callback on each render.
	        _this.handleStartInputEvent = function (e) {
	            _this.handleInputEvent(e, dateUtils_1.DateRangeBoundary.START);
	        };
	        _this.handleEndInputEvent = function (e) {
	            _this.handleInputEvent(e, dateUtils_1.DateRangeBoundary.END);
	        };
	        _this.handleInputEvent = function (e, boundary) {
	            switch (e.type) {
	                case "blur":
	                    _this.handleInputBlur(e, boundary);
	                    break;
	                case "change":
	                    _this.handleInputChange(e, boundary);
	                    break;
	                case "click":
	                    _this.handleInputClick(e);
	                    break;
	                case "focus":
	                    _this.handleInputFocus(e, boundary);
	                    break;
	                case "keydown":
	                    _this.handleInputKeyDown(e);
	                    break;
	                case "mousedown":
	                    _this.handleInputMouseDown();
	                    break;
	                default: break;
	            }
	            var inputProps = _this.getInputProps(boundary);
	            var callbackFn = _this.getInputGroupCallbackForEvent(e, inputProps);
	            core_1.Utils.safeInvoke(callbackFn, e);
	        };
	        // add a keydown listener to persistently change focus when tabbing:
	        // - if focused in start field, Tab moves focus to end field
	        // - if focused in end field, Shift+Tab moves focus to start field
	        _this.handleInputKeyDown = function (e) {
	            var isTabPressed = e.keyCode === core_1.Keys.TAB;
	            var isShiftPressed = e.shiftKey;
	            // order of JS events is our enemy here. when tabbing between fields,
	            // this handler will fire in the middle of a focus exchange when no
	            // field is currently focused. we work around this by referring to the
	            // most recently focused field, rather than the currently focused field.
	            var wasStartFieldFocused = _this.state.lastFocusedField === dateUtils_1.DateRangeBoundary.START;
	            var wasEndFieldFocused = _this.state.lastFocusedField === dateUtils_1.DateRangeBoundary.END;
	            var isEndInputFocused;
	            var isStartInputFocused;
	            // move focus to the other field
	            if (wasStartFieldFocused && isTabPressed && !isShiftPressed) {
	                isStartInputFocused = false;
	                isEndInputFocused = true;
	            }
	            else if (wasEndFieldFocused && isTabPressed && isShiftPressed) {
	                isStartInputFocused = true;
	                isEndInputFocused = false;
	            }
	            else {
	                // let the default keystroke happen without side effects
	                return;
	            }
	            // prevent the default focus-change behavior to avoid race conditions;
	            // we'll handle the focus change ourselves in componentDidUpdate.
	            e.preventDefault();
	            _this.setState({
	                isStartInputFocused: isStartInputFocused,
	                isEndInputFocused: isEndInputFocused,
	                wasLastFocusChangeDueToHover: false,
	            });
	        };
	        _this.handleInputMouseDown = function () {
	            // clicking in the field constitutes an explicit focus change. we update
	            // the flag on "mousedown" instead of on "click", because it needs to be
	            // set before onFocus is called ("click" triggers after "focus").
	            _this.setState({ wasLastFocusChangeDueToHover: false });
	        };
	        _this.handleInputClick = function (e) {
	            // unless we stop propagation on this event, a click within an input
	            // will close the popover almost as soon as it opens.
	            e.stopPropagation();
	        };
	        _this.handleInputFocus = function (_e, boundary) {
	            var _a = _this.getStateKeysAndValuesForBoundary(boundary), keys = _a.keys, values = _a.values;
	            var inputString = _this.getFormattedDateString(values.selectedValue);
	            // change the boundary only if the user explicitly focused in the field.
	            // focus changes from hovering don't count; they're just temporary.
	            var boundaryToModify = (_this.state.wasLastFocusChangeDueToHover)
	                ? _this.state.boundaryToModify
	                : boundary;
	            _this.setState((_b = {
	                    isOpen: true,
	                    boundaryToModify: boundaryToModify
	                },
	                _b[keys.inputString] = inputString,
	                _b[keys.isInputFocused] = true,
	                _b.lastFocusedField = boundary,
	                _b.shouldSelectAfterUpdate = _this.props.selectAllOnFocus,
	                _b.wasLastFocusChangeDueToHover = false,
	                _b));
	            var _b;
	        };
	        _this.handleInputBlur = function (_e, boundary) {
	            var _a = _this.getStateKeysAndValuesForBoundary(boundary), keys = _a.keys, values = _a.values;
	            var maybeNextValue = _this.dateStringToMoment(values.inputString);
	            var isValueControlled = _this.isControlled();
	            var nextState = (_b = {},
	                _b[keys.isInputFocused] = false,
	                _b.shouldSelectAfterUpdate = false,
	                _b);
	            if (_this.isInputEmpty(values.inputString)) {
	                if (isValueControlled) {
	                    nextState = tslib_1.__assign({}, nextState, (_c = {}, _c[keys.inputString] = _this.getFormattedDateString(values.controlledValue), _c));
	                }
	                else {
	                    nextState = tslib_1.__assign({}, nextState, (_d = {}, _d[keys.inputString] = null, _d[keys.selectedValue] = moment(null), _d));
	                }
	            }
	            else if (!_this.isNextDateRangeValid(maybeNextValue, boundary)) {
	                if (!isValueControlled) {
	                    nextState = tslib_1.__assign({}, nextState, (_f = {}, _f[keys.inputString] = null, _f[keys.selectedValue] = maybeNextValue, _f));
	                }
	                core_1.Utils.safeInvoke(_this.props.onError, _this.getDateRangeForCallback(maybeNextValue, boundary));
	            }
	            _this.setState(nextState);
	            var _b, _c, _d, _f;
	        };
	        _this.handleInputChange = function (e, boundary) {
	            var inputString = e.target.value;
	            var keys = _this.getStateKeysAndValuesForBoundary(boundary).keys;
	            var maybeNextValue = _this.dateStringToMoment(inputString);
	            var isValueControlled = _this.isControlled();
	            var nextState = { shouldSelectAfterUpdate: false };
	            if (inputString.length === 0) {
	                // this case will be relevant when we start showing the hovered range in the input
	                // fields. goal is to show an empty field for clarity until the mouse moves over a
	                // different date.
	                var baseState = tslib_1.__assign({}, nextState, (_a = {}, _a[keys.inputString] = "", _a));
	                if (isValueControlled) {
	                    nextState = baseState;
	                }
	                else {
	                    nextState = tslib_1.__assign({}, baseState, (_b = {}, _b[keys.selectedValue] = moment(null), _b));
	                }
	                core_1.Utils.safeInvoke(_this.props.onChange, _this.getDateRangeForCallback(moment(null), boundary));
	            }
	            else if (_this.isMomentValidAndInRange(maybeNextValue)) {
	                // note that error cases that depend on both fields (e.g. overlapping dates) should fall
	                // through into this block so that the UI can update immediately, possibly with an error
	                // message on the other field.
	                // also, clear the hover string to ensure the most recent keystroke appears.
	                var baseState = tslib_1.__assign({}, nextState, (_c = {}, _c[keys.hoverString] = null, _c[keys.inputString] = inputString, _c));
	                if (isValueControlled) {
	                    nextState = baseState;
	                }
	                else {
	                    nextState = tslib_1.__assign({}, baseState, (_d = {}, _d[keys.selectedValue] = maybeNextValue, _d));
	                }
	                if (_this.isNextDateRangeValid(maybeNextValue, boundary)) {
	                    core_1.Utils.safeInvoke(_this.props.onChange, _this.getDateRangeForCallback(maybeNextValue, boundary));
	                }
	            }
	            else {
	                // again, clear the hover string to ensure the most recent keystroke appears
	                nextState = tslib_1.__assign({}, nextState, (_f = {}, _f[keys.inputString] = inputString, _f[keys.hoverString] = null, _f));
	            }
	            _this.setState(nextState);
	            var _a, _b, _c, _d, _f;
	        };
	        // Callbacks - Popover
	        // ===================
	        _this.handlePopoverClose = function () {
	            _this.setState({ isOpen: false });
	            core_1.Utils.safeInvoke(_this.props.popoverProps.onClose);
	        };
	        _this.dateStringToMoment = function (dateString) {
	            if (_this.isInputEmpty(dateString)) {
	                return moment(null);
	            }
	            return moment(dateString, _this.props.format, _this.props.locale);
	        };
	        _this.getInitialRange = function (props) {
	            if (props === void 0) { props = _this.props; }
	            var defaultValue = props.defaultValue, value = props.value;
	            if (value != null) {
	                return dateUtils_1.fromDateRangeToMomentDateRange(value);
	            }
	            else if (defaultValue != null) {
	                return dateUtils_1.fromDateRangeToMomentDateRange(defaultValue);
	            }
	            else {
	                return [moment(null), moment(null)];
	            }
	        };
	        _this.getSelectedRange = function () {
	            var selectedStart;
	            var selectedEnd;
	            if (_this.isControlled()) {
	                _a = _this.props.value.map(dateUtils_1.fromDateToMoment), selectedStart = _a[0], selectedEnd = _a[1];
	            }
	            else {
	                selectedStart = _this.state.selectedStart;
	                selectedEnd = _this.state.selectedEnd;
	            }
	            // this helper function checks if the provided boundary date *would* overlap the selected
	            // other boundary date. providing the already-selected start date simply tells us if we're
	            // currently in an overlapping state.
	            var doBoundaryDatesOverlap = _this.doBoundaryDatesOverlap(selectedStart, dateUtils_1.DateRangeBoundary.START);
	            var momentDateRange = [selectedStart, doBoundaryDatesOverlap ? moment(null) : selectedEnd];
	            return momentDateRange.map(function (selectedBound) {
	                return _this.isMomentValidAndInRange(selectedBound)
	                    ? dateUtils_1.fromMomentToDate(selectedBound)
	                    : undefined;
	            });
	            var _a;
	        };
	        _this.getInputGroupCallbackForEvent = function (e, inputProps) {
	            // use explicit switch cases to ensure callback function names remain grep-able in the codebase.
	            switch (e.type) {
	                case "blur": return inputProps.onBlur;
	                case "change": return inputProps.onChange;
	                case "click": return inputProps.onClick;
	                case "focus": return inputProps.onFocus;
	                case "keydown": return inputProps.onKeyDown;
	                case "mousedown": return inputProps.onMouseDown;
	                default: return undefined;
	            }
	        };
	        _this.getInputDisplayString = function (boundary) {
	            var values = _this.getStateKeysAndValuesForBoundary(boundary).values;
	            var isInputFocused = values.isInputFocused, inputString = values.inputString, selectedValue = values.selectedValue, hoverString = values.hoverString;
	            if (hoverString != null) {
	                return hoverString;
	            }
	            else if (isInputFocused) {
	                return (inputString == null) ? "" : inputString;
	            }
	            else if (dateUtils_1.isMomentNull(selectedValue)) {
	                return "";
	            }
	            else if (!_this.isMomentInRange(selectedValue)) {
	                return _this.props.outOfRangeMessage;
	            }
	            else if (_this.doesEndBoundaryOverlapStartBoundary(selectedValue, boundary)) {
	                return _this.props.overlappingDatesMessage;
	            }
	            else {
	                return _this.getFormattedDateString(selectedValue);
	            }
	        };
	        _this.getInputPlaceholderString = function (boundary) {
	            var isStartBoundary = boundary === dateUtils_1.DateRangeBoundary.START;
	            var isEndBoundary = boundary === dateUtils_1.DateRangeBoundary.END;
	            var inputProps = _this.getInputProps(boundary);
	            var isInputFocused = _this.getStateKeysAndValuesForBoundary(boundary).values.isInputFocused;
	            // use the custom placeholder text for the input, if providied
	            if (inputProps.placeholder != null) {
	                return inputProps.placeholder;
	            }
	            else if (isStartBoundary) {
	                return isInputFocused ? _this.state.formattedMinDateString : "Start date";
	            }
	            else if (isEndBoundary) {
	                return isInputFocused ? _this.state.formattedMaxDateString : "End date";
	            }
	            else {
	                return "";
	            }
	        };
	        _this.getInputProps = function (boundary) {
	            return (boundary === dateUtils_1.DateRangeBoundary.START)
	                ? _this.props.startInputProps
	                : _this.props.endInputProps;
	        };
	        _this.getInputRef = function (boundary) {
	            return (boundary === dateUtils_1.DateRangeBoundary.START)
	                ? _this.refHandlers.startInputRef
	                : _this.refHandlers.endInputRef;
	        };
	        _this.getFormattedDateString = function (momentDate, formatOverride) {
	            if (dateUtils_1.isMomentNull(momentDate)) {
	                return "";
	            }
	            else if (!momentDate.isValid()) {
	                return _this.props.invalidDateMessage;
	            }
	            else {
	                var format = (formatOverride != null) ? formatOverride : _this.props.format;
	                return dateUtils_1.toLocalizedDateString(momentDate, format, _this.props.locale);
	            }
	        };
	        _this.getStateKeysAndValuesForBoundary = function (boundary) {
	            var controlledRange = dateUtils_1.fromDateRangeToMomentDateRange(_this.props.value);
	            if (boundary === dateUtils_1.DateRangeBoundary.START) {
	                return {
	                    keys: {
	                        hoverString: "startHoverString",
	                        inputString: "startInputString",
	                        isInputFocused: "isStartInputFocused",
	                        selectedValue: "selectedStart",
	                    },
	                    values: {
	                        controlledValue: (controlledRange != null) ? controlledRange[0] : undefined,
	                        hoverString: _this.state.startHoverString,
	                        inputString: _this.state.startInputString,
	                        isInputFocused: _this.state.isStartInputFocused,
	                        selectedValue: _this.state.selectedStart,
	                    },
	                };
	            }
	            else {
	                return {
	                    keys: {
	                        hoverString: "endHoverString",
	                        inputString: "endInputString",
	                        isInputFocused: "isEndInputFocused",
	                        selectedValue: "selectedEnd",
	                    },
	                    values: {
	                        controlledValue: (controlledRange != null) ? controlledRange[1] : undefined,
	                        hoverString: _this.state.endHoverString,
	                        inputString: _this.state.endInputString,
	                        isInputFocused: _this.state.isEndInputFocused,
	                        selectedValue: _this.state.selectedEnd,
	                    },
	                };
	            }
	        };
	        _this.getDateRangeForCallback = function (currValue, currBoundary) {
	            var otherBoundary = _this.getOtherBoundary(currBoundary);
	            var otherValue = _this.getStateKeysAndValuesForBoundary(otherBoundary).values.selectedValue;
	            var currDate = _this.getDateForCallback(currValue);
	            var otherDate = _this.getDateForCallback(otherValue);
	            return (currBoundary === dateUtils_1.DateRangeBoundary.START)
	                ? [currDate, otherDate]
	                : [otherDate, currDate];
	        };
	        _this.getDateForCallback = function (momentDate) {
	            if (dateUtils_1.isMomentNull(momentDate)) {
	                return null;
	            }
	            else if (!momentDate.isValid()) {
	                return new Date(undefined);
	            }
	            else {
	                return dateUtils_1.fromMomentToDate(momentDate);
	            }
	        };
	        _this.getOtherBoundary = function (boundary) {
	            return (boundary === dateUtils_1.DateRangeBoundary.START) ? dateUtils_1.DateRangeBoundary.END : dateUtils_1.DateRangeBoundary.START;
	        };
	        _this.doBoundaryDatesOverlap = function (boundaryDate, boundary) {
	            var allowSingleDayRange = _this.props.allowSingleDayRange;
	            var otherBoundary = _this.getOtherBoundary(boundary);
	            var otherBoundaryDate = _this.getStateKeysAndValuesForBoundary(otherBoundary).values.selectedValue;
	            if (boundary === dateUtils_1.DateRangeBoundary.START) {
	                return allowSingleDayRange
	                    ? boundaryDate.isAfter(otherBoundaryDate, "day")
	                    : boundaryDate.isSameOrAfter(otherBoundaryDate, "day");
	            }
	            else {
	                return allowSingleDayRange
	                    ? boundaryDate.isBefore(otherBoundaryDate, "day")
	                    : boundaryDate.isSameOrBefore(otherBoundaryDate, "day");
	            }
	        };
	        /**
	         * Returns true if the provided boundary is an END boundary overlapping the
	         * selected start date. (If the boundaries overlap, we consider the END
	         * boundary to be erroneous.)
	         */
	        _this.doesEndBoundaryOverlapStartBoundary = function (boundaryDate, boundary) {
	            return (boundary === dateUtils_1.DateRangeBoundary.START)
	                ? false
	                : _this.doBoundaryDatesOverlap(boundaryDate, boundary);
	        };
	        _this.isControlled = function () {
	            return _this.props.value !== undefined;
	        };
	        _this.isInputEmpty = function (inputString) {
	            return inputString == null || inputString.length === 0;
	        };
	        _this.isInputInErrorState = function (boundary) {
	            var values = _this.getStateKeysAndValuesForBoundary(boundary).values;
	            var isInputFocused = values.isInputFocused, hoverString = values.hoverString, inputString = values.inputString, selectedValue = values.selectedValue;
	            var boundaryValue = (isInputFocused)
	                ? _this.dateStringToMoment(inputString)
	                : selectedValue;
	            if (hoverString != null) {
	                // don't show an error state while we're hovering over a valid date.
	                return false;
	            }
	            else if (dateUtils_1.isMomentNull(boundaryValue)) {
	                return false;
	            }
	            else if (!boundaryValue.isValid()) {
	                return true;
	            }
	            else if (!_this.isMomentInRange(boundaryValue)) {
	                return true;
	            }
	            else if (_this.doesEndBoundaryOverlapStartBoundary(boundaryValue, boundary)) {
	                return true;
	            }
	            else {
	                return false;
	            }
	        };
	        _this.isMomentValidAndInRange = function (momentDate) {
	            return dateUtils_1.isMomentValidAndInRange(momentDate, _this.props.minDate, _this.props.maxDate);
	        };
	        _this.isMomentInRange = function (momentDate) {
	            return dateUtils_1.isMomentInRange(momentDate, _this.props.minDate, _this.props.maxDate);
	        };
	        _this.reset(props);
	        return _this;
	    }
	    /**
	     * Public method intended for unit testing only. Do not use in feature work!
	     */
	    DateRangeInput.prototype.reset = function (props) {
	        if (props === void 0) { props = this.props; }
	        var _a = this.getInitialRange(), selectedStart = _a[0], selectedEnd = _a[1];
	        this.state = {
	            formattedMaxDateString: this.getFormattedMinMaxDateString(props, "maxDate"),
	            formattedMinDateString: this.getFormattedMinMaxDateString(props, "minDate"),
	            isOpen: false,
	            selectedEnd: selectedEnd,
	            selectedStart: selectedStart,
	        };
	    };
	    DateRangeInput.prototype.componentDidUpdate = function () {
	        var _a = this.state, isStartInputFocused = _a.isStartInputFocused, isEndInputFocused = _a.isEndInputFocused, shouldSelectAfterUpdate = _a.shouldSelectAfterUpdate;
	        var shouldFocusStartInput = this.shouldFocusInputRef(isStartInputFocused, this.startInputRef);
	        var shouldFocusEndInput = this.shouldFocusInputRef(isEndInputFocused, this.endInputRef);
	        if (shouldFocusStartInput) {
	            this.startInputRef.focus();
	        }
	        else if (shouldFocusEndInput) {
	            this.endInputRef.focus();
	        }
	        if (isStartInputFocused && shouldSelectAfterUpdate) {
	            this.startInputRef.select();
	        }
	        else if (isEndInputFocused && shouldSelectAfterUpdate) {
	            this.endInputRef.select();
	        }
	    };
	    DateRangeInput.prototype.render = function () {
	        var popoverContent = (React.createElement(dateRangePicker_1.DateRangePicker, tslib_1.__assign({}, this.props, { boundaryToModify: this.state.boundaryToModify, onChange: this.handleDateRangePickerChange, onHoverChange: this.handleDateRangePickerHoverChange, value: this.getSelectedRange() })));
	        // allow custom props for the popover and each input group, but pass them in an order that
	        // guarantees only some props are overridable.
	        return (React.createElement(core_1.Popover, tslib_1.__assign({ inline: true, isOpen: this.state.isOpen, position: core_1.Position.BOTTOM_LEFT }, this.props.popoverProps, { autoFocus: false, content: popoverContent, enforceFocus: false, onClose: this.handlePopoverClose }),
	            React.createElement("div", { className: core_1.Classes.CONTROL_GROUP },
	                this.renderInputGroup(dateUtils_1.DateRangeBoundary.START),
	                this.renderInputGroup(dateUtils_1.DateRangeBoundary.END))));
	    };
	    DateRangeInput.prototype.componentWillReceiveProps = function (nextProps) {
	        _super.prototype.componentWillReceiveProps.call(this, nextProps);
	        var nextState = {};
	        if (nextProps.value !== this.props.value) {
	            var _a = this.getInitialRange(nextProps), selectedStart = _a[0], selectedEnd = _a[1];
	            nextState = tslib_1.__assign({}, nextState, { selectedStart: selectedStart, selectedEnd: selectedEnd });
	        }
	        // we use Moment to format date strings, but min/max dates come in as vanilla JS Dates.
	        // cache the formatted date strings to avoid creating new Moment instances on each render.
	        var didFormatChange = nextProps.format !== this.props.format;
	        if (didFormatChange || nextProps.minDate !== this.props.minDate) {
	            var formattedMinDateString = this.getFormattedMinMaxDateString(nextProps, "minDate");
	            nextState = tslib_1.__assign({}, nextState, { formattedMinDateString: formattedMinDateString });
	        }
	        if (didFormatChange || nextProps.maxDate !== this.props.maxDate) {
	            var formattedMaxDateString = this.getFormattedMinMaxDateString(nextProps, "maxDate");
	            nextState = tslib_1.__assign({}, nextState, { formattedMaxDateString: formattedMaxDateString });
	        }
	        this.setState(nextState);
	    };
	    DateRangeInput.prototype.validateProps = function (props) {
	        if (props.value === null) {
	            throw new Error(Errors.DATERANGEINPUT_NULL_VALUE);
	        }
	    };
	    // Helpers
	    // =======
	    DateRangeInput.prototype.shouldFocusInputRef = function (isFocused, inputRef) {
	        return isFocused && inputRef !== undefined && document.activeElement !== inputRef;
	    };
	    DateRangeInput.prototype.isNextDateRangeValid = function (nextMomentDate, boundary) {
	        return this.isMomentValidAndInRange(nextMomentDate)
	            && !this.doBoundaryDatesOverlap(nextMomentDate, boundary);
	    };
	    // this is a slightly kludgy function, but it saves us a good amount of repeated code between
	    // the constructor and componentWillReceiveProps.
	    DateRangeInput.prototype.getFormattedMinMaxDateString = function (props, propName) {
	        var date = props[propName];
	        var defaultDate = DateRangeInput.defaultProps[propName];
	        // default values are applied only if a prop is strictly `undefined`
	        // See: https://facebook.github.io/react/docs/react-component.html#defaultprops
	        return this.getFormattedDateString(moment((date === undefined) ? defaultDate : date), props.format);
	    };
	    return DateRangeInput;
	}(core_1.AbstractComponent));
	DateRangeInput.defaultProps = {
	    allowSingleDayRange: false,
	    closeOnSelection: true,
	    contiguousCalendarMonths: true,
	    disabled: false,
	    endInputProps: {},
	    format: "YYYY-MM-DD",
	    invalidDateMessage: "Invalid date",
	    maxDate: datePickerCore_1.getDefaultMaxDate(),
	    minDate: datePickerCore_1.getDefaultMinDate(),
	    outOfRangeMessage: "Out of range",
	    overlappingDatesMessage: "Overlapping dates",
	    popoverProps: {},
	    selectAllOnFocus: false,
	    shortcuts: true,
	    startInputProps: {},
	};
	DateRangeInput.displayName = "Blueprint.DateRangeInput";
	exports.DateRangeInput = DateRangeInput;
	
	//# sourceMappingURL=dateRangeInput.js.map


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
	 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
	 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
	 * and https://github.com/palantir/blueprint/blob/master/PATENTS
	 */
	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	var tslib_1 = __webpack_require__(6);
	var core_1 = __webpack_require__(9);
	var classNames = __webpack_require__(7);
	var React = __webpack_require__(8);
	var DayPicker = __webpack_require__(2);
	var DateClasses = __webpack_require__(1);
	var DateUtils = __webpack_require__(3);
	var dateUtils_1 = __webpack_require__(3);
	var Errors = __webpack_require__(10);
	var monthAndYear_1 = __webpack_require__(19);
	var datePickerCaption_1 = __webpack_require__(12);
	var datePickerCore_1 = __webpack_require__(14);
	var dateRangeSelectionStrategy_1 = __webpack_require__(20);
	var DateRangePicker = (function (_super) {
	    tslib_1.__extends(DateRangePicker, _super);
	    function DateRangePicker(props, context) {
	        var _this = _super.call(this, props, context) || this;
	        // these will get merged with the user's own
	        _this.modifiers = (_a = {},
	            _a[datePickerCore_1.SELECTED_RANGE_MODIFIER] = function (day) {
	                var value = _this.state.value;
	                return value[0] != null && value[1] != null && DateUtils.isDayInRange(day, value, true);
	            },
	            _a[datePickerCore_1.SELECTED_RANGE_MODIFIER + "-start"] = function (day) { return DateUtils.areSameDay(_this.state.value[0], day); },
	            _a[datePickerCore_1.SELECTED_RANGE_MODIFIER + "-end"] = function (day) { return DateUtils.areSameDay(_this.state.value[1], day); },
	            _a[datePickerCore_1.HOVERED_RANGE_MODIFIER] = function (day) {
	                var _a = _this.state, hoverValue = _a.hoverValue, value = _a.value;
	                var selectedStart = value[0], selectedEnd = value[1];
	                if (selectedStart == null && selectedEnd == null) {
	                    return false;
	                }
	                if (hoverValue == null || hoverValue[0] == null || hoverValue[1] == null) {
	                    return false;
	                }
	                return DateUtils.isDayInRange(day, hoverValue, true);
	            },
	            _a[datePickerCore_1.HOVERED_RANGE_MODIFIER + "-start"] = function (day) {
	                var hoverValue = _this.state.hoverValue;
	                if (hoverValue == null || hoverValue[0] == null) {
	                    return false;
	                }
	                return DateUtils.areSameDay(hoverValue[0], day);
	            },
	            _a[datePickerCore_1.HOVERED_RANGE_MODIFIER + "-end"] = function (day) {
	                var hoverValue = _this.state.hoverValue;
	                if (hoverValue == null || hoverValue[1] == null) {
	                    return false;
	                }
	                return DateUtils.areSameDay(hoverValue[1], day);
	            },
	            _a);
	        _this.renderSingleCaption = function (captionProps) { return (React.createElement(datePickerCaption_1.DatePickerCaption, tslib_1.__assign({}, captionProps, { maxDate: _this.props.maxDate, minDate: _this.props.minDate, onMonthChange: _this.handleLeftMonthSelectChange, onYearChange: _this.handleLeftYearSelectChange }))); };
	        _this.renderLeftCaption = function (captionProps) { return (React.createElement(datePickerCaption_1.DatePickerCaption, tslib_1.__assign({}, captionProps, { maxDate: DateUtils.getDatePreviousMonth(_this.props.maxDate), minDate: _this.props.minDate, onMonthChange: _this.handleLeftMonthSelectChange, onYearChange: _this.handleLeftYearSelectChange }))); };
	        _this.renderRightCaption = function (captionProps) { return (React.createElement(datePickerCaption_1.DatePickerCaption, tslib_1.__assign({}, captionProps, { maxDate: _this.props.maxDate, minDate: DateUtils.getDateNextMonth(_this.props.minDate), onMonthChange: _this.handleRightMonthSelectChange, onYearChange: _this.handleRightYearSelectChange }))); };
	        _this.handleDayMouseEnter = function (day, modifiers) {
	            if (modifiers.disabled) {
	                return;
	            }
	            var _a = dateRangeSelectionStrategy_1.DateRangeSelectionStrategy.getNextState(_this.state.value, day, _this.props.allowSingleDayRange, _this.props.boundaryToModify), dateRange = _a.dateRange, boundary = _a.boundary;
	            _this.setState({ hoverValue: dateRange });
	            core_1.Utils.safeInvoke(_this.props.onHoverChange, dateRange, day, boundary);
	        };
	        _this.handleDayMouseLeave = function (day, modifiers) {
	            if (modifiers.disabled) {
	                return;
	            }
	            _this.setState({ hoverValue: undefined });
	            core_1.Utils.safeInvoke(_this.props.onHoverChange, undefined, day, undefined);
	        };
	        _this.handleDayClick = function (day, modifiers) {
	            if (modifiers.disabled) {
	                // rerender base component to get around bug where you can navigate past bounds by clicking days
	                _this.forceUpdate();
	                return;
	            }
	            var nextValue = dateRangeSelectionStrategy_1.DateRangeSelectionStrategy.getNextState(_this.state.value, day, _this.props.allowSingleDayRange, _this.props.boundaryToModify).dateRange;
	            // update the hovered date range after click to show the newly selected
	            // state, at leasts until the mouse moves again
	            _this.handleDayMouseEnter(day, modifiers);
	            _this.handleNextState(nextValue);
	        };
	        _this.handleLeftMonthChange = function (newDate) {
	            var leftView = new monthAndYear_1.MonthAndYear(newDate.getMonth(), newDate.getFullYear());
	            _this.updateLeftView(leftView);
	        };
	        _this.handleRightMonthChange = function (newDate) {
	            var rightView = new monthAndYear_1.MonthAndYear(newDate.getMonth(), newDate.getFullYear());
	            _this.updateRightView(rightView);
	        };
	        _this.handleLeftMonthSelectChange = function (leftMonth) {
	            var leftView = new monthAndYear_1.MonthAndYear(leftMonth, _this.state.leftView.getYear());
	            _this.updateLeftView(leftView);
	        };
	        _this.handleRightMonthSelectChange = function (rightMonth) {
	            var rightView = new monthAndYear_1.MonthAndYear(rightMonth, _this.state.rightView.getYear());
	            _this.updateRightView(rightView);
	        };
	        /*
	        * The min / max months are offset by one because we are showing two months.
	        * We do a comparison check to see if
	        *   a) the proposed [Month, Year] change throws the two calendars out of order
	        *   b) the proposed [Month, Year] goes beyond the min / max months
	        * and rectify appropriately.
	        */
	        _this.handleLeftYearSelectChange = function (leftDisplayYear) {
	            var leftView = new monthAndYear_1.MonthAndYear(_this.state.leftView.getMonth(), leftDisplayYear);
	            var _a = _this.props, minDate = _a.minDate, maxDate = _a.maxDate;
	            var adjustedMaxDate = DateUtils.getDatePreviousMonth(maxDate);
	            var minMonthAndYear = new monthAndYear_1.MonthAndYear(minDate.getMonth(), minDate.getFullYear());
	            var maxMonthAndYear = new monthAndYear_1.MonthAndYear(adjustedMaxDate.getMonth(), adjustedMaxDate.getFullYear());
	            if (leftView.isBefore(minMonthAndYear)) {
	                leftView = minMonthAndYear;
	            }
	            else if (leftView.isAfter(maxMonthAndYear)) {
	                leftView = maxMonthAndYear;
	            }
	            var rightView = _this.state.rightView.clone();
	            if (!leftView.isBefore(rightView)) {
	                rightView = leftView.getNextMonth();
	            }
	            _this.setViews(leftView, rightView);
	        };
	        _this.handleRightYearSelectChange = function (rightDisplayYear) {
	            var rightView = new monthAndYear_1.MonthAndYear(_this.state.rightView.getMonth(), rightDisplayYear);
	            var _a = _this.props, minDate = _a.minDate, maxDate = _a.maxDate;
	            var adjustedMinDate = DateUtils.getDateNextMonth(minDate);
	            var minMonthAndYear = new monthAndYear_1.MonthAndYear(adjustedMinDate.getMonth(), adjustedMinDate.getFullYear());
	            var maxMonthAndYear = new monthAndYear_1.MonthAndYear(maxDate.getMonth(), maxDate.getFullYear());
	            if (rightView.isBefore(minMonthAndYear)) {
	                rightView = minMonthAndYear;
	            }
	            else if (rightView.isAfter(maxMonthAndYear)) {
	                rightView = maxMonthAndYear;
	            }
	            var leftView = _this.state.leftView.clone();
	            if (!rightView.isAfter(leftView)) {
	                leftView = rightView.getPreviousMonth();
	            }
	            _this.setViews(leftView, rightView);
	        };
	        var value = [null, null];
	        if (props.value != null) {
	            value = props.value;
	        }
	        else if (props.defaultValue != null) {
	            value = props.defaultValue;
	        }
	        var initialMonth;
	        var today = new Date();
	        if (props.initialMonth != null) {
	            initialMonth = props.initialMonth;
	        }
	        else if (value[0] != null) {
	            initialMonth = DateUtils.clone(value[0]);
	        }
	        else if (DateUtils.isDayInRange(today, [props.minDate, props.maxDate])) {
	            initialMonth = today;
	        }
	        else {
	            initialMonth = DateUtils.getDateBetween([props.minDate, props.maxDate]);
	        }
	        /*
	        * if the initial month is the last month of the picker's
	        * allowable range, the react-day-picker library will show
	        * the max month on the left and the *min* month on the right.
	        * subtracting one avoids that weird, wraparound state (#289).
	        */
	        var initialMonthEqualsMinMonth = DateUtils.areSameMonth(initialMonth, props.minDate);
	        var initalMonthEqualsMaxMonth = DateUtils.areSameMonth(initialMonth, props.maxDate);
	        if (!initialMonthEqualsMinMonth && initalMonthEqualsMaxMonth) {
	            initialMonth.setMonth(initialMonth.getMonth() - 1);
	        }
	        var leftView = new monthAndYear_1.MonthAndYear(initialMonth.getMonth(), initialMonth.getFullYear());
	        var rightView = leftView.getNextMonth();
	        _this.state = { leftView: leftView, rightView: rightView, value: value, hoverValue: [null, null] };
	        return _this;
	        var _a;
	    }
	    Object.defineProperty(DateRangePicker.prototype, "isControlled", {
	        get: function () {
	            return this.props.value != null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    DateRangePicker.prototype.render = function () {
	        var modifiers = datePickerCore_1.combineModifiers(this.modifiers, this.props.modifiers);
	        var _a = this.props, className = _a.className, contiguousCalendarMonths = _a.contiguousCalendarMonths, locale = _a.locale, localeUtils = _a.localeUtils, maxDate = _a.maxDate, minDate = _a.minDate;
	        var isShowingOneMonth = DateUtils.areSameMonth(this.props.minDate, this.props.maxDate);
	        var _b = this.state, leftView = _b.leftView, rightView = _b.rightView;
	        var disabledDays = [{ before: this.props.minDate }, { after: this.props.maxDate }];
	        var dayPickerBaseProps = {
	            disabledDays: disabledDays,
	            locale: locale,
	            localeUtils: localeUtils,
	            modifiers: modifiers,
	            onDayClick: this.handleDayClick,
	            onDayMouseEnter: this.handleDayMouseEnter,
	            onDayMouseLeave: this.handleDayMouseLeave,
	            selectedDays: this.state.value,
	        };
	        if (contiguousCalendarMonths || isShowingOneMonth) {
	            var classes = classNames(DateClasses.DATEPICKER, DateClasses.DATERANGEPICKER, className, (_c = {},
	                _c[DateClasses.DATERANGEPICKER_CONTIGUOUS] = contiguousCalendarMonths,
	                _c[DateClasses.DATERANGEPICKER_SINGLE_MONTH] = isShowingOneMonth,
	                _c));
	            // use the left DayPicker when we only need one
	            return (React.createElement("div", { className: classes },
	                this.maybeRenderShortcuts(),
	                React.createElement(DayPicker, tslib_1.__assign({}, dayPickerBaseProps, { captionElement: this.renderSingleCaption, fromMonth: minDate, month: leftView.getFullDate(), numberOfMonths: isShowingOneMonth ? 1 : 2, onMonthChange: this.handleLeftMonthChange, toMonth: maxDate }))));
	        }
	        else {
	            return (React.createElement("div", { className: classNames(DateClasses.DATEPICKER, DateClasses.DATERANGEPICKER, className) },
	                this.maybeRenderShortcuts(),
	                React.createElement(DayPicker, tslib_1.__assign({}, dayPickerBaseProps, { canChangeMonth: true, captionElement: this.renderLeftCaption, fromMonth: minDate, month: leftView.getFullDate(), onMonthChange: this.handleLeftMonthChange, toMonth: DateUtils.getDatePreviousMonth(maxDate) })),
	                React.createElement(DayPicker, tslib_1.__assign({}, dayPickerBaseProps, { canChangeMonth: true, captionElement: this.renderRightCaption, fromMonth: DateUtils.getDateNextMonth(minDate), month: rightView.getFullDate(), onMonthChange: this.handleRightMonthChange, toMonth: maxDate }))));
	        }
	        var _c;
	    };
	    DateRangePicker.prototype.componentWillReceiveProps = function (nextProps) {
	        _super.prototype.componentWillReceiveProps.call(this, nextProps);
	        if (!DateUtils.areRangesEqual(this.props.value, nextProps.value)) {
	            var nextState = getStateChange(this.props.value, nextProps.value, this.state, nextProps.contiguousCalendarMonths);
	            this.setState(nextState);
	        }
	    };
	    DateRangePicker.prototype.validateProps = function (props) {
	        var defaultValue = props.defaultValue, initialMonth = props.initialMonth, maxDate = props.maxDate, minDate = props.minDate, boundaryToModify = props.boundaryToModify, value = props.value;
	        var dateRange = [minDate, maxDate];
	        if (defaultValue != null && !DateUtils.isDayRangeInRange(defaultValue, dateRange)) {
	            throw new Error(Errors.DATERANGEPICKER_DEFAULT_VALUE_INVALID);
	        }
	        if (initialMonth != null && !DateUtils.isMonthInRange(initialMonth, dateRange)) {
	            throw new Error(Errors.DATERANGEPICKER_INITIAL_MONTH_INVALID);
	        }
	        if (maxDate != null
	            && minDate != null
	            && maxDate < minDate
	            && !DateUtils.areSameDay(maxDate, minDate)) {
	            throw new Error(Errors.DATERANGEPICKER_MAX_DATE_INVALID);
	        }
	        if (value != null && !DateUtils.isDayRangeInRange(value, dateRange)) {
	            throw new Error(Errors.DATERANGEPICKER_VALUE_INVALID);
	        }
	        if (boundaryToModify != null
	            && boundaryToModify !== dateUtils_1.DateRangeBoundary.START
	            && boundaryToModify !== dateUtils_1.DateRangeBoundary.END) {
	            throw new Error(Errors.DATERANGEPICKER_PREFERRED_BOUNDARY_TO_MODIFY_INVALID);
	        }
	    };
	    DateRangePicker.prototype.maybeRenderShortcuts = function () {
	        var _this = this;
	        var propsShortcuts = this.props.shortcuts;
	        if (propsShortcuts == null || propsShortcuts === false) {
	            return undefined;
	        }
	        var shortcuts = typeof propsShortcuts === "boolean" ? createDefaultShortcuts() : propsShortcuts;
	        var shortcutElements = shortcuts.map(function (s, i) {
	            return (React.createElement(core_1.MenuItem, { className: core_1.Classes.POPOVER_DISMISS_OVERRIDE, disabled: !_this.isShortcutInRange(s.dateRange), key: i, onClick: _this.getShorcutClickHandler(s.dateRange), text: s.label }));
	        });
	        return (React.createElement(core_1.Menu, { className: DateClasses.DATERANGEPICKER_SHORTCUTS }, shortcutElements));
	    };
	    DateRangePicker.prototype.getShorcutClickHandler = function (nextValue) {
	        var _this = this;
	        return function () { return _this.handleNextState(nextValue); };
	    };
	    DateRangePicker.prototype.handleNextState = function (nextValue) {
	        var value = this.state.value;
	        var nextState = getStateChange(value, nextValue, this.state, this.props.contiguousCalendarMonths);
	        if (!this.isControlled) {
	            this.setState(nextState);
	        }
	        core_1.Utils.safeInvoke(this.props.onChange, nextValue);
	    };
	    DateRangePicker.prototype.updateLeftView = function (leftView) {
	        var rightView = this.state.rightView.clone();
	        if (!leftView.isBefore(rightView)) {
	            rightView = leftView.getNextMonth();
	        }
	        this.setViews(leftView, rightView);
	    };
	    DateRangePicker.prototype.updateRightView = function (rightView) {
	        var leftView = this.state.leftView.clone();
	        if (!rightView.isAfter(leftView)) {
	            leftView = rightView.getPreviousMonth();
	        }
	        this.setViews(leftView, rightView);
	    };
	    DateRangePicker.prototype.setViews = function (leftView, rightView) {
	        this.setState({ leftView: leftView, rightView: rightView });
	    };
	    DateRangePicker.prototype.isShortcutInRange = function (shortcutDateRange) {
	        return DateUtils.isDayRangeInRange(shortcutDateRange, [this.props.minDate, this.props.maxDate]);
	    };
	    return DateRangePicker;
	}(core_1.AbstractComponent));
	DateRangePicker.defaultProps = {
	    allowSingleDayRange: false,
	    contiguousCalendarMonths: true,
	    maxDate: datePickerCore_1.getDefaultMaxDate(),
	    minDate: datePickerCore_1.getDefaultMinDate(),
	    shortcuts: true,
	};
	DateRangePicker.displayName = "Blueprint.DateRangePicker";
	exports.DateRangePicker = DateRangePicker;
	function getStateChange(value, nextValue, state, contiguousCalendarMonths) {
	    var returnVal;
	    if (value != null && nextValue == null) {
	        returnVal = { value: [null, null] };
	    }
	    else if (nextValue != null) {
	        var nextValueStart = nextValue[0], nextValueEnd = nextValue[1];
	        var leftView = state.leftView.clone();
	        var rightView = state.rightView.clone();
	        /*
	        * Only end date selected.
	        * If the newly selected end date isn't in either of the displayed months, then
	        *   - set the right DayPicker to the month of the selected end date
	        *   - ensure the left DayPicker is before the right, changing if needed
	        */
	        if (nextValueStart == null && nextValueEnd != null) {
	            var nextValueEndMonthAndYear = new monthAndYear_1.MonthAndYear(nextValueEnd.getMonth(), nextValueEnd.getFullYear());
	            if (!nextValueEndMonthAndYear.isSame(leftView) && !nextValueEndMonthAndYear.isSame(rightView)) {
	                rightView = nextValueEndMonthAndYear;
	                if (!leftView.isBefore(rightView)) {
	                    leftView = rightView.getPreviousMonth();
	                }
	            }
	            /*
	            * Only start date selected.
	            * If the newly selected start date isn't in either of the displayed months, then
	            *   - set the left DayPicker to the month of the selected start date
	            *   - ensure the right DayPicker is before the left, changing if needed
	            */
	        }
	        else if (nextValueStart != null && nextValueEnd == null) {
	            var nextValueStartMonthAndYear = new monthAndYear_1.MonthAndYear(nextValueStart.getMonth(), nextValueStart.getFullYear());
	            if (!nextValueStartMonthAndYear.isSame(leftView) && !nextValueStartMonthAndYear.isSame(rightView)) {
	                leftView = nextValueStartMonthAndYear;
	                if (!rightView.isAfter(leftView)) {
	                    rightView = leftView.getNextMonth();
	                }
	            }
	            /*
	            * Both start date and end date selected.
	            */
	        }
	        else if (nextValueStart != null && nextValueEnd != null) {
	            var nextValueStartMonthAndYear = new monthAndYear_1.MonthAndYear(nextValueStart.getMonth(), nextValueStart.getFullYear());
	            var nextValueEndMonthAndYear = new monthAndYear_1.MonthAndYear(nextValueEnd.getMonth(), nextValueEnd.getFullYear());
	            /*
	            * Both start and end date months are identical
	            * If the selected month isn't in either of the displayed months, then
	            *   - set the left DayPicker to be the selected month
	            *   - set the right DayPicker to +1
	            */
	            if (DateUtils.areSameMonth(nextValueStart, nextValueEnd)) {
	                var potentialLeftEqualsNextValueStart = leftView.isSame(nextValueStartMonthAndYear);
	                var potentialRightEqualsNextValueStart = rightView.isSame(nextValueStartMonthAndYear);
	                if (potentialLeftEqualsNextValueStart || potentialRightEqualsNextValueStart) {
	                    // do nothing
	                }
	                else {
	                    leftView = nextValueStartMonthAndYear;
	                    rightView = nextValueStartMonthAndYear.getNextMonth();
	                }
	                /*
	                * Different start and end date months, adjust display months.
	                */
	            }
	            else {
	                if (!leftView.isSame(nextValueStartMonthAndYear)) {
	                    leftView = nextValueStartMonthAndYear;
	                    rightView = nextValueStartMonthAndYear.getNextMonth();
	                }
	                if (contiguousCalendarMonths === false && !rightView.isSame(nextValueEndMonthAndYear)) {
	                    rightView = nextValueEndMonthAndYear;
	                }
	            }
	        }
	        returnVal = {
	            leftView: leftView,
	            rightView: rightView,
	            value: nextValue,
	        };
	    }
	    else {
	        returnVal = {};
	    }
	    return returnVal;
	}
	function createShortcut(label, dateRange) {
	    return { dateRange: dateRange, label: label };
	}
	function createDefaultShortcuts() {
	    var today = new Date();
	    var makeDate = function (action) {
	        var returnVal = DateUtils.clone(today);
	        action(returnVal);
	        returnVal.setDate(returnVal.getDate() + 1);
	        return returnVal;
	    };
	    var oneWeekAgo = makeDate(function (d) { return d.setDate(d.getDate() - 7); });
	    var oneMonthAgo = makeDate(function (d) { return d.setMonth(d.getMonth() - 1); });
	    var threeMonthsAgo = makeDate(function (d) { return d.setMonth(d.getMonth() - 3); });
	    var sixMonthsAgo = makeDate(function (d) { return d.setMonth(d.getMonth() - 6); });
	    var oneYearAgo = makeDate(function (d) { return d.setFullYear(d.getFullYear() - 1); });
	    var twoYearsAgo = makeDate(function (d) { return d.setFullYear(d.getFullYear() - 2); });
	    return [
	        createShortcut("Past week", [oneWeekAgo, today]),
	        createShortcut("Past month", [oneMonthAgo, today]),
	        createShortcut("Past 3 months", [threeMonthsAgo, today]),
	        createShortcut("Past 6 months", [sixMonthsAgo, today]),
	        createShortcut("Past year", [oneYearAgo, today]),
	        createShortcut("Past 2 years", [twoYearsAgo, today]),
	    ];
	}
	exports.DateRangePickerFactory = React.createFactory(DateRangePicker);
	
	//# sourceMappingURL=dateRangePicker.js.map


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
	 * Licensed under the BSD-3 License as modified (the “License”); you may obtain a copy
	 * of the license at https://github.com/palantir/blueprint/blob/master/LICENSE
	 * and https://github.com/palantir/blueprint/blob/master/PATENTS
	 */
	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	var dateUtils_1 = __webpack_require__(3);
	var MonthAndYear = (function () {
	    function MonthAndYear(month, year) {
	        if (month !== null && year !== null) {
	            this.date = new Date(year, month);
	        }
	        else {
	            this.date = new Date();
	        }
	    }
	    MonthAndYear.prototype.clone = function () {
	        return new MonthAndYear(this.getMonth(), this.getYear());
	    };
	    MonthAndYear.prototype.getFullDate = function () {
	        return this.date;
	    };
	    MonthAndYear.prototype.getMonth = function () {
	        return this.date.getMonth();
	    };
	    MonthAndYear.prototype.getYear = function () {
	        return this.date.getFullYear();
	    };
	    MonthAndYear.prototype.getPreviousMonth = function () {
	        var previousMonthDate = dateUtils_1.getDatePreviousMonth(this.date);
	        return new MonthAndYear(previousMonthDate.getMonth(), previousMonthDate.getFullYear());
	    };
	    MonthAndYear.prototype.getNextMonth = function () {
	        var nextMonthDate = dateUtils_1.getDateNextMonth(this.date);
	        return new MonthAndYear(nextMonthDate.getMonth(), nextMonthDate.getFullYear());
	    };
	    MonthAndYear.prototype.isBefore = function (monthAndYear) {
	        return compareMonthAndYear(this, monthAndYear) < 0;
	    };
	    MonthAndYear.prototype.isAfter = function (monthAndYear) {
	        return compareMonthAndYear(this, monthAndYear) > 0;
	    };
	    MonthAndYear.prototype.isSame = function (monthAndYear) {
	        return compareMonthAndYear(this, monthAndYear) === 0;
	    };
	    return MonthAndYear;
	}());
	exports.MonthAndYear = MonthAndYear;
	// returns negative if left < right
	// returns positive if left > right
	// returns 0 if left === right
	function compareMonthAndYear(firstMonthAndYear, secondMonthAndYear) {
	    var firstMonth = firstMonthAndYear.getMonth();
	    var firstYear = firstMonthAndYear.getYear();
	    var secondMonth = secondMonthAndYear.getMonth();
	    var secondYear = secondMonthAndYear.getYear();
	    if (firstYear === secondYear) {
	        return firstMonth - secondMonth;
	    }
	    else {
	        return firstYear - secondYear;
	    }
	}
	
	//# sourceMappingURL=monthAndYear.js.map


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	var dateUtils_1 = __webpack_require__(3);
	;
	var DateRangeSelectionStrategy = (function () {
	    function DateRangeSelectionStrategy() {
	    }
	    /**
	     * Returns the new date-range and the boundary that would be affected if `day` were clicked. The
	     * affected boundary may be different from the provided `boundary` in some cases. For example,
	     * clicking a particular boundary's selected date will always deselect it regardless of which
	     * `boundary` you provide to this function (because it's simply a more intuitive interaction).
	     */
	    DateRangeSelectionStrategy.getNextState = function (currentRange, day, allowSingleDayRange, boundary) {
	        if (boundary != null) {
	            return this.getNextStateForBoundary(currentRange, day, allowSingleDayRange, boundary);
	        }
	        else {
	            return this.getDefaultNextState(currentRange, day, allowSingleDayRange);
	        }
	    };
	    DateRangeSelectionStrategy.getNextStateForBoundary = function (currentRange, day, allowSingleDayRange, boundary) {
	        var boundaryDate = this.getBoundaryDate(boundary, currentRange);
	        var otherBoundary = this.getOtherBoundary(boundary);
	        var otherBoundaryDate = this.getBoundaryDate(otherBoundary, currentRange);
	        var nextBoundary;
	        var nextDateRange;
	        if (boundaryDate == null && otherBoundaryDate == null) {
	            nextBoundary = boundary;
	            nextDateRange = this.createRangeForBoundary(boundary, day, null);
	        }
	        else if (boundaryDate != null && otherBoundaryDate == null) {
	            var nextBoundaryDate = dateUtils_1.areSameDay(boundaryDate, day) ? null : day;
	            nextBoundary = boundary;
	            nextDateRange = this.createRangeForBoundary(boundary, nextBoundaryDate, null);
	        }
	        else if (boundaryDate == null && otherBoundaryDate != null) {
	            if (dateUtils_1.areSameDay(day, otherBoundaryDate)) {
	                var nextDate = void 0;
	                if (allowSingleDayRange) {
	                    nextBoundary = boundary;
	                    nextDate = otherBoundaryDate;
	                }
	                else {
	                    nextBoundary = otherBoundary;
	                    nextDate = null;
	                }
	                nextDateRange = this.createRangeForBoundary(boundary, nextDate, nextDate);
	            }
	            else if (this.isOverlappingOtherBoundary(boundary, day, otherBoundaryDate)) {
	                nextBoundary = otherBoundary;
	                nextDateRange = this.createRangeForBoundary(boundary, otherBoundaryDate, day);
	            }
	            else {
	                nextBoundary = boundary;
	                nextDateRange = this.createRangeForBoundary(boundary, day, otherBoundaryDate);
	            }
	        }
	        else {
	            // both boundaryDate and otherBoundaryDate are already defined
	            if (dateUtils_1.areSameDay(boundaryDate, day)) {
	                var isSingleDayRangeSelected = dateUtils_1.areSameDay(boundaryDate, otherBoundaryDate);
	                var nextOtherBoundaryDate = isSingleDayRangeSelected ? null : otherBoundaryDate;
	                nextBoundary = boundary;
	                nextDateRange = this.createRangeForBoundary(boundary, null, nextOtherBoundaryDate);
	            }
	            else if (dateUtils_1.areSameDay(day, otherBoundaryDate)) {
	                var _a = (allowSingleDayRange)
	                    ? [otherBoundaryDate, otherBoundaryDate]
	                    : [boundaryDate, null], nextBoundaryDate = _a[0], nextOtherBoundaryDate = _a[1];
	                nextBoundary = allowSingleDayRange ? boundary : otherBoundary;
	                nextDateRange = this.createRangeForBoundary(boundary, nextBoundaryDate, nextOtherBoundaryDate);
	            }
	            else if (this.isOverlappingOtherBoundary(boundary, day, otherBoundaryDate)) {
	                nextBoundary = boundary;
	                nextDateRange = this.createRangeForBoundary(boundary, day, null);
	            }
	            else {
	                // extend the date range with an earlier boundaryDate date
	                nextBoundary = boundary;
	                nextDateRange = this.createRangeForBoundary(boundary, day, otherBoundaryDate);
	            }
	        }
	        return { dateRange: nextDateRange, boundary: nextBoundary };
	    };
	    DateRangeSelectionStrategy.getDefaultNextState = function (selectedRange, day, allowSingleDayRange) {
	        var start = selectedRange[0], end = selectedRange[1];
	        var nextDateRange;
	        if (start == null && end == null) {
	            nextDateRange = [day, null];
	        }
	        else if (start != null && end == null) {
	            nextDateRange = this.createRange(day, start, allowSingleDayRange);
	        }
	        else if (start == null && end != null) {
	            nextDateRange = this.createRange(day, end, allowSingleDayRange);
	        }
	        else {
	            var isStart = dateUtils_1.areSameDay(start, day);
	            var isEnd = dateUtils_1.areSameDay(end, day);
	            if (isStart && isEnd) {
	                nextDateRange = [null, null];
	            }
	            else if (isStart) {
	                nextDateRange = [null, end];
	            }
	            else if (isEnd) {
	                nextDateRange = [start, null];
	            }
	            else {
	                nextDateRange = [day, null];
	            }
	        }
	        return { dateRange: nextDateRange };
	    };
	    DateRangeSelectionStrategy.getOtherBoundary = function (boundary) {
	        return (boundary === dateUtils_1.DateRangeBoundary.START)
	            ? dateUtils_1.DateRangeBoundary.END
	            : dateUtils_1.DateRangeBoundary.START;
	    };
	    DateRangeSelectionStrategy.getBoundaryDate = function (boundary, dateRange) {
	        return (boundary === dateUtils_1.DateRangeBoundary.START)
	            ? dateRange[0]
	            : dateRange[1];
	    };
	    DateRangeSelectionStrategy.isOverlappingOtherBoundary = function (boundary, boundaryDate, otherBoundaryDate) {
	        return (boundary === dateUtils_1.DateRangeBoundary.START)
	            ? boundaryDate > otherBoundaryDate
	            : boundaryDate < otherBoundaryDate;
	    };
	    DateRangeSelectionStrategy.createRangeForBoundary = function (boundary, boundaryDate, otherBoundaryDate) {
	        return (boundary === dateUtils_1.DateRangeBoundary.START)
	            ? [boundaryDate, otherBoundaryDate]
	            : [otherBoundaryDate, boundaryDate];
	    };
	    DateRangeSelectionStrategy.createRange = function (a, b, allowSingleDayRange) {
	        // clicking the same date again will clear it
	        if (!allowSingleDayRange && dateUtils_1.areSameDay(a, b)) {
	            return [null, null];
	        }
	        return a < b ? [a, b] : [b, a];
	    };
	    return DateRangeSelectionStrategy;
	}());
	exports.DateRangeSelectionStrategy = DateRangeSelectionStrategy;
	
	//# sourceMappingURL=dateRangeSelectionStrategy.js.map


/***/ })
/******/ ])
});
;
//# sourceMappingURL=datetime.bundle.js.map