/// <reference types="react" />
import { IProps } from "@blueprintjs/core";
import * as React from "react";
export declare enum TimePickerPrecision {
    MINUTE = 0,
    SECOND = 1,
    MILLISECOND = 2,
}
export interface ITimePickerProps extends IProps {
    /**
     * Initial time the `TimePicker` will display.
     * This should not be set if `value` is set.
     */
    defaultValue?: Date;
    /**
     * Whether the time picker is non-interactive.
     * @default false
     */
    disabled?: boolean;
    /**
     * Callback invoked when the user changes the time.
     */
    onChange?: (newTime: Date) => void;
    /**
     * The precision of time the user can set.
     * @default TimePickerPrecision.MINUTE
     */
    precision?: TimePickerPrecision;
    /**
     * Whether all the text in each input should be selected on focus.
     * @default false
     */
    selectAllOnFocus?: boolean;
    /**
     * Whether to show arrows buttons for changing the time.
     * @default false
     */
    showArrowButtons?: boolean;
    /**
     * The latest time the user can select. The year, month, and day parts of the `Date` object are ignored.
     * While the `maxTime` will be later than the `minTime` in the basic case,
     * it is also allowed to be earlier than the `minTime`.
     * This is useful, for example, to express a time range that extends before and after midnight.
     * If the `maxTime` and `minTime` are equal, then the valid time range is constrained to only that one value.
     */
    maxTime?: Date;
    /**
     * The earliest time the user can select. The year, month, and day parts of the `Date` object are ignored.
     * While the `minTime` will be earlier than the `maxTime` in the basic case,
     * it is also allowed to be later than the `maxTime`.
     * This is useful, for example, to express a time range that extends before and after midnight.
     * If the `maxTime` and `minTime` are equal, then the valid time range is constrained to only that one value.
     */
    minTime?: Date;
    /**
     * The currently set time.
     * If this prop is provided, the component acts in a controlled manner.
     */
    value?: Date;
}
export interface ITimePickerState {
    hourText?: string;
    minuteText?: string;
    secondText?: string;
    millisecondText?: string;
    value?: Date;
}
export declare function getDefaultMinTime(): Date;
export declare function getDefaultMaxTime(): Date;
export declare class TimePicker extends React.Component<ITimePickerProps, ITimePickerState> {
    static defaultProps: ITimePickerProps;
    static displayName: string;
    constructor(props?: ITimePickerProps, context?: any);
    render(): JSX.Element;
    componentWillReceiveProps(nextProps: ITimePickerProps): void;
    private maybeRenderArrowButton(isDirectionUp, className, onClick);
    private renderDivider(text?);
    private renderInput(className, unit, value);
    private getInputBlurHandler;
    private getInputChangeHandler;
    private getInputKeyDownHandler;
    private handleFocus;
    /**
     * Generates a full ITimePickerState object with all text fields set to formatted strings based on value
     */
    private getFullStateFromValue(value);
    private incrementTime(unit);
    private decrementTime(unit);
    private updateTime(time, unit);
    private updateState(state);
}
export declare const TimePickerFactory: React.ComponentFactory<ITimePickerProps & {
    children?: React.ReactNode;
}, TimePicker>;
