---
reference: datetime
---

@# Datetime

The __@blueprintjs/datetime__ NPM package provides several components for interacting with dates and times:

- [`DatePicker`](#datetime/datepicker) for selecting a single date (day, month, year).

- [`DateRangePicker`](#datetime/daterangepicker) for selecting date ranges.

- [`TimePicker`](#datetime/timepicker) for selecting a time (hour, minute, second,
  millisecond).

- [`DateTimePicker`](#datetime/datetimepicker), which composes `DatePicker` and
  `TimePicker` to select a date and time together.

- [`DateInput`](#datetime/dateinput), which composes a text input with a `DatePicker` in
  a `Popover`, for use in forms.

They are available in the __@blueprintjs/datetime__ package on
[NPM](https://www.npmjs.com/package/@blueprintjs/datetime).

Make sure to review the [general usage docs for JS components](#blueprint.usage).

```sh
npm install --save @blueprintjs/datetime
```

@page datepicker
@page daterangepicker
@page timepicker
@page datetimepicker
@page dateinput
@page daterangeinput
