/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var draggable_1 = require("../interactions/draggable");
var core_1 = require("@blueprintjs/core");
var classNames = require("classnames");
var React = require("react");
var EditableCell = (function (_super) {
    __extends(EditableCell, _super);
    function EditableCell() {
        var _this = this;
        _super.apply(this, arguments);
        this.handleCellRef = function (ref) {
            _this.cellElement = ref;
        };
        this.handleCellDoubleClick = function (_event) {
            if (_this.cellElement == null) {
                return;
            }
            var focusable = _this.cellElement.querySelector(".pt-editable-text");
            if (focusable.focus != null) {
                focusable.focus();
            }
        };
    }
    EditableCell.prototype.render = function () {
        var _a = this.props, className = _a.className, value = _a.value, intent = _a.intent, onCancel = _a.onCancel, onChange = _a.onChange, onConfirm = _a.onConfirm, style = _a.style, tooltip = _a.tooltip;
        return (React.createElement("div", {className: classNames(className, core_1.Classes.intentClass(intent), "bp-table-cell"), style: style, title: tooltip, ref: this.handleCellRef}, 
            React.createElement(draggable_1.Draggable, {onDoubleClick: this.handleCellDoubleClick}, 
                React.createElement(core_1.EditableText, {className: "bp-table-editable-name", defaultValue: value, intent: intent, onCancel: onCancel, onChange: onChange, onConfirm: onConfirm, placeholder: "", selectAllOnFocus: true})
            )
        ));
    };
    return EditableCell;
}(React.Component));
exports.EditableCell = EditableCell;

//# sourceMappingURL=data:application/json;base64,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
