/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var truncatedFormat_1 = require("./truncatedFormat");
var classNames = require("classnames");
var PureRender = require("pure-render-decorator");
var React = require("react");
var JSONFormat = (function (_super) {
    __extends(JSONFormat, _super);
    function JSONFormat() {
        _super.apply(this, arguments);
    }
    JSONFormat.prototype.render = function () {
        var _a = this.props, children = _a.children, omitQuotesOnStrings = _a.omitQuotesOnStrings, stringify = _a.stringify;
        var className = classNames(this.props.className, {
            "bp-table-null": children === undefined || children === null,
        });
        var displayValue = "";
        if (omitQuotesOnStrings && typeof children === "string") {
            displayValue = children;
        }
        else {
            displayValue = stringify(children);
        }
        return React.createElement(truncatedFormat_1.TruncatedFormat, __assign({}, this.props, {className: className}), displayValue);
    };
    JSONFormat.defaultProps = {
        omitQuotesOnStrings: true,
        stringify: function (obj) { return (JSON.stringify(obj, null, 2)); },
    };
    JSONFormat = __decorate([
        PureRender
    ], JSONFormat);
    return JSONFormat;
}(React.Component));
exports.JSONFormat = JSONFormat;

//# sourceMappingURL=data:application/json;base64,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
