/// <reference types="react" />
/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
import { IProps } from "@blueprintjs/core";
import * as React from "react";
export interface ITruncatedFormatProps extends IProps {
    children?: string;
    /**
     * Sets the popover content style to `white-space: pre` if `true` or
     * `white-space: normal` if `false`.
     * @default true
     */
    preformatted?: boolean;
    /**
     * Number of characters that are displayed before being truncated and appended with
     * the `truncationSuffix` prop. A value of 0 will disable truncation.
     * @default 80
     */
    truncateLength?: number;
    /**
     * The string that is appended to the display string if it is truncated.
     * @default "..."
     */
    truncationSuffix?: string;
}
export declare class TruncatedFormat extends React.Component<ITruncatedFormatProps, {}> {
    static defaultProps: ITruncatedFormatProps;
    render(): JSX.Element;
}
