/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var core_1 = require("@blueprintjs/core");
var classNames = require("classnames");
var PureRender = require("pure-render-decorator");
var React = require("react");
var TruncatedFormat = (function (_super) {
    __extends(TruncatedFormat, _super);
    function TruncatedFormat() {
        _super.apply(this, arguments);
    }
    TruncatedFormat.prototype.render = function () {
        var _a = this.props, children = _a.children, preformatted = _a.preformatted, truncateLength = _a.truncateLength, truncationSuffix = _a.truncationSuffix;
        var content = "" + children;
        if (truncateLength > 0 && content.length > truncateLength) {
            var popoverClasses = classNames("bp-table-truncated-popover", preformatted ? "bp-table-popover-whitespace-pre" : "bp-table-popover-whitespace-normal");
            var popoverContent = React.createElement("div", {className: popoverClasses}, children);
            var className = classNames(this.props.className, "bp-table-truncated-format");
            var truncated = content.substring(0, truncateLength) + truncationSuffix;
            var constraints = [{
                    attachment: "together",
                    pin: true,
                    to: "window",
                }];
            return (React.createElement("div", {className: className}, 
                React.createElement("div", {className: "bp-table-truncated-value"}, truncated), 
                React.createElement(core_1.Popover, {className: "bp-table-truncated-popover-target", constraints: constraints, content: popoverContent, position: core_1.Position.BOTTOM, useSmartArrowPositioning: true}, 
                    React.createElement("span", {className: "pt-icon-standard pt-icon-more"})
                )));
        }
        else {
            var className = classNames(this.props.className, "bp-table-truncated-text");
            return React.createElement("div", {className: className}, content);
        }
    };
    TruncatedFormat.defaultProps = {
        preformatted: true,
        truncateLength: 80,
        truncationSuffix: "...",
    };
    TruncatedFormat = __decorate([
        PureRender
    ], TruncatedFormat);
    return TruncatedFormat;
}(React.Component));
exports.TruncatedFormat = TruncatedFormat;

//# sourceMappingURL=data:application/json;base64,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
