/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
/**
 * A React component that measures and rounds the size of its only child. This
 * is necessary due to a Chrome bug that prevents scrolling when the size is
 * changed to a fractional value. See this JSFiddle for a repro of the issue:
 * https://jsfiddle.net/2rmz7p1d/5/
 */
var RoundSize = (function (_super) {
    __extends(RoundSize, _super);
    function RoundSize() {
        var _this = this;
        _super.apply(this, arguments);
        this.setInternalRef = function (ref) { return _this.internalElement = ref; };
        this.setContainerRef = function (ref) { return _this.containerElement = ref; };
    }
    RoundSize.prototype.render = function () {
        return (React.createElement("div", {className: "bp-table-rounded-layout", ref: this.setContainerRef}, 
            React.createElement("div", {className: "bp-table-no-layout", ref: this.setInternalRef}, React.Children.only(this.props.children))
        ));
    };
    RoundSize.prototype.componentDidMount = function () {
        this.copyRoundedSize();
    };
    RoundSize.prototype.componentDidUpdate = function () {
        this.copyRoundedSize();
    };
    RoundSize.prototype.copyRoundedSize = function () {
        if (this.internalElement == null || this.containerElement == null) {
            return;
        }
        // measure the size of the internal children
        var width = Math.round(this.internalElement.clientWidth) + "px";
        var height = Math.round(this.internalElement.clientHeight) + "px";
        // set the size of the container element with rounded values
        this.containerElement.style.width = width;
        this.containerElement.style.height = height;
    };
    return RoundSize;
}(React.Component));
exports.RoundSize = RoundSize;

//# sourceMappingURL=data:application/json;base64,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
