/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var index_1 = require("../common/index");
var resizable_1 = require("../interactions/resizable");
var resizeHandle_1 = require("../interactions/resizeHandle");
var selectable_1 = require("../interactions/selectable");
var regions_1 = require("../regions");
var columnHeaderCell_1 = require("./columnHeaderCell");
var classNames = require("classnames");
var PureRender = require("pure-render-decorator");
var React = require("react");
var ColumnHeader = (function (_super) {
    __extends(ColumnHeader, _super);
    function ColumnHeader() {
        var _this = this;
        _super.apply(this, arguments);
        this.renderGhostCell = function (columnIndex, extremaClasses) {
            var grid = _this.props.grid;
            var rect = grid.getGhostCellRect(0, columnIndex);
            var style = {
                flexBasis: rect.width + "px",
                width: rect.width + "px",
            };
            return (React.createElement(columnHeaderCell_1.ColumnHeaderCell, {key: "bp-table-col-" + columnIndex, className: classNames(extremaClasses), style: style}));
        };
        this.renderCell = function (columnIndex, extremaClasses) {
            var _a = _this.props, allowMultipleSelection = _a.allowMultipleSelection, cellRenderer = _a.cellRenderer, grid = _a.grid, isResizable = _a.isResizable, maxColumnWidth = _a.maxColumnWidth, minColumnWidth = _a.minColumnWidth, onColumnWidthChanged = _a.onColumnWidthChanged, onLayoutLock = _a.onLayoutLock, onResizeGuide = _a.onResizeGuide, onSelection = _a.onSelection, selectedRegions = _a.selectedRegions;
            var rect = grid.getColumnRect(columnIndex);
            var handleSizeChanged = function (size) {
                onResizeGuide([rect.left + size + 1]);
            };
            var handleResizeEnd = function (size) {
                onResizeGuide(null);
                onColumnWidthChanged(columnIndex, size);
            };
            var handleDoubleClick = function () {
                var width = _this.props.locator.getWidestVisibleCellInColumn(columnIndex);
                var clampedWidth = index_1.Utils.clamp(width, minColumnWidth, maxColumnWidth);
                onResizeGuide(null);
                onColumnWidthChanged(columnIndex, clampedWidth);
            };
            var cell = cellRenderer(columnIndex);
            var className = classNames(cell.props.className, extremaClasses, {
                "bp-table-draggable": (onSelection != null),
            });
            var isColumnSelected = regions_1.Regions.hasFullColumn(selectedRegions, columnIndex);
            return (React.createElement(selectable_1.DragSelectable, {allowMultipleSelection: allowMultipleSelection, key: "bp-table-col-" + columnIndex, locateClick: _this.locateClick, locateDrag: _this.locateDrag, onSelection: onSelection, selectedRegions: selectedRegions}, 
                React.createElement(resizable_1.Resizable, {isResizable: isResizable, maxSize: maxColumnWidth, minSize: minColumnWidth, onDoubleClick: handleDoubleClick, onLayoutLock: onLayoutLock, onResizeEnd: handleResizeEnd, onSizeChanged: handleSizeChanged, orientation: resizeHandle_1.Orientation.VERTICAL, size: rect.width}, React.cloneElement(cell, { className: className, isColumnSelected: isColumnSelected }))
            ));
        };
        this.locateClick = function (event) {
            // Abort selection unless the mouse actually hit a table header. This allows
            // users to supply interactive components in their renderHeader methods.
            if (!columnHeaderCell_1.ColumnHeaderCell.isHeaderMouseTarget(event.target)) {
                return null;
            }
            var col = _this.props.locator.convertPointToColumn(event.clientX);
            return regions_1.Regions.column(col);
        };
        this.locateDrag = function (_event, coords) {
            var colStart = _this.props.locator.convertPointToColumn(coords.activation[0]);
            var colEnd = _this.props.locator.convertPointToColumn(coords.current[0]);
            return regions_1.Regions.column(colStart, colEnd);
        };
    }
    ColumnHeader.prototype.render = function () {
        var _a = this.props, grid = _a.grid, viewportRect = _a.viewportRect, columnIndexStart = _a.columnIndexStart, columnIndexEnd = _a.columnIndexEnd;
        var cells = [];
        for (var columnIndex = columnIndexStart; columnIndex <= columnIndexEnd; columnIndex++) {
            var extremaClasses = grid.getExtremaClasses(0, columnIndex, 1, columnIndexEnd);
            var renderer = grid.isGhostIndex(-1, columnIndex) ? this.renderGhostCell : this.renderCell;
            cells.push(renderer(columnIndex, extremaClasses));
        }
        // always set width so that the layout can push out the element unless it overflows.
        var style = {
            width: grid.getRect().width + "px",
        };
        // use CSS translation to offset the cells
        if (viewportRect != null) {
            style.transform = "translate3d(" + (grid.getColumnRect(columnIndexStart).left - viewportRect.left) + "px, 0, 0)";
        }
        var classes = classNames("bp-table-thead", "bp-table-column-header-tr", {
            "bp-table-draggable": (this.props.onSelection != null),
        });
        return React.createElement("div", {style: style, className: classes}, cells);
    };
    ColumnHeader.defaultProps = {
        isResizable: true,
    };
    ColumnHeader = __decorate([
        PureRender
    ], ColumnHeader);
    return ColumnHeader;
}(React.Component));
exports.ColumnHeader = ColumnHeader;

//# sourceMappingURL=data:application/json;base64,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
