/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var core_1 = require("@blueprintjs/core");
var classNames = require("classnames");
var React = require("react");
var HEADER_CLASSNAME = "bp-table-header";
var HEADER_COLUMN_NAME_CLASSNAME = "bp-table-column-name";
var HEADER_CONTENT_CLASSNAME = "bp-table-header-content";
var HEADER_COLUMN_NAME_TEXT_CLASSNAME = "bp-table-column-name-text";
var HEADER_INTERACTION_BAR_CLASSNAME = "bp-table-interaction-bar";
var HorizontalCellDivider = (function (_super) {
    __extends(HorizontalCellDivider, _super);
    function HorizontalCellDivider() {
        _super.apply(this, arguments);
    }
    HorizontalCellDivider.prototype.render = function () {
        return React.createElement("div", {className: "bp-table-horizontal-cell-divider"});
    };
    return HorizontalCellDivider;
}(React.Component));
exports.HorizontalCellDivider = HorizontalCellDivider;
var ColumnHeaderCell = (function (_super) {
    __extends(ColumnHeaderCell, _super);
    function ColumnHeaderCell() {
        var _this = this;
        _super.apply(this, arguments);
        this.state = {
            isActive: false,
        };
        this.getPopoverStateChangeHandler = function (isActive) { return function () {
            _this.setState({ isActive: isActive });
        }; };
    }
    /**
     * This method determines if a MouseEvent was triggered on a target that
     * should be used as the header click/drag target. This enables users of
     * this component to render full interactive components in their header
     * cells without worry of selection or resize operations from capturing
     * their mouse events.
     */
    ColumnHeaderCell.isHeaderMouseTarget = function (target) {
        return target.classList.contains(HEADER_CLASSNAME)
            || target.classList.contains(HEADER_COLUMN_NAME_CLASSNAME)
            || target.classList.contains(HEADER_INTERACTION_BAR_CLASSNAME)
            || target.classList.contains(HEADER_CONTENT_CLASSNAME);
    };
    ColumnHeaderCell.prototype.render = function () {
        var _a = this.props, className = _a.className, isActive = _a.isActive, isColumnSelected = _a.isColumnSelected, resizeHandle = _a.resizeHandle, style = _a.style;
        var classes = classNames(HEADER_CLASSNAME, {
            "bp-table-header-active": isActive || this.state.isActive,
            "bp-table-header-selected": isColumnSelected,
        }, className);
        return (React.createElement("div", {className: classes, style: style}, 
            this.renderName(), 
            this.maybeRenderContent(), 
            resizeHandle));
    };
    ColumnHeaderCell.prototype.renderContextMenu = function (_event) {
        return this.props.menu;
    };
    ColumnHeaderCell.prototype.renderName = function () {
        var _a = this.props, useInteractionBar = _a.useInteractionBar, name = _a.name, renderName = _a.renderName;
        var dropdownMenu = this.maybeRenderDropdownMenu();
        var defaultName = (React.createElement("div", {className: "bp-table-truncated-text"}, name));
        var nameComponent = (renderName == null) ? defaultName : renderName(name);
        if (useInteractionBar) {
            return (React.createElement("div", {className: HEADER_COLUMN_NAME_CLASSNAME, title: name}, 
                React.createElement("div", {className: HEADER_INTERACTION_BAR_CLASSNAME}, dropdownMenu), 
                React.createElement(HorizontalCellDivider, null), 
                React.createElement("div", {className: HEADER_COLUMN_NAME_TEXT_CLASSNAME}, nameComponent)));
        }
        else {
            return (React.createElement("div", {className: HEADER_COLUMN_NAME_CLASSNAME, title: name}, 
                dropdownMenu, 
                React.createElement("div", {className: HEADER_COLUMN_NAME_TEXT_CLASSNAME}, nameComponent)));
        }
    };
    ColumnHeaderCell.prototype.maybeRenderContent = function () {
        if (this.props.children === null) {
            return undefined;
        }
        return (React.createElement("div", {className: HEADER_CONTENT_CLASSNAME}, this.props.children));
    };
    ColumnHeaderCell.prototype.maybeRenderDropdownMenu = function () {
        var _a = this.props, menu = _a.menu, menuIconName = _a.menuIconName;
        if (menu == null) {
            return undefined;
        }
        var popoverTargetClasses = classNames("pt-icon-standard", core_1.Classes.iconClass(menuIconName));
        var constraints = [{
                attachment: "together",
                pin: true,
                to: "window",
            }];
        return (React.createElement(core_1.Popover, {constraints: constraints, content: menu, position: core_1.Position.BOTTOM, className: "bp-table-th-menu", popoverDidOpen: this.getPopoverStateChangeHandler(true), popoverWillClose: this.getPopoverStateChangeHandler(false), useSmartArrowPositioning: true}, 
            React.createElement("span", {className: popoverTargetClasses})
        ));
    };
    ColumnHeaderCell.defaultProps = {
        isActive: false,
        menuIconName: "more",
        useInteractionBar: false,
    };
    ColumnHeaderCell = __decorate([
        core_1.ContextMenuTarget
    ], ColumnHeaderCell);
    return ColumnHeaderCell;
}(React.Component));
exports.ColumnHeaderCell = ColumnHeaderCell;

//# sourceMappingURL=data:application/json;base64,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
