/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var core_1 = require("@blueprintjs/core");
var classNames = require("classnames");
var React = require("react");
var EditableName = (function (_super) {
    __extends(EditableName, _super);
    function EditableName() {
        _super.apply(this, arguments);
    }
    EditableName.prototype.render = function () {
        var _a = this.props, className = _a.className, intent = _a.intent, name = _a.name, onCancel = _a.onCancel, onChange = _a.onChange, onConfirm = _a.onConfirm;
        return (React.createElement(core_1.EditableText, {className: classNames(className, "bp-table-editable-name"), defaultValue: name, intent: intent, onCancel: onCancel, onChange: onChange, onConfirm: onConfirm, placeholder: "", selectAllOnFocus: true}));
    };
    return EditableName;
}(React.Component));
exports.EditableName = EditableName;

//# sourceMappingURL=data:application/json;base64,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
