/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var roundSize_1 = require("../common/roundSize");
var resizable_1 = require("../interactions/resizable");
var resizeHandle_1 = require("../interactions/resizeHandle");
var selectable_1 = require("../interactions/selectable");
var regions_1 = require("../regions");
var rowHeaderCell_1 = require("./rowHeaderCell");
var classNames = require("classnames");
var PureRender = require("pure-render-decorator");
var React = require("react");
var RowHeader = (function (_super) {
    __extends(RowHeader, _super);
    function RowHeader() {
        var _this = this;
        _super.apply(this, arguments);
        this.renderGhostCell = function (rowIndex, extremaClasses) {
            var grid = _this.props.grid;
            var rect = grid.getGhostCellRect(rowIndex, 0);
            var style = {
                height: rect.height + "px",
            };
            return (React.createElement(rowHeaderCell_1.RowHeaderCell, {key: "bp-table-row-" + rowIndex, className: classNames(extremaClasses), style: style}));
        };
        this.renderCell = function (rowIndex, extremaClasses) {
            var _a = _this.props, allowMultipleSelection = _a.allowMultipleSelection, grid = _a.grid, isResizable = _a.isResizable, maxRowHeight = _a.maxRowHeight, minRowHeight = _a.minRowHeight, onLayoutLock = _a.onLayoutLock, onResizeGuide = _a.onResizeGuide, onRowHeightChanged = _a.onRowHeightChanged, onSelection = _a.onSelection, renderRowHeader = _a.renderRowHeader, selectedRegions = _a.selectedRegions;
            var rect = grid.getRowRect(rowIndex);
            var handleSizeChanged = function (size) {
                onResizeGuide([rect.top + size + 1]);
            };
            var handleResizeEnd = function (size) {
                onResizeGuide(null);
                onRowHeightChanged(rowIndex, size);
            };
            var cell = renderRowHeader(rowIndex);
            var className = classNames(cell.props.className, extremaClasses, {
                "bp-table-draggable": onSelection != null,
            });
            var isRowSelected = regions_1.Regions.hasFullRow(selectedRegions, rowIndex);
            return (React.createElement(selectable_1.DragSelectable, {allowMultipleSelection: allowMultipleSelection, key: "bp-table-row-" + rowIndex, locateClick: _this.locateClick, locateDrag: _this.locateDrag, onSelection: onSelection, selectedRegions: selectedRegions}, 
                React.createElement(resizable_1.Resizable, {isResizable: isResizable, maxSize: maxRowHeight, minSize: minRowHeight, onLayoutLock: onLayoutLock, onResizeEnd: handleResizeEnd, onSizeChanged: handleSizeChanged, orientation: resizeHandle_1.Orientation.HORIZONTAL, size: rect.height}, React.cloneElement(cell, { className: className, isRowSelected: isRowSelected }))
            ));
        };
        this.locateClick = function (event) {
            var row = _this.props.locator.convertPointToRow(event.clientY);
            return regions_1.Regions.row(row);
        };
        this.locateDrag = function (_event, coords) {
            var rowStart = _this.props.locator.convertPointToRow(coords.activation[1]);
            var rowEnd = _this.props.locator.convertPointToRow(coords.current[1]);
            return regions_1.Regions.row(rowStart, rowEnd);
        };
    }
    RowHeader.prototype.render = function () {
        var _a = this.props, grid = _a.grid, rowIndexEnd = _a.rowIndexEnd, rowIndexStart = _a.rowIndexStart, viewportRect = _a.viewportRect;
        var cells = [];
        for (var rowIndex = rowIndexStart; rowIndex <= rowIndexEnd; rowIndex++) {
            var extremaClasses = grid.getExtremaClasses(rowIndex, 0, rowIndexEnd, 1);
            var renderer = grid.isGhostIndex(rowIndex, -1) ? this.renderGhostCell : this.renderCell;
            cells.push(renderer(rowIndex, extremaClasses));
        }
        // always set height so that the layout can push out the element unless it overflows.
        var style = {
            height: grid.getRect().height + "px",
        };
        // use CSS translation to offset the cells
        if (viewportRect != null) {
            style.transform = "translate3d(0, " + (grid.getRowRect(rowIndexStart).top - viewportRect.top) + "px, 0)";
        }
        return (React.createElement(roundSize_1.RoundSize, null, 
            React.createElement("div", {style: style}, cells)
        ));
    };
    RowHeader.defaultProps = {
        isResizable: false,
        renderRowHeader: renderDefaultRowHeader,
    };
    RowHeader = __decorate([
        PureRender
    ], RowHeader);
    return RowHeader;
}(React.Component));
exports.RowHeader = RowHeader;
/**
 * A default implementation of `IRowHeaderRenderer` that displays 1-indexed
 * numbers for each row.
 */
function renderDefaultRowHeader(rowIndex) {
    return React.createElement(rowHeaderCell_1.RowHeaderCell, {name: "" + (rowIndex + 1)});
}
exports.renderDefaultRowHeader = renderDefaultRowHeader;

//# sourceMappingURL=data:application/json;base64,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
