/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
require("es6-shim");
var cell_1 = require("./cell/cell");
exports.Cell = cell_1.Cell;
var editableCell_1 = require("./cell/editableCell");
exports.EditableCell = editableCell_1.EditableCell;
var jsonFormat_1 = require("./cell/formats/jsonFormat");
exports.JSONFormat = jsonFormat_1.JSONFormat;
var truncatedFormat_1 = require("./cell/formats/truncatedFormat");
exports.TruncatedFormat = truncatedFormat_1.TruncatedFormat;
var column_1 = require("./column");
exports.Column = column_1.Column;
var index_1 = require("./common/index");
exports.Clipboard = index_1.Clipboard;
exports.Grid = index_1.Grid;
exports.Rect = index_1.Rect;
exports.Utils = index_1.Utils;
var menus_1 = require("./interactions/menus");
exports.CopyCellsMenuItem = menus_1.CopyCellsMenuItem;
var resizeHandle_1 = require("./interactions/resizeHandle");
exports.Orientation = resizeHandle_1.Orientation;
exports.ResizeHandle = resizeHandle_1.ResizeHandle;
var columnHeaderCell_1 = require("./headers/columnHeaderCell");
exports.ColumnHeaderCell = columnHeaderCell_1.ColumnHeaderCell;
exports.HorizontalCellDivider = columnHeaderCell_1.HorizontalCellDivider;
var rowHeaderCell_1 = require("./headers/rowHeaderCell");
exports.RowHeaderCell = rowHeaderCell_1.RowHeaderCell;
var editableName_1 = require("./headers/editableName");
exports.EditableName = editableName_1.EditableName;
var regions_1 = require("./regions");
exports.RegionCardinality = regions_1.RegionCardinality;
exports.Regions = regions_1.Regions;
exports.SelectionModes = regions_1.SelectionModes;
var table_1 = require("./table");
exports.Table = table_1.Table;

//# sourceMappingURL=data:application/json;base64,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
