/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var clipboard_1 = require("../common/clipboard");
var regions_1 = require("../regions");
var core_1 = require("@blueprintjs/core");
var React = require("react");
var MenuContext = (function () {
    function MenuContext(target, selectedRegions, numRows, numCols) {
        this.target = target;
        this.selectedRegions = selectedRegions;
        this.numRows = numRows;
        this.numCols = numCols;
        this.regions = regions_1.Regions.containsRegion(selectedRegions, target) ? selectedRegions : [target];
    }
    MenuContext.prototype.getTarget = function () {
        return this.target;
    };
    MenuContext.prototype.getSelectedRegions = function () {
        return this.selectedRegions;
    };
    MenuContext.prototype.getRegions = function () {
        return this.regions;
    };
    MenuContext.prototype.getUniqueCells = function () {
        return regions_1.Regions.enumerateUniqueCells(this.regions, this.numRows, this.numCols);
    };
    return MenuContext;
}());
exports.MenuContext = MenuContext;
var CopyCellsMenuItem = (function (_super) {
    __extends(CopyCellsMenuItem, _super);
    function CopyCellsMenuItem() {
        var _this = this;
        _super.apply(this, arguments);
        this.handleClick = function () {
            var _a = _this.props, context = _a.context, getCellData = _a.getCellData, onCopy = _a.onCopy;
            var cells = context.getUniqueCells();
            var sparse = regions_1.Regions.sparseMapCells(cells, getCellData);
            var success = clipboard_1.Clipboard.copyCells(sparse);
            if (onCopy != null) {
                onCopy(success);
            }
        };
    }
    CopyCellsMenuItem.prototype.render = function () {
        return React.createElement(core_1.MenuItem, __assign({}, this.props, {onClick: this.handleClick}));
    };
    return CopyCellsMenuItem;
}(React.Component));
exports.CopyCellsMenuItem = CopyCellsMenuItem;

//# sourceMappingURL=data:application/json;base64,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
