/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var draggable_1 = require("./draggable");
var classNames = require("classnames");
var React = require("react");
(function (Orientation) {
    Orientation[Orientation["HORIZONTAL"] = 1] = "HORIZONTAL";
    Orientation[Orientation["VERTICAL"] = 0] = "VERTICAL";
})(exports.Orientation || (exports.Orientation = {}));
var Orientation = exports.Orientation;
var ResizeHandle = (function (_super) {
    __extends(ResizeHandle, _super);
    function ResizeHandle() {
        var _this = this;
        _super.apply(this, arguments);
        this.state = {
            isDragging: false,
        };
        this.handleActivate = function (event) {
            _this.setState({ isDragging: true });
            _this.props.onLayoutLock(true);
            event.stopPropagation();
            event.stopImmediatePropagation();
            return true;
        };
        this.handleDragMove = function (_event, coords) {
            var orientationIndex = _this.props.orientation;
            if (_this.props.onResizeMove != null) {
                _this.props.onResizeMove(coords.offset[orientationIndex], coords.delta[orientationIndex]);
            }
        };
        this.handleDragEnd = function (_event, coords) {
            var orientationIndex = _this.props.orientation;
            _this.setState({ isDragging: false });
            _this.props.onLayoutLock(false);
            if (_this.props.onResizeMove != null) {
                _this.props.onResizeMove(coords.offset[orientationIndex], coords.delta[orientationIndex]);
            }
            if (_this.props.onResizeEnd != null) {
                _this.props.onResizeEnd(coords.offset[orientationIndex]);
            }
        };
        this.handleClick = function (_event) {
            _this.setState({ isDragging: false });
            _this.props.onLayoutLock(false);
        };
        this.handleDoubleClick = function (_event) {
            _this.setState({ isDragging: false });
            _this.props.onLayoutLock(false);
            if (_this.props.onDoubleClick != null) {
                _this.props.onDoubleClick();
            }
        };
    }
    ResizeHandle.prototype.render = function () {
        var _a = this.props, onResizeMove = _a.onResizeMove, onResizeEnd = _a.onResizeEnd, onDoubleClick = _a.onDoubleClick, orientation = _a.orientation;
        if (onResizeMove == null && onResizeEnd == null && onDoubleClick == null) {
            return undefined;
        }
        var targetClasses = classNames("bp-table-resize-handle-target", {
            "bp-table-resize-horizontal": orientation === Orientation.HORIZONTAL,
            "bp-table-resize-vertical": orientation === Orientation.VERTICAL,
            "bp-table-dragging": this.state.isDragging,
        });
        var handleClasses = classNames("bp-table-resize-handle", { "bp-table-dragging": this.state.isDragging });
        return (React.createElement(draggable_1.Draggable, {onActivate: this.handleActivate, onClick: this.handleClick, onDoubleClick: this.handleDoubleClick, onDragEnd: this.handleDragEnd, onDragMove: this.handleDragMove}, 
            React.createElement("div", {className: targetClasses}, 
                React.createElement("div", {className: handleClasses})
            )
        ));
    };
    return ResizeHandle;
}(React.Component));
exports.ResizeHandle = ResizeHandle;

//# sourceMappingURL=data:application/json;base64,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
