/// <reference types="react" />
/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
import { ICoordinateData } from "../interactions/draggable";
import { IRegion } from "../regions";
import * as React from "react";
export interface ISelectableProps {
    /**
     * If `false`, only a single region of a single column/row/cell may be
     * selected at one time. Using <kbd class="pt-key">ctrl</kbd> or
     * <kbd class="pt-key">meta</kbd> key will have no effect,
     * and a mouse drag will select the current column/row/cell only.
     */
    allowMultipleSelection: boolean;
    /**
     * An array containing the table's selection Regions.
     */
    selectedRegions: IRegion[];
    /**
     * When the user selects something, this callback is called with a new
     * array of Regions. This array should be considered the new selection
     * state for the entire table.
     */
    onSelection: (regions: IRegion[]) => void;
}
export interface IDragSelectableProps extends ISelectableProps {
    /**
     * A callback that determines a `Region` for the single `MouseEvent`. If
     * no valid region can be found, `null` may be returned.
     */
    locateClick: (event: MouseEvent) => IRegion;
    /**
     * A callback that determines a `Region` for the `MouseEvent` and
     * coordinate data representing a drag. If no valid region can be found,
     * `null` may be returned.
     */
    locateDrag: (event: MouseEvent, coords: ICoordinateData) => IRegion;
}
export declare class DragSelectable extends React.Component<IDragSelectableProps, {}> {
    static isLeftClick(event: MouseEvent): boolean;
    render(): JSX.Element;
    private getDraggableProps();
    private handleActivate;
    private handleDragMove;
    private handleClick;
}
