/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var draggable_1 = require("../interactions/draggable");
var regions_1 = require("../regions");
var PureRender = require("pure-render-decorator");
var React = require("react");
var DragSelectable = (function (_super) {
    __extends(DragSelectable, _super);
    function DragSelectable() {
        var _this = this;
        _super.apply(this, arguments);
        this.handleActivate = function (event) {
            if (!DragSelectable.isLeftClick(event)) {
                return false;
            }
            var region = _this.props.locateClick(event);
            if (!regions_1.Regions.isValid(region)) {
                return false;
            }
            var foundIndex = regions_1.Regions.findMatchingRegion(_this.props.selectedRegions, region);
            if (foundIndex !== -1) {
                // If re-clicking on an existing region, we either carefully
                // remove it if the meta key is used or otherwise we clear the
                // selection entirely.
                if (draggable_1.DragEvents.isAdditive(event)) {
                    var newSelectedRegions = _this.props.selectedRegions.slice();
                    newSelectedRegions.splice(foundIndex, 1);
                    _this.props.onSelection(newSelectedRegions);
                }
                else {
                    _this.props.onSelection([]);
                }
                return false;
            }
            if (draggable_1.DragEvents.isAdditive(event) && _this.props.allowMultipleSelection) {
                _this.props.onSelection(regions_1.Regions.add(_this.props.selectedRegions, region));
            }
            else {
                _this.props.onSelection([region]);
            }
            return true;
        };
        this.handleDragMove = function (event, coords) {
            var region = (_this.props.allowMultipleSelection) ?
                _this.props.locateDrag(event, coords) :
                _this.props.locateClick(event);
            if (!regions_1.Regions.isValid(region)) {
                return;
            }
            _this.props.onSelection(regions_1.Regions.update(_this.props.selectedRegions, region));
        };
        this.handleClick = function (event) {
            if (!DragSelectable.isLeftClick(event)) {
                return false;
            }
            var region = _this.props.locateClick(event);
            if (!regions_1.Regions.isValid(region)) {
                _this.props.onSelection([]);
                return false;
            }
            if (_this.props.selectedRegions.length > 0) {
                _this.props.onSelection(regions_1.Regions.update(_this.props.selectedRegions, region));
            }
            else {
                _this.props.onSelection([region]);
            }
            return false;
        };
    }
    DragSelectable.isLeftClick = function (event) {
        return event.button === 0;
    };
    DragSelectable.prototype.render = function () {
        var draggableProps = this.getDraggableProps();
        return (React.createElement(draggable_1.Draggable, __assign({}, draggableProps), this.props.children));
    };
    DragSelectable.prototype.getDraggableProps = function () {
        return this.props.onSelection == null ? {} : {
            onActivate: this.handleActivate,
            onClick: this.handleClick,
            onDragMove: this.handleDragMove,
        };
    };
    DragSelectable = __decorate([
        PureRender
    ], DragSelectable);
    return DragSelectable;
}(React.Component));
exports.DragSelectable = DragSelectable;

//# sourceMappingURL=data:application/json;base64,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
