/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var classNames = require("classnames");
var React = require("react");
var GuideLayer = (function (_super) {
    __extends(GuideLayer, _super);
    function GuideLayer() {
        _super.apply(this, arguments);
        this.renderVerticalGuide = function (offset, index) {
            var style = {
                left: offset + "px",
            };
            return (React.createElement("div", {className: "bp-table-overlay bp-table-vertical-guide", key: index, style: style}));
        };
        this.renderHorizontalGuide = function (offset, index) {
            var style = {
                top: offset + "px",
            };
            return (React.createElement("div", {className: "bp-table-overlay bp-table-horizontal-guide", key: index, style: style}));
        };
    }
    GuideLayer.prototype.render = function () {
        var _a = this.props, verticalGuides = _a.verticalGuides, horizontalGuides = _a.horizontalGuides, className = _a.className;
        var verticals = (verticalGuides == null) ? undefined : verticalGuides.map(this.renderVerticalGuide);
        var horizontals = (horizontalGuides == null) ? undefined : horizontalGuides.map(this.renderHorizontalGuide);
        return (React.createElement("div", {className: classNames(className, "bp-table-overlay-layer")}, 
            verticals, 
            horizontals));
    };
    return GuideLayer;
}(React.Component));
exports.GuideLayer = GuideLayer;

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9sYXllcnMvZ3VpZGVzLnRzeCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7O0dBR0c7Ozs7Ozs7QUFHSCxJQUFZLFVBQVUsV0FBTSxZQUFZLENBQUMsQ0FBQTtBQUN6QyxJQUFZLEtBQUssV0FBTSxPQUFPLENBQUMsQ0FBQTtBQWMvQjtJQUFnQyw4QkFBcUM7SUFBckU7UUFBZ0MsOEJBQXFDO1FBYXpELHdCQUFtQixHQUFHLFVBQUMsTUFBYyxFQUFFLEtBQWE7WUFDeEQsSUFBTSxLQUFLLEdBQUc7Z0JBQ1YsSUFBSSxFQUFLLE1BQU0sT0FBSTthQUNDLENBQUM7WUFDekIsTUFBTSxDQUFDLENBQ0gscUJBQUMsR0FBRyxJQUFDLFNBQVMsRUFBQywwQ0FBMEMsRUFBQyxHQUFHLEVBQUUsS0FBTSxFQUFDLEtBQUssRUFBRSxLQUFNLEVBQUcsQ0FDekYsQ0FBQztRQUNOLENBQUMsQ0FBQztRQUVNLDBCQUFxQixHQUFHLFVBQUMsTUFBYyxFQUFFLEtBQWE7WUFDMUQsSUFBTSxLQUFLLEdBQUc7Z0JBQ1YsR0FBRyxFQUFLLE1BQU0sT0FBSTthQUNFLENBQUM7WUFDekIsTUFBTSxDQUFDLENBQ0gscUJBQUMsR0FBRyxJQUFDLFNBQVMsRUFBQyw0Q0FBNEMsRUFBQyxHQUFHLEVBQUUsS0FBTSxFQUFDLEtBQUssRUFBRSxLQUFNLEVBQUcsQ0FDM0YsQ0FBQztRQUNOLENBQUMsQ0FBQztJQUNOLENBQUM7SUE3QlUsMkJBQU0sR0FBYjtRQUNJLElBQUEsZUFBa0UsRUFBMUQsa0NBQWMsRUFBRSxzQ0FBZ0IsRUFBRSx3QkFBUyxDQUFnQjtRQUNuRSxJQUFNLFNBQVMsR0FBRyxDQUFDLGNBQWMsSUFBSSxJQUFJLENBQUMsR0FBRyxTQUFTLEdBQUcsY0FBYyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQztRQUN0RyxJQUFNLFdBQVcsR0FBRyxDQUFDLGdCQUFnQixJQUFJLElBQUksQ0FBQyxHQUFHLFNBQVMsR0FBRyxnQkFBZ0IsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLENBQUM7UUFDOUcsTUFBTSxDQUFDLENBQ0gscUJBQUMsR0FBRyxJQUFDLFNBQVMsRUFBRSxVQUFVLENBQUMsU0FBUyxFQUFFLHdCQUF3QixDQUFFO1lBQzNELFNBQVU7WUFDVixXQUFZLENBQ1gsQ0FDVCxDQUFDO0lBQ04sQ0FBQztJQW1CTCxpQkFBQztBQUFELENBOUJBLEFBOEJDLENBOUIrQixLQUFLLENBQUMsU0FBUyxHQThCOUM7QUE5Qlksa0JBQVUsYUE4QnRCLENBQUEiLCJmaWxlIjoibGF5ZXJzL2d1aWRlcy5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQ29weXJpZ2h0IDIwMTYgUGFsYW50aXIgVGVjaG5vbG9naWVzLCBJbmMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuXG4gKiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wIC0gaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKi9cblxuaW1wb3J0IHsgSVByb3BzIH0gZnJvbSBcIkBibHVlcHJpbnRqcy9jb3JlXCI7XG5pbXBvcnQgKiBhcyBjbGFzc05hbWVzIGZyb20gXCJjbGFzc25hbWVzXCI7XG5pbXBvcnQgKiBhcyBSZWFjdCBmcm9tIFwicmVhY3RcIjtcblxuZXhwb3J0IGludGVyZmFjZSBJR3VpZGVMYXllclByb3BzIGV4dGVuZHMgSVByb3BzIHtcbiAgICAvKipcbiAgICAgKiAgVGhlIGxlZnQtb2Zmc2V0IGxvY2F0aW9uIG9mIHRoZSB2ZXJ0aWNhbCBndWlkZXNcbiAgICAgKi9cbiAgICB2ZXJ0aWNhbEd1aWRlcz86IG51bWJlcltdO1xuXG4gICAgLyoqXG4gICAgICogIFRoZSB0b3Atb2Zmc2V0IGxvY2F0aW9uIG9mIHRoZSBob3Jpem9udGFsIGd1aWRlc1xuICAgICAqL1xuICAgIGhvcml6b250YWxHdWlkZXM/OiBudW1iZXJbXTtcbn1cblxuZXhwb3J0IGNsYXNzIEd1aWRlTGF5ZXIgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQ8SUd1aWRlTGF5ZXJQcm9wcywge30+IHtcbiAgICBwdWJsaWMgcmVuZGVyKCkge1xuICAgICAgICBjb25zdCB7IHZlcnRpY2FsR3VpZGVzLCBob3Jpem9udGFsR3VpZGVzLCBjbGFzc05hbWUgfSA9IHRoaXMucHJvcHM7XG4gICAgICAgIGNvbnN0IHZlcnRpY2FscyA9ICh2ZXJ0aWNhbEd1aWRlcyA9PSBudWxsKSA/IHVuZGVmaW5lZCA6IHZlcnRpY2FsR3VpZGVzLm1hcCh0aGlzLnJlbmRlclZlcnRpY2FsR3VpZGUpO1xuICAgICAgICBjb25zdCBob3Jpem9udGFscyA9IChob3Jpem9udGFsR3VpZGVzID09IG51bGwpID8gdW5kZWZpbmVkIDogaG9yaXpvbnRhbEd1aWRlcy5tYXAodGhpcy5yZW5kZXJIb3Jpem9udGFsR3VpZGUpO1xuICAgICAgICByZXR1cm4gKFxuICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9e2NsYXNzTmFtZXMoY2xhc3NOYW1lLCBcImJwLXRhYmxlLW92ZXJsYXktbGF5ZXJcIil9PlxuICAgICAgICAgICAgICAgIHt2ZXJ0aWNhbHN9XG4gICAgICAgICAgICAgICAge2hvcml6b250YWxzfVxuICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICk7XG4gICAgfVxuXG4gICAgcHJpdmF0ZSByZW5kZXJWZXJ0aWNhbEd1aWRlID0gKG9mZnNldDogbnVtYmVyLCBpbmRleDogbnVtYmVyKSA9PiB7XG4gICAgICAgIGNvbnN0IHN0eWxlID0ge1xuICAgICAgICAgICAgbGVmdDogYCR7b2Zmc2V0fXB4YCxcbiAgICAgICAgfSBhcyBSZWFjdC5DU1NQcm9wZXJ0aWVzO1xuICAgICAgICByZXR1cm4gKFxuICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJicC10YWJsZS1vdmVybGF5IGJwLXRhYmxlLXZlcnRpY2FsLWd1aWRlXCIga2V5PXtpbmRleH0gc3R5bGU9e3N0eWxlfSAvPlxuICAgICAgICApO1xuICAgIH07XG5cbiAgICBwcml2YXRlIHJlbmRlckhvcml6b250YWxHdWlkZSA9IChvZmZzZXQ6IG51bWJlciwgaW5kZXg6IG51bWJlcikgPT4ge1xuICAgICAgICBjb25zdCBzdHlsZSA9IHtcbiAgICAgICAgICAgIHRvcDogYCR7b2Zmc2V0fXB4YCxcbiAgICAgICAgfSBhcyBSZWFjdC5DU1NQcm9wZXJ0aWVzO1xuICAgICAgICByZXR1cm4gKFxuICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJicC10YWJsZS1vdmVybGF5IGJwLXRhYmxlLWhvcml6b250YWwtZ3VpZGVcIiBrZXk9e2luZGV4fSBzdHlsZT17c3R5bGV9IC8+XG4gICAgICAgICk7XG4gICAgfTtcbn1cbiJdLCJzb3VyY2VSb290IjoiL3NvdXJjZS8ifQ==
