/// <reference types="react" />
/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
import { IRegion } from "../regions";
import { IProps } from "@blueprintjs/core";
import * as React from "react";
export interface IRegionStyler {
    (region: IRegion): React.CSSProperties;
}
export interface IRegionLayerProps extends IProps {
    /**
     * The array of regions to render.
     */
    regions?: IRegion[];
    /**
     * A callback interface for applying CSS styles to the regions.
     */
    getRegionStyle: IRegionStyler;
}
export declare class RegionLayer extends React.Component<IRegionLayerProps, {}> {
    render(): JSX.Element;
    private renderRegionChildren();
    private renderRegion;
}
