/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var classNames = require("classnames");
var PureRender = require("pure-render-decorator");
var React = require("react");
var RegionLayer = (function (_super) {
    __extends(RegionLayer, _super);
    function RegionLayer() {
        var _this = this;
        _super.apply(this, arguments);
        this.renderRegion = function (region, index) {
            var _a = _this.props, className = _a.className, getRegionStyle = _a.getRegionStyle;
            return (React.createElement("div", {className: classNames("bp-table-overlay bp-table-region", className), key: index, style: getRegionStyle(region)}));
        };
    }
    RegionLayer.prototype.render = function () {
        return React.createElement("div", {className: "bp-table-overlay-layer"}, this.renderRegionChildren());
    };
    RegionLayer.prototype.renderRegionChildren = function () {
        var regions = this.props.regions;
        if (regions == null) {
            return undefined;
        }
        return regions.map(this.renderRegion);
    };
    RegionLayer = __decorate([
        PureRender
    ], RegionLayer);
    return RegionLayer;
}(React.Component));
exports.RegionLayer = RegionLayer;

//# sourceMappingURL=data:application/json;base64,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
