/**
 * Copyright 2016 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var cell_1 = require("./cell/cell");
var rect_1 = require("./common/rect");
var utils_1 = require("./common/utils");
var menus_1 = require("./interactions/menus");
var selectable_1 = require("./interactions/selectable");
var regions_1 = require("./regions");
var core_1 = require("@blueprintjs/core");
var React = require("react");
var TABLE_BODY_CLASSES = "bp-table-body-virtual-client bp-table-cell-client";
var CELL_GHOST_CLASS = "bp-table-cell-ghost";
var CELL_LEDGER_ODD_CLASS = "bp-table-cell-ledger-odd";
var CELL_LEDGER_EVEN_CLASS = "bp-table-cell-ledger-even";
/**
 * For perf, we want to ignore changes to the `ISelectableProps` part of the
 * `ITableBodyProps` since those are only used when a context menu is launched.
 */
var UPDATE_PROPS_KEYS = [
    "grid",
    "locator",
    "viewportRect",
    "cellRenderer",
    "rowIndexStart",
    "rowIndexEnd",
    "columnIndexStart",
    "columnIndexEnd",
];
var TableBody = (function (_super) {
    __extends(TableBody, _super);
    function TableBody() {
        var _this = this;
        _super.apply(this, arguments);
        this.renderGhostCell = function (rowIndex, columnIndex, extremaClasses) {
            var grid = _this.props.grid;
            var cell = utils_1.Utils.assignClasses(cell_1.emptyCellRenderer(rowIndex, columnIndex), TableBody.cellClassNames(rowIndex, columnIndex), extremaClasses, CELL_GHOST_CLASS, (_a = {},
                _a[CELL_LEDGER_ODD_CLASS] = (rowIndex % 2) === 1,
                _a[CELL_LEDGER_EVEN_CLASS] = (rowIndex % 2) === 0,
                _a
            ));
            var key = TableBody.cellReactKey(rowIndex, columnIndex);
            var style = rect_1.Rect.style(grid.getGhostCellRect(rowIndex, columnIndex));
            return React.cloneElement(cell, { key: key, style: style });
            var _a;
        };
        this.renderCell = function (rowIndex, columnIndex, extremaClasses) {
            var _a = _this.props, allowMultipleSelection = _a.allowMultipleSelection, grid = _a.grid, cellRenderer = _a.cellRenderer, selectedRegions = _a.selectedRegions, onSelection = _a.onSelection;
            var cell = utils_1.Utils.assignClasses(cellRenderer(rowIndex, columnIndex), TableBody.cellClassNames(rowIndex, columnIndex), extremaClasses, (_b = {},
                _b[CELL_LEDGER_ODD_CLASS] = (rowIndex % 2) === 1,
                _b[CELL_LEDGER_EVEN_CLASS] = (rowIndex % 2) === 0,
                _b
            ));
            var key = TableBody.cellReactKey(rowIndex, columnIndex);
            var style = rect_1.Rect.style(grid.getCellRect(rowIndex, columnIndex));
            return (React.createElement(selectable_1.DragSelectable, {allowMultipleSelection: allowMultipleSelection, key: key, locateClick: _this.locateClick, locateDrag: _this.locateDrag, onSelection: onSelection, selectedRegions: selectedRegions}, React.cloneElement(cell, { style: style })));
            var _b;
        };
        this.locateClick = function (event) {
            var _a = _this.props.locator.convertPointToCell(event.clientX, event.clientY), col = _a.col, row = _a.row;
            return regions_1.Regions.cell(row, col);
        };
        this.locateDrag = function (_event, coords) {
            var start = _this.props.locator.convertPointToCell(coords.activation[0], coords.activation[1]);
            var end = _this.props.locator.convertPointToCell(coords.current[0], coords.current[1]);
            return regions_1.Regions.cell(start.row, start.col, end.row, end.col);
        };
    }
    /**
     * Returns the array of class names that must be applied to each table
     * cell so that we can locate any cell based on its coordinate.
     */
    TableBody.cellClassNames = function (rowIndex, columnIndex) {
        return [
            ("bp-table-cell-row-" + rowIndex),
            ("bp-table-cell-col-" + columnIndex),
        ];
    };
    TableBody.shallowCompareKeys = function (objA, objB, keys) {
        for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
            var key = keys_1[_i];
            if (objA[key] !== objB[key]) {
                return false;
            }
        }
        return true;
    };
    TableBody.cellReactKey = function (rowIndex, columnIndex) {
        return "cell-" + rowIndex + "-" + columnIndex;
    };
    TableBody.prototype.shouldComponentUpdate = function (nextProps) {
        var shallowEqual = TableBody.shallowCompareKeys(this.props, nextProps, UPDATE_PROPS_KEYS);
        return !shallowEqual;
    };
    TableBody.prototype.render = function () {
        var _a = this.props, grid = _a.grid, rowIndexStart = _a.rowIndexStart, rowIndexEnd = _a.rowIndexEnd, columnIndexStart = _a.columnIndexStart, columnIndexEnd = _a.columnIndexEnd;
        var cells = [];
        for (var rowIndex = rowIndexStart; rowIndex <= rowIndexEnd; rowIndex++) {
            for (var columnIndex = columnIndexStart; columnIndex <= columnIndexEnd; columnIndex++) {
                var isGhost = grid.isGhostIndex(rowIndex, columnIndex);
                var extremaClasses = grid.getExtremaClasses(rowIndex, columnIndex, rowIndexEnd, columnIndexEnd);
                var renderer = isGhost ? this.renderGhostCell : this.renderCell;
                cells.push(renderer(rowIndex, columnIndex, extremaClasses));
            }
        }
        var style = grid.getRect().sizeStyle();
        return React.createElement("div", {className: TABLE_BODY_CLASSES, style: style}, cells);
    };
    TableBody.prototype.renderContextMenu = function (e) {
        var _a = this.props, selectedRegions = _a.selectedRegions, renderBodyContextMenu = _a.renderBodyContextMenu, grid = _a.grid;
        if (renderBodyContextMenu == null) {
            return undefined;
        }
        var target = this.locateClick(e.nativeEvent);
        return renderBodyContextMenu(new menus_1.MenuContext(target, selectedRegions, grid.numRows, grid.numCols));
    };
    TableBody = __decorate([
        core_1.ContextMenuTarget
    ], TableBody);
    return TableBody;
}(React.Component));
exports.TableBody = TableBody;

//# sourceMappingURL=data:application/json;base64,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
