import * as integration from "./integrationGraph";
import { NodeType } from "./nodeTypeMapper";
import { NameFormatter } from "./nameFormatter";
export declare type GeneratorConfig = {
    indent: string;
    newline: string;
    nodesColorScheme: string;
    linksColorScheme: string;
    nodeAttributes: Map<NodeType, object>;
};
export declare class GraphGenerator {
    nameFormatter: NameFormatter;
    constructor(nameFormatter?: NameFormatter);
    generateLinks(links: integration.Link[], config: GeneratorConfig): string[];
    generateNodes(groupType: NodeType, nodes: integration.Node[], config: GeneratorConfig): string[];
    generateCluster(name: string, nodes: integration.Node[], attributes: object, indent?: string): string[];
    private generateGraphNodes;
    private generateNode;
    private formatAttributes;
}
