import * as integration from "./integrationGraph";
import { NodeTypeMapper } from "./nodeTypeMapper";
import { GeneratorConfig, GraphGenerator } from "./graphGenerator";
export default class IntegrationParser {
    config: GeneratorConfig;
    nodeTypeMapper: NodeTypeMapper;
    graphGenerator: GraphGenerator;
    constructor(config?: Partial<GeneratorConfig>, nodeTypeMapper?: NodeTypeMapper, graphGenerator?: GraphGenerator);
    convert(graph: string | integration.Graph): string;
    private convertGraph;
    private generateNodes;
    private generateNodeGroup;
    private generateLinks;
    private groupNodes;
}
