'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

var _chalk = require('chalk');

var _chalk2 = _interopRequireDefault(_chalk);

var _readline = require('readline');

var _readline2 = _interopRequireDefault(_readline);

var _Renderer = require('./Renderer');

var _Renderer2 = _interopRequireDefault(_Renderer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @copyright   2017, Miles Johnson
 * @license     https://opensource.org/licenses/MIT
 * 
 */

class Console {

  constructor(renderer, globalConfig) {
    this.groups = [];

    this.global = globalConfig;
    this.io = _readline2.default.createInterface({
      input: process.stdin,
      output: process.stdout
    });
    this.renderer = renderer;
  }

  ask(question) {
    return new _bluebird2.default(resolve => {
      this.io.question(_chalk2.default.magenta(`${question}\n`), answer => {
        resolve(answer.trim());
      });
    });
  }

  close() {
    this.renderer.stop();
    this.io.close();
  }

  debug(message) {
    if (this.global.config.debug) {
      this.log(`${_chalk2.default.blue('[debug]')} ${this.renderer.indent(this.groups.length)}${message}`);
    }

    return this;
  }

  groupStart(group) {
    this.debug(_chalk2.default.gray(`[${group}]`));
    this.groups.push(group);

    return this;
  }

  groupStop() {
    this.groups.pop();

    return this;
  }

  invariant(condition, message, pass, fail) {
    this.debug(`${message}: ${condition ? _chalk2.default.green(pass) : _chalk2.default.red(fail)}`);

    return this;
  }

  log(message, newline = 1) {
    this.io.write(`${message}${newline ? '\n'.repeat(newline) : ''}`);

    return this;
  }

  render() {
    this.renderer.update();
  }
}
exports.default = Console;