'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _Routine = require('./Routine');

var _Routine2 = _interopRequireDefault(_Routine);

var _Renderer = require('./Renderer');

var _Renderer2 = _interopRequireDefault(_Renderer);

var _Console = require('./Console');

var _Console2 = _interopRequireDefault(_Console);

var _TaskResult = require('./TaskResult');

var _TaskResult2 = _interopRequireDefault(_TaskResult);

var _constants = require('./constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Pipeline extends _Routine2.default {
  constructor(name, globalConfig = _constants.DEFAULT_GLOBALS) {
    super(name, name, globalConfig.config);

    this.loadResults = () => this.toResult().routines;

    this.global = globalConfig;

    this.console = new _Console2.default(new _Renderer2.default(this.loadResults), globalConfig);
  }

  run(initialValue = null) {
    return this.serializeSubroutines(initialValue).finally(() => {
      this.console.close();
    });
  }
}
exports.default = Pipeline; /**
                             * @copyright   2017, Miles Johnson
                             * @license     https://opensource.org/licenses/MIT
                             * 
                             */