'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; /**
                                                                                                                                                                                                                                                                   * @copyright   2017, Miles Johnson
                                                                                                                                                                                                                                                                   * @license     https://opensource.org/licenses/MIT
                                                                                                                                                                                                                                                                   * 
                                                                                                                                                                                                                                                                   */

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

var _merge = require('lodash/merge');

var _merge2 = _interopRequireDefault(_merge);

var _isObject = require('lodash/isObject');

var _isObject2 = _interopRequireDefault(_isObject);

var _Console = require('./Console');

var _Console2 = _interopRequireDefault(_Console);

var _Task = require('./Task');

var _Task2 = _interopRequireDefault(_Task);

var _TaskResult = require('./TaskResult');

var _TaskResult2 = _interopRequireDefault(_TaskResult);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Routine extends _Task2.default {

  constructor(key, title, defaultConfig = {}) {
    super(title, value => value);

    this.key = '';
    this.subroutines = [];
    this.tasks = [];

    this.executeTask = (value, task) => this.wrap(task.run(value)).finally(() => {
      this.console.render();
    });

    if (!key || typeof key !== 'string') {
      throw new TypeError('Routine key must be a valid unique string.');
    }

    this.action = this.execute.bind(this);
    this.config = _extends({}, defaultConfig);
    this.key = key;
  }

  bootstrap() {}

  configure(parentConfig, globalConfig, rootConsole) {
    this.global = globalConfig;
    this.console = rootConsole;

    const config = parentConfig[this.key];

    if ((0, _isObject2.default)(config)) {
      (0, _merge2.default)(this.config, config);
    }

    this.bootstrap();

    return this;
  }

  execute(value) {
    return value;
  }

  parallelizeSubroutines(value = null) {
    return _bluebird2.default.all(this.subroutines.map(routine => this.executeTask(value, routine)));
  }

  parallelizeTasks(value = null) {
    return _bluebird2.default.all(this.tasks.map(task => this.executeTask(value, task)));
  }

  pipe(...routines) {
    routines.forEach(routine => {
      if (routine instanceof Routine) {
        this.subroutines.push(routine.configure(this.config, this.global, this.console));
      } else {
        throw new TypeError('Routine must be an instance of `Routine`.');
      }
    });

    return this;
  }

  run(value) {
    this.console.groupStart(this.key);

    return super.run(value).finally(() => {
      this.console.groupStop();
      this.console.render();
    });
  }

  serialize(initialValue, items, accumulator) {
    return items.reduce((promise, item) => promise.then(value => accumulator(value, item)), _bluebird2.default.resolve(initialValue));
  }

  serializeSubroutines(value = null) {
    return this.serialize(value, this.subroutines, this.executeTask);
  }

  serializeTasks(value = null) {
    return this.serialize(value, this.tasks, this.executeTask);
  }

  task(title, callback) {
    this.tasks.push(new _Task2.default(title, callback.bind(this)));

    return this;
  }

  toResult() {
    const result = super.toResult();

    result.tasks = this.tasks.map(task => task.toResult());
    result.routines = this.subroutines.map(routine => routine.toResult());

    return result;
  }
}
exports.default = Routine;