'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

var _TaskResult = require('./TaskResult');

var _TaskResult2 = _interopRequireDefault(_TaskResult);

var _constants = require('./constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Task {

  constructor(title, action) {
    this.time = 0;
    this.title = '';
    this.status = _constants.PENDING;

    if (!title || typeof title !== 'string') {
      throw new Error('Tasks require a title.');
    }

    if (!action || typeof action !== 'function') {
      throw new Error('Tasks require an executable function.');
    }

    this.title = title;
    this.action = action;
  }

  run(value) {
    if (this.status === _constants.SKIPPED) {
      return _bluebird2.default.resolve(value);
    }

    this.status = _constants.RUNNING;

    return new _bluebird2.default(resolve => {
      resolve(this.action(value));
    }).then(result => {
      this.status = _constants.PASSED;

      return result;
    }, error => {
      this.status = _constants.FAILED;

      throw error;
    });
  }

  skip(condition = true) {
    if (condition) {
      this.status = _constants.SKIPPED;
    }

    return this;
  }

  toResult() {
    return new _TaskResult2.default(this.title, this.status);
  }

  wrap(value) {
    return value instanceof _bluebird2.default ? value : _bluebird2.default.resolve(value);
  }
}
exports.default = Task; /**
                         * @copyright   2017, Miles Johnson
                         * @license     https://opensource.org/licenses/MIT
                         * 
                         */