'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _elegantSpinner = require('elegant-spinner');

var _elegantSpinner2 = _interopRequireDefault(_elegantSpinner);

var _constants = require('./constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @copyright   2017, Miles Johnson
 * @license     https://opensource.org/licenses/MIT
 * 
 */

class TaskResult {

  constructor(title, status) {
    this.spinnerFrames = null;
    this.routines = [];
    this.tasks = [];

    this.title = title;
    this.status = status;
  }

  hasFailed() {
    return this.status === _constants.FAILED;
  }

  hasPassed() {
    return this.status === _constants.PASSED;
  }

  isPending() {
    return this.status === _constants.PENDING;
  }

  isRunning() {
    return this.status === _constants.RUNNING;
  }

  isSkipped() {
    return this.status === _constants.SKIPPED;
  }

  spinner() {
    if (!this.spinnerFrames) {
      this.spinnerFrames = (0, _elegantSpinner2.default)();
    }

    return this.spinnerFrames();
  }
}
exports.default = TaskResult;