[![CircleCI](https://circleci.com/gh/italia/bootstrap-italia/tree/master.svg?style=svg)](https://circleci.com/gh/italia/bootstrap-italia/tree/master)
[![GitHub issues](https://img.shields.io/github/issues/italia/bootstrap-italia.svg)](https://github.com/italia/bootstrap-italia/issues)
[![Join the #design channel](https://img.shields.io/badge/Slack%20channel-%23design-blue.svg)](https://developersitalia.slack.com/messages/C7VPAUVB3/)
[![Get invited](https://slack.developers.italia.it/badge.svg)](https://slack.developers.italia.it/)
[![Chat on Gitter](https://img.shields.io/gitter/room/italia/bootstrap-italia.svg)](https://gitter.im/bootstrap-Italia)

# Bootstrap Italia

*Read this in other languages: [Italiano](README.md).*

Bootstrap Italia is a [Bootstrap 4](https://getbootstrap.com/docs/) theme to create responsive web apps to make Italian public digital services consistent, accessible and simple to use.

Bootstrap Italia inherits components, mixins, grid system, and anything else from Bootstrap 4, customising them accordingly to the [Italian guidelines for designing public digital services](https://docs.italia.it/italia/designers-italia/design-linee-guida-docs/).

**[Check out the documentation »](https://italia.github.io/bootstrap-italia/)** (in italian)

or

**[Download the latest version of the library »](https://github.com/italia/bootstrap-italia/releases)**

## Indice

- [Getting started](#getting-started)
- [Issues and requests](#issues-and-requests)
- [How to contribute](#how-to-contribute)
- [Third-party licenses](#third-party-licenses)

## Getting started

To start playing with Bootstrap Italia, you can unzip the library and add the files to your project, as described [here](https://translate.google.it/translate?hl=it&sl=it&tl=en&u=https%3A%2F%2Fitalia.github.io%2Fbootstrap-italia%2Fdocs%2Fcome-iniziare%2Fintroduzione%2F) (automatic translation by Google Translate).

## Issues and requests

Found a bug or asking for help?

First of all, please ensure you're trying to tackle a problem with the Bootstrap Italia theme and not with the Bootstrap library itself (in that case you can refer directly to [Bootstrap repository](https://github.com/twbs/bootstrap)), then
you can [create an issue](https://github.com/italia/bootstrap-italia/issues).

## How to contribute

Would you like to help with Bootstrap Italia? **You are in the right place!**
 
If you have not already done so, start by spending a few minutes to deepen your knowledge on [design guidelines for Italian public digital services](https://docs.italia.it/italia/designers-italia/design-linee-guida-docs/) (in italian), and refer to the [instructions on how to contribute to Bootstrap Italia](https://github.com/italia/bootstrap-italia/blob/master/CONTRIBUTING.md) (in italian).

At this point, you'll need to configure the local environment to compile the source files and generate them
of the documentation. You can find all the information necessary for this purpose at the [page related to the compilation tools](https://translate.google.it/translate?hl=it&sl=it&tl=en&u=https%3A%2F%2Fitalia.github.io%2Fbootstrap-italia%2Fdocs%2Fcome-iniziare%2Fstrumenti-di-compilazione%2F) (automatic translation by Google Translate).

## Third-party licenses

### Components distributed by Bootstrap Italia

Software components distributed with Bootstrap Italia that have their own different license from CC0 are listed below.

- [jQuery](https://jquery.com/) © jQuery Foundation, MIT
- [Popper.js](https://popper.js.org/) © Federico Zivolo and contributors, MIT
- [Bootstrap 4](https://getbootstrap.com/) © Twitter, Inc., MIT
- [Bootstrap Select](https://developer.snapappointments.com/bootstrap-select/) © SnapAppointments, LLC, MIT
- [Owl Carousel 2](https://owlcarousel2.github.io/OwlCarousel2/) © Owl (David Deutsch), MIT
- [jQuery Easing](http://gsgd.co.uk/sandbox/jquery/easing/) © George McGinley Smith, BSD

### Main dependencies for the compilation and development phase

- [Jekyll](https://jekyllrb.com), © Tom Preston-Werner and Jekyll contributors, licenza MIT
- [HTML-proofer](https://github.com/gjtorikian/html-proofer), © Garen Torikian, licenza MIT
- [Browser Sync](https://www.browsersync.io/) Apache License Version 2.0
- [conventional-changelog](https://github.com/conventional-changelog/conventional-changelog/) © conventional-changelog team, ISC License
- [GulpJS](https://gulpjs.com/), © Blaine Bublitz, Eric Schoffstall and other contributors, licenza MIT
- [Babel](https://babeljs.io/), © Sebastian McKenzie, licenza MIT
- [Prettier](https://prettier.io/), © James Long and contributors, licenza MIT
- [node-sass](https://github.com/sass/node-sass/), © Andrew Nesbitt, licenza MIT
- [Octokit rest.js](https://octokit.github.io/rest.js/) © 2012 Cloud9 IDE, Inc. (Mike de Boer), 2017-2018 Octokit contributors, licenza MIT

Bootstrap Italia is **BSD 3-Clause** licensed:

[![License](https://img.shields.io/github/license/italia/bootstrap-italia.svg)](https://github.com/italia/bootstrap-italia/blob/master/LICENSE)

<a href="https://www.browserstack.com/
" target="_blank"><img src="https://p14.zdusercontent.com/attachment/1015988/Acl6uTyvwHnAmpEiRm9p8eh1R?token=eyJhbGciOiJkaXIiLCJlbmMiOiJBMTI4Q0JDLUhTMjU2In0..ewB9aVdbiHzfkiZdbgrc2Q.s1B7FuA_Wdegrj1PBZ0pVGgjWhzuJD8yTKRptv2BxFNe-KQSsaVtbkBer5X2rNq81mHZ_kEuAOigMPjgorAAzTUA5AmP_OX4JQJdQk96Vg3UggORRd4UDSdS-tF4o4evvo_8f3cciZcBBiFuqm-GXAclqWRusZxHITpEM7OHNvvMSDV35zbOO0zLwTnHKNQL715Ozitqrx_Q94yYO9NUM-h6jrN76MM5hLdM2umQXsrd0JH5EMp7tp8yDAAyNtoqZUiNFxCh0o1dUAFgZodntaLkGOv4Gzzj5kb7iBWS6JY.Ev5PtLdgCYcC4799H6-GEg" 
alt="BrowserStack logo" width="200" height="105" /></a>

We are using BrowserStack for interactive cross browser testing. They are sponsoring our open source project!
