(function(){'use strict';(function() {
    const env = {"NODE_ENV":"production"};
    try {
        if (process) {
            process.env = Object.assign({}, process.env);
            Object.assign(process.env, env);
            return;
        }
    } catch (e) {} // avoid ReferenceError: process is not defined
    globalThis.process = { env:env };
})();var top="top";var bottom="bottom";var right="right";var left="left";var auto="auto";var basePlacements=[top,bottom,right,left];var start="start";var end="end";var clippingParents="clippingParents";var viewport="viewport";var popper="popper";var reference="reference";var variationPlacements=basePlacements.reduce((function(e,r){return e.concat([r+"-"+start,r+"-"+end])}),[]);var placements=[].concat(basePlacements,[auto]).reduce((function(e,r){return e.concat([r,r+"-"+start,r+"-"+end])}),[]);var beforeRead="beforeRead";var read="read";var afterRead="afterRead";var beforeMain="beforeMain";var main$1="main";var afterMain="afterMain";var beforeWrite="beforeWrite";var write="write";var afterWrite="afterWrite";var modifierPhases=[beforeRead,read,afterRead,beforeMain,main$1,afterMain,beforeWrite,write,afterWrite];function getNodeName(e){return e?(e.nodeName||"").toLowerCase():null}function getWindow(n){if(null==n)return window;if("[object Window]"!==n.toString()){var e=n.ownerDocument;return e&&e.defaultView||window}return n}function isElement$2(n){return n instanceof getWindow(n).Element||n instanceof Element}function isHTMLElement$1(n){return n instanceof getWindow(n).HTMLElement||n instanceof HTMLElement}function isShadowRoot(n){return "undefined"!=typeof ShadowRoot&&(n instanceof getWindow(n).ShadowRoot||n instanceof ShadowRoot)}function applyStyles(e){var t=e.state;Object.keys(t.elements).forEach((function(e){var s=t.styles[e]||{},r=t.attributes[e]||{},n=t.elements[e];isHTMLElement$1(n)&&getNodeName(n)&&(Object.assign(n.style,s),Object.keys(r).forEach((function(e){var t=r[e];!1===t?n.removeAttribute(e):n.setAttribute(e,!0===t?"":t);})));}));}function effect$2(e){var t=e.state,s={popper:{position:t.options.strategy,left:"0",top:"0",margin:"0"},arrow:{position:"absolute"},reference:{}};return Object.assign(t.elements.popper.style,s.popper),t.styles=s,t.elements.arrow&&Object.assign(t.elements.arrow.style,s.arrow),function(){Object.keys(t.elements).forEach((function(e){var r=t.elements[e],n=t.attributes[e]||{},o=Object.keys(t.styles.hasOwnProperty(e)?t.styles[e]:s[e]).reduce((function(e,t){return e[t]="",e}),{});isHTMLElement$1(r)&&getNodeName(r)&&(Object.assign(r.style,o),Object.keys(n).forEach((function(e){r.removeAttribute(e);})));}));}}var applyStyles$1 = {name:"applyStyles",enabled:!0,phase:"write",fn:applyStyles,effect:effect$2,requires:["computeStyles"]};function getBasePlacement(e){return e.split("-")[0]}var max$1=Math.max;var min$1=Math.min;var round=Math.round;function getBoundingClientRect(t,e){void 0===e&&(e=!1);var i=t.getBoundingClientRect(),o=1,n=1;if(isHTMLElement$1(t)&&e){var r=t.offsetHeight,h=t.offsetWidth;h>0&&(o=round(i.width)/h||1),r>0&&(n=round(i.height)/r||1);}return {width:i.width/o,height:i.height/n,top:i.top/n,right:i.right/o,bottom:i.bottom/n,left:i.left/o,x:i.left/o,y:i.top/n}}function getLayoutRect(t){var e=getBoundingClientRect(t),i=t.offsetWidth,o=t.offsetHeight;return Math.abs(e.width-i)<=1&&(i=e.width),Math.abs(e.height-o)<=1&&(o=e.height),{x:t.offsetLeft,y:t.offsetTop,width:i,height:o}}function contains(o,t){var e=t.getRootNode&&t.getRootNode();if(o.contains(t))return !0;if(e&&isShadowRoot(e)){var i=t;do{if(i&&o.isSameNode(i))return !0;i=i.parentNode||i.host;}while(i)}return !1}function getComputedStyle$1(t){return getWindow(t).getComputedStyle(t)}function isTableElement(e){return ["table","td","th"].indexOf(getNodeName(e))>=0}function getDocumentElement(e){return ((isElement$2(e)?e.ownerDocument:e.document)||window.document).documentElement}function getParentNode(e){return "html"===getNodeName(e)?e:e.assignedSlot||e.parentNode||(isShadowRoot(e)?e.host:null)||getDocumentElement(e)}function getTrueOffsetParent(e){return isHTMLElement$1(e)&&"fixed"!==getComputedStyle$1(e).position?e.offsetParent:null}function getContainingBlock(e){var t=-1!==navigator.userAgent.toLowerCase().indexOf("firefox");if(-1!==navigator.userAgent.indexOf("Trident")&&isHTMLElement$1(e)&&"fixed"===getComputedStyle$1(e).position)return null;var o=getParentNode(e);for(isShadowRoot(o)&&(o=o.host);isHTMLElement$1(o)&&["html","body"].indexOf(getNodeName(o))<0;){var n=getComputedStyle$1(o);if("none"!==n.transform||"none"!==n.perspective||"paint"===n.contain||-1!==["transform","perspective"].indexOf(n.willChange)||t&&"filter"===n.willChange||t&&n.filter&&"none"!==n.filter)return o;o=o.parentNode;}return null}function getOffsetParent(e){for(var t=getWindow(e),o=getTrueOffsetParent(e);o&&isTableElement(o)&&"static"===getComputedStyle$1(o).position;)o=getTrueOffsetParent(o);return o&&("html"===getNodeName(o)||"body"===getNodeName(o)&&"static"===getComputedStyle$1(o).position)?t:o||getContainingBlock(e)||t}function getMainAxisFromPlacement(t){return ["top","bottom"].indexOf(t)>=0?"x":"y"}function within(t,i,n){return max$1(t,min$1(i,n))}function withinMaxClamp(t,i,n){var a=within(t,i,n);return a>n?n:a}function getFreshSideObject(){return {top:0,right:0,bottom:0,left:0}}function mergePaddingObject(e){return Object.assign({},getFreshSideObject(),e)}function expandToHashMap(e,n){return n.reduce((function(n,r){return n[r]=e,n}),{})}var toPaddingObject=function(e,t){return e="function"==typeof e?e(Object.assign({},t.rects,{placement:t.placement})):e,mergePaddingObject("number"!=typeof e?e:expandToHashMap(e,basePlacements))};function arrow(e){var t,r=e.state,o=e.name,n=e.options,i=r.elements.arrow,s=r.modifiersData.popperOffsets,a=getBasePlacement(r.placement),m=getMainAxisFromPlacement(a),p=[left,right].indexOf(a)>=0?"height":"width";if(i&&s){var c=toPaddingObject(n.padding,r),f=getLayoutRect(i),l="y"===m?top:left,d="y"===m?bottom:right,u=r.rects.reference[p]+r.rects.reference[m]-s[m]-r.rects.popper[p],g=s[m]-r.rects.reference[m],h=getOffsetParent(i),j=h?"y"===m?h.clientHeight||0:h.clientWidth||0:0,P=u/2-g/2,w=c[l],O=j-f[p]-c[d],b=j/2-f[p]/2+P,v=within(w,b,O),y=m;r.modifiersData[o]=((t={})[y]=v,t.centerOffset=v-b,t);}}function effect$1(e){var t=e.state,r=e.options.element,o=void 0===r?"[data-popper-arrow]":r;null!=o&&("string"!=typeof o||(o=t.elements.popper.querySelector(o)))&&("production"!==process.env.NODE_ENV&&(isHTMLElement$1(o)||console.error(['Popper: "arrow" element must be an HTMLElement (not an SVGElement).',"To use an SVG arrow, wrap it in an HTMLElement that will be used as","the arrow."].join(" "))),contains(t.elements.popper,o)?t.elements.arrow=o:"production"!==process.env.NODE_ENV&&console.error(['Popper: "arrow" modifier\'s `element` must be a child of the popper',"element."].join(" ")));}var arrow$1 = {name:"arrow",enabled:!0,phase:"main",fn:arrow,effect:effect$1,requires:["popperOffsets"],requiresIfExists:["preventOverflow"]};function getVariation(t){return t.split("-")[1]}var unsetSides={top:"auto",right:"auto",bottom:"auto",left:"auto"};function roundOffsetsByDPR(t){var e=t.x,o=t.y,i=window.devicePixelRatio||1;return {x:round(e*i)/i||0,y:round(o*i)/i||0}}function mapToStyles(t){var e,o=t.popper,i=t.popperRect,r=t.placement,s=t.variation,n=t.offsets,a=t.position,p=t.gpuAcceleration,l=t.adaptive,m=t.roundOffsets,f=t.isFixed,d=n.x,u=void 0===d?0:d,c=n.y,g=void 0===c?0:c,y="function"==typeof m?m({x:u,y:g}):{x:u,y:g};u=y.x,g=y.y;var v=n.hasOwnProperty("x"),h=n.hasOwnProperty("y"),x=left,w=top,O=window;if(l){var b=getOffsetParent(o),S="clientHeight",j="clientWidth";if(b===getWindow(o)&&(b=getDocumentElement(o),"static"!==getComputedStyle$1(b).position&&"absolute"===a&&(S="scrollHeight",j="scrollWidth")),r===top||(r===left||r===right)&&s===end)w=bottom,g-=(f&&b===O&&O.visualViewport?O.visualViewport.height:b[S])-i.height,g*=p?1:-1;if(r===left||(r===top||r===bottom)&&s===end)x=right,u-=(f&&b===O&&O.visualViewport?O.visualViewport.width:b[j])-i.width,u*=p?1:-1;}var P,D=Object.assign({position:a},l&&unsetSides),C=!0===m?roundOffsetsByDPR({x:u,y:g}):{x:u,y:g};return u=C.x,g=C.y,p?Object.assign({},D,((P={})[w]=h?"0":"",P[x]=v?"0":"",P.transform=(O.devicePixelRatio||1)<=1?"translate("+u+"px, "+g+"px)":"translate3d("+u+"px, "+g+"px, 0)",P)):Object.assign({},D,((e={})[w]=h?g+"px":"",e[x]=v?u+"px":"",e.transform="",e))}function computeStyles(t){var e=t.state,o=t.options,i=o.gpuAcceleration,r=void 0===i||i,s=o.adaptive,n=void 0===s||s,a=o.roundOffsets,p=void 0===a||a;if("production"!==process.env.NODE_ENV){var l=getComputedStyle$1(e.elements.popper).transitionProperty||"";n&&["transform","top","right","bottom","left"].some((function(t){return l.indexOf(t)>=0}))&&console.warn(["Popper: Detected CSS transitions on at least one of the following",'CSS properties: "transform", "top", "right", "bottom", "left".',"\n\n",'Disable the "computeStyles" modifier\'s `adaptive` option to allow',"for smooth transitions, or remove these properties from the CSS","transition declaration on the popper element if only transitioning","opacity or background-color for example.","\n\n","We recommend using the popper element as a wrapper around an inner","element that can have any CSS property transitioned for animations."].join(" "));}var m={placement:getBasePlacement(e.placement),variation:getVariation(e.placement),popper:e.elements.popper,popperRect:e.rects.popper,gpuAcceleration:r,isFixed:"fixed"===e.options.strategy};null!=e.modifiersData.popperOffsets&&(e.styles.popper=Object.assign({},e.styles.popper,mapToStyles(Object.assign({},m,{offsets:e.modifiersData.popperOffsets,position:e.options.strategy,adaptive:n,roundOffsets:p})))),null!=e.modifiersData.arrow&&(e.styles.arrow=Object.assign({},e.styles.arrow,mapToStyles(Object.assign({},m,{offsets:e.modifiersData.arrow,position:"absolute",adaptive:!1,roundOffsets:p})))),e.attributes.popper=Object.assign({},e.attributes.popper,{"data-popper-placement":e.placement});}var computeStyles$1 = {name:"computeStyles",enabled:!0,phase:"beforeWrite",fn:computeStyles,data:{}};var passive={passive:!0};function effect(e){var t=e.state,n=e.instance,s=e.options,r=s.scroll,i=void 0===r||r,o=s.resize,a=void 0===o||o,p=getWindow(t.elements.popper),c=[].concat(t.scrollParents.reference,t.scrollParents.popper);return i&&c.forEach((function(e){e.addEventListener("scroll",n.update,passive);})),a&&p.addEventListener("resize",n.update,passive),function(){i&&c.forEach((function(e){e.removeEventListener("scroll",n.update,passive);})),a&&p.removeEventListener("resize",n.update,passive);}}var eventListeners = {name:"eventListeners",enabled:!0,phase:"write",fn:function(){},effect:effect,data:{}};var hash$1={left:"right",right:"left",bottom:"top",top:"bottom"};function getOppositePlacement(t){return t.replace(/left|right|bottom|top/g,(function(t){return hash$1[t]}))}var hash={start:"end",end:"start"};function getOppositeVariationPlacement(t){return t.replace(/start|end/g,(function(t){return hash[t]}))}function getWindowScroll(e){var o=getWindow(e);return {scrollLeft:o.pageXOffset,scrollTop:o.pageYOffset}}function getWindowScrollBarX(e){return getBoundingClientRect(getDocumentElement(e)).left+getWindowScroll(e).scrollLeft}function getViewportRect(t){var e=getWindow(t),o=getDocumentElement(t),i=e.visualViewport,r=o.clientWidth,n=o.clientHeight,g=0,l=0;return i&&(r=i.width,n=i.height,/^((?!chrome|android).)*safari/i.test(navigator.userAgent)||(g=i.offsetLeft,l=i.offsetTop)),{width:r,height:n,x:g+getWindowScrollBarX(t),y:l}}function getDocumentRect(t){var e,o=getDocumentElement(t),l=getWindowScroll(t),i=null==(e=t.ownerDocument)?void 0:e.body,r=max$1(o.scrollWidth,o.clientWidth,i?i.scrollWidth:0,i?i.clientWidth:0),n=max$1(o.scrollHeight,o.clientHeight,i?i.scrollHeight:0,i?i.clientHeight:0),c=-l.scrollLeft+getWindowScrollBarX(t),m=-l.scrollTop;return "rtl"===getComputedStyle$1(i||o).direction&&(c+=max$1(o.clientWidth,i?i.clientWidth:0)-r),{width:r,height:n,x:c,y:m}}function isScrollParent(e){var o=getComputedStyle$1(e),t=o.overflow,r=o.overflowX,l=o.overflowY;return /auto|scroll|overlay|hidden/.test(t+l+r)}function getScrollParent(e){return ["html","body","#document"].indexOf(getNodeName(e))>=0?e.ownerDocument.body:isHTMLElement$1(e)&&isScrollParent(e)?e:getScrollParent(getParentNode(e))}function listScrollParents(r,t){var o;void 0===t&&(t=[]);var e=getScrollParent(r),n=e===(null==(o=r.ownerDocument)?void 0:o.body),l=getWindow(e),i=n?[l].concat(l.visualViewport||[],isScrollParent(e)?e:[]):e,a=t.concat(i);return n?a:a.concat(listScrollParents(getParentNode(i)))}function rectToClientRect(t){return Object.assign({},t,{left:t.x,top:t.y,right:t.x+t.width,bottom:t.y+t.height})}function getInnerBoundingClientRect(t){var e=getBoundingClientRect(t);return e.top=e.top+t.clientTop,e.left=e.left+t.clientLeft,e.bottom=e.top+t.clientHeight,e.right=e.left+t.clientWidth,e.width=t.clientWidth,e.height=t.clientHeight,e.x=e.left,e.y=e.top,e}function getClientRectFromMixedType(t,e){return e===viewport?rectToClientRect(getViewportRect(t)):isElement$2(e)?getInnerBoundingClientRect(e):rectToClientRect(getDocumentRect(getDocumentElement(t)))}function getClippingParents(t){var e=listScrollParents(getParentNode(t)),o=["absolute","fixed"].indexOf(getComputedStyle$1(t).position)>=0&&isHTMLElement$1(t)?getOffsetParent(t):t;return isElement$2(o)?e.filter((function(t){return isElement$2(t)&&contains(t,o)&&"body"!==getNodeName(t)})):[]}function getClippingRect(t,e,o){var n="clippingParents"===e?getClippingParents(t):[].concat(e),i=[].concat(n,[o]),r=i[0],m=i.reduce((function(e,o){var n=getClientRectFromMixedType(t,o);return e.top=max$1(n.top,e.top),e.right=min$1(n.right,e.right),e.bottom=min$1(n.bottom,e.bottom),e.left=max$1(n.left,e.left),e}),getClientRectFromMixedType(t,r));return m.width=m.right-m.left,m.height=m.bottom-m.top,m.x=m.left,m.y=m.top,m}function computeOffsets(e){var t,a=e.reference,i=e.element,r=e.placement,n=r?getBasePlacement(r):null,o=r?getVariation(r):null,s=a.x+a.width/2-i.width/2,m=a.y+a.height/2-i.height/2;switch(n){case top:t={x:s,y:a.y-i.height};break;case bottom:t={x:s,y:a.y+a.height};break;case right:t={x:a.x+a.width,y:m};break;case left:t={x:a.x-i.width,y:m};break;default:t={x:a.x,y:a.y};}var l=n?getMainAxisFromPlacement(n):null;if(null!=l){var c="y"===l?"height":"width";switch(o){case start:t[l]=t[l]-(a[c]/2-i[c]/2);break;case end:t[l]=t[l]+(a[c]/2-i[c]/2);}}return t}function detectOverflow(e,t){void 0===t&&(t={});var o=t,p=o.placement,n=void 0===p?e.placement:p,r=o.boundary,i=void 0===r?clippingParents:r,m=o.rootBoundary,s=void 0===m?viewport:m,c=o.elementContext,l=void 0===c?popper:c,a=o.altBoundary,f=void 0!==a&&a,d=o.padding,g=void 0===d?0:d,u=mergePaddingObject("number"!=typeof g?g:expandToHashMap(g,basePlacements)),b=l===popper?reference:popper,j=e.rects.popper,v=e.elements[f?b:l],O=getClippingRect(isElement$2(v)?v:v.contextElement||getDocumentElement(e.elements.popper),i,s),h=getBoundingClientRect(e.elements.reference),C=computeOffsets({reference:h,element:j,strategy:"absolute",placement:n}),x=rectToClientRect(Object.assign({},j,C)),R=l===popper?x:h,y={top:O.top-R.top+u.top,bottom:R.bottom-O.bottom+u.bottom,left:O.left-R.left+u.left,right:R.right-O.right+u.right},E=e.modifiersData.offset;if(l===popper&&E){var P=E[n];Object.keys(y).forEach((function(e){var t=[right,bottom].indexOf(e)>=0?1:-1,o=[top,bottom].indexOf(e)>=0?"y":"x";y[e]+=P[o]*t;}));}return y}function computeAutoPlacement(e,t){void 0===t&&(t={});var o=t,a=o.placement,n=o.boundary,r=o.rootBoundary,l=o.padding,i=o.flipVariations,s=o.allowedAutoPlacements,c=void 0===s?placements:s,m=getVariation(a),u=m?i?variationPlacements:variationPlacements.filter((function(e){return getVariation(e)===m})):basePlacements,p=u.filter((function(e){return c.indexOf(e)>=0}));0===p.length&&(p=u,"production"!==process.env.NODE_ENV&&console.error(["Popper: The `allowedAutoPlacements` option did not allow any","placements. Ensure the `placement` option matches the variation","of the allowed placements.",'For example, "auto" cannot be used to allow "bottom-start".','Use "auto-start" instead.'].join(" ")));var d=p.reduce((function(t,o){return t[o]=detectOverflow(e,{placement:o,boundary:n,rootBoundary:r,padding:l})[getBasePlacement(o)],t}),{});return Object.keys(d).sort((function(e,t){return d[e]-d[t]}))}function getExpandedFallbackPlacements(e){if(getBasePlacement(e)===auto)return [];var t=getOppositePlacement(e);return [getOppositeVariationPlacement(e),t,getOppositeVariationPlacement(t)]}function flip(e){var t=e.state,a=e.options,o=e.name;if(!t.modifiersData[o]._skip){for(var i=a.mainAxis,n=void 0===i||i,r=a.altAxis,l=void 0===r||r,p=a.fallbackPlacements,s=a.padding,m=a.boundary,c=a.rootBoundary,u=a.altBoundary,f=a.flipVariations,d=void 0===f||f,g=a.allowedAutoPlacements,P=t.options.placement,v=getBasePlacement(P),b=p||(v===P||!d?[getOppositePlacement(P)]:getExpandedFallbackPlacements(P)),O=[P].concat(b).reduce((function(e,a){return e.concat(getBasePlacement(a)===auto?computeAutoPlacement(t,{placement:a,boundary:m,rootBoundary:c,padding:s,flipVariations:d,allowedAutoPlacements:g}):a)}),[]),B=t.rects.reference,k=t.rects.popper,y=new Map,h=!0,V=O[0],j=0;j<O.length;j++){var w=O[j],x=getBasePlacement(w),A=getVariation(w)===start,E=[top,bottom].indexOf(x)>=0,_=E?"width":"height",D=detectOverflow(t,{placement:w,boundary:m,rootBoundary:c,altBoundary:u,padding:s}),F=E?A?right:left:A?bottom:top;B[_]>k[_]&&(F=getOppositePlacement(F));var q=getOppositePlacement(F),I=[];if(n&&I.push(D[x]<=0),l&&I.push(D[F]<=0,D[q]<=0),I.every((function(e){return e}))){V=w,h=!1;break}y.set(w,I);}if(h)for(var M=function(e){var t=O.find((function(t){var a=y.get(t);if(a)return a.slice(0,e).every((function(e){return e}))}));if(t)return V=t,"break"},z=d?3:1;z>0;z--){if("break"===M(z))break}t.placement!==V&&(t.modifiersData[o]._skip=!0,t.placement=V,t.reset=!0);}}var flip$1 = {name:"flip",enabled:!0,phase:"main",fn:flip,requiresIfExists:["offset"],data:{_skip:!1}};function getSideOffsets(e,t,r){return void 0===r&&(r={x:0,y:0}),{top:e.top-t.height-r.y,right:e.right-t.width+r.x,bottom:e.bottom-t.height+r.y,left:e.left-t.width-r.x}}function isAnySideFullyClipped(e){return [top,right,bottom,left].some((function(t){return e[t]>=0}))}function hide(e){var t=e.state,r=e.name,i=t.rects.reference,p=t.rects.popper,o=t.modifiersData.preventOverflow,s=detectOverflow(t,{elementContext:"reference"}),n=detectOverflow(t,{altBoundary:!0}),f=getSideOffsets(s,i),d=getSideOffsets(n,p,o),l=isAnySideFullyClipped(f),a=isAnySideFullyClipped(d);t.modifiersData[r]={referenceClippingOffsets:f,popperEscapeOffsets:d,isReferenceHidden:l,hasPopperEscaped:a},t.attributes.popper=Object.assign({},t.attributes.popper,{"data-popper-reference-hidden":l,"data-popper-escaped":a});}var hide$1 = {name:"hide",enabled:!0,phase:"main",requiresIfExists:["preventOverflow"],fn:hide};function distanceAndSkiddingToXY(e,t,n){var s=getBasePlacement(e),f=[left,top].indexOf(s)>=0?-1:1,i="function"==typeof n?n(Object.assign({},t,{placement:e})):n,o=i[0],a=i[1];return o=o||0,a=(a||0)*f,[left,right].indexOf(s)>=0?{x:a,y:o}:{x:o,y:a}}function offset(e){var t=e.state,n=e.options,s=e.name,f=n.offset,i=void 0===f?[0,0]:f,o=placements.reduce((function(e,n){return e[n]=distanceAndSkiddingToXY(n,t.rects,i),e}),{}),a=o[t.placement],p=a.x,r=a.y;null!=t.modifiersData.popperOffsets&&(t.modifiersData.popperOffsets.x+=p,t.modifiersData.popperOffsets.y+=r),t.modifiersData[s]=o;}var offset$1 = {name:"offset",enabled:!0,phase:"main",requires:["popperOffsets"],fn:offset};function popperOffsets(e){var t=e.state,p=e.name;t.modifiersData[p]=computeOffsets({reference:t.rects.reference,element:t.rects.popper,strategy:"absolute",placement:t.placement});}var popperOffsets$1 = {name:"popperOffsets",enabled:!0,phase:"read",fn:popperOffsets,data:{}};function getAltAxis(t){return "x"===t?"y":"x"}function preventOverflow(t){var e=t.state,i=t.options,a=t.name,r=i.mainAxis,o=void 0===r||r,s=i.altAxis,n=void 0!==s&&s,m=i.boundary,l=i.rootBoundary,f=i.altBoundary,p=i.padding,d=i.tether,g=void 0===d||d,c=i.tetherOffset,u=void 0===c?0:c,h=detectOverflow(e,{boundary:m,rootBoundary:l,padding:p,altBoundary:f}),x=getBasePlacement(e.placement),w=getVariation(e.placement),A=!w,v=getMainAxisFromPlacement(x),j=getAltAxis(v),y=e.modifiersData.popperOffsets,O=e.rects.reference,b=e.rects.popper,M="function"==typeof u?u(Object.assign({},e.rects,{placement:e.placement})):u,P="number"==typeof M?{mainAxis:M,altAxis:M}:Object.assign({mainAxis:0,altAxis:0},M),B=e.modifiersData.offset?e.modifiersData.offset[e.placement]:null,D={x:0,y:0};if(y){if(o){var F,L="y"===v?top:left,R="y"===v?bottom:right,S="y"===v?"height":"width",V=y[v],C=V+h[L],q=V-h[R],E=g?-b[S]/2:0,I=w===start?O[S]:b[S],T=w===start?-b[S]:-O[S],k=e.elements.arrow,z=g&&k?getLayoutRect(k):{width:0,height:0},G=e.modifiersData["arrow#persistent"]?e.modifiersData["arrow#persistent"].padding:getFreshSideObject(),H=G[L],J=G[R],K=within(0,O[S],z[S]),N=A?O[S]/2-E-K-H-P.mainAxis:I-K-H-P.mainAxis,Q=A?-O[S]/2+E+K+J+P.mainAxis:T+K+J+P.mainAxis,U=e.elements.arrow&&getOffsetParent(e.elements.arrow),W=U?"y"===v?U.clientTop||0:U.clientLeft||0:0,X=null!=(F=null==B?void 0:B[v])?F:0,Y=V+Q-X,Z=within(g?min$1(C,V+N-X-W):C,V,g?max$1(q,Y):q);y[v]=Z,D[v]=Z-V;}if(n){var $,_="x"===v?top:left,tt="x"===v?bottom:right,et=y[j],it="y"===j?"height":"width",at=et+h[_],rt=et-h[tt],ot=-1!==[top,left].indexOf(x),st=null!=($=null==B?void 0:B[j])?$:0,nt=ot?at:et-O[it]-b[it]-st+P.altAxis,mt=ot?et+O[it]+b[it]-st-P.altAxis:rt,lt=g&&ot?withinMaxClamp(nt,et,mt):within(g?nt:at,et,g?mt:rt);y[j]=lt,D[j]=lt-et;}e.modifiersData[a]=D;}}var preventOverflow$1 = {name:"preventOverflow",enabled:!0,phase:"main",fn:preventOverflow,requiresIfExists:["offset"]};function getHTMLElementScroll(l){return {scrollLeft:l.scrollLeft,scrollTop:l.scrollTop}}function getNodeScroll(e){return e!==getWindow(e)&&isHTMLElement$1(e)?getHTMLElementScroll(e):getWindowScroll(e)}function isElementScaled(e){var t=e.getBoundingClientRect(),o=round(t.width)/e.offsetWidth||1,l=round(t.height)/e.offsetHeight||1;return 1!==o||1!==l}function getCompositeRect(e,t,o){void 0===o&&(o=!1);var l=isHTMLElement$1(t),i=isHTMLElement$1(t)&&isElementScaled(t),n=getDocumentElement(t),r=getBoundingClientRect(e,i),m={scrollLeft:0,scrollTop:0},c={x:0,y:0};return (l||!l&&!o)&&(("body"!==getNodeName(t)||isScrollParent(n))&&(m=getNodeScroll(t)),isHTMLElement$1(t)?((c=getBoundingClientRect(t,!0)).x+=t.clientLeft,c.y+=t.clientTop):n&&(c.x=getWindowScrollBarX(n))),{x:r.left+m.scrollLeft-c.x,y:r.top+m.scrollTop-c.y,width:r.width,height:r.height}}function order(r){var e=new Map,n=new Set,o=[];function t(r){n.add(r.name),[].concat(r.requires||[],r.requiresIfExists||[]).forEach((function(r){if(!n.has(r)){var o=e.get(r);o&&t(o);}})),o.push(r);}return r.forEach((function(r){e.set(r.name,r);})),r.forEach((function(r){n.has(r.name)||t(r);})),o}function orderModifiers(r){var e=order(r);return modifierPhases.reduce((function(r,n){return r.concat(e.filter((function(r){return r.phase===n})))}),[])}function debounce(n){var e;return function(){return e||(e=new Promise((function(o){Promise.resolve().then((function(){e=void 0,o(n());}));}))),e}}function format$1(r){for(var e=arguments.length,n=new Array(e>1?e-1:0),t=1;t<e;t++)n[t-1]=arguments[t];return [].concat(n).reduce((function(r,e){return r.replace(/%s/,e)}),r)}var INVALID_MODIFIER_ERROR='Popper: modifier "%s" provided an invalid %s property, expected %s but got %s',MISSING_DEPENDENCY_ERROR='Popper: modifier "%s" requires "%s", but "%s" modifier is not available',VALID_PROPERTIES=["name","enabled","phase","fn","effect","requires","options"];function validateModifiers(e){e.forEach((function(r){[].concat(Object.keys(r),VALID_PROPERTIES).filter((function(e,r,n){return n.indexOf(e)===r})).forEach((function(n){switch(n){case"name":"string"!=typeof r.name&&console.error(format$1(INVALID_MODIFIER_ERROR,String(r.name),'"name"','"string"','"'+String(r.name)+'"'));break;case"enabled":"boolean"!=typeof r.enabled&&console.error(format$1(INVALID_MODIFIER_ERROR,r.name,'"enabled"','"boolean"','"'+String(r.enabled)+'"'));break;case"phase":modifierPhases.indexOf(r.phase)<0&&console.error(format$1(INVALID_MODIFIER_ERROR,r.name,'"phase"',"either "+modifierPhases.join(", "),'"'+String(r.phase)+'"'));break;case"fn":"function"!=typeof r.fn&&console.error(format$1(INVALID_MODIFIER_ERROR,r.name,'"fn"','"function"','"'+String(r.fn)+'"'));break;case"effect":null!=r.effect&&"function"!=typeof r.effect&&console.error(format$1(INVALID_MODIFIER_ERROR,r.name,'"effect"','"function"','"'+String(r.fn)+'"'));break;case"requires":null==r.requires||Array.isArray(r.requires)||console.error(format$1(INVALID_MODIFIER_ERROR,r.name,'"requires"','"array"','"'+String(r.requires)+'"'));break;case"requiresIfExists":Array.isArray(r.requiresIfExists)||console.error(format$1(INVALID_MODIFIER_ERROR,r.name,'"requiresIfExists"','"array"','"'+String(r.requiresIfExists)+'"'));break;case"options":case"data":break;default:console.error('PopperJS: an invalid property has been provided to the "'+r.name+'" modifier, valid properties are '+VALID_PROPERTIES.map((function(e){return '"'+e+'"'})).join(", ")+'; but "'+n+'" was provided.');}r.requires&&r.requires.forEach((function(n){null==e.find((function(e){return e.name===n}))&&console.error(format$1(MISSING_DEPENDENCY_ERROR,String(r.name),n,n));}));}));}));}function uniqueBy(e,n){var r=new Set;return e.filter((function(e){var t=n(e);if(!r.has(t))return r.add(t),!0}))}function mergeByName(e){var n=e.reduce((function(e,n){var t=e[n.name];return e[n.name]=t?Object.assign({},t,n,{options:Object.assign({},t.options,n.options),data:Object.assign({},t.data,n.data)}):n,e}),{});return Object.keys(n).map((function(e){return n[e]}))}var INVALID_ELEMENT_ERROR="Popper: Invalid reference or popper argument provided. They must be either a DOM element or virtual element.",INFINITE_LOOP_ERROR="Popper: An infinite loop in the modifiers cycle has been detected! The cycle has been interrupted to prevent a browser crash.",DEFAULT_OPTIONS={placement:"bottom",modifiers:[],strategy:"absolute"};function areValidElements(){for(var e=arguments.length,t=new Array(e),o=0;o<e;o++)t[o]=arguments[o];return !t.some((function(e){return !(e&&"function"==typeof e.getBoundingClientRect)}))}function popperGenerator(e){void 0===e&&(e={});var t=e,o=t.defaultModifiers,r=void 0===o?[]:o,n=t.defaultOptions,i=void 0===n?DEFAULT_OPTIONS:n;return function(e,t,o){void 0===o&&(o=i);var n={placement:"bottom",orderedModifiers:[],options:Object.assign({},DEFAULT_OPTIONS,i),modifiersData:{},elements:{reference:e,popper:t},attributes:{},styles:{}},s=[],a=!1,p={state:n,setOptions:function(o){var a="function"==typeof o?o(n.options):o;f(),n.options=Object.assign({},i,n.options,a),n.scrollParents={reference:isElement$2(e)?listScrollParents(e):e.contextElement?listScrollParents(e.contextElement):[],popper:listScrollParents(t)};var d=orderModifiers(mergeByName([].concat(r,n.options.modifiers)));if(n.orderedModifiers=d.filter((function(e){return e.enabled})),"production"!==process.env.NODE_ENV){var c=uniqueBy([].concat(d,n.options.modifiers),(function(e){return e.name}));if(validateModifiers(c),getBasePlacement(n.options.placement)===auto)n.orderedModifiers.find((function(e){return "flip"===e.name}))||console.error(['Popper: "auto" placements require the "flip" modifier be',"present and enabled to work."].join(" "));var m=getComputedStyle$1(t);[m.marginTop,m.marginRight,m.marginBottom,m.marginLeft].some((function(e){return parseFloat(e)}))&&console.warn(['Popper: CSS "margin" styles cannot be used to apply padding',"between the popper and its reference element or boundary.","To replicate margin, use the `offset` modifier, as well as","the `padding` option in the `preventOverflow` and `flip`","modifiers."].join(" "));}return n.orderedModifiers.forEach((function(e){var t=e.name,o=e.options,r=void 0===o?{}:o,i=e.effect;if("function"==typeof i){var a=i({state:n,name:t,instance:p,options:r}),f=function(){};s.push(a||f);}})),p.update()},forceUpdate:function(){if(!a){var e=n.elements,t=e.reference,o=e.popper;if(areValidElements(t,o)){n.rects={reference:getCompositeRect(t,getOffsetParent(o),"fixed"===n.options.strategy),popper:getLayoutRect(o)},n.reset=!1,n.placement=n.options.placement,n.orderedModifiers.forEach((function(e){return n.modifiersData[e.name]=Object.assign({},e.data)}));for(var r=0,i=0;i<n.orderedModifiers.length;i++){if("production"!==process.env.NODE_ENV&&(r+=1)>100){console.error(INFINITE_LOOP_ERROR);break}if(!0!==n.reset){var s=n.orderedModifiers[i],f=s.fn,d=s.options,c=void 0===d?{}:d,m=s.name;"function"==typeof f&&(n=f({state:n,options:c,name:m,instance:p})||n);}else n.reset=!1,i=-1;}}else "production"!==process.env.NODE_ENV&&console.error(INVALID_ELEMENT_ERROR);}},update:debounce((function(){return new Promise((function(e){p.forceUpdate(),e(n);}))})),destroy:function(){f(),a=!0;}};if(!areValidElements(e,t))return "production"!==process.env.NODE_ENV&&console.error(INVALID_ELEMENT_ERROR),p;function f(){s.forEach((function(e){return e()})),s=[];}return p.setOptions(o).then((function(e){!a&&o.onFirstUpdate&&o.onFirstUpdate(e);})),p}}var createPopper$2=popperGenerator();var defaultModifiers$1=[eventListeners,popperOffsets$1,computeStyles$1,applyStyles$1],createPopper$1=popperGenerator({defaultModifiers:defaultModifiers$1});var defaultModifiers=[eventListeners,popperOffsets$1,computeStyles$1,applyStyles$1,offset$1,flip$1,preventOverflow$1,arrow$1,hide$1],createPopper=popperGenerator({defaultModifiers:defaultModifiers});var Popper=/*#__PURE__*/Object.freeze({__proto__:null,popperGenerator:popperGenerator,detectOverflow:detectOverflow,createPopperBase:createPopper$2,createPopper:createPopper,createPopperLite:createPopper$1,top:top,bottom:bottom,right:right,left:left,auto:auto,basePlacements:basePlacements,start:start,end:end,clippingParents:clippingParents,viewport:viewport,popper:popper,reference:reference,variationPlacements:variationPlacements,placements:placements,beforeRead:beforeRead,read:read,afterRead:afterRead,beforeMain:beforeMain,main:main$1,afterMain:afterMain,beforeWrite:beforeWrite,write:write,afterWrite:afterWrite,modifierPhases:modifierPhases,applyStyles:applyStyles$1,arrow:arrow$1,computeStyles:computeStyles$1,eventListeners:eventListeners,flip:flip$1,hide:hide$1,offset:offset$1,popperOffsets:popperOffsets$1,preventOverflow:preventOverflow$1});const TRANSITION_END$1="transitionend",getUID=e=>{do{e+=Math.floor(1e6*Math.random());}while(document.getElementById(e));return e},getSelector$1=e=>{let t=e.getAttribute("data-bs-target");if(!t||"#"===t){let i=e.getAttribute("href");if(!i||!i.includes("#")&&!i.startsWith("."))return null;i.includes("#")&&!i.startsWith("#")&&(i=`#${i.split("#")[1]}`),t=i&&"#"!==i?i.trim():null;}return t},getSelectorFromElement$1=e=>{const t=getSelector$1(e);return t&&document.querySelector(t)?t:null},getElementFromSelector$1=e=>{const t=getSelector$1(e);return t?document.querySelector(t):null},getTransitionDurationFromElement$1=e=>{if(!e)return 0;let{transitionDuration:t,transitionDelay:i}=window.getComputedStyle(e);const n=Number.parseFloat(t),s=Number.parseFloat(i);return n||s?(t=t.split(",")[0],i=i.split(",")[0],1e3*(Number.parseFloat(t)+Number.parseFloat(i))):0},triggerTransitionEnd$1=e=>{e.dispatchEvent(new Event(TRANSITION_END$1));},isElement$1=e=>!(!e||"object"!=typeof e)&&(void 0!==e.jquery&&(e=e[0]),void 0!==e.nodeType),getElement$1=e=>isElement$1(e)?e.jquery?e[0]:e:"string"==typeof e&&e.length>0?document.querySelector(e):null,typeCheckConfig$1=(e,t,i)=>{Object.keys(i).forEach((n=>{const s=i[n],o=t[n],r=o&&isElement$1(o)?"element":null==(a=o)?`${a}`:{}.toString.call(a).match(/\s([a-z]+)/i)[1].toLowerCase();var a;if(!new RegExp(s).test(r))throw new TypeError(`${e.toUpperCase()}: Option "${n}" provided type "${r}" but expected type "${s}".`)}));},isVisible$1=e=>!(!isElement$1(e)||0===e.getClientRects().length)&&"visible"===getComputedStyle(e).getPropertyValue("visibility"),isDisabled$1=e=>!e||e.nodeType!==Node.ELEMENT_NODE||(!!e.classList.contains("disabled")||(void 0!==e.disabled?e.disabled:e.hasAttribute("disabled")&&"false"!==e.getAttribute("disabled"))),findShadowRoot=e=>{if(!document.documentElement.attachShadow)return null;if("function"==typeof e.getRootNode){const t=e.getRootNode();return t instanceof ShadowRoot?t:null}return e instanceof ShadowRoot?e:e.parentNode?findShadowRoot(e.parentNode):null},noop$1=()=>{},reflow$1=e=>{e.offsetHeight;},getjQuery$1=()=>{const{jQuery:e}=window;return e&&!document.body.hasAttribute("data-bs-no-jquery")?e:null},DOMContentLoadedCallbacks=[],isRTL=()=>"rtl"===document.documentElement.dir,defineJQueryPlugin=e=>{var t;t=()=>{const t=getjQuery$1();if(t){const i=e.NAME,n=t.fn[i];t.fn[i]=e.jQueryInterface,t.fn[i].Constructor=e,t.fn[i].noConflict=()=>(t.fn[i]=n,e.jQueryInterface);}},"loading"===document.readyState?(DOMContentLoadedCallbacks.length||document.addEventListener("DOMContentLoaded",(()=>{DOMContentLoadedCallbacks.forEach((e=>e()));})),DOMContentLoadedCallbacks.push(t)):t();},execute$1=e=>{"function"==typeof e&&e();},executeAfterTransition$1=(e,t,i=!0)=>{if(!i)return void execute$1(e);const n=getTransitionDurationFromElement$1(t)+5;let s=!1;const o=({target:i})=>{i===t&&(s=!0,t.removeEventListener(TRANSITION_END$1,o),execute$1(e));};t.addEventListener(TRANSITION_END$1,o),setTimeout((()=>{s||triggerTransitionEnd$1(t);}),n);},getNextActiveElement=(e,t,i,n)=>{let s=e.indexOf(t);if(-1===s)return e[!i&&n?e.length-1:0];const o=e.length;return s+=i?1:-1,n&&(s=(s+o)%o),e[Math.max(0,Math.min(s,o-1))]},namespaceRegex$1=/[^.]*(?=\..*)\.|.*/,stripNameRegex$1=/\..*/,stripUidRegex$1=/::\d+$/,eventRegistry$1={};let uidEvent$1=1;const customEvents$1={mouseenter:"mouseover",mouseleave:"mouseout"},customEventsRegex$1=/^(mouseenter|mouseleave)/i,nativeEvents$1=new Set(["click","dblclick","mouseup","mousedown","contextmenu","mousewheel","DOMMouseScroll","mouseover","mouseout","mousemove","selectstart","selectend","keydown","keypress","keyup","orientationchange","touchstart","touchmove","touchend","touchcancel","pointerdown","pointermove","pointerup","pointerleave","pointercancel","gesturestart","gesturechange","gestureend","focus","blur","change","reset","select","submit","focusin","focusout","load","unload","beforeunload","resize","move","DOMContentLoaded","readystatechange","error","abort","scroll"]);function getUidEvent$1(e,t){return t&&`${t}::${uidEvent$1++}`||e.uidEvent||uidEvent$1++}function getEvent$1(e){const t=getUidEvent$1(e);return e.uidEvent=t,eventRegistry$1[t]=eventRegistry$1[t]||{},eventRegistry$1[t]}function bootstrapHandler$1(e,t){return function i(n){return n.delegateTarget=e,i.oneOff&&EventHandler$2.off(e,n.type,t),t.apply(e,[n])}}function bootstrapDelegationHandler$1(e,t,i){return function n(s){const o=e.querySelectorAll(t);for(let{target:r}=s;r&&r!==this;r=r.parentNode)for(let a=o.length;a--;)if(o[a]===r)return s.delegateTarget=r,n.oneOff&&EventHandler$2.off(e,s.type,t,i),i.apply(r,[s]);return null}}function findHandler$1(e,t,i=null){const n=Object.keys(e);for(let s=0,o=n.length;s<o;s++){const o=e[n[s]];if(o.originalHandler===t&&o.delegationSelector===i)return o}return null}function normalizeParams$1(e,t,i){const n="string"==typeof t,s=n?i:t;let o=getTypeEvent$1(e);return nativeEvents$1.has(o)||(o=e),[n,s,o]}function addHandler$1(e,t,i,n,s){if("string"!=typeof t||!e)return;if(i||(i=n,n=null),customEventsRegex$1.test(t)){const e=e=>function(t){if(!t.relatedTarget||t.relatedTarget!==t.delegateTarget&&!t.delegateTarget.contains(t.relatedTarget))return e.call(this,t)};n?n=e(n):i=e(i);}const[o,r,a]=normalizeParams$1(t,i,n),l=getEvent$1(e),c=l[a]||(l[a]={}),E=findHandler$1(c,r,o?i:null);if(E)return void(E.oneOff=E.oneOff&&s);const _=getUidEvent$1(r,t.replace(namespaceRegex$1,"")),h=o?bootstrapDelegationHandler$1(e,i,n):bootstrapHandler$1(e,i);h.delegationSelector=o?i:null,h.originalHandler=r,h.oneOff=s,h.uidEvent=_,c[_]=h,e.addEventListener(a,h,o);}function removeHandler$1(e,t,i,n,s){const o=findHandler$1(t[i],n,s);o&&(e.removeEventListener(i,o,Boolean(s)),delete t[i][o.uidEvent]);}function removeNamespacedHandlers$1(e,t,i,n){const s=t[i]||{};Object.keys(s).forEach((o=>{if(o.includes(n)){const n=s[o];removeHandler$1(e,t,i,n.originalHandler,n.delegationSelector);}}));}function getTypeEvent$1(e){return e=e.replace(stripNameRegex$1,""),customEvents$1[e]||e}const EventHandler$2={on(e,t,i,n){addHandler$1(e,t,i,n,!1);},one(e,t,i,n){addHandler$1(e,t,i,n,!0);},off(e,t,i,n){if("string"!=typeof t||!e)return;const[s,o,r]=normalizeParams$1(t,i,n),a=r!==t,l=getEvent$1(e),c=t.startsWith(".");if(void 0!==o){if(!l||!l[r])return;return void removeHandler$1(e,l,r,o,s?i:null)}c&&Object.keys(l).forEach((i=>{removeNamespacedHandlers$1(e,l,i,t.slice(1));}));const E=l[r]||{};Object.keys(E).forEach((i=>{const n=i.replace(stripUidRegex$1,"");if(!a||t.includes(n)){const t=E[i];removeHandler$1(e,l,r,t.originalHandler,t.delegationSelector);}}));},trigger(e,t,i){if("string"!=typeof t||!e)return null;const n=getjQuery$1(),s=getTypeEvent$1(t),o=t!==s,r=nativeEvents$1.has(s);let a,l=!0,c=!0,E=!1,_=null;return o&&n&&(a=n.Event(t,i),n(e).trigger(a),l=!a.isPropagationStopped(),c=!a.isImmediatePropagationStopped(),E=a.isDefaultPrevented()),r?(_=document.createEvent("HTMLEvents"),_.initEvent(s,l,!0)):_=new CustomEvent(t,{bubbles:l,cancelable:!0}),void 0!==i&&Object.keys(i).forEach((e=>{Object.defineProperty(_,e,{get:()=>i[e]});})),E&&_.preventDefault(),c&&e.dispatchEvent(_),_.defaultPrevented&&void 0!==a&&a.preventDefault(),_}},elementMap$1=new Map,Data$1={set(e,t,i){elementMap$1.has(e)||elementMap$1.set(e,new Map);const n=elementMap$1.get(e);n.has(t)||0===n.size?n.set(t,i):console.error(`Bootstrap doesn't allow more than one instance per element. Bound instance: ${Array.from(n.keys())[0]}.`);},get:(e,t)=>elementMap$1.has(e)&&elementMap$1.get(e).get(t)||null,remove(e,t){if(!elementMap$1.has(e))return;const i=elementMap$1.get(e);i.delete(t),0===i.size&&elementMap$1.delete(e);}};class BaseComponent$1{constructor(e){(e=getElement$1(e))&&(this._element=e,Data$1.set(this._element,this.constructor.DATA_KEY,this));}dispose(){Data$1.remove(this._element,this.constructor.DATA_KEY),EventHandler$2.off(this._element,this.constructor.EVENT_KEY),Object.getOwnPropertyNames(this).forEach((e=>{this[e]=null;}));}_queueCallback(e,t,i=!0){executeAfterTransition$1(e,t,i);}static getInstance(e){return Data$1.get(getElement$1(e),this.DATA_KEY)}static getOrCreateInstance(e,t={}){return this.getInstance(e)||new this(e,"object"==typeof t?t:null)}static get VERSION(){return "5.1.3"}static get NAME(){throw new Error('You have to implement the static method "NAME", for each component!')}static get DATA_KEY(){return `bs.${this.NAME}`}static get EVENT_KEY(){return `.${this.DATA_KEY}`}}const enableDismissTrigger$1=(e,t="hide")=>{const i=`click.dismiss${e.EVENT_KEY}`,n=e.NAME;EventHandler$2.on(document,i,`[data-bs-dismiss="${n}"]`,(function(i){if(["A","AREA"].includes(this.tagName)&&i.preventDefault(),isDisabled$1(this))return;const s=getElementFromSelector$1(this)||this.closest(`.${n}`);e.getOrCreateInstance(s)[t]();}));},NAME$d$1="alert",EVENT_CLOSE$1="close.bs.alert",EVENT_CLOSED$1="closed.bs.alert";class Alert extends BaseComponent$1{static get NAME(){return NAME$d$1}close(){if(EventHandler$2.trigger(this._element,EVENT_CLOSE$1).defaultPrevented)return;this._element.classList.remove("show");const e=this._element.classList.contains("fade");this._queueCallback((()=>this._destroyElement()),this._element,e);}_destroyElement(){this._element.remove(),EventHandler$2.trigger(this._element,EVENT_CLOSED$1),this.dispose();}static jQueryInterface(e){return this.each((function(){const t=Alert.getOrCreateInstance(this);if("string"==typeof e){if(void 0===t[e]||e.startsWith("_")||"constructor"===e)throw new TypeError(`No method named "${e}"`);t[e](this);}}))}}enableDismissTrigger$1(Alert,"close"),defineJQueryPlugin(Alert);const NAME$c$1="button",SELECTOR_DATA_TOGGLE$5='[data-bs-toggle="button"]',EVENT_CLICK_DATA_API$6$1="click.bs.button.data-api";class Button extends BaseComponent$1{static get NAME(){return NAME$c$1}toggle(){this._element.setAttribute("aria-pressed",this._element.classList.toggle("active"));}static jQueryInterface(e){return this.each((function(){const t=Button.getOrCreateInstance(this);"toggle"===e&&t[e]();}))}}function normalizeData$1(e){return "true"===e||"false"!==e&&(e===Number(e).toString()?Number(e):""===e||"null"===e?null:e)}function normalizeDataKey$1(e){return e.replace(/[A-Z]/g,(e=>`-${e.toLowerCase()}`))}EventHandler$2.on(document,EVENT_CLICK_DATA_API$6$1,SELECTOR_DATA_TOGGLE$5,(e=>{e.preventDefault();const t=e.target.closest(SELECTOR_DATA_TOGGLE$5);Button.getOrCreateInstance(t).toggle();})),defineJQueryPlugin(Button);const Manipulator$1={setDataAttribute(e,t,i){e.setAttribute(`data-bs-${normalizeDataKey$1(t)}`,i);},removeDataAttribute(e,t){e.removeAttribute(`data-bs-${normalizeDataKey$1(t)}`);},getDataAttributes(e){if(!e)return {};const t={};return Object.keys(e.dataset).filter((e=>e.startsWith("bs"))).forEach((i=>{let n=i.replace(/^bs/,"");n=n.charAt(0).toLowerCase()+n.slice(1,n.length),t[n]=normalizeData$1(e.dataset[i]);})),t},getDataAttribute:(e,t)=>normalizeData$1(e.getAttribute(`data-bs-${normalizeDataKey$1(t)}`)),offset(e){const t=e.getBoundingClientRect();return {top:t.top+window.pageYOffset,left:t.left+window.pageXOffset}},position:e=>({top:e.offsetTop,left:e.offsetLeft})},SelectorEngine$2={find:(e,t=document.documentElement)=>[].concat(...Element.prototype.querySelectorAll.call(t,e)),findOne:(e,t=document.documentElement)=>Element.prototype.querySelector.call(t,e),children:(e,t)=>[].concat(...e.children).filter((e=>e.matches(t))),parents(e,t){const i=[];let n=e.parentNode;for(;n&&n.nodeType===Node.ELEMENT_NODE&&3!==n.nodeType;)n.matches(t)&&i.push(n),n=n.parentNode;return i},prev(e,t){let i=e.previousElementSibling;for(;i;){if(i.matches(t))return [i];i=i.previousElementSibling;}return []},next(e,t){let i=e.nextElementSibling;for(;i;){if(i.matches(t))return [i];i=i.nextElementSibling;}return []},focusableChildren(e){const t=["a","button","input","textarea","select","details","[tabindex]",'[contenteditable="true"]'].map((e=>`${e}:not([tabindex^="-"])`)).join(", ");return this.find(t,e).filter((e=>!isDisabled$1(e)&&isVisible$1(e)))}},NAME$b$1="carousel",Default$a={interval:5e3,keyboard:!0,slide:!1,pause:"hover",wrap:!0,touch:!0},DefaultType$a={interval:"(number|boolean)",keyboard:"boolean",slide:"(boolean|string)",pause:"(string|boolean)",wrap:"boolean",touch:"boolean"},ORDER_NEXT="next",ORDER_PREV="prev",DIRECTION_LEFT="left",DIRECTION_RIGHT="right",KEY_TO_DIRECTION={ArrowLeft:DIRECTION_RIGHT,ArrowRight:DIRECTION_LEFT},EVENT_SLIDE="slide.bs.carousel",EVENT_SLID="slid.bs.carousel",EVENT_KEYDOWN$3="keydown.bs.carousel",EVENT_MOUSEENTER="mouseenter.bs.carousel",EVENT_MOUSELEAVE="mouseleave.bs.carousel",EVENT_TOUCHSTART="touchstart.bs.carousel",EVENT_TOUCHMOVE="touchmove.bs.carousel",EVENT_TOUCHEND="touchend.bs.carousel",EVENT_POINTERDOWN="pointerdown.bs.carousel",EVENT_POINTERUP="pointerup.bs.carousel",EVENT_DRAG_START="dragstart.bs.carousel",EVENT_LOAD_DATA_API$2="load.bs.carousel.data-api",EVENT_CLICK_DATA_API$5$1="click.bs.carousel.data-api",CLASS_NAME_END="carousel-item-end",CLASS_NAME_START="carousel-item-start",CLASS_NAME_NEXT="carousel-item-next",CLASS_NAME_PREV="carousel-item-prev",SELECTOR_ACTIVE_ITEM=".active.carousel-item",SELECTOR_ITEM=".carousel-item",SELECTOR_ITEM_IMG=".carousel-item img",SELECTOR_NEXT_PREV=".carousel-item-next, .carousel-item-prev",SELECTOR_INDICATORS=".carousel-indicators",SELECTOR_DATA_SLIDE="[data-bs-slide], [data-bs-slide-to]",SELECTOR_DATA_RIDE='[data-bs-ride="carousel"]';class Carousel extends BaseComponent$1{constructor(e,t){super(e),this._items=null,this._interval=null,this._activeElement=null,this._isPaused=!1,this._isSliding=!1,this.touchTimeout=null,this.touchStartX=0,this.touchDeltaX=0,this._config=this._getConfig(t),this._indicatorsElement=SelectorEngine$2.findOne(SELECTOR_INDICATORS,this._element),this._touchSupported="ontouchstart"in document.documentElement||navigator.maxTouchPoints>0,this._pointerEvent=Boolean(window.PointerEvent),this._addEventListeners();}static get Default(){return Default$a}static get NAME(){return NAME$b$1}next(){this._slide(ORDER_NEXT);}nextWhenVisible(){!document.hidden&&isVisible$1(this._element)&&this.next();}prev(){this._slide(ORDER_PREV);}pause(e){e||(this._isPaused=!0),SelectorEngine$2.findOne(SELECTOR_NEXT_PREV,this._element)&&(triggerTransitionEnd$1(this._element),this.cycle(!0)),clearInterval(this._interval),this._interval=null;}cycle(e){e||(this._isPaused=!1),this._interval&&(clearInterval(this._interval),this._interval=null),this._config&&this._config.interval&&!this._isPaused&&(this._updateInterval(),this._interval=setInterval((document.visibilityState?this.nextWhenVisible:this.next).bind(this),this._config.interval));}to(e){this._activeElement=SelectorEngine$2.findOne(SELECTOR_ACTIVE_ITEM,this._element);const t=this._getItemIndex(this._activeElement);if(e>this._items.length-1||e<0)return;if(this._isSliding)return void EventHandler$2.one(this._element,EVENT_SLID,(()=>this.to(e)));if(t===e)return this.pause(),void this.cycle();const i=e>t?ORDER_NEXT:ORDER_PREV;this._slide(i,this._items[e]);}_getConfig(e){return e={...Default$a,...Manipulator$1.getDataAttributes(this._element),..."object"==typeof e?e:{}},typeCheckConfig$1(NAME$b$1,e,DefaultType$a),e}_handleSwipe(){const e=Math.abs(this.touchDeltaX);if(e<=40)return;const t=e/this.touchDeltaX;this.touchDeltaX=0,t&&this._slide(t>0?DIRECTION_RIGHT:DIRECTION_LEFT);}_addEventListeners(){this._config.keyboard&&EventHandler$2.on(this._element,EVENT_KEYDOWN$3,(e=>this._keydown(e))),"hover"===this._config.pause&&(EventHandler$2.on(this._element,EVENT_MOUSEENTER,(e=>this.pause(e))),EventHandler$2.on(this._element,EVENT_MOUSELEAVE,(e=>this.cycle(e)))),this._config.touch&&this._touchSupported&&this._addTouchEventListeners();}_addTouchEventListeners(){const e=e=>this._pointerEvent&&("pen"===e.pointerType||"touch"===e.pointerType),t=t=>{e(t)?this.touchStartX=t.clientX:this._pointerEvent||(this.touchStartX=t.touches[0].clientX);},i=e=>{this.touchDeltaX=e.touches&&e.touches.length>1?0:e.touches[0].clientX-this.touchStartX;},n=t=>{e(t)&&(this.touchDeltaX=t.clientX-this.touchStartX),this._handleSwipe(),"hover"===this._config.pause&&(this.pause(),this.touchTimeout&&clearTimeout(this.touchTimeout),this.touchTimeout=setTimeout((e=>this.cycle(e)),500+this._config.interval));};SelectorEngine$2.find(SELECTOR_ITEM_IMG,this._element).forEach((e=>{EventHandler$2.on(e,EVENT_DRAG_START,(e=>e.preventDefault()));})),this._pointerEvent?(EventHandler$2.on(this._element,EVENT_POINTERDOWN,(e=>t(e))),EventHandler$2.on(this._element,EVENT_POINTERUP,(e=>n(e))),this._element.classList.add("pointer-event")):(EventHandler$2.on(this._element,EVENT_TOUCHSTART,(e=>t(e))),EventHandler$2.on(this._element,EVENT_TOUCHMOVE,(e=>i(e))),EventHandler$2.on(this._element,EVENT_TOUCHEND,(e=>n(e))));}_keydown(e){if(/input|textarea/i.test(e.target.tagName))return;const t=KEY_TO_DIRECTION[e.key];t&&(e.preventDefault(),this._slide(t));}_getItemIndex(e){return this._items=e&&e.parentNode?SelectorEngine$2.find(SELECTOR_ITEM,e.parentNode):[],this._items.indexOf(e)}_getItemByOrder(e,t){const i=e===ORDER_NEXT;return getNextActiveElement(this._items,t,i,this._config.wrap)}_triggerSlideEvent(e,t){const i=this._getItemIndex(e),n=this._getItemIndex(SelectorEngine$2.findOne(SELECTOR_ACTIVE_ITEM,this._element));return EventHandler$2.trigger(this._element,EVENT_SLIDE,{relatedTarget:e,direction:t,from:n,to:i})}_setActiveIndicatorElement(e){if(this._indicatorsElement){const t=SelectorEngine$2.findOne(".active",this._indicatorsElement);t.classList.remove("active"),t.removeAttribute("aria-current");const i=SelectorEngine$2.find("[data-bs-target]",this._indicatorsElement);for(let t=0;t<i.length;t++)if(Number.parseInt(i[t].getAttribute("data-bs-slide-to"),10)===this._getItemIndex(e)){i[t].classList.add("active"),i[t].setAttribute("aria-current","true");break}}}_updateInterval(){const e=this._activeElement||SelectorEngine$2.findOne(SELECTOR_ACTIVE_ITEM,this._element);if(!e)return;const t=Number.parseInt(e.getAttribute("data-bs-interval"),10);t?(this._config.defaultInterval=this._config.defaultInterval||this._config.interval,this._config.interval=t):this._config.interval=this._config.defaultInterval||this._config.interval;}_slide(e,t){const i=this._directionToOrder(e),n=SelectorEngine$2.findOne(SELECTOR_ACTIVE_ITEM,this._element),s=this._getItemIndex(n),o=t||this._getItemByOrder(i,n),r=this._getItemIndex(o),a=Boolean(this._interval),l=i===ORDER_NEXT,c=l?CLASS_NAME_START:CLASS_NAME_END,E=l?CLASS_NAME_NEXT:CLASS_NAME_PREV,_=this._orderToDirection(i);if(o&&o.classList.contains("active"))return void(this._isSliding=!1);if(this._isSliding)return;if(this._triggerSlideEvent(o,_).defaultPrevented)return;if(!n||!o)return;this._isSliding=!0,a&&this.pause(),this._setActiveIndicatorElement(o),this._activeElement=o;const h=()=>{EventHandler$2.trigger(this._element,EVENT_SLID,{relatedTarget:o,direction:_,from:s,to:r});};if(this._element.classList.contains("slide")){o.classList.add(E),reflow$1(o),n.classList.add(c),o.classList.add(c);const e=()=>{o.classList.remove(c,E),o.classList.add("active"),n.classList.remove("active",E,c),this._isSliding=!1,setTimeout(h,0);};this._queueCallback(e,n,!0);}else n.classList.remove("active"),o.classList.add("active"),this._isSliding=!1,h();a&&this.cycle();}_directionToOrder(e){return [DIRECTION_RIGHT,DIRECTION_LEFT].includes(e)?isRTL()?e===DIRECTION_LEFT?ORDER_PREV:ORDER_NEXT:e===DIRECTION_LEFT?ORDER_NEXT:ORDER_PREV:e}_orderToDirection(e){return [ORDER_NEXT,ORDER_PREV].includes(e)?isRTL()?e===ORDER_PREV?DIRECTION_LEFT:DIRECTION_RIGHT:e===ORDER_PREV?DIRECTION_RIGHT:DIRECTION_LEFT:e}static carouselInterface(e,t){const i=Carousel.getOrCreateInstance(e,t);let{_config:n}=i;"object"==typeof t&&(n={...n,...t});const s="string"==typeof t?t:n.slide;if("number"==typeof t)i.to(t);else if("string"==typeof s){if(void 0===i[s])throw new TypeError(`No method named "${s}"`);i[s]();}else n.interval&&n.ride&&(i.pause(),i.cycle());}static jQueryInterface(e){return this.each((function(){Carousel.carouselInterface(this,e);}))}static dataApiClickHandler(e){const t=getElementFromSelector$1(this);if(!t||!t.classList.contains("carousel"))return;const i={...Manipulator$1.getDataAttributes(t),...Manipulator$1.getDataAttributes(this)},n=this.getAttribute("data-bs-slide-to");n&&(i.interval=!1),Carousel.carouselInterface(t,i),n&&Carousel.getInstance(t).to(n),e.preventDefault();}}EventHandler$2.on(document,EVENT_CLICK_DATA_API$5$1,SELECTOR_DATA_SLIDE,Carousel.dataApiClickHandler),EventHandler$2.on(window,EVENT_LOAD_DATA_API$2,(()=>{const e=SelectorEngine$2.find(SELECTOR_DATA_RIDE);for(let t=0,i=e.length;t<i;t++)Carousel.carouselInterface(e[t],Carousel.getInstance(e[t]));})),defineJQueryPlugin(Carousel);const NAME$a$1="collapse",DATA_KEY$9$1="bs.collapse",Default$9={toggle:!0,parent:null},DefaultType$9={toggle:"boolean",parent:"(null|element)"},EVENT_SHOW$5="show.bs.collapse",EVENT_SHOWN$5="shown.bs.collapse",EVENT_HIDE$5="hide.bs.collapse",EVENT_HIDDEN$5="hidden.bs.collapse",EVENT_CLICK_DATA_API$4$1="click.bs.collapse.data-api",CLASS_NAME_DEEPER_CHILDREN=":scope .collapse .collapse",WIDTH="width",HEIGHT="height",SELECTOR_ACTIVES=".collapse.show, .collapse.collapsing",SELECTOR_DATA_TOGGLE$4$1='[data-bs-toggle="collapse"]';class Collapse extends BaseComponent$1{constructor(e,t){super(e),this._isTransitioning=!1,this._config=this._getConfig(t),this._triggerArray=[];const i=SelectorEngine$2.find(SELECTOR_DATA_TOGGLE$4$1);for(let e=0,t=i.length;e<t;e++){const t=i[e],n=getSelectorFromElement$1(t),s=SelectorEngine$2.find(n).filter((e=>e===this._element));null!==n&&s.length&&(this._selector=n,this._triggerArray.push(t));}this._initializeChildren(),this._config.parent||this._addAriaAndCollapsedClass(this._triggerArray,this._isShown()),this._config.toggle&&this.toggle();}static get Default(){return Default$9}static get NAME(){return NAME$a$1}toggle(){this._isShown()?this.hide():this.show();}show(){if(this._isTransitioning||this._isShown())return;let e,t=[];if(this._config.parent){const e=SelectorEngine$2.find(CLASS_NAME_DEEPER_CHILDREN,this._config.parent);t=SelectorEngine$2.find(SELECTOR_ACTIVES,this._config.parent).filter((t=>!e.includes(t)));}const i=SelectorEngine$2.findOne(this._selector);if(t.length){const n=t.find((e=>i!==e));if(e=n?Collapse.getInstance(n):null,e&&e._isTransitioning)return}if(EventHandler$2.trigger(this._element,EVENT_SHOW$5).defaultPrevented)return;t.forEach((t=>{i!==t&&Collapse.getOrCreateInstance(t,{toggle:!1}).hide(),e||Data$1.set(t,DATA_KEY$9$1,null);}));const n=this._getDimension();this._element.classList.remove("collapse"),this._element.classList.add("collapsing"),this._element.style[n]=0,this._addAriaAndCollapsedClass(this._triggerArray,!0),this._isTransitioning=!0;const s=`scroll${n[0].toUpperCase()+n.slice(1)}`;this._queueCallback((()=>{this._isTransitioning=!1,this._element.classList.remove("collapsing"),this._element.classList.add("collapse","show"),this._element.style[n]="",EventHandler$2.trigger(this._element,EVENT_SHOWN$5);}),this._element,!0),this._element.style[n]=`${this._element[s]}px`;}hide(){if(this._isTransitioning||!this._isShown())return;if(EventHandler$2.trigger(this._element,EVENT_HIDE$5).defaultPrevented)return;const e=this._getDimension();this._element.style[e]=`${this._element.getBoundingClientRect()[e]}px`,reflow$1(this._element),this._element.classList.add("collapsing"),this._element.classList.remove("collapse","show");const t=this._triggerArray.length;for(let e=0;e<t;e++){const t=this._triggerArray[e],i=getElementFromSelector$1(t);i&&!this._isShown(i)&&this._addAriaAndCollapsedClass([t],!1);}this._isTransitioning=!0;this._element.style[e]="",this._queueCallback((()=>{this._isTransitioning=!1,this._element.classList.remove("collapsing"),this._element.classList.add("collapse"),EventHandler$2.trigger(this._element,EVENT_HIDDEN$5);}),this._element,!0);}_isShown(e=this._element){return e.classList.contains("show")}_getConfig(e){return (e={...Default$9,...Manipulator$1.getDataAttributes(this._element),...e}).toggle=Boolean(e.toggle),e.parent=getElement$1(e.parent),typeCheckConfig$1(NAME$a$1,e,DefaultType$9),e}_getDimension(){return this._element.classList.contains("collapse-horizontal")?WIDTH:HEIGHT}_initializeChildren(){if(!this._config.parent)return;const e=SelectorEngine$2.find(CLASS_NAME_DEEPER_CHILDREN,this._config.parent);SelectorEngine$2.find(SELECTOR_DATA_TOGGLE$4$1,this._config.parent).filter((t=>!e.includes(t))).forEach((e=>{const t=getElementFromSelector$1(e);t&&this._addAriaAndCollapsedClass([e],this._isShown(t));}));}_addAriaAndCollapsedClass(e,t){e.length&&e.forEach((e=>{t?e.classList.remove("collapsed"):e.classList.add("collapsed"),e.setAttribute("aria-expanded",t);}));}static jQueryInterface(e){return this.each((function(){const t={};"string"==typeof e&&/show|hide/.test(e)&&(t.toggle=!1);const i=Collapse.getOrCreateInstance(this,t);if("string"==typeof e){if(void 0===i[e])throw new TypeError(`No method named "${e}"`);i[e]();}}))}}EventHandler$2.on(document,EVENT_CLICK_DATA_API$4$1,SELECTOR_DATA_TOGGLE$4$1,(function(e){("A"===e.target.tagName||e.delegateTarget&&"A"===e.delegateTarget.tagName)&&e.preventDefault();const t=getSelectorFromElement$1(this);SelectorEngine$2.find(t).forEach((e=>{Collapse.getOrCreateInstance(e,{toggle:!1}).toggle();}));})),defineJQueryPlugin(Collapse);const NAME$9$1="dropdown",REGEXP_KEYDOWN=new RegExp("ArrowUp|ArrowDown|Escape"),EVENT_HIDE$4="hide.bs.dropdown",EVENT_HIDDEN$4="hidden.bs.dropdown",EVENT_SHOW$4="show.bs.dropdown",EVENT_SHOWN$4="shown.bs.dropdown",EVENT_CLICK_DATA_API$3$1="click.bs.dropdown.data-api",EVENT_KEYDOWN_DATA_API$1="keydown.bs.dropdown.data-api",EVENT_KEYUP_DATA_API$1="keyup.bs.dropdown.data-api",SELECTOR_DATA_TOGGLE$3$1='[data-bs-toggle="dropdown"]',SELECTOR_MENU=".dropdown-menu",SELECTOR_VISIBLE_ITEMS=".dropdown-menu .dropdown-item:not(.disabled):not(:disabled)",PLACEMENT_TOP=isRTL()?"top-end":"top-start",PLACEMENT_TOPEND=isRTL()?"top-start":"top-end",PLACEMENT_BOTTOM=isRTL()?"bottom-end":"bottom-start",PLACEMENT_BOTTOMEND=isRTL()?"bottom-start":"bottom-end",PLACEMENT_RIGHT=isRTL()?"left-start":"right-start",PLACEMENT_LEFT=isRTL()?"right-start":"left-start",Default$8$1={offset:[0,2],boundary:"clippingParents",reference:"toggle",display:"dynamic",popperConfig:null,autoClose:!0},DefaultType$8={offset:"(array|string|function)",boundary:"(string|element)",reference:"(string|element|object)",display:"string",popperConfig:"(null|object|function)",autoClose:"(boolean|string)"};class Dropdown extends BaseComponent$1{constructor(e,t){super(e),this._popper=null,this._config=this._getConfig(t),this._menu=this._getMenuElement(),this._inNavbar=this._detectNavbar();}static get Default(){return Default$8$1}static get DefaultType(){return DefaultType$8}static get NAME(){return NAME$9$1}toggle(){return this._isShown()?this.hide():this.show()}show(){if(isDisabled$1(this._element)||this._isShown(this._menu))return;const e={relatedTarget:this._element};if(EventHandler$2.trigger(this._element,EVENT_SHOW$4,e).defaultPrevented)return;const t=Dropdown.getParentFromElement(this._element);this._inNavbar?Manipulator$1.setDataAttribute(this._menu,"popper","none"):this._createPopper(t),"ontouchstart"in document.documentElement&&!t.closest(".navbar-nav")&&[].concat(...document.body.children).forEach((e=>EventHandler$2.on(e,"mouseover",noop$1))),this._element.focus(),this._element.setAttribute("aria-expanded",!0),this._menu.classList.add("show"),this._element.classList.add("show"),EventHandler$2.trigger(this._element,EVENT_SHOWN$4,e);}hide(){if(isDisabled$1(this._element)||!this._isShown(this._menu))return;const e={relatedTarget:this._element};this._completeHide(e);}dispose(){this._popper&&this._popper.destroy(),super.dispose();}update(){this._inNavbar=this._detectNavbar(),this._popper&&this._popper.update();}_completeHide(e){EventHandler$2.trigger(this._element,EVENT_HIDE$4,e).defaultPrevented||("ontouchstart"in document.documentElement&&[].concat(...document.body.children).forEach((e=>EventHandler$2.off(e,"mouseover",noop$1))),this._popper&&this._popper.destroy(),this._menu.classList.remove("show"),this._element.classList.remove("show"),this._element.setAttribute("aria-expanded","false"),Manipulator$1.removeDataAttribute(this._menu,"popper"),EventHandler$2.trigger(this._element,EVENT_HIDDEN$4,e));}_getConfig(e){if(e={...this.constructor.Default,...Manipulator$1.getDataAttributes(this._element),...e},typeCheckConfig$1(NAME$9$1,e,this.constructor.DefaultType),"object"==typeof e.reference&&!isElement$1(e.reference)&&"function"!=typeof e.reference.getBoundingClientRect)throw new TypeError(`${NAME$9$1.toUpperCase()}: Option "reference" provided type "object" without a required "getBoundingClientRect" method.`);return e}_createPopper(e){if(void 0===Popper)throw new TypeError("Bootstrap's dropdowns require Popper (https://popper.js.org)");let t=this._element;"parent"===this._config.reference?t=e:isElement$1(this._config.reference)?t=getElement$1(this._config.reference):"object"==typeof this._config.reference&&(t=this._config.reference);const i=this._getPopperConfig(),n=i.modifiers.find((e=>"applyStyles"===e.name&&!1===e.enabled));this._popper=createPopper(t,this._menu,i),n&&Manipulator$1.setDataAttribute(this._menu,"popper","static");}_isShown(e=this._element){return e.classList.contains("show")}_getMenuElement(){return SelectorEngine$2.next(this._element,SELECTOR_MENU)[0]}_getPlacement(){const e=this._element.parentNode;if(e.classList.contains("dropend"))return PLACEMENT_RIGHT;if(e.classList.contains("dropstart"))return PLACEMENT_LEFT;const t="end"===getComputedStyle(this._menu).getPropertyValue("--bs-position").trim();return e.classList.contains("dropup")?t?PLACEMENT_TOPEND:PLACEMENT_TOP:t?PLACEMENT_BOTTOMEND:PLACEMENT_BOTTOM}_detectNavbar(){return null!==this._element.closest(".navbar")}_getOffset(){const{offset:e}=this._config;return "string"==typeof e?e.split(",").map((e=>Number.parseInt(e,10))):"function"==typeof e?t=>e(t,this._element):e}_getPopperConfig(){const e={placement:this._getPlacement(),modifiers:[{name:"preventOverflow",options:{boundary:this._config.boundary}},{name:"offset",options:{offset:this._getOffset()}}]};return "static"===this._config.display&&(e.modifiers=[{name:"applyStyles",enabled:!1}]),{...e,..."function"==typeof this._config.popperConfig?this._config.popperConfig(e):this._config.popperConfig}}_selectMenuItem({key:e,target:t}){const i=SelectorEngine$2.find(SELECTOR_VISIBLE_ITEMS,this._menu).filter(isVisible$1);i.length&&getNextActiveElement(i,t,"ArrowDown"===e,!i.includes(t)).focus();}static jQueryInterface(e){return this.each((function(){const t=Dropdown.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e])throw new TypeError(`No method named "${e}"`);t[e]();}}))}static clearMenus(e){if(e&&(2===e.button||"keyup"===e.type&&"Tab"!==e.key))return;const t=SelectorEngine$2.find(SELECTOR_DATA_TOGGLE$3$1);for(let i=0,n=t.length;i<n;i++){const n=Dropdown.getInstance(t[i]);if(!n||!1===n._config.autoClose)continue;if(!n._isShown())continue;const s={relatedTarget:n._element};if(e){const t=e.composedPath(),i=t.includes(n._menu);if(t.includes(n._element)||"inside"===n._config.autoClose&&!i||"outside"===n._config.autoClose&&i)continue;if(n._menu.contains(e.target)&&("keyup"===e.type&&"Tab"===e.key||/input|select|option|textarea|form/i.test(e.target.tagName)))continue;"click"===e.type&&(s.clickEvent=e);}n._completeHide(s);}}static getParentFromElement(e){return getElementFromSelector$1(e)||e.parentNode}static dataApiKeydownHandler(e){if(/input|textarea/i.test(e.target.tagName)?"Space"===e.key||"Escape"!==e.key&&("ArrowDown"!==e.key&&"ArrowUp"!==e.key||e.target.closest(SELECTOR_MENU)):!REGEXP_KEYDOWN.test(e.key))return;const t=this.classList.contains("show");if(!t&&"Escape"===e.key)return;if(e.preventDefault(),e.stopPropagation(),isDisabled$1(this))return;const i=this.matches(SELECTOR_DATA_TOGGLE$3$1)?this:SelectorEngine$2.prev(this,SELECTOR_DATA_TOGGLE$3$1)[0],n=Dropdown.getOrCreateInstance(i);if("Escape"!==e.key)return "ArrowUp"===e.key||"ArrowDown"===e.key?(t||n.show(),void n._selectMenuItem(e)):void(t&&"Space"!==e.key||Dropdown.clearMenus());n.hide();}}EventHandler$2.on(document,EVENT_KEYDOWN_DATA_API$1,SELECTOR_DATA_TOGGLE$3$1,Dropdown.dataApiKeydownHandler),EventHandler$2.on(document,EVENT_KEYDOWN_DATA_API$1,SELECTOR_MENU,Dropdown.dataApiKeydownHandler),EventHandler$2.on(document,EVENT_CLICK_DATA_API$3$1,Dropdown.clearMenus),EventHandler$2.on(document,EVENT_KEYUP_DATA_API$1,Dropdown.clearMenus),EventHandler$2.on(document,EVENT_CLICK_DATA_API$3$1,SELECTOR_DATA_TOGGLE$3$1,(function(e){e.preventDefault(),Dropdown.getOrCreateInstance(this).toggle();})),defineJQueryPlugin(Dropdown);const SELECTOR_FIXED_CONTENT=".fixed-top, .fixed-bottom, .is-fixed, .sticky-top";class ScrollBarHelper{constructor(){this._element=document.body;}getWidth(){const e=document.documentElement.clientWidth;return Math.abs(window.innerWidth-e)}hide(){const e=this.getWidth();this._disableOverFlow(),this._setElementAttributes(this._element,"paddingRight",(t=>t+e)),this._setElementAttributes(SELECTOR_FIXED_CONTENT,"paddingRight",(t=>t+e)),this._setElementAttributes(".sticky-top","marginRight",(t=>t-e));}_disableOverFlow(){this._saveInitialAttribute(this._element,"overflow"),this._element.style.overflow="hidden";}_setElementAttributes(e,t,i){const n=this.getWidth();this._applyManipulationCallback(e,(e=>{if(e!==this._element&&window.innerWidth>e.clientWidth+n)return;this._saveInitialAttribute(e,t);const s=window.getComputedStyle(e)[t];e.style[t]=`${i(Number.parseFloat(s))}px`;}));}reset(){this._resetElementAttributes(this._element,"overflow"),this._resetElementAttributes(this._element,"paddingRight"),this._resetElementAttributes(SELECTOR_FIXED_CONTENT,"paddingRight"),this._resetElementAttributes(".sticky-top","marginRight");}_saveInitialAttribute(e,t){const i=e.style[t];i&&Manipulator$1.setDataAttribute(e,t,i);}_resetElementAttributes(e,t){this._applyManipulationCallback(e,(e=>{const i=Manipulator$1.getDataAttribute(e,t);void 0===i?e.style.removeProperty(t):(Manipulator$1.removeDataAttribute(e,t),e.style[t]=i);}));}_applyManipulationCallback(e,t){isElement$1(e)?t(e):SelectorEngine$2.find(e,this._element).forEach(t);}isOverflowing(){return this.getWidth()>0}}const Default$7$1={className:"modal-backdrop",isVisible:!0,isAnimated:!1,rootElement:"body",clickCallback:null},DefaultType$7={className:"string",isVisible:"boolean",isAnimated:"boolean",rootElement:"(element|string)",clickCallback:"(function|null)"},NAME$8$1="backdrop",EVENT_MOUSEDOWN="mousedown.bs.backdrop";class Backdrop{constructor(e){this._config=this._getConfig(e),this._isAppended=!1,this._element=null;}show(e){this._config.isVisible?(this._append(),this._config.isAnimated&&reflow$1(this._getElement()),this._getElement().classList.add("show"),this._emulateAnimation((()=>{execute$1(e);}))):execute$1(e);}hide(e){this._config.isVisible?(this._getElement().classList.remove("show"),this._emulateAnimation((()=>{this.dispose(),execute$1(e);}))):execute$1(e);}_getElement(){if(!this._element){const e=document.createElement("div");e.className=this._config.className,this._config.isAnimated&&e.classList.add("fade"),this._element=e;}return this._element}_getConfig(e){return (e={...Default$7$1,..."object"==typeof e?e:{}}).rootElement=getElement$1(e.rootElement),typeCheckConfig$1(NAME$8$1,e,DefaultType$7),e}_append(){this._isAppended||(this._config.rootElement.append(this._getElement()),EventHandler$2.on(this._getElement(),EVENT_MOUSEDOWN,(()=>{execute$1(this._config.clickCallback);})),this._isAppended=!0);}dispose(){this._isAppended&&(EventHandler$2.off(this._element,EVENT_MOUSEDOWN),this._element.remove(),this._isAppended=!1);}_emulateAnimation(e){executeAfterTransition$1(e,this._getElement(),this._config.isAnimated);}}const Default$6$1={trapElement:null,autofocus:!0},DefaultType$6={trapElement:"element",autofocus:"boolean"},NAME$7$1="focustrap",EVENT_KEY$7$1=".bs.focustrap",EVENT_FOCUSIN$1="focusin.bs.focustrap",EVENT_KEYDOWN_TAB="keydown.tab.bs.focustrap";class FocusTrap{constructor(e){this._config=this._getConfig(e),this._isActive=!1,this._lastTabNavDirection=null;}activate(){const{trapElement:e,autofocus:t}=this._config;this._isActive||(t&&e.focus(),EventHandler$2.off(document,EVENT_KEY$7$1),EventHandler$2.on(document,EVENT_FOCUSIN$1,(e=>this._handleFocusin(e))),EventHandler$2.on(document,EVENT_KEYDOWN_TAB,(e=>this._handleKeydown(e))),this._isActive=!0);}deactivate(){this._isActive&&(this._isActive=!1,EventHandler$2.off(document,EVENT_KEY$7$1));}_handleFocusin(e){const{target:t}=e,{trapElement:i}=this._config;if(t===document||t===i||i.contains(t))return;const n=SelectorEngine$2.focusableChildren(i);0===n.length?i.focus():"backward"===this._lastTabNavDirection?n[n.length-1].focus():n[0].focus();}_handleKeydown(e){"Tab"===e.key&&(this._lastTabNavDirection=e.shiftKey?"backward":"forward");}_getConfig(e){return e={...Default$6$1,..."object"==typeof e?e:{}},typeCheckConfig$1(NAME$7$1,e,DefaultType$6),e}}const NAME$6$1="modal",Default$5$1={backdrop:!0,keyboard:!0,focus:!0},DefaultType$5={backdrop:"(boolean|string)",keyboard:"boolean",focus:"boolean"},EVENT_HIDE$3="hide.bs.modal",EVENT_HIDE_PREVENTED="hidePrevented.bs.modal",EVENT_HIDDEN$3="hidden.bs.modal",EVENT_SHOW$3="show.bs.modal",EVENT_SHOWN$3="shown.bs.modal",EVENT_RESIZE$2="resize.bs.modal",EVENT_CLICK_DISMISS="click.dismiss.bs.modal",EVENT_KEYDOWN_DISMISS$1="keydown.dismiss.bs.modal",EVENT_MOUSEUP_DISMISS="mouseup.dismiss.bs.modal",EVENT_MOUSEDOWN_DISMISS="mousedown.dismiss.bs.modal",EVENT_CLICK_DATA_API$2$1="click.bs.modal.data-api",SELECTOR_DATA_TOGGLE$2$1='[data-bs-toggle="modal"]';class Modal extends BaseComponent$1{constructor(e,t){super(e),this._config=this._getConfig(t),this._dialog=SelectorEngine$2.findOne(".modal-dialog",this._element),this._backdrop=this._initializeBackDrop(),this._focustrap=this._initializeFocusTrap(),this._isShown=!1,this._ignoreBackdropClick=!1,this._isTransitioning=!1,this._scrollBar=new ScrollBarHelper;}static get Default(){return Default$5$1}static get NAME(){return NAME$6$1}toggle(e){return this._isShown?this.hide():this.show(e)}show(e){if(this._isShown||this._isTransitioning)return;EventHandler$2.trigger(this._element,EVENT_SHOW$3,{relatedTarget:e}).defaultPrevented||(this._isShown=!0,this._isAnimated()&&(this._isTransitioning=!0),this._scrollBar.hide(),document.body.classList.add("modal-open"),this._adjustDialog(),this._setEscapeEvent(),this._setResizeEvent(),EventHandler$2.on(this._dialog,EVENT_MOUSEDOWN_DISMISS,(()=>{EventHandler$2.one(this._element,EVENT_MOUSEUP_DISMISS,(e=>{e.target===this._element&&(this._ignoreBackdropClick=!0);}));})),this._showBackdrop((()=>this._showElement(e))));}hide(){if(!this._isShown||this._isTransitioning)return;if(EventHandler$2.trigger(this._element,EVENT_HIDE$3).defaultPrevented)return;this._isShown=!1;const e=this._isAnimated();e&&(this._isTransitioning=!0),this._setEscapeEvent(),this._setResizeEvent(),this._focustrap.deactivate(),this._element.classList.remove("show"),EventHandler$2.off(this._element,EVENT_CLICK_DISMISS),EventHandler$2.off(this._dialog,EVENT_MOUSEDOWN_DISMISS),this._queueCallback((()=>this._hideModal()),this._element,e);}dispose(){[window,this._dialog].forEach((e=>EventHandler$2.off(e,".bs.modal"))),this._backdrop.dispose(),this._focustrap.deactivate(),super.dispose();}handleUpdate(){this._adjustDialog();}_initializeBackDrop(){return new Backdrop({isVisible:Boolean(this._config.backdrop),isAnimated:this._isAnimated()})}_initializeFocusTrap(){return new FocusTrap({trapElement:this._element})}_getConfig(e){return e={...Default$5$1,...Manipulator$1.getDataAttributes(this._element),..."object"==typeof e?e:{}},typeCheckConfig$1(NAME$6$1,e,DefaultType$5),e}_showElement(e){const t=this._isAnimated(),i=SelectorEngine$2.findOne(".modal-body",this._dialog);this._element.parentNode&&this._element.parentNode.nodeType===Node.ELEMENT_NODE||document.body.append(this._element),this._element.style.display="block",this._element.removeAttribute("aria-hidden"),this._element.setAttribute("aria-modal",!0),this._element.setAttribute("role","dialog"),this._element.scrollTop=0,i&&(i.scrollTop=0),t&&reflow$1(this._element),this._element.classList.add("show");this._queueCallback((()=>{this._config.focus&&this._focustrap.activate(),this._isTransitioning=!1,EventHandler$2.trigger(this._element,EVENT_SHOWN$3,{relatedTarget:e});}),this._dialog,t);}_setEscapeEvent(){this._isShown?EventHandler$2.on(this._element,EVENT_KEYDOWN_DISMISS$1,(e=>{this._config.keyboard&&"Escape"===e.key?(e.preventDefault(),this.hide()):this._config.keyboard||"Escape"!==e.key||this._triggerBackdropTransition();})):EventHandler$2.off(this._element,EVENT_KEYDOWN_DISMISS$1);}_setResizeEvent(){this._isShown?EventHandler$2.on(window,EVENT_RESIZE$2,(()=>this._adjustDialog())):EventHandler$2.off(window,EVENT_RESIZE$2);}_hideModal(){this._element.style.display="none",this._element.setAttribute("aria-hidden",!0),this._element.removeAttribute("aria-modal"),this._element.removeAttribute("role"),this._isTransitioning=!1,this._backdrop.hide((()=>{document.body.classList.remove("modal-open"),this._resetAdjustments(),this._scrollBar.reset(),EventHandler$2.trigger(this._element,EVENT_HIDDEN$3);}));}_showBackdrop(e){EventHandler$2.on(this._element,EVENT_CLICK_DISMISS,(e=>{this._ignoreBackdropClick?this._ignoreBackdropClick=!1:e.target===e.currentTarget&&(!0===this._config.backdrop?this.hide():"static"===this._config.backdrop&&this._triggerBackdropTransition());})),this._backdrop.show(e);}_isAnimated(){return this._element.classList.contains("fade")}_triggerBackdropTransition(){if(EventHandler$2.trigger(this._element,EVENT_HIDE_PREVENTED).defaultPrevented)return;const{classList:e,scrollHeight:t,style:i}=this._element,n=t>document.documentElement.clientHeight;!n&&"hidden"===i.overflowY||e.contains("modal-static")||(n||(i.overflowY="hidden"),e.add("modal-static"),this._queueCallback((()=>{e.remove("modal-static"),n||this._queueCallback((()=>{i.overflowY="";}),this._dialog);}),this._dialog),this._element.focus());}_adjustDialog(){const e=this._element.scrollHeight>document.documentElement.clientHeight,t=this._scrollBar.getWidth(),i=t>0;(!i&&e&&!isRTL()||i&&!e&&isRTL())&&(this._element.style.paddingLeft=`${t}px`),(i&&!e&&!isRTL()||!i&&e&&isRTL())&&(this._element.style.paddingRight=`${t}px`);}_resetAdjustments(){this._element.style.paddingLeft="",this._element.style.paddingRight="";}static jQueryInterface(e,t){return this.each((function(){const i=Modal.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===i[e])throw new TypeError(`No method named "${e}"`);i[e](t);}}))}}EventHandler$2.on(document,EVENT_CLICK_DATA_API$2$1,SELECTOR_DATA_TOGGLE$2$1,(function(e){const t=getElementFromSelector$1(this);["A","AREA"].includes(this.tagName)&&e.preventDefault(),EventHandler$2.one(t,EVENT_SHOW$3,(e=>{e.defaultPrevented||EventHandler$2.one(t,EVENT_HIDDEN$3,(()=>{isVisible$1(this)&&this.focus();}));}));const i=SelectorEngine$2.findOne(".modal.show");i&&Modal.getInstance(i).hide();Modal.getOrCreateInstance(t).toggle(this);})),enableDismissTrigger$1(Modal),defineJQueryPlugin(Modal);const NAME$5$1="offcanvas",EVENT_LOAD_DATA_API$1$1="load.bs.offcanvas.data-api",Default$4$1={backdrop:!0,keyboard:!0,scroll:!1},DefaultType$4={backdrop:"boolean",keyboard:"boolean",scroll:"boolean"},CLASS_NAME_BACKDROP="offcanvas-backdrop",OPEN_SELECTOR=".offcanvas.show",EVENT_SHOW$2="show.bs.offcanvas",EVENT_SHOWN$2="shown.bs.offcanvas",EVENT_HIDE$2="hide.bs.offcanvas",EVENT_HIDDEN$2="hidden.bs.offcanvas",EVENT_CLICK_DATA_API$1$1="click.bs.offcanvas.data-api",EVENT_KEYDOWN_DISMISS="keydown.dismiss.bs.offcanvas",SELECTOR_DATA_TOGGLE$1$1='[data-bs-toggle="offcanvas"]';class Offcanvas extends BaseComponent$1{constructor(e,t){super(e),this._config=this._getConfig(t),this._isShown=!1,this._backdrop=this._initializeBackDrop(),this._focustrap=this._initializeFocusTrap(),this._addEventListeners();}static get NAME(){return NAME$5$1}static get Default(){return Default$4$1}toggle(e){return this._isShown?this.hide():this.show(e)}show(e){if(this._isShown)return;if(EventHandler$2.trigger(this._element,EVENT_SHOW$2,{relatedTarget:e}).defaultPrevented)return;this._isShown=!0,this._element.style.visibility="visible",this._backdrop.show(),this._config.scroll||(new ScrollBarHelper).hide(),this._element.removeAttribute("aria-hidden"),this._element.setAttribute("aria-modal",!0),this._element.setAttribute("role","dialog"),this._element.classList.add("show");this._queueCallback((()=>{this._config.scroll||this._focustrap.activate(),EventHandler$2.trigger(this._element,EVENT_SHOWN$2,{relatedTarget:e});}),this._element,!0);}hide(){if(!this._isShown)return;if(EventHandler$2.trigger(this._element,EVENT_HIDE$2).defaultPrevented)return;this._focustrap.deactivate(),this._element.blur(),this._isShown=!1,this._element.classList.remove("show"),this._backdrop.hide();this._queueCallback((()=>{this._element.setAttribute("aria-hidden",!0),this._element.removeAttribute("aria-modal"),this._element.removeAttribute("role"),this._element.style.visibility="hidden",this._config.scroll||(new ScrollBarHelper).reset(),EventHandler$2.trigger(this._element,EVENT_HIDDEN$2);}),this._element,!0);}dispose(){this._backdrop.dispose(),this._focustrap.deactivate(),super.dispose();}_getConfig(e){return e={...Default$4$1,...Manipulator$1.getDataAttributes(this._element),..."object"==typeof e?e:{}},typeCheckConfig$1(NAME$5$1,e,DefaultType$4),e}_initializeBackDrop(){return new Backdrop({className:CLASS_NAME_BACKDROP,isVisible:this._config.backdrop,isAnimated:!0,rootElement:this._element.parentNode,clickCallback:()=>this.hide()})}_initializeFocusTrap(){return new FocusTrap({trapElement:this._element})}_addEventListeners(){EventHandler$2.on(this._element,EVENT_KEYDOWN_DISMISS,(e=>{this._config.keyboard&&"Escape"===e.key&&this.hide();}));}static jQueryInterface(e){return this.each((function(){const t=Offcanvas.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e]||e.startsWith("_")||"constructor"===e)throw new TypeError(`No method named "${e}"`);t[e](this);}}))}}EventHandler$2.on(document,EVENT_CLICK_DATA_API$1$1,SELECTOR_DATA_TOGGLE$1$1,(function(e){const t=getElementFromSelector$1(this);if(["A","AREA"].includes(this.tagName)&&e.preventDefault(),isDisabled$1(this))return;EventHandler$2.one(t,EVENT_HIDDEN$2,(()=>{isVisible$1(this)&&this.focus();}));const i=SelectorEngine$2.findOne(OPEN_SELECTOR);i&&i!==t&&Offcanvas.getInstance(i).hide();Offcanvas.getOrCreateInstance(t).toggle(this);})),EventHandler$2.on(window,EVENT_LOAD_DATA_API$1$1,(()=>SelectorEngine$2.find(OPEN_SELECTOR).forEach((e=>Offcanvas.getOrCreateInstance(e).show())))),enableDismissTrigger$1(Offcanvas),defineJQueryPlugin(Offcanvas);const uriAttributes=new Set(["background","cite","href","itemtype","longdesc","poster","src","xlink:href"]),ARIA_ATTRIBUTE_PATTERN=/^aria-[\w-]*$/i,SAFE_URL_PATTERN=/^(?:(?:https?|mailto|ftp|tel|file|sms):|[^#&/:?]*(?:[#/?]|$))/i,DATA_URL_PATTERN=/^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[\d+/a-z]+=*$/i,allowedAttribute=(e,t)=>{const i=e.nodeName.toLowerCase();if(t.includes(i))return !uriAttributes.has(i)||Boolean(SAFE_URL_PATTERN.test(e.nodeValue)||DATA_URL_PATTERN.test(e.nodeValue));const n=t.filter((e=>e instanceof RegExp));for(let e=0,t=n.length;e<t;e++)if(n[e].test(i))return !0;return !1},DefaultAllowlist={"*":["class","dir","id","lang","role",ARIA_ATTRIBUTE_PATTERN],a:["target","href","title","rel"],area:[],b:[],br:[],col:[],code:[],div:[],em:[],hr:[],h1:[],h2:[],h3:[],h4:[],h5:[],h6:[],i:[],img:["src","srcset","alt","title","width","height"],li:[],ol:[],p:[],pre:[],s:[],small:[],span:[],sub:[],sup:[],strong:[],u:[],ul:[]};function sanitizeHtml(e,t,i){if(!e.length)return e;if(i&&"function"==typeof i)return i(e);const n=(new window.DOMParser).parseFromString(e,"text/html"),s=[].concat(...n.body.querySelectorAll("*"));for(let e=0,i=s.length;e<i;e++){const i=s[e],n=i.nodeName.toLowerCase();if(!Object.keys(t).includes(n)){i.remove();continue}const o=[].concat(...i.attributes),r=[].concat(t["*"]||[],t[n]||[]);o.forEach((e=>{allowedAttribute(e,r)||i.removeAttribute(e.nodeName);}));}return n.body.innerHTML}const NAME$4$1="tooltip",DISALLOWED_ATTRIBUTES=new Set(["sanitize","allowList","sanitizeFn"]),DefaultType$3={animation:"boolean",template:"string",title:"(string|element|function)",trigger:"string",delay:"(number|object)",html:"boolean",selector:"(string|boolean)",placement:"(string|function)",offset:"(array|string|function)",container:"(string|element|boolean)",fallbackPlacements:"array",boundary:"(string|element)",customClass:"(string|function)",sanitize:"boolean",sanitizeFn:"(null|function)",allowList:"object",popperConfig:"(null|object|function)"},AttachmentMap={AUTO:"auto",TOP:"top",RIGHT:isRTL()?"left":"right",BOTTOM:"bottom",LEFT:isRTL()?"right":"left"},Default$3$1={animation:!0,template:'<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',trigger:"hover focus",title:"",delay:0,html:!1,selector:!1,placement:"top",offset:[0,0],container:!1,fallbackPlacements:["top","right","bottom","left"],boundary:"clippingParents",customClass:"",sanitize:!0,sanitizeFn:null,allowList:DefaultAllowlist,popperConfig:null},Event$2={HIDE:"hide.bs.tooltip",HIDDEN:"hidden.bs.tooltip",SHOW:"show.bs.tooltip",SHOWN:"shown.bs.tooltip",INSERTED:"inserted.bs.tooltip",CLICK:"click.bs.tooltip",FOCUSIN:"focusin.bs.tooltip",FOCUSOUT:"focusout.bs.tooltip",MOUSEENTER:"mouseenter.bs.tooltip",MOUSELEAVE:"mouseleave.bs.tooltip"};class Tooltip extends BaseComponent$1{constructor(e,t){if(void 0===Popper)throw new TypeError("Bootstrap's tooltips require Popper (https://popper.js.org)");super(e),this._isEnabled=!0,this._timeout=0,this._hoverState="",this._activeTrigger={},this._popper=null,this._config=this._getConfig(t),this.tip=null,this._setListeners();}static get Default(){return Default$3$1}static get NAME(){return NAME$4$1}static get Event(){return Event$2}static get DefaultType(){return DefaultType$3}enable(){this._isEnabled=!0;}disable(){this._isEnabled=!1;}toggleEnabled(){this._isEnabled=!this._isEnabled;}toggle(e){if(this._isEnabled)if(e){const t=this._initializeOnDelegatedTarget(e);t._activeTrigger.click=!t._activeTrigger.click,t._isWithActiveTrigger()?t._enter(null,t):t._leave(null,t);}else {if(this.getTipElement().classList.contains("show"))return void this._leave(null,this);this._enter(null,this);}}dispose(){clearTimeout(this._timeout),EventHandler$2.off(this._element.closest(".modal"),"hide.bs.modal",this._hideModalHandler),this.tip&&this.tip.remove(),this._disposePopper(),super.dispose();}show(){if("none"===this._element.style.display)throw new Error("Please use show on visible elements");if(!this.isWithContent()||!this._isEnabled)return;const e=EventHandler$2.trigger(this._element,this.constructor.Event.SHOW),t=findShadowRoot(this._element),i=null===t?this._element.ownerDocument.documentElement.contains(this._element):t.contains(this._element);if(e.defaultPrevented||!i)return;"tooltip"===this.constructor.NAME&&this.tip&&this.getTitle()!==this.tip.querySelector(".tooltip-inner").innerHTML&&(this._disposePopper(),this.tip.remove(),this.tip=null);const n=this.getTipElement(),s=getUID(this.constructor.NAME);n.setAttribute("id",s),this._element.setAttribute("aria-describedby",s),this._config.animation&&n.classList.add("fade");const o="function"==typeof this._config.placement?this._config.placement.call(this,n,this._element):this._config.placement,r=this._getAttachment(o);this._addAttachmentClass(r);const{container:a}=this._config;Data$1.set(n,this.constructor.DATA_KEY,this),this._element.ownerDocument.documentElement.contains(this.tip)||(a.append(n),EventHandler$2.trigger(this._element,this.constructor.Event.INSERTED)),this._popper?this._popper.update():this._popper=createPopper(this._element,n,this._getPopperConfig(r)),n.classList.add("show");const l=this._resolvePossibleFunction(this._config.customClass);l&&n.classList.add(...l.split(" ")),"ontouchstart"in document.documentElement&&[].concat(...document.body.children).forEach((e=>{EventHandler$2.on(e,"mouseover",noop$1);}));const c=this.tip.classList.contains("fade");this._queueCallback((()=>{const e=this._hoverState;this._hoverState=null,EventHandler$2.trigger(this._element,this.constructor.Event.SHOWN),"out"===e&&this._leave(null,this);}),this.tip,c);}hide(){if(!this._popper)return;const e=this.getTipElement();if(EventHandler$2.trigger(this._element,this.constructor.Event.HIDE).defaultPrevented)return;e.classList.remove("show"),"ontouchstart"in document.documentElement&&[].concat(...document.body.children).forEach((e=>EventHandler$2.off(e,"mouseover",noop$1))),this._activeTrigger.click=!1,this._activeTrigger.focus=!1,this._activeTrigger.hover=!1;const t=this.tip.classList.contains("fade");this._queueCallback((()=>{this._isWithActiveTrigger()||("show"!==this._hoverState&&e.remove(),this._cleanTipClass(),this._element.removeAttribute("aria-describedby"),EventHandler$2.trigger(this._element,this.constructor.Event.HIDDEN),this._disposePopper());}),this.tip,t),this._hoverState="";}update(){null!==this._popper&&this._popper.update();}isWithContent(){return Boolean(this.getTitle())}getTipElement(){if(this.tip)return this.tip;const e=document.createElement("div");e.innerHTML=this._config.template;const t=e.children[0];return this.setContent(t),t.classList.remove("fade","show"),this.tip=t,this.tip}setContent(e){this._sanitizeAndSetContent(e,this.getTitle(),".tooltip-inner");}_sanitizeAndSetContent(e,t,i){const n=SelectorEngine$2.findOne(i,e);t||!n?this.setElementContent(n,t):n.remove();}setElementContent(e,t){if(null!==e)return isElement$1(t)?(t=getElement$1(t),void(this._config.html?t.parentNode!==e&&(e.innerHTML="",e.append(t)):e.textContent=t.textContent)):void(this._config.html?(this._config.sanitize&&(t=sanitizeHtml(t,this._config.allowList,this._config.sanitizeFn)),e.innerHTML=t):e.textContent=t)}getTitle(){const e=this._element.getAttribute("data-bs-original-title")||this._config.title;return this._resolvePossibleFunction(e)}updateAttachment(e){return "right"===e?"end":"left"===e?"start":e}_initializeOnDelegatedTarget(e,t){return t||this.constructor.getOrCreateInstance(e.delegateTarget,this._getDelegateConfig())}_getOffset(){const{offset:e}=this._config;return "string"==typeof e?e.split(",").map((e=>Number.parseInt(e,10))):"function"==typeof e?t=>e(t,this._element):e}_resolvePossibleFunction(e){return "function"==typeof e?e.call(this._element):e}_getPopperConfig(e){const t={placement:e,modifiers:[{name:"flip",options:{fallbackPlacements:this._config.fallbackPlacements}},{name:"offset",options:{offset:this._getOffset()}},{name:"preventOverflow",options:{boundary:this._config.boundary}},{name:"arrow",options:{element:`.${this.constructor.NAME}-arrow`}},{name:"onChange",enabled:!0,phase:"afterWrite",fn:e=>this._handlePopperPlacementChange(e)}],onFirstUpdate:e=>{e.options.placement!==e.placement&&this._handlePopperPlacementChange(e);}};return {...t,..."function"==typeof this._config.popperConfig?this._config.popperConfig(t):this._config.popperConfig}}_addAttachmentClass(e){this.getTipElement().classList.add(`${this._getBasicClassPrefix()}-${this.updateAttachment(e)}`);}_getAttachment(e){return AttachmentMap[e.toUpperCase()]}_setListeners(){this._config.trigger.split(" ").forEach((e=>{if("click"===e)EventHandler$2.on(this._element,this.constructor.Event.CLICK,this._config.selector,(e=>this.toggle(e)));else if("manual"!==e){const t="hover"===e?this.constructor.Event.MOUSEENTER:this.constructor.Event.FOCUSIN,i="hover"===e?this.constructor.Event.MOUSELEAVE:this.constructor.Event.FOCUSOUT;EventHandler$2.on(this._element,t,this._config.selector,(e=>this._enter(e))),EventHandler$2.on(this._element,i,this._config.selector,(e=>this._leave(e)));}})),this._hideModalHandler=()=>{this._element&&this.hide();},EventHandler$2.on(this._element.closest(".modal"),"hide.bs.modal",this._hideModalHandler),this._config.selector?this._config={...this._config,trigger:"manual",selector:""}:this._fixTitle();}_fixTitle(){const e=this._element.getAttribute("title"),t=typeof this._element.getAttribute("data-bs-original-title");(e||"string"!==t)&&(this._element.setAttribute("data-bs-original-title",e||""),!e||this._element.getAttribute("aria-label")||this._element.textContent||this._element.setAttribute("aria-label",e),this._element.setAttribute("title",""));}_enter(e,t){t=this._initializeOnDelegatedTarget(e,t),e&&(t._activeTrigger["focusin"===e.type?"focus":"hover"]=!0),t.getTipElement().classList.contains("show")||"show"===t._hoverState?t._hoverState="show":(clearTimeout(t._timeout),t._hoverState="show",t._config.delay&&t._config.delay.show?t._timeout=setTimeout((()=>{"show"===t._hoverState&&t.show();}),t._config.delay.show):t.show());}_leave(e,t){t=this._initializeOnDelegatedTarget(e,t),e&&(t._activeTrigger["focusout"===e.type?"focus":"hover"]=t._element.contains(e.relatedTarget)),t._isWithActiveTrigger()||(clearTimeout(t._timeout),t._hoverState="out",t._config.delay&&t._config.delay.hide?t._timeout=setTimeout((()=>{"out"===t._hoverState&&t.hide();}),t._config.delay.hide):t.hide());}_isWithActiveTrigger(){for(const e in this._activeTrigger)if(this._activeTrigger[e])return !0;return !1}_getConfig(e){const t=Manipulator$1.getDataAttributes(this._element);return Object.keys(t).forEach((e=>{DISALLOWED_ATTRIBUTES.has(e)&&delete t[e];})),(e={...this.constructor.Default,...t,..."object"==typeof e&&e?e:{}}).container=!1===e.container?document.body:getElement$1(e.container),"number"==typeof e.delay&&(e.delay={show:e.delay,hide:e.delay}),"number"==typeof e.title&&(e.title=e.title.toString()),"number"==typeof e.content&&(e.content=e.content.toString()),typeCheckConfig$1(NAME$4$1,e,this.constructor.DefaultType),e.sanitize&&(e.template=sanitizeHtml(e.template,e.allowList,e.sanitizeFn)),e}_getDelegateConfig(){const e={};for(const t in this._config)this.constructor.Default[t]!==this._config[t]&&(e[t]=this._config[t]);return e}_cleanTipClass(){const e=this.getTipElement(),t=new RegExp(`(^|\\s)${this._getBasicClassPrefix()}\\S+`,"g"),i=e.getAttribute("class").match(t);null!==i&&i.length>0&&i.map((e=>e.trim())).forEach((t=>e.classList.remove(t)));}_getBasicClassPrefix(){return "bs-tooltip"}_handlePopperPlacementChange(e){const{state:t}=e;t&&(this.tip=t.elements.popper,this._cleanTipClass(),this._addAttachmentClass(this._getAttachment(t.placement)));}_disposePopper(){this._popper&&(this._popper.destroy(),this._popper=null);}static jQueryInterface(e){return this.each((function(){const t=Tooltip.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e])throw new TypeError(`No method named "${e}"`);t[e]();}}))}}defineJQueryPlugin(Tooltip);const NAME$3$1="popover",Default$2$1={...Tooltip.Default,placement:"right",offset:[0,8],trigger:"click",content:"",template:'<div class="popover" role="tooltip"><div class="popover-arrow"></div><h3 class="popover-header"></h3><div class="popover-body"></div></div>'},DefaultType$2={...Tooltip.DefaultType,content:"(string|element|function)"},Event$1={HIDE:"hide.bs.popover",HIDDEN:"hidden.bs.popover",SHOW:"show.bs.popover",SHOWN:"shown.bs.popover",INSERTED:"inserted.bs.popover",CLICK:"click.bs.popover",FOCUSIN:"focusin.bs.popover",FOCUSOUT:"focusout.bs.popover",MOUSEENTER:"mouseenter.bs.popover",MOUSELEAVE:"mouseleave.bs.popover"},SELECTOR_TITLE=".popover-header";class Popover extends Tooltip{static get Default(){return Default$2$1}static get NAME(){return NAME$3$1}static get Event(){return Event$1}static get DefaultType(){return DefaultType$2}isWithContent(){return this.getTitle()||this._getContent()}setContent(e){this._sanitizeAndSetContent(e,this.getTitle(),SELECTOR_TITLE),this._sanitizeAndSetContent(e,this._getContent(),".popover-body");}_getContent(){return this._resolvePossibleFunction(this._config.content)}_getBasicClassPrefix(){return "bs-popover"}static jQueryInterface(e){return this.each((function(){const t=Popover.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e])throw new TypeError(`No method named "${e}"`);t[e]();}}))}}defineJQueryPlugin(Popover);const NAME$2$1="scrollspy",EVENT_KEY$2$1=".bs.scrollspy",Default$1$1={offset:10,method:"auto",target:""},DefaultType$1={offset:"number",method:"string",target:"(string|element)"},EVENT_ACTIVATE="activate.bs.scrollspy",EVENT_SCROLL="scroll.bs.scrollspy",EVENT_LOAD_DATA_API$3="load.bs.scrollspy.data-api",SELECTOR_DATA_SPY='[data-bs-spy="scroll"]',SELECTOR_LINK_ITEMS=".nav-link, .list-group-item, .dropdown-item";class ScrollSpy extends BaseComponent$1{constructor(e,t){super(e),this._scrollElement="BODY"===this._element.tagName?window:this._element,this._config=this._getConfig(t),this._offsets=[],this._targets=[],this._activeTarget=null,this._scrollHeight=0,EventHandler$2.on(this._scrollElement,EVENT_SCROLL,(()=>this._process())),this.refresh(),this._process();}static get Default(){return Default$1$1}static get NAME(){return NAME$2$1}refresh(){const e=this._scrollElement===this._scrollElement.window?"offset":"position",t="auto"===this._config.method?e:this._config.method,i="position"===t?this._getScrollTop():0;this._offsets=[],this._targets=[],this._scrollHeight=this._getScrollHeight();SelectorEngine$2.find(SELECTOR_LINK_ITEMS,this._config.target).map((e=>{const n=getSelectorFromElement$1(e),s=n?SelectorEngine$2.findOne(n):null;if(s){const e=s.getBoundingClientRect();if(e.width||e.height)return [Manipulator$1[t](s).top+i,n]}return null})).filter((e=>e)).sort(((e,t)=>e[0]-t[0])).forEach((e=>{this._offsets.push(e[0]),this._targets.push(e[1]);}));}dispose(){EventHandler$2.off(this._scrollElement,EVENT_KEY$2$1),super.dispose();}_getConfig(e){return (e={...Default$1$1,...Manipulator$1.getDataAttributes(this._element),..."object"==typeof e&&e?e:{}}).target=getElement$1(e.target)||document.documentElement,typeCheckConfig$1(NAME$2$1,e,DefaultType$1),e}_getScrollTop(){return this._scrollElement===window?this._scrollElement.pageYOffset:this._scrollElement.scrollTop}_getScrollHeight(){return this._scrollElement.scrollHeight||Math.max(document.body.scrollHeight,document.documentElement.scrollHeight)}_getOffsetHeight(){return this._scrollElement===window?window.innerHeight:this._scrollElement.getBoundingClientRect().height}_process(){const e=this._getScrollTop()+this._config.offset,t=this._getScrollHeight(),i=this._config.offset+t-this._getOffsetHeight();if(this._scrollHeight!==t&&this.refresh(),e>=i){const e=this._targets[this._targets.length-1];this._activeTarget!==e&&this._activate(e);}else {if(this._activeTarget&&e<this._offsets[0]&&this._offsets[0]>0)return this._activeTarget=null,void this._clear();for(let t=this._offsets.length;t--;){this._activeTarget!==this._targets[t]&&e>=this._offsets[t]&&(void 0===this._offsets[t+1]||e<this._offsets[t+1])&&this._activate(this._targets[t]);}}}_activate(e){this._activeTarget=e,this._clear();const t=SELECTOR_LINK_ITEMS.split(",").map((t=>`${t}[data-bs-target="${e}"],${t}[href="${e}"]`)),i=SelectorEngine$2.findOne(t.join(","),this._config.target);i.classList.add("active"),i.classList.contains("dropdown-item")?SelectorEngine$2.findOne(".dropdown-toggle",i.closest(".dropdown")).classList.add("active"):SelectorEngine$2.parents(i,".nav, .list-group").forEach((e=>{SelectorEngine$2.prev(e,".nav-link, .list-group-item").forEach((e=>e.classList.add("active"))),SelectorEngine$2.prev(e,".nav-item").forEach((e=>{SelectorEngine$2.children(e,".nav-link").forEach((e=>e.classList.add("active")));}));})),EventHandler$2.trigger(this._scrollElement,EVENT_ACTIVATE,{relatedTarget:e});}_clear(){SelectorEngine$2.find(SELECTOR_LINK_ITEMS,this._config.target).filter((e=>e.classList.contains("active"))).forEach((e=>e.classList.remove("active")));}static jQueryInterface(e){return this.each((function(){const t=ScrollSpy.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e])throw new TypeError(`No method named "${e}"`);t[e]();}}))}}EventHandler$2.on(window,EVENT_LOAD_DATA_API$3,(()=>{SelectorEngine$2.find(SELECTOR_DATA_SPY).forEach((e=>new ScrollSpy(e)));})),defineJQueryPlugin(ScrollSpy);const EVENT_HIDE$1="hide.bs.tab",EVENT_HIDDEN$1$1="hidden.bs.tab",EVENT_SHOW$1$1="show.bs.tab",EVENT_SHOWN$1="shown.bs.tab",EVENT_CLICK_DATA_API$7="click.bs.tab.data-api",SELECTOR_ACTIVE_UL=":scope > li > .active",SELECTOR_DATA_TOGGLE$6='[data-bs-toggle="tab"], [data-bs-toggle="pill"], [data-bs-toggle="list"]',SELECTOR_DROPDOWN_ACTIVE_CHILD=":scope > .dropdown-menu .active";class Tab extends BaseComponent$1{static get NAME(){return "tab"}show(){if(this._element.parentNode&&this._element.parentNode.nodeType===Node.ELEMENT_NODE&&this._element.classList.contains("active"))return;let e;const t=getElementFromSelector$1(this._element),i=this._element.closest(".nav, .list-group");if(i){const t="UL"===i.nodeName||"OL"===i.nodeName?SELECTOR_ACTIVE_UL:".active";e=SelectorEngine$2.find(t,i),e=e[e.length-1];}const n=e?EventHandler$2.trigger(e,EVENT_HIDE$1,{relatedTarget:this._element}):null;if(EventHandler$2.trigger(this._element,EVENT_SHOW$1$1,{relatedTarget:e}).defaultPrevented||null!==n&&n.defaultPrevented)return;this._activate(this._element,i);const s=()=>{EventHandler$2.trigger(e,EVENT_HIDDEN$1$1,{relatedTarget:this._element}),EventHandler$2.trigger(this._element,EVENT_SHOWN$1,{relatedTarget:e});};t?this._activate(t,t.parentNode,s):s();}_activate(e,t,i){const n=(!t||"UL"!==t.nodeName&&"OL"!==t.nodeName?SelectorEngine$2.children(t,".active"):SelectorEngine$2.find(SELECTOR_ACTIVE_UL,t))[0],s=i&&n&&n.classList.contains("fade"),o=()=>this._transitionComplete(e,n,i);n&&s?(n.classList.remove("show"),this._queueCallback(o,e,!0)):o();}_transitionComplete(e,t,i){if(t){t.classList.remove("active");const e=SelectorEngine$2.findOne(SELECTOR_DROPDOWN_ACTIVE_CHILD,t.parentNode);e&&e.classList.remove("active"),"tab"===t.getAttribute("role")&&t.setAttribute("aria-selected",!1);}e.classList.add("active"),"tab"===e.getAttribute("role")&&e.setAttribute("aria-selected",!0),reflow$1(e),e.classList.contains("fade")&&e.classList.add("show");let n=e.parentNode;if(n&&"LI"===n.nodeName&&(n=n.parentNode),n&&n.classList.contains("dropdown-menu")){const t=e.closest(".dropdown");t&&SelectorEngine$2.find(".dropdown-toggle",t).forEach((e=>e.classList.add("active"))),e.setAttribute("aria-expanded",!0);}i&&i();}static jQueryInterface(e){return this.each((function(){const t=Tab.getOrCreateInstance(this);if("string"==typeof e){if(void 0===t[e])throw new TypeError(`No method named "${e}"`);t[e]();}}))}}EventHandler$2.on(document,EVENT_CLICK_DATA_API$7,SELECTOR_DATA_TOGGLE$6,(function(e){if(["A","AREA"].includes(this.tagName)&&e.preventDefault(),isDisabled$1(this))return;Tab.getOrCreateInstance(this).show();})),defineJQueryPlugin(Tab);const NAME$n="toast",EVENT_MOUSEOVER="mouseover.bs.toast",EVENT_MOUSEOUT="mouseout.bs.toast",EVENT_FOCUSIN="focusin.bs.toast",EVENT_FOCUSOUT="focusout.bs.toast",EVENT_HIDE$6="hide.bs.toast",EVENT_HIDDEN$6="hidden.bs.toast",EVENT_SHOW$6="show.bs.toast",EVENT_SHOWN$6="shown.bs.toast",DefaultType$b={animation:"boolean",autohide:"boolean",delay:"number"},Default$b={animation:!0,autohide:!0,delay:5e3};class Toast extends BaseComponent$1{constructor(e,t){super(e),this._config=this._getConfig(t),this._timeout=null,this._hasMouseInteraction=!1,this._hasKeyboardInteraction=!1,this._setListeners();}static get DefaultType(){return DefaultType$b}static get Default(){return Default$b}static get NAME(){return NAME$n}show(){if(EventHandler$2.trigger(this._element,EVENT_SHOW$6).defaultPrevented)return;this._clearTimeout(),this._config.animation&&this._element.classList.add("fade");this._element.classList.remove("hide"),reflow$1(this._element),this._element.classList.add("show"),this._element.classList.add("showing"),this._queueCallback((()=>{this._element.classList.remove("showing"),EventHandler$2.trigger(this._element,EVENT_SHOWN$6),this._maybeScheduleHide();}),this._element,this._config.animation);}hide(){if(!this._element.classList.contains("show"))return;if(EventHandler$2.trigger(this._element,EVENT_HIDE$6).defaultPrevented)return;this._element.classList.add("showing"),this._queueCallback((()=>{this._element.classList.add("hide"),this._element.classList.remove("showing"),this._element.classList.remove("show"),EventHandler$2.trigger(this._element,EVENT_HIDDEN$6);}),this._element,this._config.animation);}dispose(){this._clearTimeout(),this._element.classList.contains("show")&&this._element.classList.remove("show"),super.dispose();}_getConfig(e){return e={...Default$b,...Manipulator$1.getDataAttributes(this._element),..."object"==typeof e&&e?e:{}},typeCheckConfig$1(NAME$n,e,this.constructor.DefaultType),e}_maybeScheduleHide(){this._config.autohide&&(this._hasMouseInteraction||this._hasKeyboardInteraction||(this._timeout=setTimeout((()=>{this.hide();}),this._config.delay)));}_onInteraction(e,t){switch(e.type){case"mouseover":case"mouseout":this._hasMouseInteraction=t;break;case"focusin":case"focusout":this._hasKeyboardInteraction=t;}if(t)return void this._clearTimeout();const i=e.relatedTarget;this._element===i||this._element.contains(i)||this._maybeScheduleHide();}_setListeners(){EventHandler$2.on(this._element,EVENT_MOUSEOVER,(e=>this._onInteraction(e,!0))),EventHandler$2.on(this._element,EVENT_MOUSEOUT,(e=>this._onInteraction(e,!1))),EventHandler$2.on(this._element,EVENT_FOCUSIN,(e=>this._onInteraction(e,!0))),EventHandler$2.on(this._element,EVENT_FOCUSOUT,(e=>this._onInteraction(e,!1)));}_clearTimeout(){clearTimeout(this._timeout),this._timeout=null;}static jQueryInterface(e){return this.each((function(){const t=Toast.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e])throw new TypeError(`No method named "${e}"`);t[e](this);}}))}}enableDismissTrigger$1(Toast),defineJQueryPlugin(Toast);
const loadPlugin=o=>{};var styleNode=document.createElement("style");const __PUBLIC_PATH__=window.__PUBLIC_PATH__?window.__PUBLIC_PATH__:"/bootstrap-italia/dist/fonts";styleNode.innerHTML=`\n/* Titillium+Web:300,400,600,700 */\n\n/* titillium-web-300 - latin-ext_latin */\n@font-face {\n  font-family: 'Titillium Web';\n  font-style: normal;\n  font-weight: 300;\n  src: url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-300.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-300.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-300.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-300.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-300.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-300.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n}\n\n/* titillium-web-300italic - latin-ext_latin */\n@font-face {\n  font-family: 'Titillium Web';\n  font-style: italic;\n  font-weight: 300;\n  src: url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-300italic.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-300italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-300italic.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-300italic.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-300italic.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-300italic.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n}\n\n/* titillium-web-regular - latin-ext_latin */\n@font-face {\n  font-family: 'Titillium Web';\n  font-style: normal;\n  font-weight: 400;\n  src: url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-regular.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-regular.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-regular.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-regular.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-regular.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-regular.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n}\n\n/* titillium-web-italic - latin-ext_latin */\n@font-face {\n  font-family: 'Titillium Web';\n  font-style: italic;\n  font-weight: 400;\n  src: url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-italic.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-italic.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-italic.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-italic.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-italic.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n}\n\n/* titillium-web-700 - latin-ext_latin */\n@font-face {\n  font-family: 'Titillium Web';\n  font-style: normal;\n  font-weight: 700;\n  src: url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-700.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-700.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-700.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-700.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-700.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-700.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n}\n\n/* titillium-web-700italic - latin-ext_latin */\n@font-face {\n  font-family: 'Titillium Web';\n  font-style: italic;\n  font-weight: 700;\n  src: url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-700italic.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-700italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-700italic.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-700italic.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-700italic.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-700italic.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n}\n/* titillium-web-600 - latin-ext_latin */\n@font-face {\n  font-family: 'Titillium Web';\n  font-style: normal;\n  font-weight: 600;\n  src: url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-600.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-600.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-600.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-600.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-600.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-600.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n}\n\n/* titillium-web-600italic - latin-ext_latin */\n@font-face {\n  font-family: 'Titillium Web';\n  font-style: italic;\n  font-weight: 600;\n  src: url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-600italic.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-600italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-600italic.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-600italic.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-600italic.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Titillium_Web/titillium-web-v10-latin-ext_latin-600italic.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n}\n\n/* Lora:400,700 */\n\n/* lora-regular - latin-ext_latin */\n@font-face {\n  font-family: 'Lora';\n  font-style: normal;\n  font-weight: 400;\n  src: url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-regular.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-regular.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-regular.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-regular.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-regular.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-regular.svg#Lora') format('svg'); /* Legacy iOS */\n}\n\n/* lora-700 - latin-ext_latin */\n@font-face {\n  font-family: 'Lora';\n  font-style: normal;\n  font-weight: 700;\n  src: url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-700.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-700.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-700.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-700.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-700.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-700.svg#Lora') format('svg'); /* Legacy iOS */\n}\n\n/* lora-italic - latin-ext_latin */\n@font-face {\n  font-family: 'Lora';\n  font-style: italic;\n  font-weight: 400;\n  src: url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-italic.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-italic.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-italic.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-italic.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-italic.svg#Lora') format('svg'); /* Legacy iOS */\n}\n\n/* lora-700italic - latin-ext_latin */\n@font-face {\n  font-family: 'Lora';\n  font-style: italic;\n  font-weight: 700;\n  src: url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-700italic.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-700italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-700italic.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-700italic.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-700italic.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Lora/lora-v20-latin-ext_latin-700italic.svg#Lora') format('svg'); /* Legacy iOS */\n}\n\n/* Roboto+Mono:400,700 */\n\n/* roboto-mono-regular - latin-ext_latin */\n@font-face {\n  font-family: 'Roboto Mono';\n  font-style: normal;\n  font-weight: 400;\n  src: url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-regular.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-regular.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-regular.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-regular.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-regular.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-regular.svg#RobotoMono') format('svg'); /* Legacy iOS */\n}\n\n/* roboto-mono-700 - latin-ext_latin */\n@font-face {\n  font-family: 'Roboto Mono';\n  font-style: normal;\n  font-weight: 700;\n  src: url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700.svg#RobotoMono') format('svg'); /* Legacy iOS */\n}\n\n/* roboto-mono-italic - latin-ext_latin */\n@font-face {\n  font-family: 'Roboto Mono';\n  font-style: italic;\n  font-weight: 400;\n  src: url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-italic.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-italic.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-italic.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-italic.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-italic.svg#RobotoMono') format('svg'); /* Legacy iOS */\n}\n\n/* roboto-mono-700italic - latin-ext_latin */\n@font-face {\n  font-family: 'Roboto Mono';\n  font-style: italic;\n  font-weight: 700;\n  src: url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700italic.eot'); /* IE9 Compat Modes */\n  src: local(''),\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700italic.woff2') format('woff2'), /* Super Modern Browsers */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700italic.woff') format('woff'), /* Modern Browsers */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700italic.ttf') format('truetype'), /* Safari, Android, iOS */\n       url('${__PUBLIC_PATH__}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700italic.svg#RobotoMono') format('svg'); /* Legacy iOS */\n}\n`,document.getElementsByTagName("head")[0].appendChild(styleNode);var fontsLoader=/*#__PURE__*/Object.freeze({__proto__:null});var icons=/*#__PURE__*/Object.freeze({__proto__:null});const TRANSITION_END="transitionend",getSelector=e=>{let t=e.getAttribute("data-bs-target");if(!t||"#"===t){let n=e.getAttribute("href");if(!n||!n.includes("#")&&!n.startsWith("."))return null;n.includes("#")&&!n.startsWith("#")&&(n=`#${n.split("#")[1]}`),t=n&&"#"!==n?n.trim():null;}return t},getSelectorFromElement=e=>{const t=getSelector(e);return t&&document.querySelector(t)?t:null},getElementFromSelector=e=>{const t=getSelector(e);return t?document.querySelector(t):null},getTransitionDurationFromElement=e=>{if(!e)return 0;let{transitionDuration:t,transitionDelay:n}=window.getComputedStyle(e);const o=Number.parseFloat(t),r=Number.parseFloat(n);return o||r?(t=t.split(",")[0],n=n.split(",")[0],1e3*(Number.parseFloat(t)+Number.parseFloat(n))):0},triggerTransitionEnd=e=>{e.dispatchEvent(new Event(TRANSITION_END));},isElement=e=>!(!e||"object"!=typeof e)&&(void 0!==e.jquery&&(e=e[0]),void 0!==e.nodeType),getElement=e=>isElement(e)?e.jquery?e[0]:e:"string"==typeof e&&e.length>0?document.querySelector(e):null,typeCheckConfig=(e,t,n)=>{Object.keys(n).forEach((o=>{const r=n[o],i=t[o],l=i&&isElement(i)?"element":null==(a=i)?`${a}`:{}.toString.call(a).match(/\s([a-z]+)/i)[1].toLowerCase();var a;if(!new RegExp(r).test(l))throw new TypeError(`${e.toUpperCase()}: Option "${o}" provided type "${l}" but expected type "${r}".`)}));},isVisible=e=>!(!isElement(e)||0===e.getClientRects().length)&&"visible"===getComputedStyle(e).getPropertyValue("visibility"),isDisabled=e=>!e||e.nodeType!==Node.ELEMENT_NODE||(!!e.classList.contains("disabled")||(void 0!==e.disabled?e.disabled:e.hasAttribute("disabled")&&"false"!==e.getAttribute("disabled"))),reflow=e=>{e.offsetHeight;},getjQuery=()=>{const{jQuery:e}=window;return e&&!document.body.hasAttribute("data-bs-no-jquery")?e:null},execute=e=>{"function"==typeof e&&e();},executeAfterTransition=(e,t,n=!0)=>{if(!n)return void execute(e);const o=getTransitionDurationFromElement(t)+5;let r=!1;const i=({target:n})=>{n===t&&(r=!0,t.removeEventListener(TRANSITION_END,i),execute(e));};t.addEventListener(TRANSITION_END,i),setTimeout((()=>{r||triggerTransitionEnd(t);}),o);};const SelectorEngine={find:(e,t=document.documentElement)=>[].concat(...Element.prototype.querySelectorAll.call(t,e)),findOne:(e,t=document.documentElement)=>Element.prototype.querySelector.call(t,e),children:(e,t)=>[].concat(...e.children).filter((e=>e.matches(t))),parents(e,t){const n=[];let i=e.parentNode;for(;i&&i.nodeType===Node.ELEMENT_NODE&&3!==i.nodeType;)i.matches(t)&&n.push(i),i=i.parentNode;return n},prev(e,t){let n=e.previousElementSibling;for(;n;){if(n.matches(t))return [n];n=n.previousElementSibling;}return []},next(e,t){let n=e.nextElementSibling;for(;n;){if(n.matches(t))return [n];n=n.nextElementSibling;}return []},focusableChildren(e){const t=["a","button","input","textarea","select","details","[tabindex]",'[contenteditable="true"]'].map((e=>`${e}:not([tabindex^="-"])`)).join(", ");return this.find(t,e).filter((e=>!isDisabled(e)&&isVisible(e)))}};var SelectorEngine$1 = SelectorEngine;const SELECTOR_HEADER=".it-header-sticky",SELECTOR_TOGGLER$1=".custom-navbar-toggler",SELECTOR_CLONED=".cloned-element",toggleClonedElement=(e,n=!0)=>{if(!isVisible(SelectorEngine$1.findOne(SELECTOR_TOGGLER$1,e))){const t=SelectorEngine$1.findOne(".menu-wrapper",e);if(n){const n=SelectorEngine$1.findOne(".it-brand-wrapper",e),l=SelectorEngine$1.findOne(".it-search-wrapper",e),E=SelectorEngine$1.findOne(".it-user-wrapper",e),o=n?n.cloneNode(!0):null,i=l?l.cloneNode(!0):null,r=E?E.cloneNode(!0):null;o&&t.insertBefore(o,t.childNodes[0]).classList.add("cloned-element"),i&&t.appendChild(i).classList.add("cloned-element"),r&&(t.appendChild(r).classList.add("cloned-element"),t.appendChild(r).classList.remove("show"));}else SelectorEngine$1.find(SELECTOR_CLONED,e).forEach((e=>{e.parentElement.removeChild(e);}));}};SelectorEngine$1.find(SELECTOR_HEADER).forEach((e=>{var n;(n=e).addEventListener("on.bs.sticky",(()=>toggleClonedElement(n,!0))),n.addEventListener("off.bs.sticky",(()=>toggleClonedElement(n,!1)));}));var headerSticky=/*#__PURE__*/Object.freeze({__proto__:null});var BOOTSTRAP_ITALIA_VERSION = "2.0.4";/*!
 * Splide.js
 * Version  : 3.6.12
 * License  : MIT
 * Copyright: 2022 Naotoshi Fujita
 */const STATES={CREATED:1,MOUNTED:2,IDLE:3,MOVING:4,DESTROYED:5};function empty(t){t.length=0;}function isObject$1(t){return !isNull(t)&&"object"==typeof t}function isArray$1(t){return Array.isArray(t)}function isFunction$1(t){return "function"==typeof t}function isString$1(t){return "string"==typeof t}function isUndefined(t){return void 0===t}function isNull(t){return null===t}function isHTMLElement(t){return t instanceof HTMLElement}function toArray$1(t){return isArray$1(t)?t:[t]}function forEach(t,e){toArray$1(t).forEach(e);}function includes(t,e){return t.indexOf(e)>-1}function push(t,e){return t.push(...toArray$1(e)),t}const arrayProto=Array.prototype;function slice(t,e,n){return arrayProto.slice.call(t,e,n)}function find(t,e){return slice(t).filter(e)[0]}function toggleClass(t,e,n){t&&forEach(e,(e=>{e&&t.classList[n?"add":"remove"](e);}));}function addClass(t,e){toggleClass(t,isString$1(e)?e.split(" "):e,!0);}function append(t,e){forEach(e,t.appendChild.bind(t));}function before(t,e){forEach(t,(t=>{const n=e.parentNode;n&&n.insertBefore(t,e);}));}function matches(t,e){return isHTMLElement(t)&&(t.msMatchesSelector||t.matches).call(t,e)}function children(t,e){return t?slice(t.children).filter((t=>matches(t,e))):[]}function child(t,e){return e?children(t,e)[0]:t.firstElementChild}function forOwn(t,e,n){if(t){let i=Object.keys(t);i=n?i.reverse():i;for(let n=0;n<i.length;n++){const s=i[n];if("__proto__"!==s&&!1===e(t[s],s))break}}return t}function assign(t){return slice(arguments,1).forEach((e=>{forOwn(e,((n,i)=>{t[i]=e[i];}));})),t}function merge(t,e){return forOwn(e,((e,n)=>{isArray$1(e)?t[n]=e.slice():isObject$1(e)?t[n]=merge(isObject$1(t[n])?t[n]:{},e):t[n]=e;})),t}function removeAttribute(t,e){t&&forEach(e,(e=>{t.removeAttribute(e);}));}function setAttribute(t,e,n){isObject$1(e)?forOwn(e,((e,n)=>{setAttribute(t,n,e);})):isNull(n)?removeAttribute(t,e):t.setAttribute(e,String(n));}function create(t,e,n){const i=document.createElement(t);return e&&(isString$1(e)?addClass(i,e):setAttribute(i,e)),n&&append(n,i),i}function style(t,e,n){if(isUndefined(n))return getComputedStyle(t)[e];if(!isNull(n)){const{style:i}=t;n=`${n}`,i[e]!==n&&(i[e]=n);}}function display(t,e){style(t,"display",e);}function focus(t){t.setActive&&t.setActive()||t.focus({preventScroll:!0});}function getAttribute$1(t,e){return t.getAttribute(e)}function hasClass(t,e){return t&&t.classList.contains(e)}function rect(t){return t.getBoundingClientRect()}function remove(t){forEach(t,(t=>{t&&t.parentNode&&t.parentNode.removeChild(t);}));}function measure(t,e){if(isString$1(e)){const n=create("div",{style:`width: ${e}; position: absolute;`},t);e=rect(n).width,remove(n);}return e}function parseHtml(t){return child((new DOMParser).parseFromString(t,"text/html").body)}function prevent(t,e){t.preventDefault(),e&&(t.stopPropagation(),t.stopImmediatePropagation());}function query(t,e){return t&&t.querySelector(e)}function queryAll(t,e){return slice(t.querySelectorAll(e))}function removeClass(t,e){toggleClass(t,e,!1);}function unit(t){return isString$1(t)?t:t?`${t}px`:""}function assert(t,e=""){if(!t)throw new Error(`[splide] ${e}`)}function nextTick(t){setTimeout(t);}const noop=()=>{};function raf(t){return requestAnimationFrame(t)}const{min:min,max:max,floor:floor,ceil:ceil,abs:abs}=Math;function approximatelyEqual(t,e,n){return abs(t-e)<n}function between(t,e,n,i){const s=min(e,n),o=max(e,n);return i?s<t&&t<o:s<=t&&t<=o}function clamp(t,e,n){const i=min(e,n),s=max(e,n);return min(max(i,t),s)}function sign(t){return +(t>0)-+(t<0)}function format(t,e){return forEach(e,(e=>{t=t.replace("%s",`${e}`);})),t}function pad(t){return t<10?`0${t}`:`${t}`}const ids={};function uniqueId(t){return `${t}${pad(ids[t]=(ids[t]||0)+1)}`}function EventBus(){let t={};function e(e,i){n(e,((e,n)=>{const s=t[e];t[e]=s&&s.filter((t=>t._key?t._key!==i:i||t._namespace!==n));}));}function n(t,e){toArray$1(t).join(" ").split(" ").forEach((t=>{const n=t.split(".");e(n[0],n[1]);}));}return {on:function(e,i,s,o=10){n(e,((e,n)=>{t[e]=t[e]||[],push(t[e],{_event:e,_callback:i,_namespace:n,_priority:o,_key:s}).sort(((t,e)=>t._priority-e._priority));}));},off:e,offBy:function(n){forOwn(t,((t,i)=>{e(i,n);}));},emit:function(e){(t[e]||[]).forEach((t=>{t._callback.apply(t,slice(arguments,1));}));},destroy:function(){t={};}}}function EventInterface(t){const{event:e}=t,n={};let i=[];function s(t,e,n){o(t,e,((t,e)=>{i=i.filter((i=>!!(i[0]!==t||i[1]!==e||n&&i[2]!==n)||(t.removeEventListener(e,i[2],i[3]),!1)));}));}function o(t,e,n){forEach(t,(t=>{t&&e.split(" ").forEach(n.bind(null,t));}));}function r(){i=i.filter((t=>s(t[0],t[1]))),e.offBy(n);}return e.on("destroy",r,n),{on:function(t,i,s){e.on(t,i,n,s);},off:function(t){e.off(t,n);},emit:e.emit,bind:function(t,e,n,s){o(t,e,((t,e)=>{i.push([t,e,n,s]),t.addEventListener(e,n,s);}));},unbind:s,destroy:r}}function RequestInterval(t,e,n,i){const{now:s}=Date;let o,r,c=0,l=!0,a=0;function u(){if(!l){const r=s()-o;if(r>=t?(c=1,o=s()):c=r/t,n&&n(c),1===c&&(e(),i&&++a>=i))return d();raf(u);}}function d(){l=!0;}function f(){cancelAnimationFrame(r),c=0,r=0,l=!0;}return {start:function(e){!e&&f(),o=s()-(e?c*t:0),l=!1,raf(u);},rewind:function(){o=s(),c=0,n&&n(c);},pause:d,cancel:f,set:function(e){t=e;},isPaused:function(){return l}}}function State(t){let e=t;return {set:function(t){e=t;},is:function(t){return includes(toArray$1(t),e)}}}function Throttle(t,e){let n;return function(){n||(n=RequestInterval(e||0,(()=>{t.apply(this,arguments),n=null;}),null,1),n.start());}}function Options(t,e,n){const i=Throttle(l);let s,o,r;function c(t){t&&removeEventListener("resize",i);}function l(){const e=find(o,(t=>t[1].matches))||[];e[0]!==r&&function(e){const i=n.breakpoints[e]||s;i.destroy?(t.options=s,t.destroy("completely"===i.destroy)):(t.state.is(5)&&(c(!0),t.mount()),t.options=i);}(r=e[0]);}return {setup:function(){try{merge(n,JSON.parse(getAttribute$1(t.root,"data-splide")));}catch(t){assert(!1,t.message);}s=merge({},n);const{breakpoints:e}=n;if(e){const t="min"===n.mediaQuery;o=Object.keys(e).sort(((e,n)=>t?+n-+e:+e-+n)).map((e=>[e,matchMedia(`(${t?"min":"max"}-width:${e}px)`)])),l();}},mount:function(){o&&addEventListener("resize",i);},destroy:c}}const RTL="rtl",TTB="ttb",ORIENTATION_MAP={marginRight:["marginBottom","marginLeft"],autoWidth:["autoHeight"],fixedWidth:["fixedHeight"],paddingLeft:["paddingTop","paddingRight"],paddingRight:["paddingBottom","paddingLeft"],width:["height"],left:["top","right"],right:["bottom","left"],x:["y"],X:["Y"],Y:["X"],ArrowLeft:["ArrowUp","ArrowRight"],ArrowRight:["ArrowDown","ArrowLeft"]};function Direction(t,e,n){return {resolve:function(t,e){const{direction:i}=n;return ORIENTATION_MAP[t][i!==RTL||e?i===TTB?0:-1:1]||t},orient:function(t){return t*(n.direction===RTL?1:-1)}}}const CLASS_ROOT="splide",CLASS_SLIDE="splide__slide",CLASS_CLONE="splide__slide--clone",CLASS_CONTAINER="splide__slide__container",CLASS_ARROWS="splide__arrows",CLASS_ARROW="splide__arrow",CLASS_ARROW_PREV="splide__arrow--prev",CLASS_ARROW_NEXT="splide__arrow--next",CLASS_PAGINATION="splide__pagination",CLASS_PAGINATION_PAGE="splide__pagination__page",CLASS_SPINNER="splide__spinner",CLASS_ACTIVE="is-active",STATUS_CLASSES=[CLASS_ACTIVE,"is-visible","is-prev","is-next","is-loading"],CLASSES={slide:CLASS_SLIDE,clone:CLASS_CLONE,arrows:CLASS_ARROWS,arrow:CLASS_ARROW,prev:CLASS_ARROW_PREV,next:CLASS_ARROW_NEXT,pagination:CLASS_PAGINATION,page:CLASS_PAGINATION_PAGE,spinner:CLASS_SPINNER};function Elements(t,e,n){const{on:i}=EventInterface(t),{root:s}=t,o={},r=[];let c,l,a,u;function d(){!function(){l=child(s,".splide__slider"),a=query(s,".splide__track"),u=child(a,".splide__list"),assert(a&&u,"A track/list element is missing."),push(r,children(u,`.splide__slide:not(.${CLASS_CLONE})`));const t=h(".splide__autoplay"),e=h(".splide__arrows");assign(o,{root:s,slider:l,track:a,list:u,slides:r,arrows:e,autoplay:t,prev:query(e,".splide__arrow--prev"),next:query(e,".splide__arrow--next"),bar:query(h(".splide__progress"),".splide__progress__bar"),play:query(t,".splide__play"),pause:query(t,".splide__pause")});}(),function(){const t=s.id||uniqueId("splide");s.id=t,a.id=a.id||`${t}-track`,u.id=u.id||`${t}-list`;}(),addClass(s,c=S());}function f(){[s,a,u].forEach((t=>{removeAttribute(t,"style");})),empty(r),removeClass(s,c);}function E(){f(),d();}function p(){removeClass(s,c),addClass(s,c=S());}function h(t){return child(s,t)||child(l,t)}function S(){return [`${CLASS_ROOT}--${n.type}`,`${CLASS_ROOT}--${n.direction}`,n.drag&&`${CLASS_ROOT}--draggable`,n.isNavigation&&`${CLASS_ROOT}--nav`,CLASS_ACTIVE]}return assign(o,{setup:d,mount:function(){i("refresh",E,8),i("updated",p);},destroy:f})}const ROLE="role",ARIA_CONTROLS="aria-controls",ARIA_CURRENT="aria-current",ARIA_LABEL="aria-label",ARIA_HIDDEN="aria-hidden",TAB_INDEX="tabindex",DISABLED="disabled",ARIA_ORIENTATION="aria-orientation",ALL_ATTRIBUTES=[ROLE,ARIA_CONTROLS,ARIA_CURRENT,ARIA_LABEL,ARIA_HIDDEN,ARIA_ORIENTATION,TAB_INDEX,DISABLED],SLIDE="slide",LOOP="loop",FADE="fade";function Slide$1(t,e,n,i){const{on:s,emit:o,bind:r,destroy:c}=EventInterface(t),{Components:l,root:a,options:u}=t,{isNavigation:d,updateOnMove:f}=u,{resolve:E}=l.Direction,p=getAttribute$1(i,"style"),h=n>-1,S=child(i,`.${CLASS_CONTAINER}`),A=u.focusableNodes&&queryAll(i,u.focusableNodes);let _;function g(){const s=h?n:e,o=format(u.i18n.slideX,s+1),r=t.splides.map((t=>t.splide.root.id)).join(" ");setAttribute(i,ARIA_LABEL,o),setAttribute(i,ARIA_CONTROLS,r),setAttribute(i,ROLE,"menuitem"),L(C());}function T(){_||m();}function m(){if(!_){const{index:n}=t;L(C()),function(t){const e=!t&&(!C()||h);setAttribute(i,ARIA_HIDDEN,e||null),setAttribute(i,TAB_INDEX,!e&&u.slideFocus?0:null),A&&A.forEach((t=>{setAttribute(t,TAB_INDEX,e?-1:null);}));t!==hasClass(i,"is-visible")&&(toggleClass(i,"is-visible",t),o(t?"visible":"hidden",I));}(function(){if(t.is(FADE))return C();const e=rect(l.Elements.track),n=rect(i),s=E("left"),o=E("right");return floor(e[s])<=ceil(n[s])&&floor(n[o])<=ceil(e[o])}()),toggleClass(i,"is-prev",e===n-1),toggleClass(i,"is-next",e===n+1);}}function L(t){t!==hasClass(i,CLASS_ACTIVE)&&(toggleClass(i,CLASS_ACTIVE,t),d&&setAttribute(i,ARIA_CURRENT,t||null),o(t?"active":"inactive",I));}function C(){const{index:i}=t;return i===e||u.cloneStatus&&i===n}const I={index:e,slideIndex:n,slide:i,container:S,isClone:h,mount:function(){h||(i.id=`${a.id}-slide${pad(e+1)}`),r(i,"click keydown",(t=>{o("click"===t.type?"click":"slide:keydown",I,t);})),s(["refresh","repositioned","shifted","moved","scrolled"],m),s("navigation:mounted",g),f&&s("move",T);},destroy:function(){_=!0,c(),removeClass(i,STATUS_CLASSES),removeAttribute(i,ALL_ATTRIBUTES),setAttribute(i,"style",p);},update:m,style:function(t,e,n){style(n&&S||i,t,e);},isWithin:function(n,i){let s=abs(n-e);return h||!u.rewind&&!t.is(LOOP)||(s=min(s,t.length-s)),s<=i}};return I}function Slides(t,e,n){const{on:i,emit:s,bind:o}=EventInterface(t),{slides:r,list:c}=e.Elements,l=[];function a(){r.forEach(((t,e)=>{f(t,e,-1);}));}function u(){p((t=>{t.destroy();})),empty(l);}function d(){u(),a();}function f(e,n,i){const s=Slide$1(t,n,i,e);s.mount(),l.push(s);}function E(t){return t?h((t=>!t.isClone)):l}function p(t,e){E(e).forEach(t);}function h(t){return l.filter(isFunction$1(t)?t:e=>isString$1(t)?matches(e.slide,t):includes(toArray$1(t),e.index))}return {mount:function(){a(),i("refresh",d),i(["mounted","refresh"],(()=>{l.sort(((t,e)=>t.index-e.index));}));},destroy:u,update:function(){p((t=>{t.update();}));},register:f,get:E,getIn:function(t){const{Controller:i}=e,s=i.toIndex(t),o=i.hasFocus()?1:n.perPage;return h((t=>between(t.index,s,s+o-1)))},getAt:function(t){return h(t)[0]},add:function(t,e){forEach(t,(t=>{if(isString$1(t)&&(t=parseHtml(t)),isHTMLElement(t)){const i=r[e];i?before(t,i):append(c,t),addClass(t,n.classes.slide),function(t,e){const n=queryAll(t,"img");let{length:i}=n;i?n.forEach((t=>{o(t,"load error",(()=>{--i||e();}));})):e();}(t,s.bind(null,"resize"));}})),s("refresh");},remove:function(t){remove(h(t).map((t=>t.slide))),s("refresh");},forEach:p,filter:h,style:function(t,e,n){p((i=>{i.style(t,e,n);}));},getLength:function(t){return t?r.length:l.length},isEnough:function(){return l.length>n.perPage}}}function Layout(t,e,n){const{on:i,bind:s,emit:o}=EventInterface(t),{Slides:r}=e,{resolve:c}=e.Direction,{root:l,track:a,list:u}=e.Elements,{getAt:d}=r;let f,E;function p(){E=null,f=n.direction===TTB,style(l,"maxWidth",unit(n.width)),style(a,c("paddingLeft"),S(!1)),style(a,c("paddingRight"),S(!0)),h();}function h(){const t=rect(l);E&&E.width===t.width&&E.height===t.height||(style(a,"height",function(){let t="";f&&(t=A(),assert(t,"height or heightRatio is missing."),t=`calc(${t} - ${S(!1)} - ${S(!0)})`);return t}()),r.style(c("marginRight"),unit(n.gap)),r.style("width",(n.autoWidth?"":unit(n.fixedWidth)||(f?"":_()))||null),r.style("height",unit(n.fixedHeight)||(f?n.autoHeight?"":_():A())||null,!0),E=t,o("resized"));}function S(t){const{padding:e}=n,i=c(t?"right":"left");return e&&unit(e[i]||(isObject$1(e)?0:e))||"0px"}function A(){return unit(n.height||rect(u).width*n.heightRatio)}function _(){const t=unit(n.gap);return `calc((100%${t&&` + ${t}`})/${n.perPage||1}${t&&` - ${t}`})`}function g(t,e){const n=d(t);if(n){const t=rect(n.slide)[c("right")],i=rect(u)[c("left")];return abs(t-i)+(e?0:T())}return 0}function T(){const t=d(0);return t&&parseFloat(style(t.slide,c("marginRight")))||0}return {mount:function(){p(),s(window,"resize load",Throttle(o.bind(this,"resize"))),i(["updated","refresh"],p),i("resize",h);},listSize:function(){return rect(u)[c("width")]},slideSize:function(t,e){const n=d(t||0);return n?rect(n.slide)[c("width")]+(e?0:T()):0},sliderSize:function(){return g(t.length-1,!0)-g(-1,!0)},totalSize:g,getPadding:function(t){return parseFloat(style(a,c("padding"+(t?"Right":"Left"))))||0}}}function Clones(t,e,n){const{on:i,emit:s}=EventInterface(t),{Elements:o,Slides:r}=e,{resolve:c}=e.Direction,l=[];let a;function u(){(a=p())&&(!function(e){const i=r.get().slice(),{length:s}=i;if(s){for(;i.length<e;)push(i,i);push(i.slice(-e),i.slice(0,e)).forEach(((c,a)=>{const u=a<e,d=function(e,i){const s=e.cloneNode(!0);return addClass(s,n.classes.clone),s.id=`${t.root.id}-clone${pad(i+1)}`,s}(c.slide,a);u?before(d,i[0].slide):append(o.list,d),push(l,d),r.register(d,a-e+(u?0:s),c.index);}));}}(a),s("resize"));}function d(){remove(l),empty(l);}function f(){d(),u();}function E(){a<p()&&s("refresh");}function p(){let{clones:e}=n;if(t.is(LOOP)){if(!e){const i=measure(o.list,n[c("fixedWidth")]);e=(i&&ceil(rect(o.track)[c("width")]/i)||n[c("autoWidth")]&&t.length||n.perPage)*(n.drag?(n.flickMaxPages||1)+1:2);}}else e=0;return e}return {mount:function(){u(),i("refresh",f),i(["updated","resize"],E);},destroy:d}}function Move(t,e,n){const{on:i,emit:s}=EventInterface(t),{slideSize:o,getPadding:r,totalSize:c,listSize:l,sliderSize:a}=e.Layout,{resolve:u,orient:d}=e.Direction,{list:f,track:E}=e.Elements;let p;function h(){L()||(e.Scroll.cancel(),S(t.index),s("repositioned"));}function S(t){A(g(t,!0));}function A(e,n){if(!t.is(FADE)){const i=n?e:function(e){if(t.is(LOOP)){const t=d(e-T()),n=C(!1,e)&&t<0,i=C(!0,e)&&t>0;(n||i)&&(e=_(e,i));}return e}(e);f.style.transform=`translate${u("X")}(${i}px)`,e!==i&&s("shifted");}}function _(t,e){const n=t-m(e),i=a();return t-=d(i*(ceil(abs(n)/i)||1))*(e?1:-1)}function g(e,i){const s=d(c(e-1)-function(t){const{focus:e}=n;return "center"===e?(l()-o(t,!0))/2:+e*o(t)||0}(e));return i?function(e){n.trimSpace&&t.is(SLIDE)&&(e=clamp(e,0,d(a()-l())));return e}(s):s}function T(){const t=u("left");return rect(f)[t]-rect(E)[t]+d(r(!1))}function m(t){return g(t?e.Controller.getEnd():0,!!n.trimSpace)}function L(){return t.state.is(4)&&n.waitForTransition}function C(t,e){e=isUndefined(e)?T():e;const n=!0!==t&&d(e)<d(m(!1)),i=!1!==t&&d(e)>d(m(!0));return n||i}return {mount:function(){p=e.Transition,i(["mounted","resized","updated","refresh"],h);},destroy:function(){removeAttribute(f,"style");},move:function(i,o,r,c){if(!L()){const{set:l}=t.state,a=T();i!==o&&(p.cancel(),A(_(a,i>o),!0)),l(4),s("move",o,r,i),p.start(o,(()=>{l(3),s("moved",o,r,i),"move"===n.trimSpace&&i!==r&&a===T()?e.Controller.go(i>r?">":"<",!1,c):c&&c();}));}},jump:S,translate:A,shift:_,cancel:function(){A(T()),p.cancel();},toIndex:function(t){const n=e.Slides.get();let i=0,s=1/0;for(let e=0;e<n.length;e++){const o=n[e].index,r=abs(g(o,!0)-t);if(!(r<=s))break;s=r,i=o;}return i},toPosition:g,getPosition:T,getLimit:m,isBusy:L,exceededLimit:C}}function Controller(t,e,n){const{on:i}=EventInterface(t),{Move:s}=e,{getPosition:o,getLimit:r}=s,{isEnough:c,getLength:l}=e.Slides,a=t.is(LOOP),u=t.is(SLIDE);let d,f,E,p=n.start||0,h=p;function S(){d=l(!0),f=n.perMove,E=n.perPage,p=clamp(p,0,d-1);}function A(t,n,i,o,r){const c=n?t:O(t);e.Scroll.scroll(n||i?s.toPosition(c,!0):t,o,(()=>{y(s.toIndex(s.getPosition())),r&&r();}));}function _(t){return T(!1,t)}function g(t){return T(!0,t)}function T(t,e){const n=f||(N()?1:E),i=m(p+n*(t?-1:1),p);return -1===i&&u&&!approximatelyEqual(o(),r(!t),1)?t?0:L():e?i:C(i)}function m(t,e,i){if(c()){const s=L();t<0||t>s?t=between(0,t,e,!0)||between(s,e,t,!0)?I(R(t)):a?f||N()?t:t<0?-(d%E||E):d:n.rewind?t<0?s:0:-1:i||t===e||(t=f?t:I(R(e)+(t<e?-1:1)));}else t=-1;return t}function L(){let t=d-E;return (N()||a&&f)&&(t=d-1),max(t,0)}function C(t){return a?c()?t%d+(t<0?d:0):-1:t}function I(t){return clamp(N()?t:E*t,0,L())}function R(t){return N()||(t=between(t,d-E,d-1)?d-1:t,t=floor(t/E)),t}function O(t){const e=s.toIndex(t);return u?clamp(e,0,L()):e}function y(t){t!==p&&(h=p,p=t);}function N(){return !isUndefined(n.focus)||n.isNavigation}return {mount:function(){S(),i(["updated","refresh"],S,9);},go:function(t,e,i){const o=function(t){let e=p;if(isString$1(t)){const[,n,i]=t.match(/([+\-<>])(\d+)?/)||[];"+"===n||"-"===n?e=m(p+ +`${n}${+i||1}`,p,!0):">"===n?e=i?I(+i):_(!0):"<"===n&&(e=g(!0));}else e=a?t:clamp(t,0,L());return e}(t);if(n.useScroll)A(o,!0,!0,n.speed,i);else {const t=C(o);t>-1&&!s.isBusy()&&(e||t!==p)&&(y(t),s.move(o,t,h,i));}},scroll:A,getNext:_,getPrev:g,getAdjacent:T,getEnd:L,setIndex:y,getIndex:function(t){return t?h:p},toIndex:I,toPage:R,toDest:O,hasFocus:N}}const XML_NAME_SPACE="http://www.w3.org/2000/svg",PATH="m15.5 0.932-4.3 4.38 14.5 14.6-14.5 14.5 4.3 4.4 14.6-14.6 4.4-4.3-4.4-4.4-14.6-14.6z";function Arrows(t,e,n){const{on:i,bind:s,emit:o}=EventInterface(t),{classes:r,i18n:c}=n,{Elements:l,Controller:a}=e;let u,d=l.arrows,f=l.prev,E=l.next;const p={};function h(){if(n.arrows&&(f&&E||(d=create("div",r.arrows),f=S(!0),E=S(!1),u=!0,append(d,[f,E]),before(d,child("slider"===n.arrows&&l.slider||t.root)))),f&&E)if(p.prev)display(d,!1===n.arrows?"none":"");else {const{id:t}=l.track;setAttribute(f,ARIA_CONTROLS,t),setAttribute(E,ARIA_CONTROLS,t),p.prev=f,p.next=E,function(){const{go:t}=a;i(["mounted","moved","updated","refresh","scrolled"],A),s(E,"click",(()=>{t(">",!0);})),s(f,"click",(()=>{t("<",!0);}));}(),o("arrows:mounted",f,E);}}function S(t){return parseHtml(`<button class="${r.arrow} ${t?r.prev:r.next}" type="button"><svg xmlns="${XML_NAME_SPACE}" viewBox="0 0 40 40" width="40" height="40"><path d="${n.arrowPath||PATH}" />`)}function A(){const e=t.index,n=a.getPrev(),i=a.getNext(),s=n>-1&&e<n?c.last:c.prev,r=i>-1&&e>i?c.first:c.next;f.disabled=n<0,E.disabled=i<0,setAttribute(f,ARIA_LABEL,s),setAttribute(E,ARIA_LABEL,r),o("arrows:updated",f,E,n,i);}return {arrows:p,mount:function(){h(),i("updated",h);},destroy:function(){u?remove(d):(removeAttribute(f,ALL_ATTRIBUTES),removeAttribute(E,ALL_ATTRIBUTES));}}}function Autoplay(t,e,n){const{on:i,bind:s,emit:o}=EventInterface(t),r=RequestInterval(n.interval,t.go.bind(t,">"),(function(t){const{bar:e}=l;e&&style(e,"width",100*t+"%"),o("autoplay:playing",t);})),{isPaused:c}=r,{Elements:l}=e;let a,u,d;function f(t){const e=t?"pause":"play",i=l[e];i&&(setAttribute(i,ARIA_CONTROLS,l.track.id),setAttribute(i,ARIA_LABEL,n.i18n[e]),s(i,"click",t?p:E));}function E(){c()&&e.Slides.isEnough()&&(r.start(!n.resetProgress),u=a=d=!1,o("autoplay:play"));}function p(t=!0){c()||(r.pause(),o("autoplay:pause")),d=t;}function h(){d||(a||u?p(!1):E());}function S(){const i=e.Slides.getAt(t.index);r.set(i&&+getAttribute$1(i.slide,"data-splide-interval")||n.interval);}return {mount:function(){const{autoplay:t}=n;t&&(f(!0),f(!1),function(){const{root:t}=l;n.pauseOnHover&&s(t,"mouseenter mouseleave",(t=>{a="mouseenter"===t.type,h();}));n.pauseOnFocus&&s(t,"focusin focusout",(t=>{u="focusin"===t.type,h();}));i(["move","scroll","refresh"],r.rewind),i("move",S);}(),"pause"!==t&&E());},destroy:r.cancel,play:E,pause:p,isPaused:c}}function Cover(t,e,n){const{on:i}=EventInterface(t);function s(t){e.Slides.forEach((e=>{const n=child(e.container||e.slide,"img");n&&n.src&&o(t,n,e);}));}function o(t,e,n){n.style("background",t?`center/cover no-repeat url("${e.src}")`:"",!0),display(e,t?"none":"");}return {mount:function(){n.cover&&(i("lazyload:loaded",((t,e)=>{o(!0,t,e);})),i(["mounted","updated","refresh"],s.bind(null,!0)));},destroy:function(){s(!1);}}}function Scroll(t,e,n){const{on:i,emit:s}=EventInterface(t),{Move:o}=e,{getPosition:r,getLimit:c,exceededLimit:l}=o;let a,u;function d(e,i,p,h){const S=r();let A=1;var _;i=i||(_=abs(e-S),max(_/1.5,800)),u=p,E(),a=RequestInterval(i,f,(i=>{const s=r(),a=(S+(e-S)*function(t){const{easingFunc:e}=n;return e?e(t):1-Math.pow(1-t,4)}(i)-r())*A;var u;o.translate(s+a),t.is(SLIDE)&&!h&&l()&&(A*=.6,abs(a)<10&&(u=l(!1),d(c(!u),600,null,!0)));}),1),s("scroll"),a.start();}function f(){const e=r(),n=o.toIndex(e);between(n,0,t.length-1)||o.translate(o.shift(e,n>0),!0),u&&u(),s("scrolled");}function E(){a&&a.cancel();}function p(){a&&!a.isPaused()&&(E(),f());}return {mount:function(){i("move",E),i(["updated","refresh"],p);},destroy:E,scroll:d,cancel:p}}const SCROLL_LISTENER_OPTIONS={passive:!1,capture:!0},POINTER_DOWN_EVENTS="touchstart mousedown",POINTER_MOVE_EVENTS="touchmove mousemove",POINTER_UP_EVENTS="touchend touchcancel mouseup";function Drag(t,e,n){const{on:i,emit:s,bind:o,unbind:r}=EventInterface(t),{Move:c,Scroll:l,Controller:a}=e,{track:u}=e.Elements,{resolve:d,orient:f}=e.Direction,{getPosition:E,exceededLimit:p}=c;let h,S,A,_,g,T,m,L,C,I=!1;function R(){const{drag:t}=n;$(!t),g="free"===t;}function O(t){if(!L){const{noDrag:e}=n,i=w(t),s=!e||!matches(t.target,e);m=!1,!s||!i&&t.button||(c.isBusy()?prevent(t,!0):(C=i?u:window,A=null,_=null,o(C,POINTER_MOVE_EVENTS,y,SCROLL_LISTENER_OPTIONS),o(C,POINTER_UP_EVENTS,N,SCROLL_LISTENER_OPTIONS),c.cancel(),l.cancel(),v(t)));}}function y(e){if(_||s("drag"),_=e,e.cancelable){const i=P(e)-P(S);if(T){c.translate(h+function(e){return e/(I&&t.is(SLIDE)?5:1)}(i));const n=V(e)-V(S)>200,o=I!==(I=p());(n||o)&&v(e),s("dragging"),m=!0,prevent(e);}else {let{dragMinThreshold:t}=n;t=isObject$1(t)?t:{mouse:0,touch:+t||10},T=abs(i)>(w(e)?t.touch:t.mouse),D()&&prevent(e);}}}function N(i){r(C,POINTER_MOVE_EVENTS,y),r(C,POINTER_UP_EVENTS,N);const{index:o}=t;if(_){if(T||i.cancelable&&D()){const s=function(e){if(t.is(LOOP)||!I){const t=S===_&&A||S,n=P(_)-P(t),i=V(e)-V(t),s=V(e)-V(_)<200;if(i&&s)return n/i}return 0}(i),r=function(t){return E()+sign(t)*min(abs(t)*(n.flickPower||600),g?1/0:e.Layout.listSize()*(n.flickMaxPages||1))}(s);g?a.scroll(r):t.is(FADE)?a.go(o+f(sign(s))):a.go(a.toDest(r),!0),prevent(i);}s("dragged");}else g||E()===c.toPosition(o)||a.go(o,!0);T=!1;}function v(t){A=S,S=t,h=E();}function b(t){!L&&m&&prevent(t,!0);}function D(){return abs(P(_)-P(S))>abs(P(_,!0)-P(S,!0))}function P(t,e){return (w(t)?t.touches[0]:t)[`page${d(e?"Y":"X")}`]}function V(t){return t.timeStamp}function w(t){return "undefined"!=typeof TouchEvent&&t instanceof TouchEvent}function $(t){L=t;}return {mount:function(){o(u,POINTER_MOVE_EVENTS,noop,SCROLL_LISTENER_OPTIONS),o(u,POINTER_UP_EVENTS,noop,SCROLL_LISTENER_OPTIONS),o(u,POINTER_DOWN_EVENTS,O,SCROLL_LISTENER_OPTIONS),o(u,"click",b,{capture:!0}),o(u,"dragstart",prevent),i(["mounted","updated"],R);},disable:$,isDragging:function(){return T}}}const IE_ARROW_KEYS=["Left","Right","Up","Down"];function Keyboard(t,e,n){const{on:i,bind:s,unbind:o}=EventInterface(t),{root:r}=t,{resolve:c}=e.Direction;let l,a;function u(){const{keyboard:t}=n;t&&("focused"===t?(l=r,setAttribute(r,TAB_INDEX,0)):l=window,s(l,"keydown",p));}function d(){o(l,"keydown"),isHTMLElement(l)&&removeAttribute(l,TAB_INDEX);}function f(){const t=a;a=!0,nextTick((()=>{a=t;}));}function E(){d(),u();}function p(e){if(!a){const{key:n}=e,i=includes(IE_ARROW_KEYS,n)?`Arrow${n}`:n;i===c("ArrowLeft")?t.go("<"):i===c("ArrowRight")&&t.go(">");}}return {mount:function(){u(),i("updated",E),i("move",f);},destroy:d,disable:function(t){a=t;}}}const SRCSET_DATA_ATTRIBUTE="data-splide-lazy-srcset",IMAGE_SELECTOR="[data-splide-lazy], [data-splide-lazy-srcset]";function LazyLoad(t,e,n){const{on:i,off:s,bind:o,emit:r}=EventInterface(t),c="sequential"===n.lazyLoad;let l=[],a=0;function u(){f(),d();}function d(){e.Slides.forEach((t=>{queryAll(t.slide,IMAGE_SELECTOR).forEach((e=>{const i=getAttribute$1(e,"data-splide-lazy"),s=getAttribute$1(e,SRCSET_DATA_ATTRIBUTE);if(i!==e.src||s!==e.srcset){const o=n.classes.spinner,r=e.parentElement,c=child(r,`.${o}`)||create("span",o,r);setAttribute(c,ROLE,"presentation"),l.push({_img:e,_Slide:t,src:i,srcset:s,_spinner:c}),!e.src&&display(e,"none");}}));})),c&&h();}function f(){a=0,l=[];}function E(){l=l.filter((e=>{const i=n.perPage*((n.preloadPages||1)+1)-1;return !e._Slide.isWithin(t.index,i)||p(e)})),l.length||s("moved");}function p(t){const{_img:e}=t;addClass(t._Slide.slide,"is-loading"),o(e,"load error",(e=>{!function(t,e){const{_Slide:n}=t;removeClass(n.slide,"is-loading"),e||(remove(t._spinner),display(t._img,""),r("lazyload:loaded",t._img,n),r("resize"));c&&h();}(t,"error"===e.type);})),["srcset","src"].forEach((n=>{t[n]&&(setAttribute(e,n,t[n]),removeAttribute(e,"src"===n?"data-splide-lazy":SRCSET_DATA_ATTRIBUTE));}));}function h(){a<l.length&&p(l[a++]);}return {mount:function(){n.lazyLoad&&(d(),i("refresh",u),c||i(["mounted","refresh","moved","scrolled"],E));},destroy:f}}function Pagination(t,e,n){const{on:i,emit:s,bind:o,unbind:r}=EventInterface(t),{Slides:c,Elements:l,Controller:a}=e,{hasFocus:u,getIndex:d}=a,f=[];let E;function p(){h(),n.pagination&&c.isEnough()&&(!function(){const{length:e}=t,{classes:i,i18n:s,perPage:r}=n,a="slider"===n.pagination&&l.slider||l.root,d=u()?e:ceil(e/r);E=create("ul",i.pagination,a);for(let t=0;t<d;t++){const e=create("li",null,E),n=create("button",{class:i.page,type:"button"},e),l=c.getIn(t).map((t=>t.slide.id)),a=!u()&&r>1?s.pageX:s.slideX;o(n,"click",S.bind(null,t)),setAttribute(n,ARIA_CONTROLS,l.join(" ")),setAttribute(n,ARIA_LABEL,format(a,t+1)),f.push({li:e,button:n,page:t});}}(),s("pagination:mounted",{list:E,items:f},A(t.index)),_());}function h(){E&&(remove(E),f.forEach((t=>{r(t.button,"click");})),empty(f),E=null);}function S(t){a.go(`>${t}`,!0,(()=>{const e=c.getAt(a.toIndex(t));e&&focus(e.slide);}));}function A(t){return f[a.toPage(t)]}function _(){const t=A(d(!0)),e=A(d());t&&(removeClass(t.button,CLASS_ACTIVE),removeAttribute(t.button,ARIA_CURRENT)),e&&(addClass(e.button,CLASS_ACTIVE),setAttribute(e.button,ARIA_CURRENT,!0)),s("pagination:updated",{list:E,items:f},t,e);}return {items:f,mount:function(){p(),i(["updated","refresh"],p),i(["move","scrolled"],_);},destroy:h,getAt:A,update:_}}const TRIGGER_KEYS=[" ","Enter","Spacebar"];function Sync(t,e,n){const{list:i}=e.Elements,s=[];function o(){t.splides.forEach((e=>{var n;!e.isParent&&(n=e.splide,[t,n].forEach((e=>{const i=EventInterface(e),o=e===t?n:t;i.on("move",((t,e,n)=>{o.go(o.is(LOOP)?n:t);})),s.push(i);})));})),n.isNavigation&&function(){const e=EventInterface(t),{on:n}=e;n("click",l),n("slide:keydown",a),n(["mounted","updated"],c),setAttribute(i,ROLE,"menu"),s.push(e),e.emit("navigation:mounted",t.splides);}();}function r(){removeAttribute(i,ALL_ATTRIBUTES),s.forEach((t=>{t.destroy();})),empty(s);}function c(){setAttribute(i,ARIA_ORIENTATION,n.direction!==TTB?"horizontal":null);}function l(e){t.go(e.index);}function a(t,e){includes(TRIGGER_KEYS,e.key)&&(l(t),prevent(e));}return {mount:o,destroy:r,remount:function(){r(),o();}}}function Wheel(t,e,n){const{bind:i}=EventInterface(t);function s(i){if(i.cancelable){const{deltaY:s}=i;if(s){const o=s<0;t.go(o?"<":">"),function(i){return !n.releaseWheel||t.state.is(4)||-1!==e.Controller.getAdjacent(i)}(o)&&prevent(i);}}}return {mount:function(){n.wheel&&i(e.Elements.track,"wheel",s,SCROLL_LISTENER_OPTIONS);}}}var ComponentConstructors=Object.freeze({__proto__:null,Options:Options,Direction:Direction,Elements:Elements,Slides:Slides,Layout:Layout,Clones:Clones,Move:Move,Controller:Controller,Arrows:Arrows,Autoplay:Autoplay,Cover:Cover,Scroll:Scroll,Drag:Drag,Keyboard:Keyboard,LazyLoad:LazyLoad,Pagination:Pagination,Sync:Sync,Wheel:Wheel});const I18N={prev:"Previous slide",next:"Next slide",first:"Go to first slide",last:"Go to last slide",slideX:"Go to slide %s",pageX:"Go to page %s",play:"Start autoplay",pause:"Pause autoplay"},DEFAULTS={type:"slide",speed:400,waitForTransition:!0,perPage:1,cloneStatus:!0,arrows:!0,pagination:!0,interval:5e3,pauseOnHover:!0,pauseOnFocus:!0,resetProgress:!0,keyboard:!0,easing:"cubic-bezier(0.25, 1, 0.5, 1)",drag:!0,direction:"ltr",slideFocus:!0,trimSpace:!0,focusableNodes:"a, button, textarea, input, select, iframe",classes:CLASSES,i18n:I18N};function Fade(t,e,n){const{on:i}=EventInterface(t);return {mount:function(){i(["mounted","refresh"],(()=>{nextTick((()=>{e.Slides.style("transition",`opacity ${n.speed}ms ${n.easing}`);}));}));},start:function(t,n){const{track:i}=e.Elements;style(i,"height",unit(rect(i).height)),nextTick((()=>{n(),style(i,"height","");}));},cancel:noop}}function Slide(t,e,n){const{bind:i}=EventInterface(t),{Move:s,Controller:o}=e,{list:r}=e.Elements;let c;function l(){a("");}function a(t){style(r,"transition",t);}return {mount:function(){i(r,"transitionend",(t=>{t.target===r&&c&&(l(),c());}));},start:function(e,i){const r=s.toPosition(e,!0),l=s.getPosition(),u=function(e){const{rewindSpeed:i}=n;if(t.is(SLIDE)&&i){const t=o.getIndex(!0),n=o.getEnd();if(0===t&&e>=n||t>=n&&0===e)return i}return n.speed}(e);abs(r-l)>=1&&u>=1?(a(`transform ${u}ms ${n.easing}`),s.translate(r,!0),c=i):(s.jump(e),i());},cancel:l}}const _Splide=class{constructor(t,e){this.event=EventBus(),this.Components={},this.state=State(1),this.splides=[],this._options={},this._Extensions={};const n=isString$1(t)?query(document,t):t;assert(n,`${n} is invalid.`),this.root=n,merge(DEFAULTS,_Splide.defaults),merge(merge(this._options,DEFAULTS),e||{});}mount(t,e){const{state:n,Components:i}=this;assert(n.is([1,5]),"Already mounted!"),n.set(1),this._Components=i,this._Transition=e||this._Transition||(this.is(FADE)?Fade:Slide),this._Extensions=t||this._Extensions;return forOwn(assign({},ComponentConstructors,this._Extensions,{Transition:this._Transition}),((t,e)=>{const n=t(this,i,this._options);i[e]=n,n.setup&&n.setup();})),forOwn(i,(t=>{t.mount&&t.mount();})),this.emit("mounted"),addClass(this.root,"is-initialized"),n.set(3),this.emit("ready"),this}sync(t){return this.splides.push({splide:t}),t.splides.push({splide:this,isParent:!0}),this.state.is(3)&&(this._Components.Sync.remount(),t.Components.Sync.remount()),this}go(t){return this._Components.Controller.go(t),this}on(t,e){return this.event.on(t,e,null,20),this}off(t){return this.event.off(t),this}emit(t){return this.event.emit(t,...slice(arguments,1)),this}add(t,e){return this._Components.Slides.add(t,e),this}remove(t){return this._Components.Slides.remove(t),this}is(t){return this._options.type===t}refresh(){return this.emit("refresh"),this}destroy(t=!0){const{event:e,state:n}=this;return n.is(1)?e.on("ready",this.destroy.bind(this,t),this):(forOwn(this._Components,(e=>{e.destroy&&e.destroy(t);}),!0),e.emit("destroy"),e.destroy(),t&&empty(this.splides),n.set(5)),this}get options(){return this._options}set options(t){const{_options:e}=this;merge(e,t),this.state.is(1)||this.emit("updated",e);}get length(){return this._Components.Slides.getLength(!0)}get index(){return this._Components.Controller.getIndex()}};let Splide=_Splide;Splide.defaults={},Splide.STATES=STATES;
const elementMap=new Map;var Data = {set(e,t,n){elementMap.has(e)||elementMap.set(e,new Map);const a=elementMap.get(e);a.has(t)||0===a.size?a.set(t,n):console.error(`Bootstrap doesn't allow more than one instance per element. Bound instance: ${Array.from(a.keys())[0]}.`);},get:(e,t)=>elementMap.has(e)&&elementMap.get(e).get(t)||null,remove(e,t){if(!elementMap.has(e))return;const n=elementMap.get(e);n.delete(t),0===n.size&&elementMap.delete(e);}};const namespaceRegex=/[^.]*(?=\..*)\.|.*/,stripNameRegex=/\..*/,stripUidRegex=/::\d+$/,eventRegistry={};let uidEvent=1;const customEvents={mouseenter:"mouseover",mouseleave:"mouseout"},customEventsRegex=/^(mouseenter|mouseleave)/i,nativeEvents=new Set(["click","dblclick","mouseup","mousedown","contextmenu","mousewheel","DOMMouseScroll","mouseover","mouseout","mousemove","selectstart","selectend","keydown","keypress","keyup","orientationchange","touchstart","touchmove","touchend","touchcancel","pointerdown","pointermove","pointerup","pointerleave","pointercancel","gesturestart","gesturechange","gestureend","focus","blur","change","reset","select","submit","focusin","focusout","load","unload","beforeunload","resize","move","DOMContentLoaded","readystatechange","error","abort","scroll"]);function getUidEvent(e,t){return t&&`${t}::${uidEvent++}`||e.uidEvent||uidEvent++}function getEvent(e){const t=getUidEvent(e);return e.uidEvent=t,eventRegistry[t]=eventRegistry[t]||{},eventRegistry[t]}function bootstrapHandler(e,t){return function n(r){return r.delegateTarget=e,n.oneOff&&EventHandler.off(e,r.type,t),t.apply(e,[r])}}function bootstrapDelegationHandler(e,t,n){return function r(o){const a=e.querySelectorAll(t);for(let{target:l}=o;l&&l!==this;l=l.parentNode)for(let i=a.length;i--;)if(a[i]===l)return o.delegateTarget=l,r.oneOff&&EventHandler.off(e,o.type,t,n),n.apply(l,[o]);return null}}function findHandler(e,t,n=null){const r=Object.keys(e);for(let o=0,a=r.length;o<a;o++){const a=e[r[o]];if(a.originalHandler===t&&a.delegationSelector===n)return a}return null}function normalizeParams(e,t,n){const r="string"==typeof t,o=r?n:t;let a=getTypeEvent(e);return nativeEvents.has(a)||(a=e),[r,o,a]}function addHandler(e,t,n,r,o){if("string"!=typeof t||!e)return;if(n||(n=r,r=null),customEventsRegex.test(t)){const e=e=>function(t){if(!t.relatedTarget||t.relatedTarget!==t.delegateTarget&&!t.delegateTarget.contains(t.relatedTarget))return e.call(this,t)};r?r=e(r):n=e(n);}const[a,l,i]=normalizeParams(t,n,r),s=getEvent(e),u=s[i]||(s[i]={}),c=findHandler(u,l,a?n:null);if(c)return void(c.oneOff=c.oneOff&&o);const d=getUidEvent(l,t.replace(namespaceRegex,"")),v=a?bootstrapDelegationHandler(e,n,r):bootstrapHandler(e,n);v.delegationSelector=a?n:null,v.originalHandler=l,v.oneOff=o,v.uidEvent=d,u[d]=v,e.addEventListener(i,v,a);}function removeHandler(e,t,n,r,o){const a=findHandler(t[n],r,o);a&&(e.removeEventListener(n,a,Boolean(o)),delete t[n][a.uidEvent]);}function removeNamespacedHandlers(e,t,n,r){const o=t[n]||{};Object.keys(o).forEach((a=>{if(a.includes(r)){const r=o[a];removeHandler(e,t,n,r.originalHandler,r.delegationSelector);}}));}function getTypeEvent(e){return e=e.replace(stripNameRegex,""),customEvents[e]||e}const EventHandler={on(e,t,n,r){addHandler(e,t,n,r,!1);},one(e,t,n,r){addHandler(e,t,n,r,!0);},off(e,t,n,r){if("string"!=typeof t||!e)return;const[o,a,l]=normalizeParams(t,n,r),i=l!==t,s=getEvent(e),u=t.startsWith(".");if(void 0!==a){if(!s||!s[l])return;return void removeHandler(e,s,l,a,o?n:null)}u&&Object.keys(s).forEach((n=>{removeNamespacedHandlers(e,s,n,t.slice(1));}));const c=s[l]||{};Object.keys(c).forEach((n=>{const r=n.replace(stripUidRegex,"");if(!i||t.includes(r)){const t=c[n];removeHandler(e,s,l,t.originalHandler,t.delegationSelector);}}));},trigger(e,t,n){if("string"!=typeof t||!e)return null;const r=getjQuery(),o=getTypeEvent(t),a=t!==o,l=nativeEvents.has(o);let i,s=!0,u=!0,c=!1,d=null;return a&&r&&(i=r.Event(t,n),r(e).trigger(i),s=!i.isPropagationStopped(),u=!i.isImmediatePropagationStopped(),c=i.isDefaultPrevented()),l?(d=document.createEvent("HTMLEvents"),d.initEvent(o,s,!0)):d=new CustomEvent(t,{bubbles:s,cancelable:!0}),void 0!==n&&Object.keys(n).forEach((e=>{Object.defineProperty(d,e,{get:()=>n[e]});})),c&&d.preventDefault(),u&&e.dispatchEvent(d),d.defaultPrevented&&void 0!==i&&i.preventDefault(),d}};var EventHandler$1 = EventHandler;class BaseComponent{constructor(t){(t=getElement(t))&&(this._element=t,Data.set(this._element,this.constructor.DATA_KEY,this));}dispose(){Data.remove(this._element,this.constructor.DATA_KEY),EventHandler$1.off(this._element,this.constructor.EVENT_KEY),Object.getOwnPropertyNames(this).forEach((t=>{this[t]=null;}));}_queueCallback(t,e,n=!0){executeAfterTransition(t,e,n);}static getInstance(t){return Data.get(getElement(t),this.DATA_KEY)}static getOrCreateInstance(t,e={}){return this.getInstance(t)||new this(t,"object"==typeof e?e:null)}static get VERSION(){return "5.1.3"}static get NAME(){throw new Error('You have to implement the static method "NAME", for each component!')}static get DATA_KEY(){return `bs.${this.NAME}`}static get EVENT_KEY(){return `.${this.DATA_KEY}`}}const NAME$m="carousel",EVENT_LOAD_DATA_API$1="load.bs.carousel.data-api",SELECTOR_CAROUSEL="[data-bs-carousel-splide]",CONFIG_DEFAULT$1={slideFocus:!0,i18n:{prev:"Slide precedente",next:"Slide successiva",first:"Vai alla prima slide",last:"Vai all’ultima slide",slideX:"Vai alla slide %s",pageX:"Vai a pagina %s",play:"Attiva autoplay",pause:"Pausa autoplay"}},CONFIGS={"it-carousel-landscape-abstract-three-cols":{type:"slide",perPage:3,gap:24,padding:{left:0,right:0},arrows:!1,breakpoints:{768:{perPage:1,gap:24,padding:{left:40,right:40},arrows:!1},992:{perPage:2,gap:24,padding:{left:40,right:40},arrows:!1}}},"it-carousel-landscape-abstract-three-cols-arrow-visible":{type:"slide",perPage:3,gap:24,padding:{left:0,right:0},arrows:!0,breakpoints:{768:{perPage:1,gap:24,padding:{left:40,right:40},arrows:!0},992:{perPage:2,gap:24,padding:{left:40,right:40},arrows:!0}}},"it-big-img":{type:"loop",perPage:1,gap:48,padding:{left:320,right:320},arrows:!1,breakpoints:{768:{perPage:1,gap:0,padding:{left:0,right:0},arrows:!1},992:{perPage:1,gap:24,padding:{left:160,right:160},arrows:!1}}},"it-standard-image":{type:"loop",perPage:3,gap:24,padding:{left:48,right:48},arrows:!1,breakpoints:{768:{perPage:1,gap:24,padding:{left:40,right:40},arrows:!1},992:{perPage:2,gap:24,padding:{left:48,right:48},arrows:!1}}},"it-carousel-landscape-abstract":{type:"slide",perPage:1,gap:24,padding:{left:0,right:0},arrows:!1,breakpoints:{768:{perPage:1,gap:24,padding:{left:0,right:0},arrows:!1},992:{perPage:1,gap:24,padding:{left:24,right:24},arrows:!1}}},"it-calendar-wrapper":{type:"slide",perPage:4,gap:0,padding:{left:0,right:0},arrows:!1,breakpoints:{560:{perPage:1,gap:0,padding:{left:24,right:24},arrows:!1},768:{perPage:2,gap:0,padding:{left:0,right:0},arrows:!1},992:{perPage:3,gap:0,padding:{left:0,right:0},arrows:!1}}}};class CarouselBI extends BaseComponent{constructor(e){super(e),this._config=this._getConfig(),this._splide=new Splide(this._element,this._config),this._init();}dispose(){this._splide.destroy(),super.dispose();}static get NAME(){return NAME$m}_init(){this._splide.mount();}_getConfig(){let e=Object.assign({},CONFIG_DEFAULT$1);return Object.keys(CONFIGS).forEach((a=>{this._element.classList.contains(a)&&(e=Object.assign({},e,CONFIGS[a]));})),e}}EventHandler$1.on(window,EVENT_LOAD_DATA_API$1,(()=>{SelectorEngine$1.find(SELECTOR_CAROUSEL).forEach((e=>{CarouselBI.getOrCreateInstance(e);}));}));var CarouselBI$1 = CarouselBI;const NAME$l="inputlabel",DATA_KEY$a="bs.inputlabel",EVENT_KEY$a=`.${DATA_KEY$a}`,EVENT_FOCUS=`focus${EVENT_KEY$a}`,EVENT_BLUR=`blur${EVENT_KEY$a}`,EVENT_CHANGE$2=`change${EVENT_KEY$a}`;class InputLabel{constructor(e){this._element=e,this._init();}static get NAME(){return NAME$l}_init(){const e=this._getLabel();e&&!e.classList.contains("active")&&(this._labelOut(),this._labelOver(),this._bindEvents());}_bindEvents(){"file"===this._element.getAttribute("type")?EventHandler$1.on(this._element,EVENT_BLUR,(()=>{this._labelOut();})):(EventHandler$1.on(this._element,EVENT_FOCUS,(()=>{this._labelOut();})),EventHandler$1.on(this._element,EVENT_BLUR,(()=>{this._labelOver();})),EventHandler$1.on(this._element,EVENT_CHANGE$2,(()=>{this._labelToggle();})));}_getLabel(){return SelectorEngine$1.findOne('label[for="'+this._element.getAttribute("id")+'"]')}_isEmpty(){return !this._element.value&&!this._element.getAttribute("placeholder")}_labelOut(){const e=this._getLabel();e&&e.classList.add("active");}_labelOver(){if(this._isEmpty()){const e=this._getLabel();e&&e.classList.remove("active");}}_labelToggle(){this._isEmpty()?this._labelOver():this._labelOut();}}var InputLabel$1 = InputLabel;const NAME$k="inputnumber",DATA_KEY$9="bs.inputnumber",EVENT_KEY$9=`.${DATA_KEY$9}`,EVENT_CLICK$8=`click${EVENT_KEY$9}`,EVENT_CHANGE$1=`change${EVENT_KEY$9}`,EVENT_FOCUS_DATA_API=`focus${EVENT_KEY$9}.data-api`,EVENT_CLICK_DATA_API$6=`click${EVENT_KEY$9}.data-api`,CLASS_NAME_ADAPTIVE="input-number-adaptive",CLASS_NAME_PERCENTAGE="input-number-percentage",CLASS_NAME_CURRENCY="input-number-currency",SELECTOR_INPUT='input[data-bs-input][type="number"]';class InputNumber extends BaseComponent{constructor(e){super(e),this._wrapperElement=this._element.closest(".input-number"),this._label=new InputLabel$1(e),this._init(),this._bindEvents();}static get NAME(){return NAME$k}_init(){this._wrapperElement&&this._inputResize();}_bindEvents(){this._wrapperElement&&(SelectorEngine$1.find("button",this._wrapperElement).forEach((e=>{EventHandler$1.on(e,EVENT_CLICK$8,(t=>{t.preventDefault(),this._incrDecr(e.classList.contains("input-number-sub"));}));})),EventHandler$1.on(this._element,EVENT_CHANGE$1,(()=>this._checkLimit())));}_inputResize(){if(this._wrapperElement.classList.contains(CLASS_NAME_ADAPTIVE)){let e=null;this._wrapperElement.classList.contains(CLASS_NAME_PERCENTAGE)||(e="calc(44px + "+this._element.value.length+"ch)"),this._wrapperElement.classList.contains(CLASS_NAME_CURRENCY)&&(e="calc(40px + 44px + "+this._element.value.length+"ch)"),e&&(this._element.style.width=e);}}_incrDecr(e){const t=parseFloat(this._element.value);if(!isNaN(t)){let n=parseFloat(this._element.getAttribute("step"));n||(n=1),this._element.value=t+n*(e?-1:1),EventHandler$1.trigger(this._element,EVENT_CHANGE$1);}}_checkLimit(){const e=parseFloat(this._element.value);if(!isNaN(e)){let t=e;const n=parseFloat(this._element.getAttribute("max")),i=parseFloat(this._element.getAttribute("min"));i&&e<i&&(t=i),n&&e>n&&(t=n),this._element.value=t;}this._inputResize();}}const inputs$3=SelectorEngine$1.find(SELECTOR_INPUT);inputs$3.forEach((e=>{EventHandler$1.one(e,EVENT_FOCUS_DATA_API,(t=>{t.preventDefault(),InputNumber.getOrCreateInstance(e),EventHandler$1.trigger(e,"focus");}));}));const inputsButtons=SelectorEngine$1.find(".input-number button");inputsButtons.forEach((e=>{EventHandler$1.one(e,EVENT_CLICK_DATA_API$6,(t=>{if(e.classList.contains("input-number-add")||e.classList.contains("input-number-sub")){const n=e.closest(".input-number");if(n){const i=SelectorEngine$1.findOne(SELECTOR_INPUT,n);if(i){InputNumber.getInstance(i)||(t.preventDefault(),InputNumber.getOrCreateInstance(i),EventHandler$1.trigger(e,"click"));}}}}));}));var InputNumber$1 = InputNumber;const NAME$j="dimmer",EVENT_CLICK$7="click.bs.dimmer",SELECTOR_DATA_TOGGLE$4='[data-bs-toggle="dimmer"]';class Dimmer extends BaseComponent{constructor(e){super(e),this._isShown=!1,this._isTransitioning=!1,this._init();}static get NAME(){return NAME$j}show(){this._isShown||this._isTransitioning||(this._isShown=!0,this._isAnimated()&&(this._isTransitioning=!0),this._showElement());}hide(){if(!this._isShown||this._isTransitioning)return;this._isShown=!1;const e=this._isAnimated();e&&(this._isTransitioning=!0),this._element.classList.remove("show"),this._queueCallback((()=>this._hideElement()),this._element,e);}_init(){this._element.classList.contains("show")&&this.show();}_isAnimated(){return this._element.classList.contains("fade")}_showElement(){const e=this._isAnimated();this._element.style.display="flex",this._element.removeAttribute("aria-hidden"),e&&reflow(this._element),this._element.classList.add("show");this._queueCallback((()=>{this._isTransitioning=!1;}),this._element,e);}_hideElement(){this._element.style.display="none",this._element.setAttribute("aria-hidden",!0),this._isTransitioning=!1;}}SelectorEngine$1.find(SELECTOR_DATA_TOGGLE$4).forEach((e=>{const t=getElementFromSelector(e),i=Dimmer.getOrCreateInstance(t);EventHandler$1.on(e,EVENT_CLICK$7,(()=>{e.checked?i.show():i.hide();})),e.checked&&i.show();}));var Dimmer$1 = Dimmer;function normalizeData(t){return "true"===t||"false"!==t&&(t===Number(t).toString()?Number(t):""===t||"null"===t?null:t)}function normalizeDataKey(t){return t.replace(/[A-Z]/g,(t=>`-${t.toLowerCase()}`))}const Manipulator={setDataAttribute(t,e,a){t.setAttribute(`data-bs-${normalizeDataKey(e)}`,a);},removeDataAttribute(t,e){t.removeAttribute(`data-bs-${normalizeDataKey(e)}`);},getDataAttributes(t){if(!t)return {};const e={};return Object.keys(t.dataset).filter((t=>t.startsWith("bs"))).forEach((a=>{let r=a.replace(/^bs/,"");r=r.charAt(0).toLowerCase()+r.slice(1,r.length),e[r]=normalizeData(t.dataset[a]);})),e},getDataAttribute:(t,e)=>normalizeData(t.getAttribute(`data-bs-${normalizeDataKey(e)}`)),offset(t){const e=t.getBoundingClientRect();return {top:e.top+window.pageYOffset,left:e.left+window.pageXOffset}},position:t=>({top:t.offsetTop,left:t.offsetLeft})};const enableDismissTrigger=(e,t="hide")=>{const s=`click.dismiss${e.EVENT_KEY}`,i=e.NAME;EventHandler$1.on(document,s,`[data-bs-dismiss="${i}"]`,(function(s){if(["A","AREA"].includes(this.tagName)&&s.preventDefault(),isDisabled(this))return;const n=getElementFromSelector(this)||this.closest(`.${i}`);e.getOrCreateInstance(n)[t]();}));};const NAME$i="notification",DATA_KEY$8="bs.notification",EVENT_KEY$8=`.${DATA_KEY$8}`,EVENT_CLICK_DATA_API$5=`click${EVENT_KEY$8}.data-api`,EVENT_HIDDEN$1=`hidden${EVENT_KEY$8}`,EVENT_SHOW$1=`show${EVENT_KEY$8}`,Default$8={timeout:0},DefaultType={timeout:"number"},SELECTOR_DATA_TOGGLE$3='[data-bs-toggle="notification"]';class Notification extends BaseComponent{constructor(t,e){super(t),this._config=this._getConfig(e),this._isShown=this._element.classList.contains("show"),this._isTransitioning=!1,this._toId=null;}static get NAME(){return NAME$i}show(t,e){if(this._isShown||this._isTransitioning)return;const i=t||this._getElementTimeout(e);this._isShown=!0,this._isAnimated()&&(this._isTransitioning=!0),this._showElement(i);}hide(){if(!this._isShown||this._isTransitioning)return;this._isShown=!1;const t=this._isAnimated();t&&(this._isTransitioning=!0),this._element.classList.remove("show"),this._queueCallback((()=>this._hideElement()),this._element,t);}toggle(t){this._isShown?this.hide():this.show(null,t);}_isAnimated(){return this._element.classList.contains("fade")}_showElement(t){const e=this._isAnimated();this._element.style.display="block",this._element.removeAttribute("aria-hidden"),e&&reflow(this._element),this._element.classList.add("show");this._queueCallback((()=>{this._isTransitioning=!1,t&&this._setTimeout(t,(()=>this.hide()));}),this._element,e);}_hideElement(){this._element.style.display="none",this._element.setAttribute("aria-hidden",!0),this._isTransitioning=!1;}_getConfig(t){return t={...Default$8,...Manipulator.getDataAttributes(this._element),..."object"==typeof t?t:{}},typeCheckConfig(NAME$i,t,DefaultType),t}_getElementTimeout(t){const e=t?parseInt(t.getAttribute("data-bs-timeout")):null;return e>0?e:this._config.timeout}_setTimeout(t,e){this._clearTimeout(),setTimeout(e,t);}_clearTimeout(){this._toId&&(clearTimeout(this._toId),this._toId=null);}}EventHandler$1.on(document,EVENT_CLICK_DATA_API$5,SELECTOR_DATA_TOGGLE$3,(function(t){const e=getElementFromSelector(this);["A","AREA"].includes(this.tagName)&&t.preventDefault(),EventHandler$1.one(e,EVENT_SHOW$1,(t=>{t.defaultPrevented||EventHandler$1.one(e,EVENT_HIDDEN$1,(()=>{isVisible(this)&&this.focus();}));}));Notification.getOrCreateInstance(e).toggle(this);})),enableDismissTrigger(Notification);var Notification$1 = Notification;const NAME$h="cookiebar",DATA_KEY$7="bs.cookiebar",EVENT_KEY$7=`.${DATA_KEY$7}`,COOKIE_NAME="cookies_consent",SELECTOR_ACCEPT='[data-bs-accept="cookiebar"]',EVENT_CLOSE=`close${EVENT_KEY$7}`,EVENT_CLOSED=`closed${EVENT_KEY$7}`,EVENT_LOAD_DATA_API=`load${EVENT_KEY$7}.data-api`,EVENT_CLICK_DATA_API$4=`click${EVENT_KEY$7}.data-api`;class Cookiebar extends BaseComponent{constructor(e){super(e),this._isShown=this._element.classList.contains("show"),this._isTransitioning=!1;}static get NAME(){return NAME$h}static get VERSION(){return "5.0.0"}show(){this._isShown||this._isTransitioning||(this._isShown=!0,this._isAnimated()&&(this._isTransitioning=!0),this._showElement());}hide(){if(!this._isShown||this._isTransitioning)return;this._isShown=!1;const e=this._isAnimated();e&&(this._isTransitioning=!0),this._element.classList.remove("show"),this._queueCallback((()=>this._hideElement()),this._element,e);}accept(e){e=e||this._element;const t=this._getRootElement(e);this._triggerCloseEvent(t).defaultPrevented||(this._setCookieEU(),this.hide());}static clearCookie(){document.cookie=COOKIE_NAME+"=; Path=/; Expires=Thu, 01 Jan 1970 00:00:01 GMT;";}_isAnimated(){return this._element.classList.contains("fade")}_showElement(){const e=this._isAnimated();this._element.removeAttribute("aria-hidden"),this._element.setAttribute("aria-live","polite"),e&&reflow(this._element),this._element.classList.add("show");this._queueCallback((()=>{this._isTransitioning=!1;}),this._element,e);}_hideElement(){this._element.style.display="none",this._element.setAttribute("aria-hidden",!0),this._element.removeAttribute("aria-live"),this._isTransitioning=!1;}_setCookieEU(){var e=new Date;e.setDate(e.getDate()+30);var t=escape("true")+"; expires="+e.toUTCString();document.cookie=COOKIE_NAME+"="+t+"; path=/";}_getRootElement(e){const t=getElementFromSelector(e);let i=null;return t&&(i=t),i||(i=e.closest(".cookiebar")),i}_triggerCloseEvent(e){return EventHandler$1.trigger(e,EVENT_CLOSE)}_removeElement(e){e.classList.remove("show"),e.setAttribute("aria-hidden","true"),e.setAttribute("aria-live","off"),EventHandler$1.trigger(e,EVENT_CLOSED),this.dispose();}static _handleAccept(e){return function(t){t&&t.preventDefault(),e.close(this);}}static _handleConsent(e){return function(t){t&&t.preventDefault(),e.close(this);}}static _getCookieEU(){var e,t,i,s=document.cookie.split(";");for(e=0;e<s.length;e++)if(t=s[e].substring(0,s[e].indexOf("=")),i=s[e].substring(s[e].indexOf("=")+1),(t=t.replace(/^\s+|\s+$/g,""))==COOKIE_NAME)return unescape(i)}}EventHandler$1.on(document,EVENT_CLICK_DATA_API$4,SELECTOR_ACCEPT,(function(e){if(["A","AREA"].includes(this.tagName)&&e.preventDefault(),isDisabled(this))return;const t=getElementFromSelector(this)||this.closest(`.${NAME$h}`);Cookiebar.getOrCreateInstance(t).accept();})),EventHandler$1.on(window,EVENT_LOAD_DATA_API,(function(){if(!Cookiebar._getCookieEU()){document.querySelectorAll(".cookiebar").forEach((e=>{Cookiebar.getOrCreateInstance(e).show();}));}}));var Cookiebar$1 = Cookiebar;const MEDIA_MOBILE="(max-width: 991px)",isScreenMobile=()=>window.matchMedia(MEDIA_MOBILE).matches;const getElementIndex=(e,t)=>{let i=null;return t.forEach(((t,o)=>{t===e&&(i=o);})),i};const focusSimbling=(e,t,i)=>{i={isDirectionTop:!1,isLimit:!1,loop:!1,..."object"==typeof i?i:{}};const o=getElementIndex(e,t);let n=null;if(i.isLimit&&i.isDirectionTop&&o>0)n=t[0];else if(i.isLimit&&o<t.length-1)n=t[t.length-1];else if(i.isDirectionTop){if(!i.loop&&0===o)return;n=t[0===o?t.length-1:o-1];}else {if(!i.loop&&o===t.length-1)return;n=t[o===t.length-1?0:o+1];}n&&n.focus();};const NAME$g="navbarcollapsible",DATA_KEY$6="bs.navbarcollapsible",EVENT_KEY$6=`.${DATA_KEY$6}`,EVENT_CLICK_DATA_API$3=`click${EVENT_KEY$6}.data-api`,EVENT_CLICK$6=`click${EVENT_KEY$6}`,EVENT_KEYUP$2=`keyup${EVENT_KEY$6}`,EVENT_KEYDOWN$2=`keydown${EVENT_KEY$6}`,EVENT_HIDE=`hide${EVENT_KEY$6}`,EVENT_HIDDEN=`hidden${EVENT_KEY$6}`,EVENT_SHOW=`show${EVENT_KEY$6}`,EVENT_SHOWN=`shown${EVENT_KEY$6}`,EVENT_RESIZE$1=`resize${EVENT_KEY$6}`,SELECTOR_DATA_TOGGLE$2='[data-bs-toggle="navbarcollapsible"]',SELECTOR_BTN_CLOSE=".close-div button",SELECTOR_BTN_MENU_CLOSE=".close-menu",SELECTOR_NAVLINK="a.nav-link",SELECTOR_MEGAMENUNAVLINK=".nav-item .list-item";class NavBarCollapsible extends BaseComponent{constructor(e){super(e),this._isShown=this._element.classList.contains("expanded"),this._isTransitioning=!1,this._isMobile=isScreenMobile(),this._isKeyShift=!1,this._currItemIdx=0,this._btnClose=SelectorEngine$1.findOne(SELECTOR_BTN_CLOSE,this._element),this._btnBack=SelectorEngine$1.findOne(".it-back-button",this._element),this._menuWrapper=SelectorEngine$1.findOne(".menu-wrapper",this._element),this._overlay=null,this._setOverlay(),this._menuItems=SelectorEngine$1.find([SELECTOR_NAVLINK,SELECTOR_MEGAMENUNAVLINK,SELECTOR_BTN_MENU_CLOSE].join(","),this._element),this._bindEvents();}static get NAME(){return NAME$g}show(e){if(this._isShown||this._isTransitioning)return;EventHandler$1.trigger(this._element,EVENT_SHOW,{relatedTarget:e}).defaultPrevented||(this._btnBack&&this._btnBack.classList.add("show"),this._isShown=!0,this._showElement());}hide(){if(!this._isShown||this._isTransitioning)return;if(EventHandler$1.trigger(this._element,EVENT_HIDE).defaultPrevented)return;this._isShown=!1;const e=this._isAnimated();e&&(this._isTransitioning=!0),this._btnBack&&this._btnBack.classList.remove("show"),this._overlay&&this._overlay.classList.remove("show"),this._element.classList.remove("expanded"),this._queueCallback((()=>this._hideElement()),this._menuWrapper,e);}toggle(e){this._isShown?this.hide():this.show(e);}dispose(){EventHandler$1.off(window,EVENT_RESIZE$1),super.dispose();}_bindEvents(){EventHandler$1.on(window,EVENT_RESIZE$1,(()=>this._onResize())),this._overlay&&EventHandler$1.on(this._overlay,EVENT_CLICK$6,(()=>this.hide())),EventHandler$1.on(this._btnClose,EVENT_CLICK$6,(e=>{e.preventDefault(),this.hide();})),EventHandler$1.on(this._btnBack,EVENT_CLICK$6,(e=>{e.preventDefault(),this.hide();})),this._menuItems.forEach((e=>{EventHandler$1.on(e,EVENT_KEYDOWN$2,(e=>this._isMobile&&this._onMenuItemKeyDown(e))),EventHandler$1.on(e,EVENT_KEYUP$2,(e=>this._isMobile&&this._onMenuItemKeyUp(e))),EventHandler$1.on(e,EVENT_CLICK$6,(e=>this._isMobile&&this._onMenuItemClick(e)));}));}_onResize(){this._isMobile=isScreenMobile();}_onMenuItemKeyUp(e){"Shift"===e.key&&(this._isKeyShift=!1);}_onMenuItemKeyDown(e){"Shift"===e.key&&(this._isKeyShift=!0),"Tab"===e.key&&(e.preventDefault(),this._focusNext());}_onMenuItemClick(e){this.currItemIdx=getElementIndex(e.currentTarget,this._menuItems);}_isAnimated(){return !0}_isElementHidden(e){return null===e.offsetParent}_showElement(){const e=this._isAnimated();this._element.style.display="block",this._element.removeAttribute("aria-hidden"),this._element.setAttribute("aria-expanded",!0),this._overlay&&(this._overlay.style.display="block"),e&&reflow(this._element),this._element.classList.add("expanded"),this._overlay&&this._overlay.classList.add("show");this._queueCallback((()=>{this._isTransitioning=!1;const e=this._getNextVisibleItem(1);e.item&&(e.item.focus(),this._currItemIdx=e.index),EventHandler$1.trigger(this._element,EVENT_SHOWN);}),this._menuWrapper,e);}_hideElement(){this._overlay&&(this._overlay.style.display="none"),this._element.style.display="none",this._element.setAttribute("aria-hidden",!0),this._element.removeAttribute("aria-expanded"),this._isTransitioning=!1,EventHandler$1.trigger(this._element,EVENT_HIDDEN);}_setOverlay(){this._overlay=SelectorEngine$1.findOne(".overlay",this._element),this._isAnimated&&this._overlay.classList.add("fade");}_focusNext(){let e=this._currItemIdx+(this._isKeyShift?-1:1);e<0?e=this._menuItems.length-1:e>=this._menuItems.length&&(e=0);const t=this._getNextVisibleItem(e,this._isKeyShift);t.item&&(t.item.focus(),this._currItemIdx=t.index);}_getNextVisibleItem(e,t){let i=null,s=null,n=e,E=t?-1:1,_=!1;for(;!(i||n==e&&_);)n==e&&(_=!0),this._isElementHidden(this._menuItems[n])||(i=this._menuItems[n],s=n),n+=E,n<0?n=this._menuItems.length-1:n>=this._menuItems.length&&(n=0);return {item:i,index:s}}}EventHandler$1.on(document,EVENT_CLICK_DATA_API$3,SELECTOR_DATA_TOGGLE$2,(function(e){const t=getElementFromSelector(this);["A","AREA"].includes(this.tagName)&&e.preventDefault(),EventHandler$1.one(t,EVENT_SHOW,(e=>{e.defaultPrevented||EventHandler$1.one(t,EVENT_HIDDEN,(()=>{isVisible(this)&&this.focus();}));}));NavBarCollapsible.getOrCreateInstance(t).toggle(this);}));var NavBarCollapsible$1 = NavBarCollapsible;const NAME$f="accordion",DATA_KEY$5="bs.accordion",EVENT_KEY$5=`.${DATA_KEY$5}`,EVENT_KEYDOWN$1=`keydown${EVENT_KEY$5}`,EVENT_KEYDOWN_DATA_API=`keydown${EVENT_KEY$5}.data-api`,SELECTOR_HEADBTN='.accordion-item > .accordion-header [data-bs-toggle="collapse"]';class Accordion extends BaseComponent{constructor(o){super(o),this._bindEvents();}static get NAME(){return NAME$f}handleKeyDown(o,e,t){const n={ArrowDown:o=>this._focusNext(o),ArrowUp:o=>this._focusPrev(o),Home:o=>this._focusFirst(o),End:o=>this._focusLast(o)};"function"==typeof n[o]&&(t&&t.preventDefault(),n[o](e));}_bindEvents(){SelectorEngine$1.find(SELECTOR_HEADBTN,this._element).forEach((o=>{EventHandler$1.on(o,EVENT_KEYDOWN$1,(o=>{this.handleKeyDown(o.key,o.currentTarget,o);}));}));}_getHeadButtons(){return SelectorEngine$1.find(":scope > "+SELECTOR_HEADBTN,this._element)}_focusNext(o){focusSimbling(o,this._getHeadButtons(),{loop:!0});}_focusPrev(o){focusSimbling(o,this._getHeadButtons(),{isDirectionTop:!0,loop:!0});}_focusFirst(o){focusSimbling(o,this._getHeadButtons(),{isDirectionTop:!0,isLimit:!0});}_focusLast(o){focusSimbling(o,this._getHeadButtons(),{isLimit:!0});}}const accordionToggles=SelectorEngine$1.find(SELECTOR_HEADBTN);accordionToggles.forEach((o=>{EventHandler$1.one(o,EVENT_KEYDOWN_DATA_API,(e=>{const t=o.closest(".accordion");if(t){Accordion.getOrCreateInstance(t).handleKeyDown(e.key,o,e);}}));}));var Accordion$1 = Accordion;var getRandomValues,rnds8=new Uint8Array(16);function rng(){if(!getRandomValues&&!(getRandomValues="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto)||"undefined"!=typeof msCrypto&&"function"==typeof msCrypto.getRandomValues&&msCrypto.getRandomValues.bind(msCrypto)))throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");return getRandomValues(rnds8)}
var REGEX = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;function validate(t){return "string"==typeof t&&REGEX.test(t)}for(var byteToHex=[],i=0;i<256;++i)byteToHex.push((i+256).toString(16).substr(1));function stringify(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,o=(byteToHex[e[t+0]]+byteToHex[e[t+1]]+byteToHex[e[t+2]]+byteToHex[e[t+3]]+"-"+byteToHex[e[t+4]]+byteToHex[e[t+5]]+"-"+byteToHex[e[t+6]]+byteToHex[e[t+7]]+"-"+byteToHex[e[t+8]]+byteToHex[e[t+9]]+"-"+byteToHex[e[t+10]]+byteToHex[e[t+11]]+byteToHex[e[t+12]]+byteToHex[e[t+13]]+byteToHex[e[t+14]]+byteToHex[e[t+15]]).toLowerCase();if(!validate(o))throw TypeError("Stringified UUID is invalid");return o}function v4(r,n,i){var t=(r=r||{}).random||(r.rng||rng)();if(t[6]=15&t[6]|64,t[8]=63&t[8]|128,n){i=i||0;for(var o=0;o<16;++o)n[i+o]=t[o];return n}return stringify(t)}let ticking=!1,callbacks=[];class ScrollCallback{constructor(c,l){this.id=c,this._callback=l;}dispose(){removeCallBack(this.id);}_execute(c){this._callback(c);}}const removeCallBack=c=>{callbacks=callbacks.filter((l=>l.id!==c));},onDocumentScroll=c=>{if(callbacks.length||document.addEventListener("scroll",(c=>{ticking||(window.requestAnimationFrame((()=>{callbacks.forEach((l=>l.cb._execute(c))),ticking=!1;})),ticking=!0);})),"function"==typeof c){const l=new ScrollCallback(v4(),c);return callbacks.push({id:l.id,cb:l}),l}return console.error("[onDocumentScroll] the provided data has to be of type function"),null};var onDocumentScroll$1 = onDocumentScroll;var defaultInstanceSettings={update:null,begin:null,loopBegin:null,changeBegin:null,change:null,changeComplete:null,loopComplete:null,complete:null,loop:1,direction:"normal",autoplay:!0,timelineOffset:0},defaultTweenSettings={duration:1e3,delay:0,endDelay:0,easing:"easeOutElastic(1, .5)",round:0},validTransforms=["translateX","translateY","translateZ","rotate","rotateX","rotateY","rotateZ","scale","scaleX","scaleY","scaleZ","skew","skewX","skewY","perspective","matrix","matrix3d"],cache={CSS:{},springs:{}};function minMax(e,t,n){return Math.min(Math.max(e,t),n)}function stringContains(e,t){return e.indexOf(t)>-1}function applyArguments(e,t){return e.apply(null,t)}var is={arr:function(e){return Array.isArray(e)},obj:function(e){return stringContains(Object.prototype.toString.call(e),"Object")},pth:function(e){return is.obj(e)&&e.hasOwnProperty("totalLength")},svg:function(e){return e instanceof SVGElement},inp:function(e){return e instanceof HTMLInputElement},dom:function(e){return e.nodeType||is.svg(e)},str:function(e){return "string"==typeof e},fnc:function(e){return "function"==typeof e},und:function(e){return void 0===e},nil:function(e){return is.und(e)||null===e},hex:function(e){return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(e)},rgb:function(e){return /^rgb/.test(e)},hsl:function(e){return /^hsl/.test(e)},col:function(e){return is.hex(e)||is.rgb(e)||is.hsl(e)},key:function(e){return !defaultInstanceSettings.hasOwnProperty(e)&&!defaultTweenSettings.hasOwnProperty(e)&&"targets"!==e&&"keyframes"!==e}};function parseEasingParameters(e){var t=/\(([^)]+)\)/.exec(e);return t?t[1].split(",").map((function(e){return parseFloat(e)})):[]}function spring(e,t){var n=parseEasingParameters(e),r=minMax(is.und(n[0])?1:n[0],.1,100),a=minMax(is.und(n[1])?100:n[1],.1,100),i=minMax(is.und(n[2])?10:n[2],.1,100),o=minMax(is.und(n[3])?0:n[3],.1,100),s=Math.sqrt(a/r),u=i/(2*Math.sqrt(a*r)),c=u<1?s*Math.sqrt(1-u*u):0,l=u<1?(u*s-o)/c:-o+s;function g(e){var n=t?t*e/1e3:e;return n=u<1?Math.exp(-n*u*s)*(1*Math.cos(c*n)+l*Math.sin(c*n)):(1+l*n)*Math.exp(-n*s),0===e||1===e?e:1-n}return t?g:function(){var t=cache.springs[e];if(t)return t;for(var n=1/6,r=0,a=0;;)if(1===g(r+=n)){if(++a>=16)break}else a=0;var i=r*n*1e3;return cache.springs[e]=i,i}}function steps(e){return void 0===e&&(e=10),function(t){return Math.ceil(minMax(t,1e-6,1)*e)*(1/e)}}var bezier=function(){var e=.1;function t(e,t){return 1-3*t+3*e}function n(e,t){return 3*t-6*e}function r(e){return 3*e}function a(e,a,i){return ((t(a,i)*e+n(a,i))*e+r(a))*e}function i(e,a,i){return 3*t(a,i)*e*e+2*n(a,i)*e+r(a)}return function(t,n,r,o){if(0<=t&&t<=1&&0<=r&&r<=1){var s=new Float32Array(11);if(t!==n||r!==o)for(var u=0;u<11;++u)s[u]=a(u*e,t,r);return function(e){return t===n&&r===o||0===e||1===e?e:a(c(e),n,o)}}function c(n){for(var o=0,u=1;10!==u&&s[u]<=n;++u)o+=e;--u;var c=o+(n-s[u])/(s[u+1]-s[u])*e,l=i(c,t,r);return l>=.001?function(e,t,n,r){for(var o=0;o<4;++o){var s=i(t,n,r);if(0===s)return t;t-=(a(t,n,r)-e)/s;}return t}(n,c,t,r):0===l?c:function(e,t,n,r,i){var o,s,u=0;do{(o=a(s=t+(n-t)/2,r,i)-e)>0?n=s:t=s;}while(Math.abs(o)>1e-7&&++u<10);return s}(n,o,o+e,t,r)}}}(),penner=function(){var e={linear:function(){return function(e){return e}}},t={Sine:function(){return function(e){return 1-Math.cos(e*Math.PI/2)}},Circ:function(){return function(e){return 1-Math.sqrt(1-e*e)}},Back:function(){return function(e){return e*e*(3*e-2)}},Bounce:function(){return function(e){for(var t,n=4;e<((t=Math.pow(2,--n))-1)/11;);return 1/Math.pow(4,3-n)-7.5625*Math.pow((3*t-2)/22-e,2)}},Elastic:function(e,t){void 0===e&&(e=1),void 0===t&&(t=.5);var n=minMax(e,1,10),r=minMax(t,.1,2);return function(e){return 0===e||1===e?e:-n*Math.pow(2,10*(e-1))*Math.sin((e-1-r/(2*Math.PI)*Math.asin(1/n))*(2*Math.PI)/r)}}};return ["Quad","Cubic","Quart","Quint","Expo"].forEach((function(e,n){t[e]=function(){return function(e){return Math.pow(e,n+2)}};})),Object.keys(t).forEach((function(n){var r=t[n];e["easeIn"+n]=r,e["easeOut"+n]=function(e,t){return function(n){return 1-r(e,t)(1-n)}},e["easeInOut"+n]=function(e,t){return function(n){return n<.5?r(e,t)(2*n)/2:1-r(e,t)(-2*n+2)/2}},e["easeOutIn"+n]=function(e,t){return function(n){return n<.5?(1-r(e,t)(1-2*n))/2:(r(e,t)(2*n-1)+1)/2}};})),e}();function parseEasings(e,t){if(is.fnc(e))return e;var n=e.split("(")[0],r=penner[n],a=parseEasingParameters(e);switch(n){case"spring":return spring(e,t);case"cubicBezier":return applyArguments(bezier,a);case"steps":return applyArguments(steps,a);default:return applyArguments(r,a)}}function selectString(e){try{return document.querySelectorAll(e)}catch(e){return}}function filterArray(e,t){for(var n=e.length,r=arguments.length>=2?arguments[1]:void 0,a=[],i=0;i<n;i++)if(i in e){var o=e[i];t.call(r,o,i,e)&&a.push(o);}return a}function flattenArray(e){return e.reduce((function(e,t){return e.concat(is.arr(t)?flattenArray(t):t)}),[])}function toArray(e){return is.arr(e)?e:(is.str(e)&&(e=selectString(e)||e),e instanceof NodeList||e instanceof HTMLCollection?[].slice.call(e):[e])}function arrayContains(e,t){return e.some((function(e){return e===t}))}function cloneObject(e){var t={};for(var n in e)t[n]=e[n];return t}function replaceObjectProps(e,t){var n=cloneObject(e);for(var r in e)n[r]=t.hasOwnProperty(r)?t[r]:e[r];return n}function mergeObjects(e,t){var n=cloneObject(e);for(var r in t)n[r]=is.und(e[r])?t[r]:e[r];return n}function rgbToRgba(e){var t=/rgb\((\d+,\s*[\d]+,\s*[\d]+)\)/g.exec(e);return t?"rgba("+t[1]+",1)":e}function hexToRgba(e){var t=e.replace(/^#?([a-f\d])([a-f\d])([a-f\d])$/i,(function(e,t,n,r){return t+t+n+n+r+r})),n=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(t);return "rgba("+parseInt(n[1],16)+","+parseInt(n[2],16)+","+parseInt(n[3],16)+",1)"}function hslToRgba(e){var t,n,r,a=/hsl\((\d+),\s*([\d.]+)%,\s*([\d.]+)%\)/g.exec(e)||/hsla\((\d+),\s*([\d.]+)%,\s*([\d.]+)%,\s*([\d.]+)\)/g.exec(e),i=parseInt(a[1],10)/360,o=parseInt(a[2],10)/100,s=parseInt(a[3],10)/100,u=a[4]||1;function c(e,t,n){return n<0&&(n+=1),n>1&&(n-=1),n<1/6?e+6*(t-e)*n:n<.5?t:n<2/3?e+(t-e)*(2/3-n)*6:e}if(0==o)t=n=r=s;else {var l=s<.5?s*(1+o):s+o-s*o,g=2*s-l;t=c(g,l,i+1/3),n=c(g,l,i),r=c(g,l,i-1/3);}return "rgba("+255*t+","+255*n+","+255*r+","+u+")"}function colorToRgb(e){return is.rgb(e)?rgbToRgba(e):is.hex(e)?hexToRgba(e):is.hsl(e)?hslToRgba(e):void 0}function getUnit(e){var t=/[+-]?\d*\.?\d+(?:\.\d+)?(?:[eE][+-]?\d+)?(%|px|pt|em|rem|in|cm|mm|ex|ch|pc|vw|vh|vmin|vmax|deg|rad|turn)?$/.exec(e);if(t)return t[1]}function getTransformUnit(e){return stringContains(e,"translate")||"perspective"===e?"px":stringContains(e,"rotate")||stringContains(e,"skew")?"deg":void 0}function getFunctionValue(e,t){return is.fnc(e)?e(t.target,t.id,t.total):e}function getAttribute(e,t){return e.getAttribute(t)}function convertPxToUnit(e,t,n){if(arrayContains([n,"deg","rad","turn"],getUnit(t)))return t;var r=cache.CSS[t+n];if(!is.und(r))return r;var a=document.createElement(e.tagName),i=e.parentNode&&e.parentNode!==document?e.parentNode:document.body;i.appendChild(a),a.style.position="absolute",a.style.width=100+n;var o=100/a.offsetWidth;i.removeChild(a);var s=o*parseFloat(t);return cache.CSS[t+n]=s,s}function getCSSValue(e,t,n){if(t in e.style){var r=t.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase(),a=e.style[t]||getComputedStyle(e).getPropertyValue(r)||"0";return n?convertPxToUnit(e,a,n):a}}function getAnimationType(e,t){return is.dom(e)&&!is.inp(e)&&(!is.nil(getAttribute(e,t))||is.svg(e)&&e[t])?"attribute":is.dom(e)&&arrayContains(validTransforms,t)?"transform":is.dom(e)&&"transform"!==t&&getCSSValue(e,t)?"css":null!=e[t]?"object":void 0}function getElementTransforms(e){if(is.dom(e)){for(var t,n=e.style.transform||"",r=/(\w+)\(([^)]*)\)/g,a=new Map;t=r.exec(n);)a.set(t[1],t[2]);return a}}function getTransformValue(e,t,n,r){var a=stringContains(t,"scale")?1:0+getTransformUnit(t),i=getElementTransforms(e).get(t)||a;return n&&(n.transforms.list.set(t,i),n.transforms.last=t),r?convertPxToUnit(e,i,r):i}function getOriginalTargetValue(e,t,n,r){switch(getAnimationType(e,t)){case"transform":return getTransformValue(e,t,r,n);case"css":return getCSSValue(e,t,n);case"attribute":return getAttribute(e,t);default:return e[t]||0}}function getRelativeValue(e,t){var n=/^(\*=|\+=|-=)/.exec(e);if(!n)return e;var r=getUnit(e)||0,a=parseFloat(t),i=parseFloat(e.replace(n[0],""));switch(n[0][0]){case"+":return a+i+r;case"-":return a-i+r;case"*":return a*i+r}}function validateValue(e,t){if(is.col(e))return colorToRgb(e);if(/\s/g.test(e))return e;var n=getUnit(e),r=n?e.substr(0,e.length-n.length):e;return t?r+t:r}function getDistance(e,t){return Math.sqrt(Math.pow(t.x-e.x,2)+Math.pow(t.y-e.y,2))}function getCircleLength(e){return 2*Math.PI*getAttribute(e,"r")}function getRectLength(e){return 2*getAttribute(e,"width")+2*getAttribute(e,"height")}function getLineLength(e){return getDistance({x:getAttribute(e,"x1"),y:getAttribute(e,"y1")},{x:getAttribute(e,"x2"),y:getAttribute(e,"y2")})}function getPolylineLength(e){for(var t,n=e.points,r=0,a=0;a<n.numberOfItems;a++){var i=n.getItem(a);a>0&&(r+=getDistance(t,i)),t=i;}return r}function getPolygonLength(e){var t=e.points;return getPolylineLength(e)+getDistance(t.getItem(t.numberOfItems-1),t.getItem(0))}function getTotalLength(e){if(e.getTotalLength)return e.getTotalLength();switch(e.tagName.toLowerCase()){case"circle":return getCircleLength(e);case"rect":return getRectLength(e);case"line":return getLineLength(e);case"polyline":return getPolylineLength(e);case"polygon":return getPolygonLength(e)}}function setDashoffset(e){var t=getTotalLength(e);return e.setAttribute("stroke-dasharray",t),t}function getParentSvgEl(e){for(var t=e.parentNode;is.svg(t)&&is.svg(t.parentNode);)t=t.parentNode;return t}function getParentSvg(e,t){var n=t||{},r=n.el||getParentSvgEl(e),a=r.getBoundingClientRect(),i=getAttribute(r,"viewBox"),o=a.width,s=a.height,u=n.viewBox||(i?i.split(" "):[0,0,o,s]);return {el:r,viewBox:u,x:u[0]/1,y:u[1]/1,w:o,h:s,vW:u[2],vH:u[3]}}function getPath(e,t){var n=is.str(e)?selectString(e)[0]:e,r=t||100;return function(e){return {property:e,el:n,svg:getParentSvg(n),totalLength:getTotalLength(n)*(r/100)}}}function getPathProgress(e,t,n){function r(n){void 0===n&&(n=0);var r=t+n>=1?t+n:0;return e.el.getPointAtLength(r)}var a=getParentSvg(e.el,e.svg),i=r(),o=r(-1),s=r(1),u=n?1:a.w/a.vW,c=n?1:a.h/a.vH;switch(e.property){case"x":return (i.x-a.x)*u;case"y":return (i.y-a.y)*c;case"angle":return 180*Math.atan2(s.y-o.y,s.x-o.x)/Math.PI}}function decomposeValue(e,t){var n=/[+-]?\d*\.?\d+(?:\.\d+)?(?:[eE][+-]?\d+)?/g,r=validateValue(is.pth(e)?e.totalLength:e,t)+"";return {original:r,numbers:r.match(n)?r.match(n).map(Number):[0],strings:is.str(e)||t?r.split(n):[]}}function parseTargets(e){return filterArray(e?flattenArray(is.arr(e)?e.map(toArray):toArray(e)):[],(function(e,t,n){return n.indexOf(e)===t}))}function getAnimatables(e){var t=parseTargets(e);return t.map((function(e,n){return {target:e,id:n,total:t.length,transforms:{list:getElementTransforms(e)}}}))}function normalizePropertyTweens(e,t){var n=cloneObject(t);if(/^spring/.test(n.easing)&&(n.duration=spring(n.easing)),is.arr(e)){var r=e.length;2===r&&!is.obj(e[0])?e={value:e}:is.fnc(t.duration)||(n.duration=t.duration/r);}var a=is.arr(e)?e:[e];return a.map((function(e,n){var r=is.obj(e)&&!is.pth(e)?e:{value:e};return is.und(r.delay)&&(r.delay=n?0:t.delay),is.und(r.endDelay)&&(r.endDelay=n===a.length-1?t.endDelay:0),r})).map((function(e){return mergeObjects(e,n)}))}function flattenKeyframes(e){for(var t=filterArray(flattenArray(e.map((function(e){return Object.keys(e)}))),(function(e){return is.key(e)})).reduce((function(e,t){return e.indexOf(t)<0&&e.push(t),e}),[]),n={},r=function(r){var a=t[r];n[a]=e.map((function(e){var t={};for(var n in e)is.key(n)?n==a&&(t.value=e[n]):t[n]=e[n];return t}));},a=0;a<t.length;a++)r(a);return n}function getProperties(e,t){var n=[],r=t.keyframes;for(var a in r&&(t=mergeObjects(flattenKeyframes(r),t)),t)is.key(a)&&n.push({name:a,tweens:normalizePropertyTweens(t[a],e)});return n}function normalizeTweenValues(e,t){var n={};for(var r in e){var a=getFunctionValue(e[r],t);is.arr(a)&&1===(a=a.map((function(e){return getFunctionValue(e,t)}))).length&&(a=a[0]),n[r]=a;}return n.duration=parseFloat(n.duration),n.delay=parseFloat(n.delay),n}function normalizeTweens(e,t){var n;return e.tweens.map((function(r){var a=normalizeTweenValues(r,t),i=a.value,o=is.arr(i)?i[1]:i,s=getUnit(o),u=getOriginalTargetValue(t.target,e.name,s,t),c=n?n.to.original:u,l=is.arr(i)?i[0]:c,g=getUnit(l)||getUnit(u),f=s||g;return is.und(o)&&(o=c),a.from=decomposeValue(l,f),a.to=decomposeValue(getRelativeValue(o,l),f),a.start=n?n.end:0,a.end=a.start+a.delay+a.duration+a.endDelay,a.easing=parseEasings(a.easing,a.duration),a.isPath=is.pth(i),a.isPathTargetInsideSVG=a.isPath&&is.svg(t.target),a.isColor=is.col(a.from.original),a.isColor&&(a.round=1),n=a,a}))}var setProgressValue={css:function(e,t,n){return e.style[t]=n},attribute:function(e,t,n){return e.setAttribute(t,n)},object:function(e,t,n){return e[t]=n},transform:function(e,t,n,r,a){if(r.list.set(t,n),t===r.last||a){var i="";r.list.forEach((function(e,t){i+=t+"("+e+") ";})),e.style.transform=i;}}};function setTargetsValue(e,t){getAnimatables(e).forEach((function(e){for(var n in t){var r=getFunctionValue(t[n],e),a=e.target,i=getUnit(r),o=getOriginalTargetValue(a,n,i,e),s=getRelativeValue(validateValue(r,i||getUnit(o)),o),u=getAnimationType(a,n);setProgressValue[u](a,n,s,e.transforms,!0);}}));}function createAnimation(e,t){var n=getAnimationType(e.target,t.name);if(n){var r=normalizeTweens(t,e),a=r[r.length-1];return {type:n,property:t.name,animatable:e,tweens:r,duration:a.end,delay:r[0].delay,endDelay:a.endDelay}}}function getAnimations(e,t){return filterArray(flattenArray(e.map((function(e){return t.map((function(t){return createAnimation(e,t)}))}))),(function(e){return !is.und(e)}))}function getInstanceTimings(e,t){var n=e.length,r=function(e){return e.timelineOffset?e.timelineOffset:0},a={};return a.duration=n?Math.max.apply(Math,e.map((function(e){return r(e)+e.duration}))):t.duration,a.delay=n?Math.min.apply(Math,e.map((function(e){return r(e)+e.delay}))):t.delay,a.endDelay=n?a.duration-Math.max.apply(Math,e.map((function(e){return r(e)+e.duration-e.endDelay}))):t.endDelay,a}var instanceID=0;function createNewInstance(e){var t=replaceObjectProps(defaultInstanceSettings,e),n=replaceObjectProps(defaultTweenSettings,e),r=getProperties(n,e),a=getAnimatables(e.targets),i=getAnimations(a,r),o=getInstanceTimings(i,n),s=instanceID;return instanceID++,mergeObjects(t,{id:s,children:[],animatables:a,animations:i,duration:o.duration,delay:o.delay,endDelay:o.endDelay})}var activeInstances=[],engine=function(){var e;function t(n){for(var r=activeInstances.length,a=0;a<r;){var i=activeInstances[a];i.paused?(activeInstances.splice(a,1),r--):(i.tick(n),a++);}e=a>0?requestAnimationFrame(t):void 0;}return "undefined"!=typeof document&&document.addEventListener("visibilitychange",(function(){anime.suspendWhenDocumentHidden&&(isDocumentHidden()?e=cancelAnimationFrame(e):(activeInstances.forEach((function(e){return e._onDocumentVisibility()})),engine()));})),function(){e||isDocumentHidden()&&anime.suspendWhenDocumentHidden||!(activeInstances.length>0)||(e=requestAnimationFrame(t));}}();function isDocumentHidden(){return !!document&&document.hidden}function anime(e){void 0===e&&(e={});var t,n=0,r=0,a=0,i=0,o=null;function s(e){var t=window.Promise&&new Promise((function(e){return o=e}));return e.finished=t,t}var u=createNewInstance(e);s(u);function c(){var e=u.direction;"alternate"!==e&&(u.direction="normal"!==e?"normal":"reverse"),u.reversed=!u.reversed,t.forEach((function(e){return e.reversed=u.reversed}));}function l(e){return u.reversed?u.duration-e:e}function g(){n=0,r=l(u.currentTime)*(1/anime.speed);}function f(e,t){t&&t.seek(e-t.timelineOffset);}function m(e){for(var t=0,n=u.animations,r=n.length;t<r;){var a=n[t],i=a.animatable,o=a.tweens,s=o.length-1,c=o[s];s&&(c=filterArray(o,(function(t){return e<t.end}))[0]||c);for(var l=minMax(e-c.start-c.delay,0,c.duration)/c.duration,g=isNaN(l)?1:c.easing(l),f=c.to.strings,m=c.round,d=[],p=c.to.numbers.length,v=void 0,h=0;h<p;h++){var y=void 0,b=c.to.numbers[h],T=c.from.numbers[h]||0;y=c.isPath?getPathProgress(c.value,g*b,c.isPathTargetInsideSVG):T+g*(b-T),m&&(c.isColor&&h>2||(y=Math.round(y*m)/m)),d.push(y);}var x=f.length;if(x){v=f[0];for(var M=0;M<x;M++){f[M];var A=f[M+1],P=d[M];isNaN(P)||(v+=A?P+A:P+" ");}}else v=d[0];setProgressValue[a.type](i.target,a.property,v,i.transforms),a.currentValue=v,t++;}}function d(e){u[e]&&!u.passThrough&&u[e](u);}function p(e){var g=u.duration,p=u.delay,v=g-u.endDelay,h=l(e);u.progress=minMax(h/g*100,0,100),u.reversePlayback=h<u.currentTime,t&&function(e){if(u.reversePlayback)for(var n=i;n--;)f(e,t[n]);else for(var r=0;r<i;r++)f(e,t[r]);}(h),!u.began&&u.currentTime>0&&(u.began=!0,d("begin")),!u.loopBegan&&u.currentTime>0&&(u.loopBegan=!0,d("loopBegin")),h<=p&&0!==u.currentTime&&m(0),(h>=v&&u.currentTime!==g||!g)&&m(g),h>p&&h<v?(u.changeBegan||(u.changeBegan=!0,u.changeCompleted=!1,d("changeBegin")),d("change"),m(h)):u.changeBegan&&(u.changeCompleted=!0,u.changeBegan=!1,d("changeComplete")),u.currentTime=minMax(h,0,g),u.began&&d("update"),e>=g&&(r=0,u.remaining&&!0!==u.remaining&&u.remaining--,u.remaining?(n=a,d("loopComplete"),u.loopBegan=!1,"alternate"===u.direction&&c()):(u.paused=!0,u.completed||(u.completed=!0,d("loopComplete"),d("complete"),!u.passThrough&&"Promise"in window&&(o(),s(u)))));}return u.reset=function(){var e=u.direction;u.passThrough=!1,u.currentTime=0,u.progress=0,u.paused=!0,u.began=!1,u.loopBegan=!1,u.changeBegan=!1,u.completed=!1,u.changeCompleted=!1,u.reversePlayback=!1,u.reversed="reverse"===e,u.remaining=u.loop,t=u.children;for(var n=i=t.length;n--;)u.children[n].reset();(u.reversed&&!0!==u.loop||"alternate"===e&&1===u.loop)&&u.remaining++,m(u.reversed?u.duration:0);},u._onDocumentVisibility=g,u.set=function(e,t){return setTargetsValue(e,t),u},u.tick=function(e){a=e,n||(n=a),p((a+(r-n))*anime.speed);},u.seek=function(e){p(l(e));},u.pause=function(){u.paused=!0,g();},u.play=function(){u.paused&&(u.completed&&u.reset(),u.paused=!1,activeInstances.push(u),g(),engine());},u.reverse=function(){c(),u.completed=!u.reversed,g();},u.restart=function(){u.reset(),u.play();},u.remove=function(e){removeTargetsFromInstance(parseTargets(e),u);},u.reset(),u.autoplay&&u.play(),u}function removeTargetsFromAnimations(e,t){for(var n=t.length;n--;)arrayContains(e,t[n].animatable.target)&&t.splice(n,1);}function removeTargetsFromInstance(e,t){var n=t.animations,r=t.children;removeTargetsFromAnimations(e,n);for(var a=r.length;a--;){var i=r[a],o=i.animations;removeTargetsFromAnimations(e,o),o.length||i.children.length||r.splice(a,1);}n.length||r.length||t.pause();}function removeTargetsFromActiveInstances(e){for(var t=parseTargets(e),n=activeInstances.length;n--;){removeTargetsFromInstance(t,activeInstances[n]);}}function stagger(e,t){void 0===t&&(t={});var n=t.direction||"normal",r=t.easing?parseEasings(t.easing):null,a=t.grid,i=t.axis,o=t.from||0,s="first"===o,u="center"===o,c="last"===o,l=is.arr(e),g=l?parseFloat(e[0]):parseFloat(e),f=l?parseFloat(e[1]):0,m=getUnit(l?e[1]:e)||0,d=t.start||0+(l?g:0),p=[],v=0;return function(e,t,h){if(s&&(o=0),u&&(o=(h-1)/2),c&&(o=h-1),!p.length){for(var y=0;y<h;y++){if(a){var b=u?(a[0]-1)/2:o%a[0],T=u?(a[1]-1)/2:Math.floor(o/a[0]),x=b-y%a[0],M=T-Math.floor(y/a[0]),A=Math.sqrt(x*x+M*M);"x"===i&&(A=-x),"y"===i&&(A=-M),p.push(A);}else p.push(Math.abs(o-y));v=Math.max.apply(Math,p);}r&&(p=p.map((function(e){return r(e/v)*v}))),"reverse"===n&&(p=p.map((function(e){return i?e<0?-1*e:-e:Math.abs(v-e)})));}return d+(l?(f-g)/v:g)*(Math.round(100*p[t])/100)+m}}function timeline(e){void 0===e&&(e={});var t=anime(e);return t.duration=0,t.add=function(n,r){var a=activeInstances.indexOf(t),i=t.children;function o(e){e.passThrough=!0;}a>-1&&activeInstances.splice(a,1);for(var s=0;s<i.length;s++)o(i[s]);var u=mergeObjects(n,replaceObjectProps(defaultTweenSettings,e));u.targets=u.targets||e.targets;var c=t.duration;u.autoplay=!1,u.direction=t.direction,u.timelineOffset=is.und(r)?c:getRelativeValue(r,c),o(t),t.seek(u.timelineOffset);var l=anime(u);o(l),i.push(l);var g=getInstanceTimings(i,e);return t.delay=g.delay,t.endDelay=g.endDelay,t.duration=g.duration,t.seek(0),t.reset(),t.autoplay&&t.play(),t},t}anime.version="3.2.1",anime.speed=1,anime.suspendWhenDocumentHidden=!0,anime.running=activeInstances,anime.remove=removeTargetsFromActiveInstances,anime.get=getOriginalTargetValue,anime.set=setTargetsValue,anime.convertPx=convertPxToUnit,anime.path=getPath,anime.setDashoffset=setDashoffset,anime.stagger=stagger,anime.timeline=timeline,anime.easing=parseEasings,anime.penner=penner,anime.random=function(e,t){return Math.floor(Math.random()*(t-e+1))+e};const AnimeDefault={duration:800,easing:"easeInOutSine"};const documentScrollTo=(e,o)=>{const t=("object"==typeof o?o:{}).complete,n=window.document.scrollingElement||window.document.body||window.document.documentElement,l=n.style.scrollBehavior;o={scrollTop:e||0,...AnimeDefault,..."object"==typeof o?o:{}},n.style.scrollBehavior="auto",o.complete=e=>{n.style.scrollBehavior=l,"function"==typeof t&&t(e);},anime({targets:n,...o});};const NAME$e="navscroll",SELECTOR_NAVSCROLL="[data-bs-navscroll]",SELECTOR_LIST$1="ul.link-list",SELECTOR_LINK_CONTAINER="li.nav-link, li.nav-item",SELECTOR_CONTAINER=".it-page-sections-container",SELECTOR_TOGGLER=".custom-navbar-toggler",SELECTOR_COLLAPSIBLE=".navbar-collapsable",SELECTOR_PROGRESS_BAR=".it-navscroll-progressbar",Default$7={scrollPadding:10,duration:800,easing:"easeInOutSine"};class NavScroll extends BaseComponent{constructor(e,t){super(e),this._config=this._getConfig(t),this._togglerElement=SelectorEngine$1.findOne(SELECTOR_TOGGLER,this._element),this._sectionContainer=SelectorEngine$1.findOne(SELECTOR_CONTAINER),this._collapsible=this._getCollapsible(),this._isCollapseOpened=!1,this._callbackQueue=[],this._scrollCb=null,this._bindEvents();}static get NAME(){return NAME$e}setScrollPadding(e){this._config.scrollPadding=e;}dispose(){this._scrollCb&&this._scrollCb.dispose(),super.dispose();}_getConfig(e){return e={...Default$7,...Manipulator.getDataAttributes(this._element),..."object"==typeof e?e:{}}}_bindEvents(){this._scrollCb=onDocumentScroll$1((()=>this._onScroll())),this._collapsible&&(EventHandler$1.on(this._collapsible._element,"shown.bs.navbarcollapsible",(()=>this._onCollapseOpened())),EventHandler$1.on(this._collapsible._element,"hidden.bs.navbarcollapsible",(()=>this._onCollapseClosed()))),SelectorEngine$1.find('a.nav-link[href^="#"]',this._element).forEach((e=>{e.addEventListener("click",(t=>{t.preventDefault();const n=()=>this._scrollToHash(e.hash);this._isCollapseOpened?(this._callbackQueue.push(n),this._collapsible.hide()):n();}));})),EventHandler$1.on(window,"load",(()=>{setTimeout((()=>this._onScroll()),150);}));}_onCollapseOpened(){this._isCollapseOpened=!0;}_onCollapseClosed(){for(;this._callbackQueue.length>0;){const e=this._callbackQueue.shift();"function"==typeof e&&e();}this._isCollapseOpened=!1;}_getParentLinks(e){const t=[];let n=e.closest(SELECTOR_LIST$1),o=null,l=!1;for(;n&&!l;){const e=n.closest(SELECTOR_LINK_CONTAINER);if(e){const n=e.querySelector("a.nav-link");n&&t.push(n);}o=n,n=(n.parentElement||n).closest(SELECTOR_LIST$1),n===o&&(l=!0);}return t}_decorateToggler(e){if(this._togglerElement){const t=SelectorEngine$1.findOne(".it-list",this._togglerElement);this._togglerElement.innerText="",this._togglerElement.textContent="",this._togglerElement.append(t),this._togglerElement.append(e);}}_scrollToHash(e){const t=SelectorEngine$1.findOne(e,this._sectionContainer);t&&(documentScrollTo(t.offsetTop-this._getScrollPadding(),{duration:this._config.duration,easing:this._config.easing}),history.pushState?history.pushState(null,null,e):location.hash=e);}_updateProgress(e){const t=SelectorEngine$1.find(SELECTOR_PROGRESS_BAR);if(t){const n=Math.abs(e.getBoundingClientRect().top)/e.getBoundingClientRect().height*100,o=Math.min(100,Math.max(0,n));t.forEach((t=>{e.getBoundingClientRect().top<=0?(t.style.width=o+"%",t.setAttribute("aria-valuenow",o)):(t.style.width="0%",t.setAttribute("aria-valuenow",0));}));}}_onScroll(){const e=this._sectionContainer?this._sectionContainer.offsetTop:0,t=document.scrollingElement.scrollTop-e,n=SelectorEngine$1.find("a.nav-link",this._element),o=this._getScrollPadding();SelectorEngine$1.find(".it-page-section").forEach(((l,i)=>{if(l.offsetTop-e<=t+o&&(SelectorEngine$1.find("a.nav-link.active",this._element).forEach((e=>{e.classList.remove("active");})),i<n.length)){const e=n[i];this._getParentLinks(e).forEach((e=>{e.classList.add("active");})),e.classList.add("active"),this._decorateToggler(e.innerText);}})),this._updateProgress(this._sectionContainer);}_getCollapsible(){const e=SelectorEngine$1.findOne(SELECTOR_COLLAPSIBLE,this._element);return e?NavBarCollapsible$1.getOrCreateInstance(e):null}_getScrollPadding(){return "function"==typeof this._config.scrollPadding?this._config.scrollPadding():this._config.scrollPadding}}const dataApiCb$2=onDocumentScroll$1((()=>{SelectorEngine$1.find(SELECTOR_NAVSCROLL).forEach((e=>{NavScroll.getOrCreateInstance(e);})),dataApiCb$2.dispose();}));var NavScroll$1 = NavScroll;const NAME$d="sticky",EVENT_RESIZE="resize.bs.sticky",CLASS_NAME_WRAPPER="bs-it-sticky-wrapper",DATA_TARGET_MOBILE="data-bs-target-mobile",SELECTOR_DATA_TOGGLE$1='[data-bs-toggle="sticky"]',Default$6={positionType:"sticky",stickyClassName:"",stackable:!1,paddingTop:0};class Sticky extends BaseComponent{constructor(t,e){super(t),this._config=this._getConfig(e),this._isSticky=!1,this._wrapper=null,this._stickyTarget=SelectorEngine$1.findOne(getSelectorFromElement(this._element),this._element)||this._element,this._stickyTargetMobile=SelectorEngine$1.findOne(this._element.getAttribute(DATA_TARGET_MOBILE),this._element)||this._stickyTarget,this._stickyLimit=0,this._stickyLimitMobile=0,this._setLimit(),this._scrollCb=null,this._isMobile=isScreenMobile(),this._prevTop=0,this._onScroll(),this._bindEvents();}dispose(){EventHandler$1.off(window,EVENT_RESIZE),this._scrollCb.dispose(),super.dispose();}static get NAME(){return NAME$d}_getConfig(t){return t={...Default$6,...Manipulator.getDataAttributes(this._element),..."object"==typeof t?t:{}}}_bindEvents(){EventHandler$1.on(window,EVENT_RESIZE,(()=>this._onResize())),this._scrollCb=onDocumentScroll$1((()=>this._onScroll()));}_onResize(){this._isMobile=isScreenMobile(),this._setLimit();}_onScroll(){this._checkSticky();}_setLimit(){this._stickyLimit=this._cumulativeOffset(this._stickyTarget).top,this._stickyLimitMobile=this._cumulativeOffset(this._stickyTargetMobile).top;}_getLimit(){let t=this._isMobile?this._stickyLimitMobile:this._stickyLimit;return this._config.stackable&&this._getStickySimblings().forEach(((e,i)=>{const s=e.getBoundingClientRect();t-=s.height+(0===i?parseFloat(e.style.top):0);})),t>0?t:0}_cumulativeOffset(t){let e=0,i=0;do{e+=t.offsetTop||0,i+=t.offsetLeft||0,t=t.offsetParent;}while(t);return {top:e,left:i}}_isTypeSticky(){return "sticky"===this._config.positionType}_checkSticky(){this._isSticky||this._setLimit();const t=this._getLimit();window.pageYOffset>t?this._setSticky():this._unsetSticky();}_setSticky(){if(!this._isSticky){this._isSticky=!0;let t="bs-is-sticky";this._isTypeSticky()||(t="bs-is-fixed",this._wrapper=this._createWrapper()),this._element.classList.add(t),this._config.stickyClassName&&this._element.classList.add(this._config.stickyClassName),this._prevTop=this._element.style.top,this._element.style.top=this._getPositionTop()+"px",EventHandler$1.trigger(this._element,"on.bs.sticky");}}_unsetSticky(){if(this._isSticky){let t="bs-is-sticky";this._isTypeSticky()||(t="bs-is-fixed",this._destroyWrapper()),this._element.classList.remove(t),this._config.stickyClassName&&this._element.classList.remove(this._config.stickyClassName),this._element.style.top=this._prevTop,this._isSticky=!1,EventHandler$1.trigger(this._element,"off.bs.sticky");}}_createWrapper(){const t=document.createElement("div");return t.classList.add(CLASS_NAME_WRAPPER),t.style.width="100%",t.style.height=this._element.getBoundingClientRect().height+"px",t.style.overflow="hidden",this._element.parentNode.insertBefore(t,this._element),t.appendChild(this._element),t}_destroyWrapper(){this._wrapper&&(this._wrapper.parentNode.insertBefore(this._element,this._wrapper),this._wrapper.remove());}_getStickySimblings(){return SelectorEngine$1.find(SELECTOR_DATA_TOGGLE$1).filter((t=>{const e=Sticky.getInstance(t);return !(!e||!e._isSticky||t===this._element)}))}_getPositionTop(){let t=0;return this._config.stackable?(this._getStickySimblings().forEach(((e,i)=>{const s=e.getBoundingClientRect();t+=s.height+(0===i?parseFloat(e.style.top):0);})),t):t+this._config.paddingTop}}const dataApiCb$1=onDocumentScroll$1((()=>{SelectorEngine$1.find(SELECTOR_DATA_TOGGLE$1).forEach((t=>{Sticky.getOrCreateInstance(t);})),dataApiCb$1.dispose();}));var Sticky$1 = Sticky;const DATA_MOUSE_FOCUS="data-focus-mouse";class TrackFocus{constructor(){this._usingMouse=!1,this._bindEvents();}_bindEvents(){["keydown","mousedown"].forEach((t=>{document.addEventListener(t,(t=>{this._usingMouse="mousedown"===t.type;}));})),document.addEventListener("focusin",(t=>{this._usingMouse&&t.target&&(t.target.classList.add("focus--mouse"),t.target.setAttribute(DATA_MOUSE_FOCUS,!0));})),document.addEventListener("focusout",(t=>{t.target&&(t.target.classList.remove("focus--mouse"),t.target.setAttribute(DATA_MOUSE_FOCUS,!1));}));}}new TrackFocus;var TrackFocus$1 = TrackFocus;var __defProp=Object.defineProperty,__getOwnPropSymbols=Object.getOwnPropertySymbols,__hasOwnProp=Object.prototype.hasOwnProperty,__propIsEnum=Object.prototype.propertyIsEnumerable,__defNormalProp=(e,i,s)=>i in e?__defProp(e,i,{enumerable:!0,configurable:!0,writable:!0,value:s}):e[i]=s,__spreadValues=(e,i)=>{for(var s in i||(i={}))__hasOwnProp.call(i,s)&&__defNormalProp(e,s,i[s]);if(__getOwnPropSymbols)for(var s of __getOwnPropSymbols(i))__propIsEnum.call(i,s)&&__defNormalProp(e,s,i[s]);return e},__publicField=(e,i,s)=>(__defNormalProp(e,"symbol"!=typeof i?i+"":i,s),s);const EMAIL_REGEXP=/^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,NUMBER_REGEXP=/^[0-9]+$/,PASSWORD_REGEXP=/^(?=.*[A-Za-z])(?=.*\d)[A-Za-z\d]{8,}$/,STRONG_PASSWORD_REGEXP=/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/,isEmpty=e=>{let i=e;return "string"==typeof e&&(i=e.trim()),!i},isLengthMoreThanMax=(e,i)=>e.length>i,isLengthLessThanMin=(e,i)=>e.length<i,isNumber=e=>NUMBER_REGEXP.test(e),isPassword=e=>PASSWORD_REGEXP.test(e),isStrongPassword=e=>STRONG_PASSWORD_REGEXP.test(e),isNumberMoreThanMax=(e,i)=>e>i,isNumberLessThanMin=(e,i)=>e<i;var Rules,GroupRules,CustomStyleTagIds;!function(e){e.Required="required",e.Email="email",e.MinLength="minLength",e.MaxLength="maxLength",e.Password="password",e.Number="number",e.MaxNumber="maxNumber",e.MinNumber="minNumber",e.StrongPassword="strongPassword",e.CustomRegexp="customRegexp",e.MinFilesCount="minFilesCount",e.MaxFilesCount="maxFilesCount",e.Files="files";}(Rules||(Rules={})),(GroupRules||(GroupRules={})).Required="required",function(e){e.Label="label",e.LabelArrow="labelArrow";}(CustomStyleTagIds||(CustomStyleTagIds={}));const getDefaultFieldMessage=(e,i)=>{switch(e){case Rules.Required:return "The field is required";case Rules.Email:return "Email has invalid format";case Rules.MaxLength:return "The field must contain a maximum of :value characters".replace(":value",String(i));case Rules.MinLength:return "The field must contain a minimum of :value characters".replace(":value",String(i));case Rules.Password:return "Password must contain minimum eight characters, at least one letter and one number";case Rules.Number:return "Value should be a number";case Rules.StrongPassword:return "Password should contain minimum eight characters, at least one uppercase letter, one lowercase letter, one number and one special character";case Rules.MaxNumber:return "Number should be less or equal than :value".replace(":value",String(i));case Rules.MinNumber:return "Number should be more or equal than :value".replace(":value",String(i));case Rules.MinFilesCount:return "Files count should be more or equal than :value".replace(":value",String(i));case Rules.MaxFilesCount:return "Files count should be less or equal than :value".replace(":value",String(i));case Rules.Files:return "Uploaded files have one or several invalid properties (extension/size/type etc)";default:return "Value is incorrect"}},isPromise=e=>!!e&&"function"==typeof e.then,errorLabelCss=".just-validate-error-label[data-tooltip=true]{position:fixed;padding:4px 8px;background:#423f3f;color:#fff;white-space:nowrap;z-index:10;border-radius:4px;transform:translateY(-5px)}.just-validate-error-label[data-tooltip=true]:before{content:'';width:0;height:0;border-left:solid 5px transparent;border-right:solid 5px transparent;border-bottom:solid 5px #423f3f;position:absolute;z-index:3;display:block;bottom:-5px;transform:rotate(180deg);left:calc(50% - 5px)}.just-validate-error-label[data-tooltip=true][data-direction=left]{transform:translateX(-5px)}.just-validate-error-label[data-tooltip=true][data-direction=left]:before{right:-7px;bottom:auto;left:auto;top:calc(50% - 2px);transform:rotate(90deg)}.just-validate-error-label[data-tooltip=true][data-direction=right]{transform:translateX(5px)}.just-validate-error-label[data-tooltip=true][data-direction=right]:before{right:auto;bottom:auto;left:-7px;top:calc(50% - 2px);transform:rotate(-90deg)}.just-validate-error-label[data-tooltip=true][data-direction=bottom]{transform:translateY(5px)}.just-validate-error-label[data-tooltip=true][data-direction=bottom]:before{right:auto;bottom:auto;left:calc(50% - 5px);top:-5px;transform:rotate(0)}",defaultGlobalConfig={errorFieldStyle:{color:"#b81111",border:"1px solid #B81111"},errorFieldCssClass:"just-validate-error-field",successFieldCssClass:"just-validate-success-field",errorLabelStyle:{color:"#b81111"},errorLabelCssClass:"just-validate-error-label",successLabelCssClass:"just-validate-success-label",focusInvalidField:!0,lockForm:!0,testingMode:!1};class JustValidate{constructor(e,i,s){__publicField(this,"form",null),__publicField(this,"fields",{}),__publicField(this,"groupFields",{}),__publicField(this,"errors",{}),__publicField(this,"isValid",!1),__publicField(this,"isSubmitted",!1),__publicField(this,"globalConfig",defaultGlobalConfig),__publicField(this,"errorLabels",{}),__publicField(this,"successLabels",{}),__publicField(this,"eventListeners",[]),__publicField(this,"dictLocale",[]),__publicField(this,"currentLocale"),__publicField(this,"customStyleTags",{}),__publicField(this,"onSuccessCallback"),__publicField(this,"onFailCallback"),__publicField(this,"tooltips",[]),__publicField(this,"lastScrollPosition"),__publicField(this,"isScrollTick"),__publicField(this,"refreshAllTooltips",(()=>{this.tooltips.forEach((e=>{e.refresh();}));})),__publicField(this,"handleDocumentScroll",(()=>{this.lastScrollPosition=window.scrollY,this.isScrollTick||(window.requestAnimationFrame((()=>{this.refreshAllTooltips(),this.isScrollTick=!1;})),this.isScrollTick=!0);})),__publicField(this,"formSubmitHandler",(e=>{e.preventDefault(),this.isSubmitted=!0,this.validateHandler(e);})),__publicField(this,"handleFieldChange",(e=>{let i;for(const s in this.fields){if(this.fields[s].elem===e){i=s;break}}i&&this.validateField(i,!0);})),__publicField(this,"handleGroupChange",(e=>{let i,s;for(const l in this.groupFields){const t=this.groupFields[l];if(t.elems.find((i=>i===e))){i=t,s=l;break}}i&&s&&this.validateGroup(s,i);})),__publicField(this,"handlerChange",(e=>{e.target&&(this.handleFieldChange(e.target),this.handleGroupChange(e.target),this.renderErrors());})),this.initialize(e,i,s);}initialize(e,i,s){if(this.form=null,this.errors={},this.isValid=!1,this.isSubmitted=!1,this.globalConfig=defaultGlobalConfig,this.errorLabels={},this.successLabels={},this.eventListeners=[],this.customStyleTags={},this.tooltips=[],"string"==typeof e){const i=document.querySelector(e);if(!i)throw Error(`Form with ${e} selector not found! Please check the form selector`);this.setForm(i);}else {if(!(e instanceof HTMLFormElement))throw Error("Form selector is not valid. Please specify a string selector or a DOM element.");this.setForm(e);}if(this.globalConfig=__spreadValues(__spreadValues({},defaultGlobalConfig),i),s&&(this.dictLocale=s),this.isTooltip()){const e=document.createElement("style");e.textContent=errorLabelCss,this.customStyleTags[CustomStyleTagIds.Label]=document.head.appendChild(e),this.addListener("scroll",document,this.handleDocumentScroll);}}getLocalisedString(e){var i;if(!this.currentLocale||!this.dictLocale.length)return e;return (null==(i=this.dictLocale.find((i=>i.key===e)))?void 0:i.dict[this.currentLocale])||e}getFieldErrorMessage(e,i){const s="function"==typeof e.errorMessage?e.errorMessage(this.getElemValue(i),this.fields):e.errorMessage;return this.getLocalisedString(s)||getDefaultFieldMessage(e.rule,e.value)}getFieldSuccessMessage(e,i){const s="function"==typeof e?e(this.getElemValue(i),this.fields):e;return this.getLocalisedString(s)}getGroupErrorMessage(e){return this.getLocalisedString(e.errorMessage)||(e.rule===GroupRules.Required?"The field is required":"Group is incorrect")}getGroupSuccessMessage(e){return this.getLocalisedString(e.successMessage)}setFieldInvalid(e,i){this.fields[e].isValid=!1,this.fields[e].errorMessage=this.getFieldErrorMessage(i,this.fields[e].elem);}setFieldValid(e,i){this.fields[e].isValid=!0,void 0!==i&&(this.fields[e].successMessage=this.getFieldSuccessMessage(i,this.fields[e].elem));}setGroupInvalid(e,i){this.groupFields[e].isValid=!1,this.groupFields[e].errorMessage=this.getGroupErrorMessage(i);}setGroupValid(e,i){this.groupFields[e].isValid=!0,this.groupFields[e].successMessage=this.getGroupSuccessMessage(i);}getElemValue(e){switch(e.type){case"checkbox":return e.checked;case"file":return e.files;default:return e.value}}validateGroupRule(e,i,s,l){if(l.rule===GroupRules.Required)"radio"!==i&&"checkbox"!==i||(s.every((e=>!e.checked))?this.setGroupInvalid(e,l):this.setGroupValid(e,l));}validateFieldRule(e,i,s,l=!1){const t=s.value,r=this.getElemValue(i);if(s.plugin){s.plugin(r,this.fields)||this.setFieldInvalid(e,s);}else {switch(s.rule){case Rules.Required:isEmpty(r)&&this.setFieldInvalid(e,s);break;case Rules.Email:if("string"!=typeof r){this.setFieldInvalid(e,s);break}o=r,EMAIL_REGEXP.test(o)||this.setFieldInvalid(e,s);break;case Rules.MaxLength:if(void 0===t){console.error(`Value for ${s.rule} rule for [${e}] field is not defined. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("number"!=typeof t){console.error(`Value for ${s.rule} rule for [${e}] should be a number. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("string"!=typeof r){this.setFieldInvalid(e,s);break}if(""===r)break;isLengthMoreThanMax(r,t)&&this.setFieldInvalid(e,s);break;case Rules.MinLength:if(void 0===t){console.error(`Value for ${s.rule} rule for [${e}] field is not defined. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("number"!=typeof t){console.error(`Value for ${s.rule} rule for [${e}] should be a number. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("string"!=typeof r){this.setFieldInvalid(e,s);break}if(""===r)break;isLengthLessThanMin(r,t)&&this.setFieldInvalid(e,s);break;case Rules.Password:if("string"!=typeof r){this.setFieldInvalid(e,s);break}if(""===r)break;isPassword(r)||this.setFieldInvalid(e,s);break;case Rules.StrongPassword:if("string"!=typeof r){this.setFieldInvalid(e,s);break}if(""===r)break;isStrongPassword(r)||this.setFieldInvalid(e,s);break;case Rules.Number:if("string"!=typeof r){this.setFieldInvalid(e,s);break}if(""===r)break;isNumber(r)||this.setFieldInvalid(e,s);break;case Rules.MaxNumber:{if(void 0===t){console.error(`Value for ${s.rule} rule for [${e}] field is not defined. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("number"!=typeof t){console.error(`Value for ${s.rule} rule for [${e}] field should be a number. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("string"!=typeof r){this.setFieldInvalid(e,s);break}if(""===r)break;const i=+r;(Number.isNaN(i)||isNumberMoreThanMax(i,t))&&this.setFieldInvalid(e,s);break}case Rules.MinNumber:{if(void 0===t){console.error(`Value for ${s.rule} rule for [${e}] field is not defined. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("number"!=typeof t){console.error(`Value for ${s.rule} rule for [${e}] field should be a number. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("string"!=typeof r){this.setFieldInvalid(e,s);break}if(""===r)break;const i=+r;(Number.isNaN(i)||isNumberLessThanMin(i,t))&&this.setFieldInvalid(e,s);break}case Rules.CustomRegexp:{if(void 0===t)return console.error(`Value for ${s.rule} rule for [${e}] field is not defined. This field will be always invalid.`),void this.setFieldInvalid(e,s);let i;try{i=new RegExp(t);}catch(i){console.error(`Value for ${s.rule} rule for [${e}] should be a valid regexp. This field will be always invalid.`),this.setFieldInvalid(e,s);break}const l=String(r);""===l||i.test(l)||this.setFieldInvalid(e,s);break}case Rules.MinFilesCount:if(void 0===t){console.error(`Value for ${s.rule} rule for [${e}] field is not defined. This field will be always invalid.`),this.setFieldInvalid(e,s);break}if("number"!=typeof t){console.error(`Value for ${s.rule} rule for [${e}] field should be a number. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if(Number.isFinite(null==r?void 0:r.length)&&r.length<t){this.setFieldInvalid(e,s);break}break;case Rules.MaxFilesCount:if(void 0===t){console.error(`Value for ${s.rule} rule for [${e}] field is not defined. This field will be always invalid.`),this.setFieldInvalid(e,s);break}if("number"!=typeof t){console.error(`Value for ${s.rule} rule for [${e}] field should be a number. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if(Number.isFinite(null==r?void 0:r.length)&&r.length>t){this.setFieldInvalid(e,s);break}break;case Rules.Files:{if(void 0===t)return console.error(`Value for ${s.rule} rule for [${e}] field is not defined. This field will be always invalid.`),void this.setFieldInvalid(e,s);if("object"!=typeof t)return console.error(`Value for ${s.rule} rule for [${e}] field should be an object. This field will be always invalid.`),void this.setFieldInvalid(e,s);const i=t.files;if("object"!=typeof i)return console.error(`Value for ${s.rule} rule for [${e}] field should be an object with files array. This field will be always invalid.`),void this.setFieldInvalid(e,s);const l=(e,i)=>{const s=Number.isFinite(i.minSize)&&e.size<i.minSize,l=Number.isFinite(i.maxSize)&&e.size>i.maxSize,t=Array.isArray(i.names)&&!i.names.includes(e.name),r=Array.isArray(i.extensions)&&!i.extensions.includes(e.name.split(".")[e.name.split(".").length-1]),o=Array.isArray(i.types)&&!i.types.includes(e.type);return s||l||t||r||o};if("object"==typeof r&&null!==r)for(let t=0,o=r.length;t<o;++t){const o=r.item(t);if(!o){this.setFieldInvalid(e,s);break}if(l(o,i)){this.setFieldInvalid(e,s);break}}break}default:{if("function"!=typeof s.validator)return console.error(`Validator for custom rule for [${e}] field should be a function. This field will be always invalid.`),void this.setFieldInvalid(e,s);const i=s.validator(r,this.fields);if("boolean"!=typeof i&&"function"!=typeof i&&console.error(`Validator return value for [${e}] field should be boolean or function. It will be cast to boolean.`),"function"==typeof i){if(!l){this.fields[e].asyncCheckPending=!1;const l=i();return isPromise(l)?l.then((i=>{i||this.setFieldInvalid(e,s);})).catch((()=>{this.setFieldInvalid(e,s);})):(console.error(`Validator function for custom rule for [${e}] field should return a Promise. This field will be always invalid.`),void this.setFieldInvalid(e,s))}this.fields[e].asyncCheckPending=!0;}i||this.setFieldInvalid(e,s);}}var o;}}validateField(e,i=!1){var s;const l=this.fields[e];l.isValid=!0;const t=[];return [...l.rules].reverse().forEach((s=>{const r=this.validateFieldRule(e,l.elem,s,i);isPromise(r)&&t.push(r);})),l.isValid&&this.setFieldValid(e,null==(s=l.config)?void 0:s.successMessage),Promise.allSettled(t)}revalidateField(e){if("string"!=typeof e)throw Error("Field selector is not valid. Please specify a string selector.");return this.fields[e]?new Promise((i=>{this.validateField(e,!0).finally((()=>{this.clearFieldError(e),this.clearFieldLabel(e),this.renderFieldError(e),i(!!this.fields[e].isValid);}));})):(console.error("Field not found. Check the field selector."),Promise.reject())}validateGroup(e,i){const s=[];return [...i.rules].reverse().forEach((l=>{const t=this.validateGroupRule(e,i.type,i.elems,l);isPromise(t)&&s.push(t);})),Promise.allSettled(s)}focusInvalidField(){for(const e in this.fields){const i=this.fields[e];if(!i.isValid){setTimeout((()=>i.elem.focus()),0);break}}}afterSubmitValidation(e=!1){this.renderErrors(e),this.globalConfig.focusInvalidField&&this.focusInvalidField();}validate(e=!1){return new Promise((i=>{const s=[];Object.keys(this.fields).forEach((e=>{const i=this.validateField(e);isPromise(i)&&s.push(i);})),Object.keys(this.groupFields).forEach((e=>{const i=this.groupFields[e],l=this.validateGroup(e,i);isPromise(l)&&s.push(l);})),s.length?Promise.allSettled(s).then((()=>{this.afterSubmitValidation(e),i(!0);})):(this.afterSubmitValidation(e),i(!1));}))}revalidate(){return new Promise((e=>{this.validateHandler(void 0,!0).finally((()=>{this.globalConfig.focusInvalidField&&this.focusInvalidField(),e(this.isValid);}));}))}validateHandler(e,i=!1){return this.globalConfig.lockForm&&this.lockForm(),this.validate(i).finally((()=>{var i,s;this.globalConfig.lockForm&&this.unlockForm(),this.isValid?null==(i=this.onSuccessCallback)||i.call(this,e):null==(s=this.onFailCallback)||s.call(this,this.fields,this.groupFields);}))}setForm(e){this.form=e,this.form.setAttribute("novalidate","novalidate"),this.removeListener("submit",this.form,this.formSubmitHandler),this.addListener("submit",this.form,this.formSubmitHandler);}addListener(e,i,s){i.addEventListener(e,s),this.eventListeners.push({type:e,elem:i,func:s});}removeListener(e,i,s){i.removeEventListener(e,s),this.eventListeners=this.eventListeners.filter((s=>s.type!==e||s.elem!==i));}addField(e,i,s){if("string"!=typeof e)throw Error("Field selector is not valid. Please specify a string selector.");const l=this.form.querySelector(e);if(!l)throw Error(`Field with ${e} selector not found! Please check the field selector.`);if(!Array.isArray(i)||!i.length)throw Error(`Rules argument for the field [${e}] should be an array and should contain at least 1 element.`);return i.forEach((i=>{if(!("rule"in i||"validator"in i||"plugin"in i))throw Error(`Rules argument for the field [${e}] must contain at least one rule or validator property.`);if(!(i.validator||i.plugin||i.rule&&Object.values(Rules).includes(i.rule)))throw Error(`Rule should be one of these types: ${Object.values(Rules).join(", ")}. Provided value: ${i.rule}`)})),this.fields[e]={elem:l,rules:i,isValid:void 0,config:s},this.setListeners(l),this.isSubmitted&&this.validate(),this}removeField(e){if("string"!=typeof e)throw Error("Field selector is not valid. Please specify a string selector.");if(!this.fields[e])return console.error("Field not found. Check the field selector."),this;const i=this.getListenerType(this.fields[e].elem.type);return this.removeListener(i,this.fields[e].elem,this.handlerChange),this.clearErrors(),delete this.fields[e],this}removeGroup(e){if("string"!=typeof e)throw Error("Group selector is not valid. Please specify a string selector.");return this.groupFields[e]?(this.groupFields[e].elems.forEach((e=>{const i=this.getListenerType(e.type);this.removeListener(i,e,this.handlerChange);})),this.clearErrors(),delete this.groupFields[e],this):(console.error("Group not found. Check the group selector."),this)}addRequiredGroup(e,i,s,l){if("string"!=typeof e)throw Error("Group selector is not valid. Please specify a string selector.");const t=this.form.querySelector(e);if(!t)throw Error(`Group with ${e} selector not found! Please check the group selector.`);const r=t.querySelectorAll("input"),o=Array.from(r).every((e=>"radio"===e.type)),a=Array.from(r).every((e=>"checkbox"===e.type));if(!o&&!a)throw Error("Group should contain either or checkboxes or radio buttons");return this.groupFields[e]={rules:[{rule:GroupRules.Required,errorMessage:i,successMessage:l}],groupElem:t,elems:Array.from(r),type:o?"radio":"checkbox",isDirty:!1,isValid:void 0,config:s},r.forEach((e=>{this.setListeners(e);})),this}getListenerType(e){switch(e){case"checkbox":case"select-one":case"file":case"radio":return "change";default:return "input"}}setListeners(e){const i=this.getListenerType(e.type);this.removeListener(i,e,this.handlerChange),this.addListener(i,e,this.handlerChange);}clearFieldLabel(e){var i,s;null==(i=this.errorLabels[e])||i.remove(),null==(s=this.successLabels[e])||s.remove();}clearFieldError(e){var i,s,l,t;const r=this.fields[e],o=(null==(i=r.config)?void 0:i.errorFieldStyle)||this.globalConfig.errorFieldStyle;Object.keys(o).forEach((e=>{r.elem.style[e]="";}));const a=(null==(s=r.config)?void 0:s.successFieldStyle)||this.globalConfig.successFieldStyle||{};Object.keys(a).forEach((e=>{r.elem.style[e]="";})),r.elem.classList.remove((null==(l=r.config)?void 0:l.errorFieldCssClass)||this.globalConfig.errorFieldCssClass,(null==(t=r.config)?void 0:t.successFieldCssClass)||this.globalConfig.successFieldCssClass);}clearErrors(){var e,i;Object.keys(this.errorLabels).forEach((e=>this.errorLabels[e].remove())),Object.keys(this.successLabels).forEach((e=>this.successLabels[e].remove()));for(const e in this.fields)this.clearFieldError(e);for(const s in this.groupFields){const l=this.groupFields[s],t=(null==(e=l.config)?void 0:e.errorFieldStyle)||this.globalConfig.errorFieldStyle;Object.keys(t).forEach((e=>{l.elems.forEach((i=>{var s;i.style[e]="",i.classList.remove((null==(s=l.config)?void 0:s.errorFieldCssClass)||this.globalConfig.errorFieldCssClass);}));}));const r=(null==(i=l.config)?void 0:i.successFieldStyle)||this.globalConfig.successFieldStyle||{};Object.keys(r).forEach((e=>{l.elems.forEach((i=>{var s;i.style[e]="",i.classList.remove((null==(s=l.config)?void 0:s.successFieldCssClass)||this.globalConfig.successFieldCssClass);}));}));}this.tooltips=[];}isTooltip(){return !!this.globalConfig.tooltip}lockForm(){const e=this.form.querySelectorAll("input, textarea, button, select");for(let i=0,s=e.length;i<s;++i)e[i].setAttribute("disabled","disabled"),e[i].style.pointerEvents="none",e[i].style.webkitFilter="grayscale(100%)",e[i].style.filter="grayscale(100%)";}unlockForm(){const e=this.form.querySelectorAll("input, textarea, button, select");for(let i=0,s=e.length;i<s;++i)e[i].removeAttribute("disabled"),e[i].style.pointerEvents="",e[i].style.webkitFilter="",e[i].style.filter="";}renderTooltip(e,i,s){var l;const{top:t,left:r,width:o,height:a}=e.getBoundingClientRect(),n=i.getBoundingClientRect(),d=s||(null==(l=this.globalConfig.tooltip)?void 0:l.position);switch(d){case"left":i.style.top=t+a/2-n.height/2+"px",i.style.left=r-n.width-5+"px";break;case"top":i.style.top=t-n.height-5+"px",i.style.left=r+o/2-n.width/2+"px";break;case"right":i.style.top=t+a/2-n.height/2+"px",i.style.left=`${r+o+5}px`;break;case"bottom":i.style.top=`${t+a+5}px`,i.style.left=r+o/2-n.width/2+"px";}i.dataset.direction=d;return {refresh:()=>{this.renderTooltip(e,i,s);}}}createErrorLabelElem(e,i,s){const l=document.createElement("div");l.innerHTML=i;const t=this.isTooltip()?null==s?void 0:s.errorLabelStyle:(null==s?void 0:s.errorLabelStyle)||this.globalConfig.errorLabelStyle;return Object.assign(l.style,t),l.classList.add((null==s?void 0:s.errorLabelCssClass)||this.globalConfig.errorLabelCssClass,"just-validate-error-label"),this.isTooltip()&&(l.dataset.tooltip="true"),this.globalConfig.testingMode&&(l.dataset.testId=`error-label-${e}`),this.errorLabels[e]=l,l}createSuccessLabelElem(e,i,s){if(void 0===i)return null;const l=document.createElement("div");l.innerHTML=i;const t=(null==s?void 0:s.successLabelStyle)||this.globalConfig.successLabelStyle;return Object.assign(l.style,t),l.classList.add((null==s?void 0:s.successLabelCssClass)||this.globalConfig.successLabelCssClass,"just-validate-success-label"),this.globalConfig.testingMode&&(l.dataset.testId=`success-label-${e}`),this.successLabels[e]=l,l}renderErrorsContainer(e,i){const s=i||this.globalConfig.errorsContainer;if("string"==typeof s){const i=this.form.querySelector(s);if(i)return i.appendChild(e),!0;console.error(`Error container with ${s} selector not found. Errors will be rendered as usual`);}return s instanceof Element?(s.appendChild(e),!0):(void 0!==s&&console.error("Error container not found. It should be a string or existing Element. Errors will be rendered as usual"),!1)}renderGroupLabel(e,i,s,l){if(!l){if(this.renderErrorsContainer(i,s))return}e.appendChild(i);}renderFieldLabel(e,i,s,l){var t,r,o,a,n,d,u;if(!l){if(this.renderErrorsContainer(i,s))return}if("checkbox"===e.type||"radio"===e.type){const s=document.querySelector(`label[for="${e.getAttribute("id")}"]`);"label"===(null==(r=null==(t=e.parentElement)?void 0:t.tagName)?void 0:r.toLowerCase())?null==(a=null==(o=e.parentElement)?void 0:o.parentElement)||a.appendChild(i):s?null==(n=s.parentElement)||n.appendChild(i):null==(d=e.parentElement)||d.appendChild(i);}else null==(u=e.parentElement)||u.appendChild(i);}renderFieldError(e){var i,s,l,t,r,o;const a=this.fields[e];if(a.isValid){if(!a.asyncCheckPending){const l=this.createSuccessLabelElem(e,a.successMessage,a.config);l&&this.renderFieldLabel(a.elem,l,null==(i=a.config)?void 0:i.errorsContainer,!0),a.elem.classList.add((null==(s=a.config)?void 0:s.successFieldCssClass)||this.globalConfig.successFieldCssClass);}return}this.isValid=!1,a.elem.classList.add((null==(l=a.config)?void 0:l.errorFieldCssClass)||this.globalConfig.errorFieldCssClass);const n=this.createErrorLabelElem(e,a.errorMessage,a.config);this.renderFieldLabel(a.elem,n,null==(t=a.config)?void 0:t.errorsContainer),this.isTooltip()&&this.tooltips.push(this.renderTooltip(a.elem,n,null==(o=null==(r=a.config)?void 0:r.tooltip)?void 0:o.position));}renderErrors(e=!1){var i,s,l,t;if(this.isSubmitted||e){this.clearErrors(),this.isValid=!0;for(const e in this.groupFields){const r=this.groupFields[e];if(r.isValid){r.elems.forEach((e=>{var i,s;Object.assign(e.style,(null==(i=r.config)?void 0:i.successFieldStyle)||this.globalConfig.successFieldStyle),e.classList.add((null==(s=r.config)?void 0:s.successFieldCssClass)||this.globalConfig.successFieldCssClass);}));const s=this.createSuccessLabelElem(e,r.successMessage,r.config);s&&this.renderGroupLabel(r.groupElem,s,null==(i=r.config)?void 0:i.errorsContainer,!0);continue}this.isValid=!1,r.elems.forEach((e=>{var i,s;Object.assign(e.style,(null==(i=r.config)?void 0:i.errorFieldStyle)||this.globalConfig.errorFieldStyle),e.classList.add((null==(s=r.config)?void 0:s.errorFieldCssClass)||this.globalConfig.errorFieldCssClass);}));const o=this.createErrorLabelElem(e,r.errorMessage,r.config);this.renderGroupLabel(r.groupElem,o,null==(s=r.config)?void 0:s.errorsContainer),this.isTooltip()&&this.tooltips.push(this.renderTooltip(r.groupElem,o,null==(t=null==(l=r.config)?void 0:l.tooltip)?void 0:t.position));}for(const e in this.fields)this.renderFieldError(e);}}destroy(){this.eventListeners.forEach((e=>{this.removeListener(e.type,e.elem,e.func);})),Object.keys(this.customStyleTags).forEach((e=>{this.customStyleTags[e].remove();})),this.clearErrors(),this.globalConfig.lockForm&&this.unlockForm();}refresh(){this.destroy(),this.form?(this.initialize(this.form,this.globalConfig),Object.keys(this.fields).forEach((e=>{this.addField(e,[...this.fields[e].rules],this.fields[e].config);}))):console.error("Cannot initialize the library! Form is not defined");}setCurrentLocale(e){"string"==typeof e||void 0===e?(this.currentLocale=e,this.isSubmitted&&this.validate()):console.error("Current locale should be a string");}onSuccess(e){return this.onSuccessCallback=e,this}onFail(e){return this.onFailCallback=e,this}}class CssClassObserver{constructor(t,s,e,a,i){this.targetNode=t,this.classToWatch=s,this.classAddedCallback=e,this.classRemovedCallback=a,this.observer=null,this.lastClassState=t.classList.contains(this.classToWatch),this.ignoreToggle=!!i,this.init();}init(){this.observer=new MutationObserver((t=>this.mutationCallback(t))),this.observe();}observe(){this.observer.observe(this.targetNode,{attributes:!0});}disconnect(){this.observer.disconnect();}mutationCallback(t){for(let s of t)if("attributes"===s.type&&"class"===s.attributeName){let t=s.target.classList.contains(this.classToWatch);(this.ignoreToggle||this.lastClassState!==t)&&(this.lastClassState=t,t?this.classAddedCallback():this.classRemovedCallback());}}}class ContentObserver{constructor(t,s,e,a){this.targetNode=t,this.contentSelector=s,this.contentAddedCallback=e,this.contentRemovedCallback=a,this.observer=null,this.init();}init(){this.observer=new MutationObserver((t=>this.mutationCallback(t))),this.observe();}observe(){this.observer.observe(this.targetNode,{childList:!0});}disconnect(){this.observer.disconnect();}mutationCallback(t){for(let s of t)"childList"===s.type&&(s.addedNodes.forEach((t=>{t.matches(this.contentSelector)&&this.contentAddedCallback();})),s.removedNodes.forEach((t=>{t.matches(this.contentSelector)&&this.contentRemovedCallback();})));}}const CONFIG_DEFAULT={errorFieldCssClass:"is-invalid",errorLabelCssClass:"just-validate-error-label"},NAME$c="justvalidatebi",CLASS_NAME_SRONLY="sr-only-justvalidate-bi",SELECTOR_SPAN_SRONLY=`.${CLASS_NAME_SRONLY}`;class FormValidate{constructor(e,t){return this.formSelector=e,this.target=document.querySelector(e),this.validate=new JustValidate(e,t),this.config=Object.assign({},CONFIG_DEFAULT,this.validate.globalConfig),this.formItems=[],this.init(),this.validate}init(){this.target.querySelectorAll("input, select").forEach((e=>{const t=new CssClassObserver(e,this.config.errorFieldCssClass,(()=>this.onInputError(e)),(()=>this.onInputErrorRemove(e)),!0);e.id||e.setAttribute("id",NAME$c+"-input-"+Math.random()),this.formItems.push({item:e,watcher:t});}));this.target.querySelectorAll("fieldset").forEach((e=>{if(e.querySelectorAll("input[type=radio],input[type=checkbox]").length>0){const t=new ContentObserver(e,"."+this.config.errorLabelCssClass,(()=>this.onFieldsetError(e)),(()=>this.onFieldsetErrorRemove(e)));e.id||e.setAttribute("id",NAME$c+"-fieldset-"+Math.random()),this.formItems.push({item:e,watcher:t});}}));}onInputError(e){const t=this.getErrorMessages(e),r=[];t.forEach(((t,s)=>{const i=e.id+"-error-"+s;t.setAttribute("id",i),r.push(i);})),r.length>0&&(e.setAttribute("aria-describedby",r.join(" ")),e.setAttribute("aria-invalid","true"));}onInputErrorRemove(e){e.removeAttribute("aria-describedby"),e.setAttribute("aria-invalid","false");}onFieldsetError(e){const t=this.getErrorMessages(e),r=[],s=[];if(t.forEach(((t,i)=>{const o=e.id+"-error-"+i;t.setAttribute("id",o),r.push(o),s.push(t.textContent);})),r.length>0){const t=e.querySelector("legend");t&&(t.setAttribute("aria-describedby",r.join(" ")),t.setAttribute("aria-invalid","true"));}}onFieldsetErrorRemove(e){const t=e.querySelector("legend");if(t){t.removeAttribute("aria-describedby"),t.setAttribute("aria-invalid","false");const e=t.querySelector(SELECTOR_SPAN_SRONLY);e&&e.remove();}}getErrorMessages(e){let t=e,r=t.querySelectorAll("."+this.config.errorLabelCssClass);for(;null!=t&&0===r.length;)t=t.parentNode,r=t.querySelectorAll("."+this.config.errorLabelCssClass);return r}}const ValidatorSelectAutocomplete=(e,t={})=>(r,s)=>{let i=!1;const o=s[e];if(!o)throw new Error("ValidatorSelectAutocomplete: "+e+" not found as form field");return t.required||r?document.querySelector("#"+o.elem.id+"-select").querySelectorAll("option").forEach((e=>{e.text===r&&(i=!0);})):i=!0,i};const NAME$b="input",EVENT_CHANGE="change.bs.input";class Input extends BaseComponent{constructor(e){super(e),this._label=new InputLabel$1(e),this._bindEvents();}static get NAME(){return NAME$b}_bindEvents(){"file"===this._element.getAttribute("type")&&EventHandler$1.on(this._element,EVENT_CHANGE,(()=>{this._handleFileDescription();}));}_handleFileDescription(){const e=[];let t="";Array.from(this._element.files).forEach((t=>{const n=Math.round(parseInt(t.size,10)/1024);e.push(t.name+" ("+n+"kb)");})),this._element.files.length>1&&(t=this._element.files.length+" file da caricare: ");const n=SelectorEngine$1.findOne('label[for="'+this._element.getAttribute("id")+'"] label.form-file-name',this._element);n&&(n.innerText=t+e.join("; "));}}const excludes=["select",'input[data-bs-input][type="number"]','input[data-bs-input][type="password"]','input[data-bs-autocomplete][type="search"]','input[type="time"]'],inputs$2=SelectorEngine$1.find("input, textarea").filter((e=>{let t=!0;return excludes.forEach((n=>{e.matches(n)&&(t=!1);})),t}));inputs$2.forEach((e=>{Input.getOrCreateInstance(e);}));var Input$1 = Input;var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function unwrapExports (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function createCommonjsModule(fn, module) {
	return module = { exports: {} }, fn(module, module.exports), module.exports;
}var accessibleAutocomplete_min=createCommonjsModule((function(e,t){var n;n=function(){return function(e){var t={};function n(r){if(t[r])return t[r].exports;var o=t[r]={i:r,l:!1,exports:{}};return e[r].call(o.exports,o,o.exports,n),o.l=!0,o.exports}return n.m=e,n.c=t,n.d=function(e,t,r){n.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:r});},n.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0});},n.t=function(e,t){if(1&t&&(e=n(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var o in e)n.d(r,o,function(t){return e[t]}.bind(null,o));return r},n.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return n.d(t,"a",t),t},n.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},n.p="/",n(n.s=37)}([function(e,t,n){var r=n(1),o=n(6),i=n(7),u=n(16),a=n(18),s="prototype",l=function(e,t,n){var c,p,f,d,h=e&l.F,v=e&l.G,m=e&l.S,y=e&l.P,_=e&l.B,g=v?r:m?r[t]||(r[t]={}):(r[t]||{})[s],b=v?o:o[t]||(o[t]={}),w=b[s]||(b[s]={});for(c in v&&(n=t),n)f=((p=!h&&g&&void 0!==g[c])?g:n)[c],d=_&&p?a(f,r):y&&"function"==typeof f?a(Function.call,f):f,g&&u(g,c,f,e&l.U),b[c]!=f&&i(b,c,d),y&&w[c]!=f&&(w[c]=f);};r.core=o,l.F=1,l.G=2,l.S=4,l.P=8,l.B=16,l.W=32,l.U=64,l.R=128,e.exports=l;},function(e,t){var n=e.exports="undefined"!=typeof window&&window.Math==Math?window:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"number"==typeof __g&&(__g=n);},function(e,t){e.exports=function(e){return "object"==typeof e?null!==e:"function"==typeof e};},function(e,t,n){e.exports=!n(4)((function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a}));},function(e,t){e.exports=function(e){try{return !!e()}catch(e){return !0}};},function(e,t,n){n.r(t),n.d(t,"h",(function(){return a})),n.d(t,"createElement",(function(){return a})),n.d(t,"cloneElement",(function(){return c})),n.d(t,"Component",(function(){return L})),n.d(t,"render",(function(){return T})),n.d(t,"rerender",(function(){return h})),n.d(t,"options",(function(){return o}));var r=function(){},o={},i=[],u=[];function a(e,t){var n,a,s,l,c=u;for(l=arguments.length;2<l--;)i.push(arguments[l]);for(t&&null!=t.children&&(i.length||i.push(t.children),delete t.children);i.length;)if((a=i.pop())&&void 0!==a.pop)for(l=a.length;l--;)i.push(a[l]);else "boolean"==typeof a&&(a=null),(s="function"!=typeof e)&&(null==a?a="":"number"==typeof a?a=String(a):"string"!=typeof a&&(s=!1)),s&&n?c[c.length-1]+=a:c===u?c=[a]:c.push(a),n=s;var p=new r;return p.nodeName=e,p.children=c,p.attributes=null==t?void 0:t,p.key=null==t?void 0:t.key,void 0!==o.vnode&&o.vnode(p),p}function s(e,t){for(var n in t)e[n]=t[n];return e}var l="function"==typeof Promise?Promise.resolve().then.bind(Promise.resolve()):setTimeout;function c(e,t){return a(e.nodeName,s(s({},e.attributes),t),2<arguments.length?[].slice.call(arguments,2):e.children)}var p=/acit|ex(?:s|g|n|p|$)|rph|ows|mnc|ntw|ine[ch]|zoo|^ord/i,f=[];function d(e){!e._dirty&&(e._dirty=!0)&&1==f.push(e)&&(o.debounceRendering||l)(h);}function h(){var e,t=f;for(f=[];e=t.pop();)e._dirty&&j(e);}function v(e,t){return e.normalizedNodeName===t||e.nodeName.toLowerCase()===t.toLowerCase()}function m(e){var t=s({},e.attributes);t.children=e.children;var n=e.nodeName.defaultProps;if(void 0!==n)for(var r in n)void 0===t[r]&&(t[r]=n[r]);return t}function y(e){var t=e.parentNode;t&&t.removeChild(e);}function _(e,t,n,r,o){if("className"===t&&(t="class"),"key"===t);else if("ref"===t)n&&n(null),r&&r(e);else if("class"!==t||o)if("style"===t){if(r&&"string"!=typeof r&&"string"!=typeof n||(e.style.cssText=r||""),r&&"object"==typeof r){if("string"!=typeof n)for(var i in n)i in r||(e.style[i]="");for(var i in r)e.style[i]="number"==typeof r[i]&&!1===p.test(i)?r[i]+"px":r[i];}}else if("dangerouslySetInnerHTML"===t)r&&(e.innerHTML=r.__html||"");else if("o"==t[0]&&"n"==t[1]){var u=t!==(t=t.replace(/Capture$/,""));t=t.toLowerCase().substring(2),r?n||e.addEventListener(t,g,u):e.removeEventListener(t,g,u),(e._listeners||(e._listeners={}))[t]=r;}else if("list"!==t&&"type"!==t&&!o&&t in e){try{e[t]=null==r?"":r;}catch(e){}null!=r&&!1!==r||"spellcheck"==t||e.removeAttribute(t);}else {var a=o&&t!==(t=t.replace(/^xlink:?/,""));null==r||!1===r?a?e.removeAttributeNS("http://www.w3.org/1999/xlink",t.toLowerCase()):e.removeAttribute(t):"function"!=typeof r&&(a?e.setAttributeNS("http://www.w3.org/1999/xlink",t.toLowerCase(),r):e.setAttribute(t,r));}else e.className=r||"";}function g(e){return this._listeners[e.type](o.event&&o.event(e)||e)}var b=[],w=0,x=!1,O=!1;function C(){for(var e;e=b.pop();)o.afterMount&&o.afterMount(e),e.componentDidMount&&e.componentDidMount();}function S(e,t,n,r,o){var i=e,u=x;if(null!=t&&"boolean"!=typeof t||(t=""),"string"==typeof t||"number"==typeof t)return e&&void 0!==e.splitText&&e.parentNode&&(!e._component||o)?e.nodeValue!=t&&(e.nodeValue=t):(i=document.createTextNode(t),e&&(e.parentNode&&e.parentNode.replaceChild(i,e),E(e,!0))),i.__preactattr_=!0,i;var a=t.nodeName;if("function"==typeof a)return function(e,t,n,r){for(var o=e&&e._component,i=o,u=e,a=o&&e._componentConstructor===t.nodeName,s=a,l=m(t);o&&!s&&(o=o._parentComponent);)s=o.constructor===t.nodeName;return o&&s&&(!r||o._component)?(k(o,l,3,n,r),e=o.base):(i&&!a&&(P(i),e=u=null),o=I(t.nodeName,l,n),e&&!o.nextBase&&(o.nextBase=e,u=null),k(o,l,1,n,r),e=o.base,u&&e!==u&&(u._component=null,E(u,!1))),e}(e,t,n,r);if(x="svg"===a||"foreignObject"!==a&&x,a=String(a),(!e||!v(e,a))&&(i=function(e,t){var n=t?document.createElementNS("http://www.w3.org/2000/svg",e):document.createElement(e);return n.normalizedNodeName=e,n}(a,x),e)){for(;e.firstChild;)i.appendChild(e.firstChild);e.parentNode&&e.parentNode.replaceChild(i,e),E(e,!0);}var s=i.firstChild,l=i.__preactattr_,c=t.children;if(null==l){l=i.__preactattr_={};for(var p=i.attributes,f=p.length;f--;)l[p[f].name]=p[f].value;}return !O&&c&&1===c.length&&"string"==typeof c[0]&&null!=s&&void 0!==s.splitText&&null==s.nextSibling?s.nodeValue!=c[0]&&(s.nodeValue=c[0]):(c&&c.length||null!=s)&&function(e,t,n,r,o){var i,u,a,s,l,c,p,f,d=e.childNodes,h=[],m={},_=0,g=0,b=d.length,w=0,x=t?t.length:0;if(0!==b)for(var O=0;O<b;O++){var C=d[O],M=C.__preactattr_;null!=(N=x&&M?C._component?C._component.__key:M.key:null)?(_++,m[N]=C):(M||(void 0!==C.splitText?!o||C.nodeValue.trim():o))&&(h[w++]=C);}if(0!==x)for(O=0;O<x;O++){var N;if(l=null,null!=(N=(s=t[O]).key))_&&void 0!==m[N]&&(l=m[N],m[N]=void 0,_--);else if(g<w)for(i=g;i<w;i++)if(void 0!==h[i]&&(c=u=h[i],f=o,"string"==typeof(p=s)||"number"==typeof p?void 0!==c.splitText:"string"==typeof p.nodeName?!c._componentConstructor&&v(c,p.nodeName):f||c._componentConstructor===p.nodeName)){l=u,h[i]=void 0,i===w-1&&w--,i===g&&g++;break}l=S(l,s,n,r),a=d[O],l&&l!==e&&l!==a&&(null==a?e.appendChild(l):l===a.nextSibling?y(a):e.insertBefore(l,a));}if(_)for(var O in m)void 0!==m[O]&&E(m[O],!1);for(;g<=w;)void 0!==(l=h[w--])&&E(l,!1);}(i,c,n,r,O||null!=l.dangerouslySetInnerHTML),function(e,t,n){var r;for(r in n)t&&null!=t[r]||null==n[r]||_(e,r,n[r],n[r]=void 0,x);for(r in t)"children"===r||"innerHTML"===r||r in n&&t[r]===("value"===r||"checked"===r?e[r]:n[r])||_(e,r,n[r],n[r]=t[r],x);}(i,t.attributes,l),x=u,i}function E(e,t){var n=e._component;n?P(n):(null!=e.__preactattr_&&e.__preactattr_.ref&&e.__preactattr_.ref(null),!1!==t&&null!=e.__preactattr_||y(e),M(e));}function M(e){for(e=e.lastChild;e;){var t=e.previousSibling;E(e,!0),e=t;}}var N=[];function I(e,t,n){var r,o=N.length;for(e.prototype&&e.prototype.render?(r=new e(t,n),L.call(r,t,n)):((r=new L(t,n)).constructor=e,r.render=A);o--;)if(N[o].constructor===e)return r.nextBase=N[o].nextBase,N.splice(o,1),r;return r}function A(e,t,n){return this.constructor(e,n)}function k(e,t,n,r,i){e._disable||(e._disable=!0,e.__ref=t.ref,e.__key=t.key,delete t.ref,delete t.key,void 0===e.constructor.getDerivedStateFromProps&&(!e.base||i?e.componentWillMount&&e.componentWillMount():e.componentWillReceiveProps&&e.componentWillReceiveProps(t,r)),r&&r!==e.context&&(e.prevContext||(e.prevContext=e.context),e.context=r),e.prevProps||(e.prevProps=e.props),e.props=t,e._disable=!1,0!==n&&(1!==n&&!1===o.syncComponentUpdates&&e.base?d(e):j(e,1,i)),e.__ref&&e.__ref(e));}function j(e,t,n,r){if(!e._disable){var i,u,a,l=e.props,c=e.state,p=e.context,f=e.prevProps||l,d=e.prevState||c,h=e.prevContext||p,v=e.base,y=e.nextBase,_=v||y,g=e._component,M=!1,N=h;if(e.constructor.getDerivedStateFromProps&&(c=s(s({},c),e.constructor.getDerivedStateFromProps(l,c)),e.state=c),v&&(e.props=f,e.state=d,e.context=h,2!==t&&e.shouldComponentUpdate&&!1===e.shouldComponentUpdate(l,c,p)?M=!0:e.componentWillUpdate&&e.componentWillUpdate(l,c,p),e.props=l,e.state=c,e.context=p),e.prevProps=e.prevState=e.prevContext=e.nextBase=null,e._dirty=!1,!M){i=e.render(l,c,p),e.getChildContext&&(p=s(s({},p),e.getChildContext())),v&&e.getSnapshotBeforeUpdate&&(N=e.getSnapshotBeforeUpdate(f,d));var A,L,T=i&&i.nodeName;if("function"==typeof T){var B=m(i);(u=g)&&u.constructor===T&&B.key==u.__key?k(u,B,1,p,!1):(A=u,e._component=u=I(T,B,p),u.nextBase=u.nextBase||y,u._parentComponent=e,k(u,B,0,p,!1),j(u,1,n,!0)),L=u.base;}else a=_,(A=g)&&(a=e._component=null),(_||1===t)&&(a&&(a._component=null),L=function(e,t,n,r,o,i){w++||(x=null!=o&&void 0!==o.ownerSVGElement,O=null!=e&&!("__preactattr_"in e));var u=S(e,t,n,r,i);return o&&u.parentNode!==o&&o.appendChild(u),--w||(O=!1,i||C()),u}(a,i,p,n||!v,_&&_.parentNode,!0));if(_&&L!==_&&u!==g){var D=_.parentNode;D&&L!==D&&(D.replaceChild(L,_),A||(_._component=null,E(_,!1)));}if(A&&P(A),(e.base=L)&&!r){for(var F=e,R=e;R=R._parentComponent;)(F=R).base=L;L._component=F,L._componentConstructor=F.constructor;}}for(!v||n?b.unshift(e):M||(e.componentDidUpdate&&e.componentDidUpdate(f,d,N),o.afterUpdate&&o.afterUpdate(e));e._renderCallbacks.length;)e._renderCallbacks.pop().call(e);w||r||C();}}function P(e){o.beforeUnmount&&o.beforeUnmount(e);var t=e.base;e._disable=!0,e.componentWillUnmount&&e.componentWillUnmount(),e.base=null;var n=e._component;n?P(n):t&&(t.__preactattr_&&t.__preactattr_.ref&&t.__preactattr_.ref(null),y(e.nextBase=t),N.push(e),M(t)),e.__ref&&e.__ref(null);}function L(e,t){this._dirty=!0,this.context=t,this.props=e,this.state=this.state||{},this._renderCallbacks=[];}function T(e,t,n){return function(e,t,n,r,o,i){w++||(x=null!=o&&void 0!==o.ownerSVGElement,O=null!=e&&!("__preactattr_"in e));var u=S(e,t,n,r,i);return o&&u.parentNode!==o&&o.appendChild(u),--w||(O=!1,i||C()),u}(n,e,{},!1,t,!1)}s(L.prototype,{setState:function(e,t){this.prevState||(this.prevState=this.state),this.state=s(s({},this.state),"function"==typeof e?e(this.state,this.props):e),t&&this._renderCallbacks.push(t),d(this);},forceUpdate:function(e){e&&this._renderCallbacks.push(e),j(this,2);},render:function(){}});var B={h:a,createElement:a,cloneElement:c,Component:L,render:T,rerender:h,options:o};t.default=B;},function(e,t){var n=e.exports={version:"2.5.7"};"number"==typeof __e&&(__e=n);},function(e,t,n){var r=n(8),o=n(40);e.exports=n(3)?function(e,t,n){return r.f(e,t,o(1,n))}:function(e,t,n){return e[t]=n,e};},function(e,t,n){var r=n(9),o=n(38),i=n(39),u=Object.defineProperty;t.f=n(3)?Object.defineProperty:function(e,t,n){if(r(e),t=i(t,!0),r(n),o)try{return u(e,t,n)}catch(e){}if("get"in n||"set"in n)throw TypeError("Accessors not supported!");return "value"in n&&(e[t]=n.value),e};},function(e,t,n){var r=n(2);e.exports=function(e){if(!r(e))throw TypeError(e+" is not an object!");return e};},function(e,t){var n=0,r=Math.random();e.exports=function(e){return "Symbol(".concat(void 0===e?"":e,")_",(++n+r).toString(36))};},function(e,t,n){var r=n(22);e.exports=Object("z").propertyIsEnumerable(0)?Object:function(e){return "String"==r(e)?e.split(""):Object(e)};},function(e,t){e.exports=function(e){if(null==e)throw TypeError("Can't call method on  "+e);return e};},function(e,t,n){var r=n(4);e.exports=function(e,t){return !!e&&r((function(){t?e.call(null,(function(){}),1):e.call(null);}))};},function(e,t,n){var r=n(0);r(r.S+r.F,"Object",{assign:n(41)});},function(e,t,n){var r=n(2),o=n(1).document,i=r(o)&&r(o.createElement);e.exports=function(e){return i?o.createElement(e):{}};},function(e,t,n){var r=n(1),o=n(7),i=n(17),u=n(10)("src"),a="toString",s=Function[a],l=(""+s).split(a);n(6).inspectSource=function(e){return s.call(e)},(e.exports=function(e,t,n,a){var s="function"==typeof n;s&&(i(n,"name")||o(n,"name",t)),e[t]!==n&&(s&&(i(n,u)||o(n,u,e[t]?""+e[t]:l.join(String(t)))),e===r?e[t]=n:a?e[t]?e[t]=n:o(e,t,n):(delete e[t],o(e,t,n)));})(Function.prototype,a,(function(){return "function"==typeof this&&this[u]||s.call(this)}));},function(e,t){var n={}.hasOwnProperty;e.exports=function(e,t){return n.call(e,t)};},function(e,t,n){var r=n(19);e.exports=function(e,t,n){if(r(e),void 0===t)return e;switch(n){case 1:return function(n){return e.call(t,n)};case 2:return function(n,r){return e.call(t,n,r)};case 3:return function(n,r,o){return e.call(t,n,r,o)}}return function(){return e.apply(t,arguments)}};},function(e,t){e.exports=function(e){if("function"!=typeof e)throw TypeError(e+" is not a function!");return e};},function(e,t,n){var r=n(42),o=n(28);e.exports=Object.keys||function(e){return r(e,o)};},function(e,t,n){var r=n(11),o=n(12);e.exports=function(e){return r(o(e))};},function(e,t){var n={}.toString;e.exports=function(e){return n.call(e).slice(8,-1)};},function(e,t,n){var r=n(21),o=n(24),i=n(43);e.exports=function(e){return function(t,n,u){var a,s=r(t),l=o(s.length),c=i(u,l);if(e&&n!=n){for(;c<l;)if((a=s[c++])!=a)return !0}else for(;c<l;c++)if((e||c in s)&&s[c]===n)return e||c||0;return !e&&-1}};},function(e,t,n){var r=n(25),o=Math.min;e.exports=function(e){return 0<e?o(r(e),9007199254740991):0};},function(e,t){var n=Math.ceil,r=Math.floor;e.exports=function(e){return isNaN(e=+e)?0:(0<e?r:n)(e)};},function(e,t,n){var r=n(27)("keys"),o=n(10);e.exports=function(e){return r[e]||(r[e]=o(e))};},function(e,t,n){var r=n(6),o=n(1),i="__core-js_shared__",u=o[i]||(o[i]={});(e.exports=function(e,t){return u[e]||(u[e]=void 0!==t?t:{})})("versions",[]).push({version:r.version,mode:n(44)?"pure":"global",copyright:"© 2018 Denis Pushkarev (zloirock.ru)"});},function(e,t){e.exports="constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf".split(",");},function(e,t,n){var r=n(12);e.exports=function(e){return Object(r(e))};},function(e,t,n){var r=n(8).f,o=Function.prototype,i=/^\s*function ([^ (]*)/;"name"in o||n(3)&&r(o,"name",{configurable:!0,get:function(){try{return (""+this).match(i)[1]}catch(e){return ""}}});},function(e,t,n){var r=n(0),o=n(32)(1);r(r.P+r.F*!n(13)([].map,!0),"Array",{map:function(e){return o(this,e,arguments[1])}});},function(e,t,n){var r=n(18),o=n(11),i=n(29),u=n(24),a=n(47);e.exports=function(e,t){var n=1==e,s=2==e,l=3==e,c=4==e,p=6==e,f=5==e||p,d=t||a;return function(t,a,h){for(var v,m,y=i(t),_=o(y),g=r(a,h,3),b=u(_.length),w=0,x=n?d(t,b):s?d(t,0):void 0;w<b;w++)if((f||w in _)&&(m=g(v=_[w],w,y),e))if(n)x[w]=m;else if(m)switch(e){case 3:return !0;case 5:return v;case 6:return w;case 2:x.push(v);}else if(c)return !1;return p?-1:l||c?c:x}};},function(e,t,n){var r=n(22);e.exports=Array.isArray||function(e){return "Array"==r(e)};},function(e,t,n){var r=n(27)("wks"),o=n(10),i=n(1).Symbol,u="function"==typeof i;(e.exports=function(e){return r[e]||(r[e]=u&&i[e]||(u?i:o)("Symbol."+e))}).store=r;},function(e,t,n){var r=n(0),o=n(23)(!1),i=[].indexOf,u=!!i&&1/[1].indexOf(1,-0)<0;r(r.P+r.F*(u||!n(13)(i)),"Array",{indexOf:function(e){return u?i.apply(this,arguments)||0:o(this,e,arguments[1])}});},function(e,t,n){var r=n(0);r(r.S,"Object",{create:n(52)});},function(e,t,n){t.__esModule=!0,t.default=void 0,n(14),n(30),n(31),n(35),n(49),n(50);var r=n(5),o=function(e){return e&&e.__esModule?e:{default:e}}(n(51));function i(e){if(!e.element)throw new Error("element is not defined");if(!e.id)throw new Error("id is not defined");if(!e.source)throw new Error("source is not defined");Array.isArray(e.source)&&(e.source=u(e.source)),(0, r.render)((0, r.createElement)(o.default,e),e.element);}var u=function(e){return function(t,n){n(e.filter((function(e){return -1!==e.toLowerCase().indexOf(t.toLowerCase())})));}};i.enhanceSelectElement=function(e){if(!e.selectElement)throw new Error("selectElement is not defined");if(!e.source){var t=[].filter.call(e.selectElement.options,(function(t){return t.value||e.preserveNullOptions}));e.source=t.map((function(e){return e.textContent||e.innerText}));}if(e.onConfirm=e.onConfirm||function(t){var n=[].filter.call(e.selectElement.options,(function(e){return (e.textContent||e.innerText)===t}))[0];n&&(n.selected=!0);},e.selectElement.value||void 0===e.defaultValue){var n=e.selectElement.options[e.selectElement.options.selectedIndex];e.defaultValue=n.textContent||n.innerText;}void 0===e.name&&(e.name=""),void 0===e.id&&(void 0===e.selectElement.id?e.id="":e.id=e.selectElement.id),void 0===e.autoselect&&(e.autoselect=!0);var r=document.createElement("div");e.selectElement.parentNode.insertBefore(r,e.selectElement),i(Object.assign({},e,{element:r})),e.selectElement.style.display="none",e.selectElement.id=e.selectElement.id+"-select";};var a=i;t.default=a;},function(e,t,n){e.exports=!n(3)&&!n(4)((function(){return 7!=Object.defineProperty(n(15)("div"),"a",{get:function(){return 7}}).a}));},function(e,t,n){var r=n(2);e.exports=function(e,t){if(!r(e))return e;var n,o;if(t&&"function"==typeof(n=e.toString)&&!r(o=n.call(e)))return o;if("function"==typeof(n=e.valueOf)&&!r(o=n.call(e)))return o;if(!t&&"function"==typeof(n=e.toString)&&!r(o=n.call(e)))return o;throw TypeError("Can't convert object to primitive value")};},function(e,t){e.exports=function(e,t){return {enumerable:!(1&e),configurable:!(2&e),writable:!(4&e),value:t}};},function(e,t,n){var r=n(20),o=n(45),i=n(46),u=n(29),a=n(11),s=Object.assign;e.exports=!s||n(4)((function(){var e={},t={},n=Symbol(),r="abcdefghijklmnopqrst";return e[n]=7,r.split("").forEach((function(e){t[e]=e;})),7!=s({},e)[n]||Object.keys(s({},t)).join("")!=r}))?function(e,t){for(var n=u(e),s=arguments.length,l=1,c=o.f,p=i.f;l<s;)for(var f,d=a(arguments[l++]),h=c?r(d).concat(c(d)):r(d),v=h.length,m=0;m<v;)p.call(d,f=h[m++])&&(n[f]=d[f]);return n}:s;},function(e,t,n){var r=n(17),o=n(21),i=n(23)(!1),u=n(26)("IE_PROTO");e.exports=function(e,t){var n,a=o(e),s=0,l=[];for(n in a)n!=u&&r(a,n)&&l.push(n);for(;t.length>s;)r(a,n=t[s++])&&(~i(l,n)||l.push(n));return l};},function(e,t,n){var r=n(25),o=Math.max,i=Math.min;e.exports=function(e,t){return (e=r(e))<0?o(e+t,0):i(e,t)};},function(e,t){e.exports=!1;},function(e,t){t.f=Object.getOwnPropertySymbols;},function(e,t){t.f={}.propertyIsEnumerable;},function(e,t,n){var r=n(48);e.exports=function(e,t){return new(r(e))(t)};},function(e,t,n){var r=n(2),o=n(33),i=n(34)("species");e.exports=function(e){var t;return o(e)&&("function"!=typeof(t=e.constructor)||t!==Array&&!o(t.prototype)||(t=void 0),r(t)&&null===(t=t[i])&&(t=void 0)),void 0===t?Array:t};},function(e,t,n){var r=n(0),o=n(32)(2);r(r.P+r.F*!n(13)([].filter,!0),"Array",{filter:function(e){return o(this,e,arguments[1])}});},function(e,t,n){var r=n(0);r(r.S,"Array",{isArray:n(33)});},function(e,t,n){t.__esModule=!0,t.default=void 0,n(14),n(36),n(30),n(31),n(35),n(55),n(58);var r=n(5),o=u(n(60)),i=u(n(61));function u(e){return e&&e.__esModule?e:{default:e}}function a(){return (a=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r]);}return e}).apply(this,arguments)}function s(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}var l={13:"enter",27:"escape",32:"space",38:"up",40:"down"};function c(){return "undefined"!=typeof navigator&&!(!navigator.userAgent.match(/(iPod|iPhone|iPad)/g)||!navigator.userAgent.match(/AppleWebKit/g))}var p=function(e){function t(t){var n;return (n=e.call(this,t)||this).elementReferences={},n.state={focused:null,hovered:null,menuOpen:!1,options:t.defaultValue?[t.defaultValue]:[],query:t.defaultValue,validChoiceMade:!1,selected:null,ariaHint:!0},n.handleComponentBlur=n.handleComponentBlur.bind(s(s(n))),n.handleKeyDown=n.handleKeyDown.bind(s(s(n))),n.handleUpArrow=n.handleUpArrow.bind(s(s(n))),n.handleDownArrow=n.handleDownArrow.bind(s(s(n))),n.handleEnter=n.handleEnter.bind(s(s(n))),n.handlePrintableKey=n.handlePrintableKey.bind(s(s(n))),n.handleListMouseLeave=n.handleListMouseLeave.bind(s(s(n))),n.handleOptionBlur=n.handleOptionBlur.bind(s(s(n))),n.handleOptionClick=n.handleOptionClick.bind(s(s(n))),n.handleOptionFocus=n.handleOptionFocus.bind(s(s(n))),n.handleOptionMouseDown=n.handleOptionMouseDown.bind(s(s(n))),n.handleOptionMouseEnter=n.handleOptionMouseEnter.bind(s(s(n))),n.handleInputBlur=n.handleInputBlur.bind(s(s(n))),n.handleInputChange=n.handleInputChange.bind(s(s(n))),n.handleInputFocus=n.handleInputFocus.bind(s(s(n))),n.pollInputElement=n.pollInputElement.bind(s(s(n))),n.getDirectInputChanges=n.getDirectInputChanges.bind(s(s(n))),n}!function(e,t){e.prototype=Object.create(t.prototype),(e.prototype.constructor=e).__proto__=t;}(t,e);var n=t.prototype;return n.isQueryAnOption=function(e,t){var n=this;return -1!==t.map((function(e){return n.templateInputValue(e).toLowerCase()})).indexOf(e.toLowerCase())},n.componentDidMount=function(){this.pollInputElement();},n.componentWillUnmount=function(){clearTimeout(this.$pollInput);},n.pollInputElement=function(){var e=this;this.getDirectInputChanges(),this.$pollInput=setTimeout((function(){e.pollInputElement();}),100);},n.getDirectInputChanges=function(){var e=this.elementReferences[-1];e&&e.value!==this.state.query&&this.handleInputChange({target:{value:e.value}});},n.componentDidUpdate=function(e,t){var n=this.state.focused,r=null===n,o=t.focused!==n;o&&!r&&this.elementReferences[n].focus();var i=-1===n,u=o&&null===t.focused;if(i&&u){var a=this.elementReferences[n];a.setSelectionRange(0,a.value.length);}},n.hasAutoselect=function(){return !c()&&this.props.autoselect},n.templateInputValue=function(e){var t=this.props.templates&&this.props.templates.inputValue;return t?t(e):e},n.templateSuggestion=function(e){var t=this.props.templates&&this.props.templates.suggestion;return t?t(e):e},n.handleComponentBlur=function(e){var t,n=this.state,r=n.options,o=n.query,i=n.selected;this.props.confirmOnBlur?(t=e.query||o,this.props.onConfirm(r[i])):t=o,this.setState({focused:null,menuOpen:e.menuOpen||!1,query:t,selected:null,validChoiceMade:this.isQueryAnOption(t,r)});},n.handleListMouseLeave=function(e){this.setState({hovered:null});},n.handleOptionBlur=function(e,t){var n=this.state,r=n.focused,o=n.menuOpen,i=n.options,u=n.selected,a=null===e.relatedTarget,s=e.relatedTarget===this.elementReferences[-1],l=r!==t&&-1!==r;if(!l&&a||!l&&!s){var p=o&&c();this.handleComponentBlur({menuOpen:p,query:this.templateInputValue(i[u])});}},n.handleInputBlur=function(e){var t=this.state,n=t.focused,r=t.menuOpen,o=t.options,i=t.query,u=t.selected;if(-1===n){var a=r&&c(),s=c()?i:this.templateInputValue(o[u]);this.handleComponentBlur({menuOpen:a,query:s});}},n.handleInputChange=function(e){var t=this,n=this.props,r=n.minLength,o=n.source,i=n.showAllValues,u=this.hasAutoselect(),a=e.target.value,s=0===a.length,l=this.state.query.length!==a.length,c=a.length>=r;this.setState({query:a,ariaHint:s}),i||!s&&l&&c?o(a,(function(e){var n=0<e.length;t.setState({menuOpen:n,options:e,selected:u&&n?0:-1,validChoiceMade:!1});})):!s&&c||this.setState({menuOpen:!1,options:[]});},n.handleInputClick=function(e){this.handleInputChange(e);},n.handleInputFocus=function(e){var t=this.state,n=t.query,r=t.validChoiceMade,o=t.options,i=this.props.minLength,u=!r&&n.length>=i&&0<o.length;u?this.setState((function(e){var t=e.menuOpen;return {focused:-1,menuOpen:u||t,selected:-1}})):this.setState({focused:-1});},n.handleOptionFocus=function(e){this.setState({focused:e,hovered:null,selected:e});},n.handleOptionMouseEnter=function(e,t){c()||this.setState({hovered:t});},n.handleOptionClick=function(e,t){var n=this.state.options[t],r=this.templateInputValue(n);this.props.onConfirm(n),this.setState({focused:-1,hovered:null,menuOpen:!1,query:r,selected:-1,validChoiceMade:!0}),this.forceUpdate();},n.handleOptionMouseDown=function(e){e.preventDefault();},n.handleUpArrow=function(e){e.preventDefault();var t=this.state,n=t.menuOpen,r=t.selected;-1!==r&&n&&this.handleOptionFocus(r-1);},n.handleDownArrow=function(e){var t=this;if(e.preventDefault(),this.props.showAllValues&&!1===this.state.menuOpen)e.preventDefault(),this.props.source("",(function(e){t.setState({menuOpen:!0,options:e,selected:0,focused:0,hovered:null});}));else if(!0===this.state.menuOpen){var n=this.state,r=n.menuOpen,o=n.options,i=n.selected;i!==o.length-1&&r&&this.handleOptionFocus(i+1);}},n.handleSpace=function(e){var t=this;this.props.showAllValues&&!1===this.state.menuOpen&&""===this.state.query&&(e.preventDefault(),this.props.source("",(function(e){t.setState({menuOpen:!0,options:e});}))),-1!==this.state.focused&&(e.preventDefault(),this.handleOptionClick(e,this.state.focused));},n.handleEnter=function(e){this.state.menuOpen&&(e.preventDefault(),0<=this.state.selected&&this.handleOptionClick(e,this.state.selected));},n.handlePrintableKey=function(e){var t=this.elementReferences[-1];e.target===t||t.focus();},n.handleKeyDown=function(e){switch(l[e.keyCode]){case"up":this.handleUpArrow(e);break;case"down":this.handleDownArrow(e);break;case"space":this.handleSpace(e);break;case"enter":this.handleEnter(e);break;case"escape":this.handleComponentBlur({query:this.state.query});break;default:(function(e){return 47<e&&e<58||32===e||8===e||64<e&&e<91||95<e&&e<112||185<e&&e<193||218<e&&e<223})(e.keyCode)&&this.handlePrintableKey(e);}},n.render=function(){var e,t=this,n=this.props,i=n.cssNamespace,u=n.displayMenu,s=n.id,l=n.minLength,p=n.name,f=n.placeholder,d=n.required,h=n.showAllValues,v=n.tNoResults,m=n.tStatusQueryTooShort,y=n.tStatusNoResults,_=n.tStatusSelectedOption,g=n.tStatusResults,b=n.tAssistiveHint,w=n.dropdownArrow,x=this.state,O=x.focused,C=x.hovered,S=x.menuOpen,E=x.options,M=x.query,N=x.selected,I=x.ariaHint,A=x.validChoiceMade,k=this.hasAutoselect(),j=-1===O,P=0===E.length,L=0!==M.length,T=M.length>=l,B=this.props.showNoOptionsFound&&j&&P&&L&&T,D=i+"__wrapper",F=i+"__input",R=null!==O?" "+F+"--focused":"",U=this.props.showAllValues?" "+F+"--show-all-values":" "+F+"--default",V=i+"__dropdown-arrow-down",q=-1!==O&&null!==O,H=i+"__menu",W=H+"--"+u,K=H+"--"+(S||B?"visible":"hidden"),Q=i+"__option",z=i+"__hint",G=this.templateInputValue(E[N]),$=G&&0===G.toLowerCase().indexOf(M.toLowerCase())&&k?M+G.substr(M.length):"",J=s+"__assistiveHint",X=I?{"aria-describedby":J}:null;return h&&"string"==typeof(e=w({className:V}))&&(e=(0, r.createElement)("div",{className:i+"__dropdown-arrow-down-wrapper",dangerouslySetInnerHTML:{__html:e}})),(0, r.createElement)("div",{className:D,onKeyDown:this.handleKeyDown},(0, r.createElement)(o.default,{id:s,length:E.length,queryLength:M.length,minQueryLength:l,selectedOption:this.templateInputValue(E[N]),selectedOptionIndex:N,validChoiceMade:A,isInFocus:null!==this.state.focused,tQueryTooShort:m,tNoResults:y,tSelectedOption:_,tResults:g}),$&&(0, r.createElement)("span",null,(0, r.createElement)("input",{className:z,readonly:!0,tabIndex:"-1",value:$})),(0, r.createElement)("input",a({"aria-expanded":S?"true":"false","aria-activedescendant":!!q&&s+"__option--"+O,"aria-owns":s+"__listbox","aria-autocomplete":this.hasAutoselect()?"both":"list"},X,{autoComplete:"off",className:""+F+R+U,id:s,onClick:function(e){return t.handleInputClick(e)},onBlur:this.handleInputBlur},function(e){return {onInput:e}}(this.handleInputChange),{onFocus:this.handleInputFocus,name:p,placeholder:f,ref:function(e){t.elementReferences[-1]=e;},type:"text",role:"combobox",required:d,value:M})),e,(0, r.createElement)("ul",{className:H+" "+W+" "+K,onMouseLeave:function(e){return t.handleListMouseLeave(e)},id:s+"__listbox",role:"listbox"},E.map((function(e,n){var o=(-1===O?N===n:O===n)&&null===C?" "+Q+"--focused":"",i=n%2?" "+Q+"--odd":"",u=c()?"<span id="+s+"__option-suffix--"+n+' style="border:0;clip:rect(0 0 0 0);height:1px;marginBottom:-1px;marginRight:-1px;overflow:hidden;padding:0;position:absolute;whiteSpace:nowrap;width:1px"> '+(n+1)+" of "+E.length+"</span>":"";return (0, r.createElement)("li",{"aria-selected":O===n?"true":"false",className:""+Q+o+i,dangerouslySetInnerHTML:{__html:t.templateSuggestion(e)+u},id:s+"__option--"+n,key:n,onBlur:function(e){return t.handleOptionBlur(e,n)},onClick:function(e){return t.handleOptionClick(e,n)},onMouseDown:t.handleOptionMouseDown,onMouseEnter:function(e){return t.handleOptionMouseEnter(e,n)},ref:function(e){t.elementReferences[n]=e;},role:"option",tabIndex:"-1","aria-posinset":n+1,"aria-setsize":E.length})})),B&&(0, r.createElement)("li",{className:Q+" "+Q+"--no-results"},v())),(0, r.createElement)("span",{id:J,style:{display:"none"}},b()))},t}(r.Component);(t.default=p).defaultProps={autoselect:!1,cssNamespace:"autocomplete",defaultValue:"",displayMenu:"inline",minLength:0,name:"input-autocomplete",placeholder:"",onConfirm:function(){},confirmOnBlur:!0,showNoOptionsFound:!0,showAllValues:!1,required:!1,tNoResults:function(){return "No results found"},tAssistiveHint:function(){return "When autocomplete results are available use up and down arrows to review and enter to select.  Touch device users, explore by touch or with swipe gestures."},dropdownArrow:i.default};},function(e,t,n){var r=n(9),o=n(53),i=n(28),u=n(26)("IE_PROTO"),a=function(){},s="prototype",l=function(){var e,t=n(15)("iframe"),r=i.length;for(t.style.display="none",n(54).appendChild(t),t.src="javascript:",(e=t.contentWindow.document).open(),e.write("<script>document.F=Object<\/script>"),e.close(),l=e.F;r--;)delete l[s][i[r]];return l()};e.exports=Object.create||function(e,t){var n;return null!==e?(a[s]=r(e),n=new a,a[s]=null,n[u]=e):n=l(),void 0===t?n:o(n,t)};},function(e,t,n){var r=n(8),o=n(9),i=n(20);e.exports=n(3)?Object.defineProperties:function(e,t){o(e);for(var n,u=i(t),a=u.length,s=0;s<a;)r.f(e,n=u[s++],t[n]);return e};},function(e,t,n){var r=n(1).document;e.exports=r&&r.documentElement;},function(e,t,n){var r=n(0);r(r.P,"Function",{bind:n(56)});},function(e,t,n){var r=n(19),o=n(2),i=n(57),u=[].slice,a={};e.exports=Function.bind||function(e){var t=r(this),n=u.call(arguments,1),s=function(){var r=n.concat(u.call(arguments));return this instanceof s?function(e,t,n){if(!(t in a)){for(var r=[],o=0;o<t;o++)r[o]="a["+o+"]";a[t]=Function("F,a","return new F("+r.join(",")+")");}return a[t](e,n)}(t,r.length,r):i(t,r,e)};return o(t.prototype)&&(s.prototype=t.prototype),s};},function(e,t){e.exports=function(e,t,n){var r=void 0===n;switch(t.length){case 0:return r?e():e.call(n);case 1:return r?e(t[0]):e.call(n,t[0]);case 2:return r?e(t[0],t[1]):e.call(n,t[0],t[1]);case 3:return r?e(t[0],t[1],t[2]):e.call(n,t[0],t[1],t[2]);case 4:return r?e(t[0],t[1],t[2],t[3]):e.call(n,t[0],t[1],t[2],t[3])}return e.apply(n,t)};},function(e,t,n){n(59)("match",1,(function(e,t,n){return [function(n){var r=e(this),o=null==n?void 0:n[t];return void 0!==o?o.call(n,r):new RegExp(n)[t](String(r))},n]}));},function(e,t,n){var r=n(7),o=n(16),i=n(4),u=n(12),a=n(34);e.exports=function(e,t,n){var s=a(e),l=n(u,s,""[e]),c=l[0],p=l[1];i((function(){var t={};return t[s]=function(){return 7},7!=""[e](t)}))&&(o(String.prototype,e,c),r(RegExp.prototype,s,2==t?function(e,t){return p.call(e,this,t)}:function(e){return p.call(e,this)}));};},function(e,t,n){t.__esModule=!0,t.default=void 0,n(36);var r=n(5),o=function(e){function t(){for(var t,n=arguments.length,r=new Array(n),o=0;o<n;o++)r[o]=arguments[o];return (t=e.call.apply(e,[this].concat(r))||this).state={bump:!1,debounced:!1},t}!function(e,t){e.prototype=Object.create(t.prototype),(e.prototype.constructor=e).__proto__=t;}(t,e);var n=t.prototype;return n.componentWillMount=function(){var e=this;this.debounceStatusUpdate=function(e,t,n){var r;return function(){var o=this,i=arguments,u=function(){r=null,n||e.apply(o,i);},a=n&&!r;clearTimeout(r),r=setTimeout(u,t),a&&e.apply(o,i);}}((function(){if(!e.state.debounced){var t=!e.props.isInFocus||e.props.validChoiceMade;e.setState((function(e){return {bump:!e.bump,debounced:!0,silenced:t}}));}}),1400);},n.componentWillReceiveProps=function(e){e.queryLength,this.setState({debounced:!1});},n.render=function(){var e,t=this.props,n=t.id,o=t.length,i=t.queryLength,u=t.minQueryLength,a=t.selectedOption,s=t.selectedOptionIndex,l=t.tQueryTooShort,c=t.tNoResults,p=t.tSelectedOption,f=t.tResults,d=this.state,h=d.bump,v=d.debounced,m=d.silenced,y=i<u,_=0===o,g=a?p(a,o,s):"";return e=y?l(u):_?c():f(o,g),this.debounceStatusUpdate(),(0, r.createElement)("div",{style:{border:"0",clip:"rect(0 0 0 0)",height:"1px",marginBottom:"-1px",marginRight:"-1px",overflow:"hidden",padding:"0",position:"absolute",whiteSpace:"nowrap",width:"1px"}},(0, r.createElement)("div",{id:n+"__status--A",role:"status","aria-atomic":"true","aria-live":"polite"},!m&&v&&h?e:""),(0, r.createElement)("div",{id:n+"__status--B",role:"status","aria-atomic":"true","aria-live":"polite"},m||!v||h?"":e))},t}(r.Component);(t.default=o).defaultProps={tQueryTooShort:function(e){return "Type in "+e+" or more characters for results"},tNoResults:function(){return "No search results"},tSelectedOption:function(e,t,n){return e+" "+(n+1)+" of "+t+" is highlighted"},tResults:function(e,t){return e+" "+(1===e?"result":"results")+" "+(1===e?"is":"are")+" available. "+t}};},function(e,t,n){t.__esModule=!0,t.default=void 0;var r=n(5);t.default=function(e){var t=e.className;return (0, r.createElement)("svg",{version:"1.1",xmlns:"http://www.w3.org/2000/svg",className:t,focusable:"false"},(0, r.createElement)("g",{stroke:"none",fill:"none","fill-rule":"evenodd"},(0, r.createElement)("polygon",{fill:"#000000",points:"0 0 22 0 11 17"})))};}]).default},e.exports=n();}));var accessibleAutocomplete = unwrapExports(accessibleAutocomplete_min);
const NAME$a="selectautocomplete";class SelectAutocomplete extends BaseComponent{constructor(e,t){super(e),this._config=t,this._enhance();}static get NAME(){return NAME$a}_enhance(){accessibleAutocomplete.enhanceSelectElement(Object.assign({},{selectElement:this._element},this._config));}}var SelectAutocomplete$1 = SelectAutocomplete;const NAME$9="inputsearchautocomplete",DATA_KEY$4="bs.inputsearchautocomplete",EVENT_KEY$4=`.${DATA_KEY$4}`,Default$5={autocomplete:[]},EVENT_KEYUP$1=`keyup${EVENT_KEY$4}`,EVENT_KEYUP_DATA_API=`keyup${EVENT_KEY$4}.data-api`,CLASS_NAME_SHOW$1="autocomplete-list-show",DATA_AUTOCOMPLETE="data-bs-autocomplete",SELECTOR_SEARCH='input[data-bs-autocomplete][type="search"]';class InputSearch extends BaseComponent{constructor(e,t){super(e),this._config=this._getConfig(t),this._items=[],this._autocompleteElement=null,this._label=new InputLabel$1(e),this._init(),this._bindEvents();}static get NAME(){return NAME$9}search(){const e=this._element.value;//!!! $autocomplete.empty()
this._autocompleteElement.innerHTML="",e?this._items.forEach((t=>{let n=new RegExp("("+e+")","gi"),o=t.text.replace(n,"<mark>$1</mark>"),a=t.label?"<em>"+t.label+"</em>":"",s=t.icon?t.icon:"",i=t.link?t.link:"#";-1!==o.toLowerCase().indexOf(e.toLowerCase())&&(this._autocompleteElement.classList.add(CLASS_NAME_SHOW$1),this._autocompleteElement.appendChild(this._createOption(i,o,a,s)));})):this._autocompleteElement.classList.remove(CLASS_NAME_SHOW$1);}_getConfig(e){return e={...Default$5,..."object"==typeof e?e:{}}}_getItems(){try{return JSON.parse(this._element.getAttribute(DATA_AUTOCOMPLETE))}catch(e){return console.error("[InputSearchAutocomplete] invalid data provided for data-bs-autocomplete attribute",e),[]}}_init(){this._element.classList.contains("autocomplete")&&(this._items=this._getItems(),this._autocompleteElement=document.createElement("ul"),this._autocompleteElement.classList.add("autocomplete-list"),this._element.parentNode.insertBefore(this._autocompleteElement,this._element.nextSibling));}_bindEvents(){EventHandler$1.on(this._element,EVENT_KEYUP$1,(()=>this.search()));}_createOption(e,t,n,o){const a=document.createElement("li");return a.innerHTML=`<a href="${e}">\n        ${o}\n        <span class="autocomplete-list-text">\n          <span>${t}</span>\n          ${n}\n        </span>\n      </a>`,a}}const inputs$1=SelectorEngine$1.find(SELECTOR_SEARCH);inputs$1.forEach((e=>{EventHandler$1.one(e,EVENT_KEYUP_DATA_API,(()=>{InputSearch.getOrCreateInstance(e).search();}));}));var InputSearchAutocomplete = InputSearch;const NAME$8="inputpassword",DATA_KEY$3="bs.inputpassword",EVENT_KEY$3=`.${DATA_KEY$3}`,Default$4={shortPass:"Password molto debole",badPass:"Password debole",goodPass:"Password sicura",strongPass:"Password molto sicura",enterPass:"Inserisci almeno 8 caratteri e una lettera maiuscola",alertCaps:"CAPS LOCK inserito",showText:!0,minimumLength:4},EVENT_CLICK$5=`click${EVENT_KEY$3}`,EVENT_KEYUP=`keyup${EVENT_KEY$3}`,EVENT_KEYDOWN=`keydown${EVENT_KEY$3}`,EVENT_KEYPRESS=`keypress${EVENT_KEY$3}`,EVENT_SCORE=`score${EVENT_KEY$3}`,EVENT_TEXT=`text${EVENT_KEY$3}`,CLASS_NAME_METER="input-password-strength-meter",SELECTOR_PASSWORD='input[data-bs-input][type="password"]';class InputPassword extends BaseComponent{constructor(t,e){super(t),this._config=this._getConfig(e),this._isCustom=this._element.classList.contains("input-password"),this._hasMeter=this._element.classList.contains(CLASS_NAME_METER),this._isShiftPressed=!1,this._isCapsOn=!1,this._grayBarElement=null,this._colorBarElement=null,this._textElement=null,this._capsElement=null,this._showPwdElement=null,this._label=new InputLabel$1(t),this._init(),this._bindEvents();}static get NAME(){return NAME$8}_getConfig(t){return t={...Default$4,...Manipulator.getDataAttributes(this._element),..."object"==typeof t?t:{}}}_init(){if(this._hasMeter){this._grayBarElement=document.createElement("div"),this._grayBarElement.classList.add("password-meter","progress","rounded-0","position-absolute"),this._grayBarElement.innerHTML='<div class="row position-absolute w-100 m-0">\n          <div class="col-3 border-start border-end border-white"></div>\n          <div class="col-3 border-start border-end border-white"></div>\n          <div class="col-3 border-start border-end border-white"></div>\n          <div class="col-3 border-start border-end border-white"></div>\n        </div>',this._colorBarElement=document.createElement("div"),this._colorBarElement.classList.add("progress-bar"),this._colorBarElement.setAttribute("role","progressbar"),this._colorBarElement.setAttribute("aria-valuenow","0"),this._colorBarElement.setAttribute("aria-valuemin","0"),this._colorBarElement.setAttribute("aria-valuemax","100");const t=document.createElement("div");t.classList.add("password-strength-meter"),this._grayBarElement.appendChild(this._colorBarElement),this._config.showText&&(this._textElement=document.createElement("small"),this._textElement.classList.add("form-text","text-muted"),this._textElement.innerHTML=this._config.enterPass,t.appendChild(this._textElement)),t.appendChild(this._grayBarElement),this._element.parentNode.insertBefore(t,this._element.nextSibling);}this._isCustom&&(this._capsElement=document.createElement("small"),this._capsElement.style.display="none",this._capsElement.classList.add("password-caps","form-text","text-warning","position-absolute","bg-white","w-100"),this._capsElement.innerHTML=this._config.alertCaps,this._element.parentNode.appendChild(this._capsElement)),this._showPwdElement=SelectorEngine$1.findOne(".password-icon",this._element.parentNode);}_bindEvents(){this._hasMeter&&EventHandler$1.on(this._element,EVENT_KEYUP,(()=>this._checkPassword())),this._isCustom&&(EventHandler$1.on(this._element,EVENT_KEYDOWN,(t=>{"Shift"===t.key&&(this._isShiftPressed=!0);})),EventHandler$1.on(this._element,EVENT_KEYUP,(t=>{"Shift"===t.key&&(this._isShiftPressed=!1),"CapsLock"===t.key&&(this._isCapsOn=!this._isCapsOn,this._isCapsOn?this._showCapsMsg():this._hideCapsMsg());})),EventHandler$1.on(this._element,EVENT_KEYPRESS,(t=>{(t.key.match(/[A-Z]$/)||[]).length>0&&!this._isShiftPressed?(this._isCapsOn=!0,this._showCapsMsg()):this._isCapsOn&&(this._isCapsOn=!1,this._hideCapsMsg());}))),this._showPwdElement&&EventHandler$1.on(this._showPwdElement,EVENT_CLICK$5,(()=>this._toggleShowPassword()));}_showCapsMsg(){this._capsElement.style.display="block";}_hideCapsMsg(){this._capsElement.style.display="none";}_toggleShowPassword(){const t="password"===this._element.getAttribute("type");SelectorEngine$1.find('[class^="password-icon"]',this._showPwdElement).forEach((t=>t.classList.toggle("d-none"))),t?this._element.setAttribute("type","text"):this._element.setAttribute("type","password");}_checkPassword(){const t=this._calculateScore(this._element.value),e=t<0?0:t;if(this._colorBarElement.classList.forEach((t=>{t.match(/(^|\s)bg-\S+/g)&&this._colorBarElement.classList.remove(t);})),this._colorBarElement.classList.add("bg-"+this._scoreColor(t)),this._colorBarElement.style.width=e+"%",this._colorBarElement.setAttribute("aria-valuenow",e),EventHandler$1.trigger(this._element,EVENT_SCORE),this._config.showText){let e=this._scoreText(t);0===this._element.value.length&&t<=0&&(e=this._config.enterPass),-1===this._textElement.innerHTML.search(e)&&(this._textElement.innerHTML=e,this._textElement.classList.forEach((t=>{t.match(/(^|\s)text-\S+/g)&&this._textElement.classList.remove(t);})),this._textElement.classList.add("text-"+this._scoreColor(t)),EventHandler$1.trigger(this._element,EVENT_TEXT));}}_scoreText(t){return -1===t||(t=t<0?0:t)<26?this._config.shortPass:t<51?this._config.badPass:t<76?this._config.goodPass:this._config.strongPass}_scoreColor(t){return -1===t?"danger":-2===t?"muted":(t=t<0?0:t)<26?"danger":t<51?"warning":"success"}_calculateScore(t){var e=0;if(0===t.trim().length)return -2;if(t.length<this._config.minimumLength)return -1;e+=4*t.length,e+=this._checkRepetition(1,t).length-t.length,e+=this._checkRepetition(2,t).length-t.length,e+=this._checkRepetition(3,t).length-t.length,e+=this._checkRepetition(4,t).length-t.length,t.match(/(.*[0-9].*[0-9].*[0-9])/)&&(e+=5);var s=".*[!,@,#,$,%,^,&,*,?,_,~]";return s=new RegExp("("+s+s+")"),t.match(s)&&(e+=5),t.match(/([a-z].*[A-Z])|([A-Z].*[a-z])/)&&(e+=10),t.match(/([a-zA-Z])/)&&t.match(/([0-9])/)&&(e+=15),t.match(/([!,@,#,$,%,^,&,*,?,_,~])/)&&t.match(/([0-9])/)&&(e+=15),t.match(/([!,@,#,$,%,^,&,*,?,_,~])/)&&t.match(/([a-zA-Z])/)&&(e+=15),(t.match(/^\w+$/)||t.match(/^\d+$/))&&(e-=10),e>100&&(e=100),e<0&&(e=0),e}_checkRepetition(t,e){for(var s="",i=!1,n=0;n<e.length;n++){i=!0;for(var r=0;r<t&&r+n+t<e.length;r++)i=i&&e.charAt(r+n)===e.charAt(r+n+t);r<t&&(i=!1),i?(n+=t-1,i=!1):s+=e.charAt(n);}return s}}const inputs=SelectorEngine$1.find(SELECTOR_PASSWORD);inputs.forEach((t=>{InputPassword.getOrCreateInstance(t);}));var InputPassword$1 = InputPassword;var shifty_node=createCommonjsModule((function(t,e){
/*! Shifty 2.17.1 - https://github.com/jeremyckahn/shifty */
var n;n=function(){return (()=>{var t={720:(t,e,n)=>{n.r(e),n.d(e,{Scene:()=>Yt,Tweenable:()=>_t,interpolate:()=>Ut,processTweens:()=>ft,setBezierFunction:()=>te,tween:()=>mt,unsetBezierFunction:()=>ee});var r={};n.r(r),n.d(r,{bounce:()=>D,bouncePast:()=>q,easeFrom:()=>B,easeFromTo:()=>Q,easeInBack:()=>E,easeInCirc:()=>j,easeInCubic:()=>c,easeInExpo:()=>b,easeInOutBack:()=>F,easeInOutCirc:()=>P,easeInOutCubic:()=>l,easeInOutExpo:()=>S,easeInOutQuad:()=>s,easeInOutQuart:()=>v,easeInOutQuint:()=>y,easeInOutSine:()=>w,easeInQuad:()=>a,easeInQuart:()=>h,easeInQuint:()=>_,easeInSine:()=>d,easeOutBack:()=>x,easeOutBounce:()=>M,easeOutCirc:()=>k,easeOutCubic:()=>f,easeOutExpo:()=>O,easeOutQuad:()=>u,easeOutQuart:()=>p,easeOutQuint:()=>m,easeOutSine:()=>g,easeTo:()=>H,elastic:()=>I,linear:()=>o,swingFrom:()=>A,swingFromTo:()=>T,swingTo:()=>C});var i={};n.r(i),n.d(i,{afterTween:()=>Ht,beforeTween:()=>Bt,doesApply:()=>qt,tweenCreated:()=>Qt});
/*!
 * All equations are adapted from Thomas Fuchs'
 * [Scripty2](https://github.com/madrobby/scripty2/blob/master/src/effects/transitions/penner.js).
 *
 * Based on Easing Equations (c) 2003 [Robert
 * Penner](http://www.robertpenner.com/), all rights reserved. This work is
 * [subject to terms](http://www.robertpenner.com/easing_terms_of_use.html).
 */
/*!
 *  TERMS OF USE - EASING EQUATIONS
 *  Open source under the BSD License.
 *  Easing Equations (c) 2003 Robert Penner, all rights reserved.
 */
var o=function(t){return t},a=function(t){return Math.pow(t,2)},u=function(t){return -(Math.pow(t-1,2)-1)},s=function(t){return (t/=.5)<1?.5*Math.pow(t,2):-.5*((t-=2)*t-2)},c=function(t){return Math.pow(t,3)},f=function(t){return Math.pow(t-1,3)+1},l=function(t){return (t/=.5)<1?.5*Math.pow(t,3):.5*(Math.pow(t-2,3)+2)},h=function(t){return Math.pow(t,4)},p=function(t){return -(Math.pow(t-1,4)-1)},v=function(t){return (t/=.5)<1?.5*Math.pow(t,4):-.5*((t-=2)*Math.pow(t,3)-2)},_=function(t){return Math.pow(t,5)},m=function(t){return Math.pow(t-1,5)+1},y=function(t){return (t/=.5)<1?.5*Math.pow(t,5):.5*(Math.pow(t-2,5)+2)},d=function(t){return 1-Math.cos(t*(Math.PI/2))},g=function(t){return Math.sin(t*(Math.PI/2))},w=function(t){return -.5*(Math.cos(Math.PI*t)-1)},b=function(t){return 0===t?0:Math.pow(2,10*(t-1))},O=function(t){return 1===t?1:1-Math.pow(2,-10*t)},S=function(t){return 0===t?0:1===t?1:(t/=.5)<1?.5*Math.pow(2,10*(t-1)):.5*(2-Math.pow(2,-10*--t))},j=function(t){return -(Math.sqrt(1-t*t)-1)},k=function(t){return Math.sqrt(1-Math.pow(t-1,2))},P=function(t){return (t/=.5)<1?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1)},M=function(t){return t<1/2.75?7.5625*t*t:t<2/2.75?7.5625*(t-=1.5/2.75)*t+.75:t<2.5/2.75?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375},E=function(t){var e=1.70158;return t*t*((e+1)*t-e)},x=function(t){var e=1.70158;return (t-=1)*t*((e+1)*t+e)+1},F=function(t){var e=1.70158;return (t/=.5)<1?t*t*((1+(e*=1.525))*t-e)*.5:.5*((t-=2)*t*((1+(e*=1.525))*t+e)+2)},I=function(t){return -1*Math.pow(4,-8*t)*Math.sin((6*t-1)*(2*Math.PI)/2)+1},T=function(t){var e=1.70158;return (t/=.5)<1?t*t*((1+(e*=1.525))*t-e)*.5:.5*((t-=2)*t*((1+(e*=1.525))*t+e)+2)},A=function(t){var e=1.70158;return t*t*((e+1)*t-e)},C=function(t){var e=1.70158;return (t-=1)*t*((e+1)*t+e)+1},D=function(t){return t<1/2.75?7.5625*t*t:t<2/2.75?7.5625*(t-=1.5/2.75)*t+.75:t<2.5/2.75?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375},q=function(t){return t<1/2.75?7.5625*t*t:t<2/2.75?2-(7.5625*(t-=1.5/2.75)*t+.75):t<2.5/2.75?2-(7.5625*(t-=2.25/2.75)*t+.9375):2-(7.5625*(t-=2.625/2.75)*t+.984375)},Q=function(t){return (t/=.5)<1?.5*Math.pow(t,4):-.5*((t-=2)*Math.pow(t,3)-2)},B=function(t){return Math.pow(t,4)},H=function(t){return Math.pow(t,.25)};function N(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}function R(t,e){for(var n=0;n<e.length;n++){var r=e[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(t,r.key,r);}}function z(t){return z="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},z(t)}function G(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r);}return n}function L(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?G(Object(n),!0).forEach((function(e){U(t,e,n[e]);})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):G(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e));}));}return t}function U(t,e,n){return e in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t}var V,W,$,J="linear",K="undefined"!=typeof window?window:commonjsGlobal,X="afterTween",Y="afterTweenEnd",Z="beforeTween",tt="tweenCreated",et="function",nt="string",rt=K.requestAnimationFrame||K.webkitRequestAnimationFrame||K.oRequestAnimationFrame||K.msRequestAnimationFrame||K.mozCancelRequestAnimationFrame&&K.mozRequestAnimationFrame||setTimeout,it=function(){},ot=null,at=null,ut=L({},r),st=function(t,e,n,r,i,o,a){var u,s,c,f=t<o?0:(t-o)/i,l=!1;for(var h in a&&a.call&&(l=!0,u=a(f)),e)l||(u=((s=a[h]).call?s:ut[s])(f)),c=n[h],e[h]=c+(r[h]-c)*u;return e},ct=function(t,e){var n=t._timestamp,r=t._currentState,i=t._delay;if(!(e<n+i)){var o=t._duration,a=t._targetState,u=n+i+o,s=e>u?u:e,c=s>=u,f=o-(u-s),l=t._filters.length>0;if(c)return t._render(a,t._data,f),t.stop(!0);l&&t._applyFilter(Z),s<n+i?n=o=s=1:n+=i,st(s,r,t._originalState,a,o,n,t._easing),l&&t._applyFilter(X),t._render(r,t._data,f);}},ft=function(){for(var t,e=_t.now(),n=ot;n;)t=n._next,ct(n,e),n=t;},lt=Date.now||function(){return +new Date},ht=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:J,n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=z(e);if(ut[e])return ut[e];if(r===nt||r===et)for(var i in t)n[i]=e;else for(var o in t)n[o]=e[o]||J;return n},pt=function(t){t===ot?(ot=t._next)?ot._previous=null:at=null:t===at?(at=t._previous)?at._next=null:ot=null:(W=t._previous,$=t._next,W._next=$,$._previous=W),t._previous=t._next=null;},vt="function"==typeof Promise?Promise:null,_t=function(){function t(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:void 0;N(this,t),this._config={},this._data={},this._delay=0,this._filters=[],this._next=null,this._previous=null,this._timestamp=null,this._resolve=null,this._reject=null,this._currentState=e||{},this._originalState={},this._targetState={},this._start=it,this._render=it,this._promiseCtor=vt,n&&this.setConfig(n);}var e,n;return e=t,n=[{key:"_applyFilter",value:function(t){for(var e=this._filters.length;e>0;e--){var n=this._filters[e-e][t];n&&n(this);}}},{key:"tween",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:void 0;return this._isPlaying&&this.stop(),!e&&this._config||this.setConfig(e),this._pausedAtTime=null,this._timestamp=t.now(),this._start(this.get(),this._data),this._delay&&this._render(this._currentState,this._data,0),this._resume(this._timestamp)}},{key:"setConfig",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=this._config;for(var r in e)n[r]=e[r];var i=n.promise,o=void 0===i?this._promiseCtor:i,a=n.start,u=void 0===a?it:a,s=n.finish,c=n.render,f=void 0===c?this._config.step||it:c,l=n.step,h=void 0===l?it:l;this._data=n.data||n.attachment||this._data,this._isPlaying=!1,this._pausedAtTime=null,this._scheduleId=null,this._delay=e.delay||0,this._start=u,this._render=f||h,this._duration=n.duration||500,this._promiseCtor=o,s&&(this._resolve=s);var p=e.from,v=e.to,_=void 0===v?{}:v,m=this._currentState,y=this._originalState,d=this._targetState;for(var g in p)m[g]=p[g];var w=!1;for(var b in m){var O=m[b];w||z(O)!==nt||(w=!0),y[b]=O,d[b]=_.hasOwnProperty(b)?_[b]:O;}if(this._easing=ht(this._currentState,n.easing,this._easing),this._filters.length=0,w){for(var S in t.filters)t.filters[S].doesApply(this)&&this._filters.push(t.filters[S]);this._applyFilter(tt);}return this}},{key:"then",value:function(t,e){var n=this;return this._promise=new this._promiseCtor((function(t,e){n._resolve=t,n._reject=e;})),this._promise.then(t,e)}},{key:"catch",value:function(t){return this.then().catch(t)}},{key:"get",value:function(){return L({},this._currentState)}},{key:"set",value:function(t){this._currentState=t;}},{key:"pause",value:function(){if(this._isPlaying)return this._pausedAtTime=t.now(),this._isPlaying=!1,pt(this),this}},{key:"resume",value:function(){return this._resume()}},{key:"_resume",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:t.now();return null===this._timestamp?this.tween():this._isPlaying?this._promise:(this._pausedAtTime&&(this._timestamp+=e-this._pausedAtTime,this._pausedAtTime=null),this._isPlaying=!0,null===ot?(ot=this,at=this):(this._previous=at,at._next=this,at=this),this)}},{key:"seek",value:function(e){e=Math.max(e,0);var n=t.now();return this._timestamp+e===0||(this._timestamp=n-e,ct(this,n)),this}},{key:"stop",value:function(){var t=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(!this._isPlaying)return this;this._isPlaying=!1,pt(this);var e=this._filters.length>0;return t&&(e&&this._applyFilter(Z),st(1,this._currentState,this._originalState,this._targetState,1,0,this._easing),e&&(this._applyFilter(X),this._applyFilter(Y))),this._resolve&&this._resolve({data:this._data,state:this._currentState,tweenable:this}),this._resolve=null,this._reject=null,this}},{key:"cancel",value:function(){var t=arguments.length>0&&void 0!==arguments[0]&&arguments[0],e=this._currentState,n=this._data,r=this._isPlaying;return r?(this._reject&&this._reject({data:n,state:e,tweenable:this}),this._resolve=null,this._reject=null,this.stop(t)):this}},{key:"isPlaying",value:function(){return this._isPlaying}},{key:"setScheduleFunction",value:function(e){t.setScheduleFunction(e);}},{key:"data",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;return t&&(this._data=L({},t)),this._data}},{key:"dispose",value:function(){for(var t in this)delete this[t];}}],n&&R(e.prototype,n),t}();function mt(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=new _t;return e.tween(t),e.tweenable=e,e}U(_t,"now",(function(){return V})),_t.setScheduleFunction=function(t){return rt=t},_t.formulas=ut,_t.filters={},function t(){V=lt(),rt.call(K,t,16.666666666666668),ft();}();var yt,dt,gt=/(\d|-|\.)/,wt=/([^\-0-9.]+)/g,bt=/[0-9.-]+/g,Ot=(yt=bt.source,dt=/,\s*/.source,new RegExp("rgba?\\(".concat(yt).concat(dt).concat(yt).concat(dt).concat(yt,"(").concat(dt).concat(yt,")?\\)"),"g")),St=/^.*\(/,jt=/#([0-9]|[a-f]){3,6}/gi,kt="VAL",Pt=function(t,e){return t.map((function(t,n){return "_".concat(e,"_").concat(n)}))};function Mt(t){return parseInt(t,16)}var Et=function(t){return "rgb(".concat((e=t,3===(e=e.replace(/#/,"")).length&&(e=(e=e.split(""))[0]+e[0]+e[1]+e[1]+e[2]+e[2]),[Mt(e.substr(0,2)),Mt(e.substr(2,2)),Mt(e.substr(4,2))]).join(","),")");var e;},xt=function(t,e,n){var r=e.match(t),i=e.replace(t,kt);return r&&r.forEach((function(t){return i=i.replace(kt,n(t))})),i},Ft=function(t){for(var e in t){var n=t[e];"string"==typeof n&&n.match(jt)&&(t[e]=xt(jt,n,Et));}},It=function(t){var e=t.match(bt),n=e.slice(0,3).map(Math.floor),r=t.match(St)[0];if(3===e.length)return "".concat(r).concat(n.join(","),")");if(4===e.length)return "".concat(r).concat(n.join(","),",").concat(e[3],")");throw new Error("Invalid rgbChunk: ".concat(t))},Tt=function(t){return t.match(bt)},At=function(t,e){var n={};return e.forEach((function(e){n[e]=t[e],delete t[e];})),n},Ct=function(t,e){return e.map((function(e){return t[e]}))},Dt=function(t,e){return e.forEach((function(e){return t=t.replace(kt,+e.toFixed(4))})),t},qt=function(t){for(var e in t._currentState)if("string"==typeof t._currentState[e])return !0;return !1};function Qt(t){var e=t._currentState;[e,t._originalState,t._targetState].forEach(Ft),t._tokenData=function(t){var e,n,r={};for(var i in t){var o=t[i];"string"==typeof o&&(r[i]={formatString:(e=o,n=void 0,n=e.match(wt),n?(1===n.length||e.charAt(0).match(gt))&&n.unshift(""):n=["",""],n.join(kt)),chunkNames:Pt(Tt(o),i)});}return r}(e);}function Bt(t){var e=t._currentState,n=t._originalState,r=t._targetState,i=t._easing,o=t._tokenData;!function(t,e){var n=function(n){var r=e[n].chunkNames,i=t[n];if("string"==typeof i){var o=i.split(" "),a=o[o.length-1];r.forEach((function(e,n){return t[e]=o[n]||a}));}else r.forEach((function(e){return t[e]=i}));delete t[n];};for(var r in e)n(r);}(i,o),[e,n,r].forEach((function(t){return function(t,e){var n=function(n){Tt(t[n]).forEach((function(r,i){return t[e[n].chunkNames[i]]=+r})),delete t[n];};for(var r in e)n(r);}(t,o)}));}function Ht(t){var e=t._currentState,n=t._originalState,r=t._targetState,i=t._easing,o=t._tokenData;[e,n,r].forEach((function(t){return function(t,e){for(var n in e){var r=e[n],i=r.chunkNames,o=r.formatString,a=Dt(o,Ct(At(t,i),i));t[n]=xt(Ot,a,It);}}(t,o)})),function(t,e){for(var n in e){var r=e[n].chunkNames,i=t[r[0]];t[n]="string"==typeof i?r.map((function(e){var n=t[e];return delete t[e],n})).join(" "):i;}}(i,o);}function Nt(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r);}return n}function Rt(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?Nt(Object(n),!0).forEach((function(e){zt(t,e,n[e]);})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):Nt(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e));}));}return t}function zt(t,e,n){return e in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t}var Gt=new _t,Lt=_t.filters,Ut=function(t,e,n,r){var i=arguments.length>4&&void 0!==arguments[4]?arguments[4]:0,o=Rt({},t),a=ht(t,r);for(var u in Gt._filters.length=0,Gt.set({}),Gt._currentState=o,Gt._originalState=t,Gt._targetState=e,Gt._easing=a,Lt)Lt[u].doesApply(Gt)&&Gt._filters.push(Lt[u]);Gt._applyFilter("tweenCreated"),Gt._applyFilter("beforeTween");var s=st(n,o,t,e,1,i,a);return Gt._applyFilter("afterTween"),s};function Vt(t){return function(t){if(Array.isArray(t))return Wt(t)}(t)||function(t){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(t))return Array.from(t)}(t)||function(t,e){if(t){if("string"==typeof t)return Wt(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);return "Object"===n&&t.constructor&&(n=t.constructor.name),"Map"===n||"Set"===n?Array.from(t):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?Wt(t,e):void 0}}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function Wt(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,r=new Array(e);n<e;n++)r[n]=t[n];return r}function $t(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}function Jt(t,e){for(var n=0;n<e.length;n++){var r=e[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(t,r.key,r);}}function Kt(t,e){var n=e.get(t);if(!n)throw new TypeError("attempted to get private field on non-instance");return n.get?n.get.call(t):n.value}var Xt=new WeakMap,Yt=function(){function t(){$t(this,t),Xt.set(this,{writable:!0,value:[]});for(var e=arguments.length,n=new Array(e),r=0;r<e;r++)n[r]=arguments[r];n.forEach(this.add.bind(this));}var e,n;return e=t,(n=[{key:"add",value:function(t){return Kt(this,Xt).push(t),t}},{key:"remove",value:function(t){var e=Kt(this,Xt).indexOf(t);return ~e&&Kt(this,Xt).splice(e,1),t}},{key:"empty",value:function(){return this.tweenables.map(this.remove.bind(this))}},{key:"isPlaying",value:function(){return Kt(this,Xt).some((function(t){return t.isPlaying()}))}},{key:"play",value:function(){return Kt(this,Xt).forEach((function(t){return t.tween()})),this}},{key:"pause",value:function(){return Kt(this,Xt).forEach((function(t){return t.pause()})),this}},{key:"resume",value:function(){return Kt(this,Xt).forEach((function(t){return t.resume()})),this}},{key:"stop",value:function(t){return Kt(this,Xt).forEach((function(e){return e.stop(t)})),this}},{key:"tweenables",get:function(){return Vt(Kt(this,Xt))}},{key:"promises",get:function(){return Kt(this,Xt).map((function(t){return t.then()}))}}])&&Jt(e.prototype,n),t}();function Zt(t,e,n,r,i,o){var a,u,s=0,c=0,f=0,l=0,h=0,p=0,v=function(t){return ((s*t+c)*t+f)*t},_=function(t){return (3*s*t+2*c)*t+f},m=function(t){return t>=0?t:0-t};return s=1-(f=3*e)-(c=3*(r-e)-f),l=1-(p=3*n)-(h=3*(i-n)-p),a=t,u=function(t){return 1/(200*t)}(o),function(t){return ((l*t+h)*t+p)*t}(function(t,e){var n,r,i,o,a,u;for(i=t,u=0;u<8;u++){if(o=v(i)-t,m(o)<e)return i;if(a=_(i),m(a)<1e-6)break;i-=o/a;}if((i=t)<(n=0))return n;if(i>(r=1))return r;for(;n<r;){if(o=v(i),m(o-t)<e)return i;t>o?n=i:r=i,i=.5*(r-n)+n;}return i}(a,u))}var te=function(t,e,n,r,i){var o=function(t,e,n,r){return function(i){return Zt(i,t,e,n,r,1)}}(e,n,r,i);return o.displayName=t,o.x1=e,o.y1=n,o.x2=r,o.y2=i,_t.formulas[t]=o},ee=function(t){return delete _t.formulas[t]};_t.filters.token=i;}},e={};function n(r){if(e[r])return e[r].exports;var i=e[r]={exports:{}};return t[r](i,i.exports,n),i.exports}return n.d=(t,e)=>{for(var r in e)n.o(e,r)&&!n.o(t,r)&&Object.defineProperty(t,r,{enumerable:!0,get:e[r]});},n.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e),n.r=t=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0});},n(720)})()},t.exports=n();}));unwrapExports(shifty_node);var PREFIXES="Webkit Moz O ms".split(" "),FLOAT_COMPARISON_EPSILON=.001;function extend(t,e,i){for(var r in t=t||{},i=i||!1,e=e||{})if(e.hasOwnProperty(r)){var s=t[r],l=e[r];i&&isObject(s)&&isObject(l)?t[r]=extend(s,l,i):t[r]=l;}return t}function render(t,e){var i=t;for(var r in e)if(e.hasOwnProperty(r)){var s=e[r],l=new RegExp("\\{"+r+"\\}","g");i=i.replace(l,s);}return i}function setStyle(t,e,i){for(var r=t.style,s=0;s<PREFIXES.length;++s){r[PREFIXES[s]+capitalize(e)]=i;}r[e]=i;}function setStyles(t,e){forEachObject(e,(function(e,i){null!=e&&(isObject(e)&&!0===e.prefix?setStyle(t,i,e.value):t.style[i]=e);}));}function capitalize(t){return t.charAt(0).toUpperCase()+t.slice(1)}function isString(t){return "string"==typeof t||t instanceof String}function isFunction(t){return "function"==typeof t}function isArray(t){return "[object Array]"===Object.prototype.toString.call(t)}function isObject(t){return !isArray(t)&&("object"===typeof t&&!!t)}function forEachObject(t,e){for(var i in t){if(t.hasOwnProperty(i))e(t[i],i);}}function floatEquals(t,e){return Math.abs(t-e)<FLOAT_COMPARISON_EPSILON}function removeChildren(t){for(;t.firstChild;)t.removeChild(t.firstChild);}var utils$1={extend:extend,render:render,setStyle:setStyle,setStyles:setStyles,capitalize:capitalize,isString:isString,isFunction:isFunction,isObject:isObject,forEachObject:forEachObject,floatEquals:floatEquals,removeChildren:removeChildren};var Tweenable=shifty_node.Tweenable,EASING_ALIASES={easeIn:"easeInCubic",easeOut:"easeOutCubic",easeInOut:"easeInOutCubic"},Path=function t(e,s){if(!(this instanceof t))throw new Error("Constructor was called without new keyword");var o;s=utils$1.extend({delay:0,duration:800,easing:"linear",from:{},to:{},step:function(){}},s),o=utils$1.isString(e)?document.querySelector(e):e,this.path=o,this._opts=s,this._tweenable=null;var i=this.path.getTotalLength();this.path.style.strokeDasharray=i+" "+i,this.set(0);};Path.prototype.value=function(){var t=this._getComputedDashOffset(),e=this.path.getTotalLength();return parseFloat((1-t/e).toFixed(6),10)},Path.prototype.set=function(t){this.stop(),this.path.style.strokeDashoffset=this._progressToOffset(t);var e=this._opts.step;if(utils$1.isFunction(e)){var s=this._easing(this._opts.easing);e(this._calculateTo(t,s),this._opts.shape||this,this._opts.attachment);}},Path.prototype.stop=function(){this._stopTween(),this.path.style.strokeDashoffset=this._getComputedDashOffset();},Path.prototype.animate=function(t,e,s){e=e||{},utils$1.isFunction(e)&&(s=e,e={});var o=utils$1.extend({},e),i=utils$1.extend({},this._opts);e=utils$1.extend(i,e);var a=this._easing(e.easing),n=this._resolveFromAndTo(t,a,o);this.stop(),this.path.getBoundingClientRect();var r=this._getComputedDashOffset(),h=this._progressToOffset(t),p=this;this._tweenable=new Tweenable,this._tweenable.tween({from:utils$1.extend({offset:r},n.from),to:utils$1.extend({offset:h},n.to),duration:e.duration,delay:e.delay,easing:a,step:function(t){p.path.style.strokeDashoffset=t.offset;var s=e.shape||p;e.step(t,s,e.attachment);}}).then((function(t){utils$1.isFunction(s)&&s();}));},Path.prototype._getComputedDashOffset=function(){var t=window.getComputedStyle(this.path,null);return parseFloat(t.getPropertyValue("stroke-dashoffset"),10)},Path.prototype._progressToOffset=function(t){var e=this.path.getTotalLength();return e-t*e},Path.prototype._resolveFromAndTo=function(t,e,s){return s.from&&s.to?{from:s.from,to:s.to}:{from:this._calculateFrom(e),to:this._calculateTo(t,e)}},Path.prototype._calculateFrom=function(t){return shifty_node.interpolate(this._opts.from,this._opts.to,this.value(),t)},Path.prototype._calculateTo=function(t,e){return shifty_node.interpolate(this._opts.from,this._opts.to,t,e)},Path.prototype._stopTween=function(){null!==this._tweenable&&(this._tweenable.stop(),this._tweenable=null);},Path.prototype._easing=function(t){return EASING_ALIASES.hasOwnProperty(t)?EASING_ALIASES[t]:t};var path=Path;var DESTROYED_ERROR="Object is destroyed",Shape=function t(e,r){if(!(this instanceof t))throw new Error("Constructor was called without new keyword");if(0!==arguments.length){this._opts=utils$1.extend({color:"#555",strokeWidth:1,trailColor:null,trailWidth:null,fill:null,text:{style:{color:null,position:"absolute",left:"50%",top:"50%",padding:0,margin:0,transform:{prefix:!0,value:"translate(-50%, -50%)"}},autoStyleContainer:!0,alignToBottom:!0,value:null,className:"progressbar-text"},svgStyle:{display:"block",width:"100%"},warnings:!1},r,!0),utils$1.isObject(r)&&void 0!==r.svgStyle&&(this._opts.svgStyle=r.svgStyle),utils$1.isObject(r)&&utils$1.isObject(r.text)&&void 0!==r.text.style&&(this._opts.text.style=r.text.style);var i,s=this._createSvgView(this._opts);if(!(i=utils$1.isString(e)?document.querySelector(e):e))throw new Error("Container does not exist: "+e);this._container=i,this._container.appendChild(s.svg),this._opts.warnings&&this._warnContainerAspectRatio(this._container),this._opts.svgStyle&&utils$1.setStyles(s.svg,this._opts.svgStyle),this.svg=s.svg,this.path=s.path,this.trail=s.trail,this.text=null;var o=utils$1.extend({attachment:void 0,shape:this},this._opts);this._progressPath=new path(s.path,o),utils$1.isObject(this._opts.text)&&null!==this._opts.text.value&&this.setText(this._opts.text.value);}};Shape.prototype.animate=function(t,e,r){if(null===this._progressPath)throw new Error(DESTROYED_ERROR);this._progressPath.animate(t,e,r);},Shape.prototype.stop=function(){if(null===this._progressPath)throw new Error(DESTROYED_ERROR);void 0!==this._progressPath&&this._progressPath.stop();},Shape.prototype.pause=function(){if(null===this._progressPath)throw new Error(DESTROYED_ERROR);void 0!==this._progressPath&&this._progressPath._tweenable&&this._progressPath._tweenable.pause();},Shape.prototype.resume=function(){if(null===this._progressPath)throw new Error(DESTROYED_ERROR);void 0!==this._progressPath&&this._progressPath._tweenable&&this._progressPath._tweenable.resume();},Shape.prototype.destroy=function(){if(null===this._progressPath)throw new Error(DESTROYED_ERROR);this.stop(),this.svg.parentNode.removeChild(this.svg),this.svg=null,this.path=null,this.trail=null,this._progressPath=null,null!==this.text&&(this.text.parentNode.removeChild(this.text),this.text=null);},Shape.prototype.set=function(t){if(null===this._progressPath)throw new Error(DESTROYED_ERROR);this._progressPath.set(t);},Shape.prototype.value=function(){if(null===this._progressPath)throw new Error(DESTROYED_ERROR);return void 0===this._progressPath?0:this._progressPath.value()},Shape.prototype.setText=function(t){if(null===this._progressPath)throw new Error(DESTROYED_ERROR);null===this.text&&(this.text=this._createTextContainer(this._opts,this._container),this._container.appendChild(this.text)),utils$1.isObject(t)?(utils$1.removeChildren(this.text),this.text.appendChild(t)):this.text.innerHTML=t;},Shape.prototype._createSvgView=function(t){var e=document.createElementNS("http://www.w3.org/2000/svg","svg");this._initializeSvg(e,t);var r=null;(t.trailColor||t.trailWidth)&&(r=this._createTrail(t),e.appendChild(r));var i=this._createPath(t);return e.appendChild(i),{svg:e,path:i,trail:r}},Shape.prototype._initializeSvg=function(t,e){t.setAttribute("viewBox","0 0 100 100");},Shape.prototype._createPath=function(t){var e=this._pathString(t);return this._createPathElement(e,t)},Shape.prototype._createTrail=function(t){var e=this._trailString(t),r=utils$1.extend({},t);return r.trailColor||(r.trailColor="#eee"),r.trailWidth||(r.trailWidth=r.strokeWidth),r.color=r.trailColor,r.strokeWidth=r.trailWidth,r.fill=null,this._createPathElement(e,r)},Shape.prototype._createPathElement=function(t,e){var r=document.createElementNS("http://www.w3.org/2000/svg","path");return r.setAttribute("d",t),r.setAttribute("stroke",e.color),r.setAttribute("stroke-width",e.strokeWidth),e.fill?r.setAttribute("fill",e.fill):r.setAttribute("fill-opacity","0"),r},Shape.prototype._createTextContainer=function(t,e){var r=document.createElement("div");r.className=t.text.className;var i=t.text.style;return i&&(t.text.autoStyleContainer&&(e.style.position="relative"),utils$1.setStyles(r,i),i.color||(r.style.color=t.color)),this._initializeTextContainer(t,e,r),r},Shape.prototype._initializeTextContainer=function(t,e,r){},Shape.prototype._pathString=function(t){throw new Error("Override this function for each progress bar")},Shape.prototype._trailString=function(t){throw new Error("Override this function for each progress bar")},Shape.prototype._warnContainerAspectRatio=function(t){if(this.containerAspectRatio){var e=window.getComputedStyle(t,null),r=parseFloat(e.getPropertyValue("width"),10),i=parseFloat(e.getPropertyValue("height"),10);utils$1.floatEquals(this.containerAspectRatio,r/i)||(console.warn("Incorrect aspect ratio of container","#"+t.id,"detected:",e.getPropertyValue("width")+"(width)","/",e.getPropertyValue("height")+"(height)","=",r/i),console.warn("Aspect ratio of should be",this.containerAspectRatio));}};var shape=Shape;
var Line=function(t,e){this._pathTemplate="M 0,{center} L 100,{center}",shape.apply(this,arguments);};Line.prototype=new shape,Line.prototype.constructor=Line,Line.prototype._initializeSvg=function(t,e){t.setAttribute("viewBox","0 0 100 "+e.strokeWidth),t.setAttribute("preserveAspectRatio","none");},Line.prototype._pathString=function(t){return utils$1.render(this._pathTemplate,{center:t.strokeWidth/2})},Line.prototype._trailString=function(t){return this._pathString(t)};var line=Line;var Circle=function(r,t){this._pathTemplate="M 50,50 m 0,-{radius} a {radius},{radius} 0 1 1 0,{2radius} a {radius},{radius} 0 1 1 0,-{2radius}",this.containerAspectRatio=1,shape.apply(this,arguments);};Circle.prototype=new shape,Circle.prototype.constructor=Circle,Circle.prototype._pathString=function(r){var t=r.strokeWidth;r.trailWidth&&r.trailWidth>r.strokeWidth&&(t=r.trailWidth);var i=50-t/2;return utils$1.render(this._pathTemplate,{radius:i,"2radius":2*i})},Circle.prototype._trailString=function(r){return this._pathString(r)};var circle=Circle;var SemiCircle=function(t,i){this._pathTemplate="M 50,50 m -{radius},0 a {radius},{radius} 0 1 1 {2radius},0",this.containerAspectRatio=2,shape.apply(this,arguments);};SemiCircle.prototype=new shape,SemiCircle.prototype.constructor=SemiCircle,SemiCircle.prototype._initializeSvg=function(t,i){t.setAttribute("viewBox","0 0 100 50");},SemiCircle.prototype._initializeTextContainer=function(t,i,e){t.text.style&&(e.style.top="auto",e.style.bottom="0",t.text.alignToBottom?utils$1.setStyle(e,"transform","translate(-50%, 0)"):utils$1.setStyle(e,"transform","translate(-50%, 50%)"));},SemiCircle.prototype._pathString=circle.prototype._pathString,SemiCircle.prototype._trailString=circle.prototype._trailString;var semicircle=SemiCircle;var Square=function(t,r){this._pathTemplate="M 0,{halfOfStrokeWidth} L {width},{halfOfStrokeWidth} L {width},{width} L {halfOfStrokeWidth},{width} L {halfOfStrokeWidth},{strokeWidth}",this._trailTemplate="M {startMargin},{halfOfStrokeWidth} L {width},{halfOfStrokeWidth} L {width},{width} L {halfOfStrokeWidth},{width} L {halfOfStrokeWidth},{halfOfStrokeWidth}",shape.apply(this,arguments);};Square.prototype=new shape,Square.prototype.constructor=Square,Square.prototype._pathString=function(t){var r=100-t.strokeWidth/2;return utils$1.render(this._pathTemplate,{width:r,strokeWidth:t.strokeWidth,halfOfStrokeWidth:t.strokeWidth/2})},Square.prototype._trailString=function(t){var r=100-t.strokeWidth/2;return utils$1.render(this._trailTemplate,{width:r,strokeWidth:t.strokeWidth,halfOfStrokeWidth:t.strokeWidth/2,startMargin:t.strokeWidth/2-t.trailWidth/2})};var square=Square;var main={Line:line,Circle:circle,SemiCircle:semicircle,Square:square,Path:path,Shape:shape,utils:utils$1};const NAME$7="progressdonut",SELECTOR_DONUT$1="[data-bs-progress-donut]",Default$3={color:"#0073E6",trailColor:"#D4E9FF",strokeWidth:24,trailWidth:12,easing:"easeInOut",duration:1400,text:{autoStyleContainer:!1},animate:!0,value:0};class ProgressDonut extends BaseComponent{constructor(t,e){super(t),this._config=this._getConfig(e),this._bar=null,this._init();}static get NAME(){return NAME$7}set(t){this._config.animate?this._bar.animate(t):this._bar.set(t);}dispose(){this._bar.destroy(),super.dispose();}_getConfig(t){return t={...Default$3,step:this._getStepCallback(),...Manipulator.getDataAttributes(this._element),..."object"==typeof t?t:{}}}_getStepCallback(){return (t,e)=>{const s=Math.round(100*e.value());e.setText(s+"%");}}_init(){this._bar=new main.Circle(this._element,this._config),this._config.value>0&&this.set(this._config.value);}}SelectorEngine$1.find(SELECTOR_DONUT$1).forEach((t=>{ProgressDonut.getOrCreateInstance(t);}));var ProgressDonut$1 = ProgressDonut;const NAME$6="upload",SELECTOR_FORM="[data-bs-upload-dragdrop]",SELECTOR_DONUT="[data-bs-progress-donut]";class UploadDragDrop extends BaseComponent{constructor(e){super(e);const t=SelectorEngine$1.findOne(SELECTOR_DONUT,this._element);t&&(this._donut=ProgressDonut$1.getOrCreateInstance(t)),this._bindEvents();}static get NAME(){return NAME$6}progress(e){this._donut.set(e);}start(){this.reset(),this._element.classList.add("loading");}success(){this._element.classList.remove("loading"),this._element.classList.add("success");}reset(){this._element.classList.remove("loading"),this._element.classList.remove("success"),this._donut.set(0);}dispose(){this._donut.dispose(),super.dispose();}_bindEvents(){EventHandler$1.on(this._element,"drag",(e=>this._preventEvent(e))),EventHandler$1.on(this._element,"dragstart",(e=>this._preventEvent(e))),EventHandler$1.on(this._element,"dragend",(e=>this._preventEvent(e))),EventHandler$1.on(this._element,"dragover",(e=>this._preventEvent(e))),EventHandler$1.on(this._element,"dragenter",(e=>this._preventEvent(e))),EventHandler$1.on(this._element,"dragleave",(e=>this._preventEvent(e))),EventHandler$1.on(this._element,"drop",(e=>this._preventEvent(e))),EventHandler$1.on(this._element,"dragover",(()=>this._dropIn())),EventHandler$1.on(this._element,"dragenter",(()=>this._dropIn())),EventHandler$1.on(this._element,"dragleave",(()=>this._dropOut())),EventHandler$1.on(this._element,"dragend",(()=>this._dropOut())),EventHandler$1.on(this._element,"drop",(()=>this._dropOut())),EventHandler$1.on(this._element,"drop",(()=>this._drop()));}_preventEvent(e){e.preventDefault(),e.stopPropagation();}_dropIn(){this._isSuccess()||this._element.classList.add("dragover");}_dropOut(){this._isSuccess()||this._element.classList.remove("dragover");}_drop(){this._isSuccess()||this.start();}_isSuccess(){return this._element.classList.contains("success")}}SelectorEngine$1.find(SELECTOR_FORM).forEach((e=>{UploadDragDrop.getOrCreateInstance(e);}));var UploadDragDrop$1 = UploadDragDrop;const NAME$5="backtotop",DATA_KEY$2="bs.backtotop",EVENT_KEY$2=`.${DATA_KEY$2}`,EVENT_CLICK$4=`click${EVENT_KEY$2}`,CLASS_NAME_SHOW="back-to-top-show",SELECTOR_TOGGLE$2='[data-bs-toggle="backtotop"]',Default$2={positionTop:0,scrollLimit:100,duration:800,easing:"easeInOutSine"};class BackToTop extends BaseComponent{constructor(o,t){super(o),this._config=this._getConfig(t),this._scrollCb=null,this._isAnim=!1,this._prevScrollBehavior="",this._bindEvents();}static get NAME(){return NAME$5}show(){this._element.classList.contains(CLASS_NAME_SHOW)||this._element.classList.add(CLASS_NAME_SHOW);}hide(){this._element.classList.contains(CLASS_NAME_SHOW)&&this._element.classList.remove(CLASS_NAME_SHOW);}toggleShow(){document.scrollingElement.scrollTop>this._config.scrollLimit?this.show():this.hide();}scrollToTop(){this._isAnim||(this._isAnim=!0,documentScrollTo(this._config.positionTop,{duration:this._config.duration,easing:this._config.easing,complete:()=>{this._isAnim=!1;}}));}dispose(){this._scrollCb&&this._scrollCb.dispose(),super.dispose();}_getConfig(o){return o={...Default$2,...Manipulator.getDataAttributes(this._element),..."object"==typeof o?o:{}}}_bindEvents(){this._scrollCb=onDocumentScroll$1((()=>this.toggleShow())),EventHandler$1.on(this._element,EVENT_CLICK$4,(o=>{o.preventDefault(),this.scrollToTop();}));}}const dataApiCb=onDocumentScroll$1((()=>{SelectorEngine$1.find(SELECTOR_TOGGLE$2).forEach((o=>{BackToTop.getOrCreateInstance(o).toggleShow();})),dataApiCb.dispose();}));var BackToTop$1 = BackToTop;const NAME$4="historyback",DATA_KEY$1="bs.historyback",EVENT_KEY$1=`.${DATA_KEY$1}`,EVENT_CLICK$3=`click${EVENT_KEY$1}`,EVENT_CLICK_DATA_API$2=`click${EVENT_KEY$1}.data-api`,SELECTOR_TOGGLE$1='[data-bs-toggle="historyback"]';class HistoryBack extends BaseComponent{constructor(t){super(t),this._bindEvents();}static get NAME(){return NAME$4}back(){window.history.back();}_bindEvents(){EventHandler$1.on(this._element,EVENT_CLICK$3,(t=>{t.preventDefault(),this.back();}));}}const toggles$1=SelectorEngine$1.find(SELECTOR_TOGGLE$1);toggles$1.forEach((t=>{EventHandler$1.one(t,EVENT_CLICK_DATA_API$2,(e=>{e.preventDefault();HistoryBack.getOrCreateInstance(t).back();}));}));var HistoryBack$1 = HistoryBack;const NAME$3="historyback",DATA_KEY="bs.historyback",EVENT_KEY=`.${DATA_KEY}`,EVENT_CLICK$2=`click${EVENT_KEY}`,EVENT_CLICK_DATA_API$1=`click${EVENT_KEY}.data-api`,SELECTOR_TOGGLE='[data-bs-toggle="forward"]',Default$1={duration:800,easing:"easeInOutSine"};class Forward extends BaseComponent{constructor(t,e){super(t),this._config=this._getConfig(e),this._bindEvents();}static get NAME(){return NAME$3}goToTarget(){const t=getElementFromSelector(this._element);t&&documentScrollTo(t.offsetTop,{duration:this._config.duration,easing:this._config.easing});}_getConfig(t){return t={...Default$1,...Manipulator.getDataAttributes(this._element),..."object"==typeof t?t:{}}}_bindEvents(){EventHandler$1.on(this._element,EVENT_CLICK$2,(t=>{t.preventDefault(),this.goToTarget();}));}}const toggles=SelectorEngine$1.find(SELECTOR_TOGGLE);toggles.forEach((t=>{EventHandler$1.one(t,EVENT_CLICK_DATA_API$1,(e=>{e.preventDefault();Forward.getOrCreateInstance(t).goToTarget();}));}));var Forward$1 = Forward;var evEmitter=createCommonjsModule((function(e){var t,n;t="undefined"!=typeof window?window:commonjsGlobal,n=function(){function e(){}var t=e.prototype;return t.on=function(e,t){if(e&&t){var n=this._events=this._events||{},s=n[e]=n[e]||[];return -1==s.indexOf(t)&&s.push(t),this}},t.once=function(e,t){if(e&&t){this.on(e,t);var n=this._onceEvents=this._onceEvents||{};return (n[e]=n[e]||{})[t]=!0,this}},t.off=function(e,t){var n=this._events&&this._events[e];if(n&&n.length){var s=n.indexOf(t);return -1!=s&&n.splice(s,1),this}},t.emitEvent=function(e,t){var n=this._events&&this._events[e];if(n&&n.length){n=n.slice(0),t=t||[];for(var s=this._onceEvents&&this._onceEvents[e],o=0;o<n.length;o++){var i=n[o];s&&s[i]&&(this.off(e,i),delete s[i]),i.apply(this,t);}return this}},t.allOff=function(){delete this._events,delete this._onceEvents;},e},e.exports?e.exports=n():t.EvEmitter=n();}));var getSize=createCommonjsModule((function(t){
/*!
 * getSize v2.0.3
 * measure size of elements
 * MIT license
 */
!function(e,i){t.exports?t.exports=i():e.getSize=i();}(window,(function(){function t(t){var e=parseFloat(t);return -1==t.indexOf("%")&&!isNaN(e)&&e}var e="undefined"==typeof console?function(){}:function(t){console.error(t);},i=["paddingLeft","paddingRight","paddingTop","paddingBottom","marginLeft","marginRight","marginTop","marginBottom","borderLeftWidth","borderRightWidth","borderTopWidth","borderBottomWidth"],o=i.length;function r(t){var i=getComputedStyle(t);return i||e("Style returned "+i+". Are you running this code in a hidden iframe on Firefox? See https://bit.ly/getsizebug1"),i}var n,d=!1;function h(e){if(function(){if(!d){d=!0;var e=document.createElement("div");e.style.width="200px",e.style.padding="1px 2px 3px 4px",e.style.borderStyle="solid",e.style.borderWidth="1px 2px 3px 4px",e.style.boxSizing="border-box";var i=document.body||document.documentElement;i.appendChild(e);var o=r(e);n=200==Math.round(t(o.width)),h.isBoxSizeOuter=n,i.removeChild(e);}}(),"string"==typeof e&&(e=document.querySelector(e)),e&&"object"==typeof e&&e.nodeType){var a=r(e);if("none"==a.display)return function(){for(var t={width:0,height:0,innerWidth:0,innerHeight:0,outerWidth:0,outerHeight:0},e=0;e<o;e++)t[i[e]]=0;return t}();var p={};p.width=e.offsetWidth,p.height=e.offsetHeight;for(var g=p.isBorderBox="border-box"==a.boxSizing,u=0;u<o;u++){var s=i[u],m=a[s],f=parseFloat(m);p[s]=isNaN(f)?0:f;}var l=p.paddingLeft+p.paddingRight,c=p.paddingTop+p.paddingBottom,x=p.marginLeft+p.marginRight,b=p.marginTop+p.marginBottom,v=p.borderLeftWidth+p.borderRightWidth,y=p.borderTopWidth+p.borderBottomWidth,W=g&&n,S=t(a.width);!1!==S&&(p.width=S+(W?0:l+v));var w=t(a.height);return !1!==w&&(p.height=w+(W?0:c+y)),p.innerWidth=p.width-(l+v),p.innerHeight=p.height-(c+y),p.outerWidth=p.width+x,p.outerHeight=p.height+b,p}}return h}));}));
var matchesSelector=createCommonjsModule((function(e){!function(t,r){e.exports?e.exports=r():t.matchesSelector=r();}(window,(function(){var e=function(){var e=window.Element.prototype;if(e.matches)return "matches";if(e.matchesSelector)return "matchesSelector";for(var t=["webkit","moz","ms","o"],r=0;r<t.length;r++){var o=t[r]+"MatchesSelector";if(e[o])return o}}();return function(t,r){return t[e](r)}}));}));var utils=createCommonjsModule((function(e){!function(t,r){e.exports?e.exports=r(t,matchesSelector):t.fizzyUIUtils=r(t,t.matchesSelector);}(window,(function(e,t){var r={extend:function(e,t){for(var r in t)e[r]=t[r];return e},modulo:function(e,t){return (e%t+t)%t}},o=Array.prototype.slice;r.makeArray=function(e){return Array.isArray(e)?e:null==e?[]:"object"==typeof e&&"number"==typeof e.length?o.call(e):[e]},r.removeFrom=function(e,t){var r=e.indexOf(t);-1!=r&&e.splice(r,1);},r.getParent=function(e,r){for(;e.parentNode&&e!=document.body;)if(e=e.parentNode,t(e,r))return e},r.getQueryElement=function(e){return "string"==typeof e?document.querySelector(e):e},r.handleEvent=function(e){var t="on"+e.type;this[t]&&this[t](e);},r.filterFindElements=function(e,o){e=r.makeArray(e);var n=[];return e.forEach((function(e){if(e instanceof HTMLElement)if(o){t(e,o)&&n.push(e);for(var r=e.querySelectorAll(o),u=0;u<r.length;u++)n.push(r[u]);}else n.push(e);})),n},r.debounceMethod=function(e,t,r){r=r||100;var o=e.prototype[t],n=t+"Timeout";e.prototype[t]=function(){var e=this[n];clearTimeout(e);var t=arguments,u=this;this[n]=setTimeout((function(){o.apply(u,t),delete u[n];}),r);};},r.docReady=function(e){var t=document.readyState;"complete"==t||"interactive"==t?setTimeout(e):document.addEventListener("DOMContentLoaded",e);},r.toDashed=function(e){return e.replace(/(.)([A-Z])/g,(function(e,t,r){return t+"-"+r})).toLowerCase()};var n=e.console;return r.htmlInit=function(t,o){r.docReady((function(){var u=r.toDashed(o),a="data-"+u,i=document.querySelectorAll("["+a+"]"),c=document.querySelectorAll(".js-"+u),s=r.makeArray(i).concat(r.makeArray(c)),l=a+"-options",m=e.jQuery;s.forEach((function(e){var r,u=e.getAttribute(a)||e.getAttribute(l);try{r=u&&JSON.parse(u);}catch(t){return void(n&&n.error("Error parsing "+a+" on "+e.className+": "+t))}var i=new t(e,r);m&&m.data(e,o,i);}));}));},r}));}));var item=createCommonjsModule((function(t){!function(i,n){t.exports?t.exports=n(evEmitter,getSize):(i.Outlayer={},i.Outlayer.Item=n(i.EvEmitter,i.getSize));}(window,(function(t,i){var n=document.documentElement.style,o="string"==typeof n.transition?"transition":"WebkitTransition",e="string"==typeof n.transform?"transform":"WebkitTransform",s={WebkitTransition:"webkitTransitionEnd",transition:"transitionend"}[o],r={transform:e,transition:o,transitionDuration:o+"Duration",transitionProperty:o+"Property",transitionDelay:o+"Delay"};function a(t,i){t&&(this.element=t,this.layout=i,this.position={x:0,y:0},this._create());}var h=a.prototype=Object.create(t.prototype);h.constructor=a,h._create=function(){this._transn={ingProperties:{},clean:{},onEnd:{}},this.css({position:"absolute"});},h.handleEvent=function(t){var i="on"+t.type;this[i]&&this[i](t);},h.getSize=function(){this.size=i(this.element);},h.css=function(t){var i=this.element.style;for(var n in t){i[r[n]||n]=t[n];}},h.getPosition=function(){var t=getComputedStyle(this.element),i=this.layout._getOption("originLeft"),n=this.layout._getOption("originTop"),o=t[i?"left":"right"],e=t[n?"top":"bottom"],s=parseFloat(o),r=parseFloat(e),a=this.layout.size;-1!=o.indexOf("%")&&(s=s/100*a.width),-1!=e.indexOf("%")&&(r=r/100*a.height),s=isNaN(s)?0:s,r=isNaN(r)?0:r,s-=i?a.paddingLeft:a.paddingRight,r-=n?a.paddingTop:a.paddingBottom,this.position.x=s,this.position.y=r;},h.layoutPosition=function(){var t=this.layout.size,i={},n=this.layout._getOption("originLeft"),o=this.layout._getOption("originTop"),e=n?"paddingLeft":"paddingRight",s=n?"left":"right",r=n?"right":"left",a=this.position.x+t[e];i[s]=this.getXValue(a),i[r]="";var h=o?"paddingTop":"paddingBottom",l=o?"top":"bottom",p=o?"bottom":"top",u=this.position.y+t[h];i[l]=this.getYValue(u),i[p]="",this.css(i),this.emitEvent("layout",[this]);},h.getXValue=function(t){var i=this.layout._getOption("horizontal");return this.layout.options.percentPosition&&!i?t/this.layout.size.width*100+"%":t+"px"},h.getYValue=function(t){var i=this.layout._getOption("horizontal");return this.layout.options.percentPosition&&i?t/this.layout.size.height*100+"%":t+"px"},h._transitionTo=function(t,i){this.getPosition();var n=this.position.x,o=this.position.y,e=t==this.position.x&&i==this.position.y;if(this.setPosition(t,i),!e||this.isTransitioning){var s=t-n,r=i-o,a={};a.transform=this.getTranslate(s,r),this.transition({to:a,onTransitionEnd:{transform:this.layoutPosition},isCleaning:!0});}else this.layoutPosition();},h.getTranslate=function(t,i){return "translate3d("+(t=this.layout._getOption("originLeft")?t:-t)+"px, "+(i=this.layout._getOption("originTop")?i:-i)+"px, 0)"},h.goTo=function(t,i){this.setPosition(t,i),this.layoutPosition();},h.moveTo=h._transitionTo,h.setPosition=function(t,i){this.position.x=parseFloat(t),this.position.y=parseFloat(i);},h._nonTransition=function(t){for(var i in this.css(t.to),t.isCleaning&&this._removeStyles(t.to),t.onTransitionEnd)t.onTransitionEnd[i].call(this);},h.transition=function(t){if(parseFloat(this.layout.options.transitionDuration)){var i=this._transn;for(var n in t.onTransitionEnd)i.onEnd[n]=t.onTransitionEnd[n];for(n in t.to)i.ingProperties[n]=!0,t.isCleaning&&(i.clean[n]=!0);if(t.from){this.css(t.from);this.element.offsetHeight;}this.enableTransition(t.to),this.css(t.to),this.isTransitioning=!0;}else this._nonTransition(t);};var l="opacity,"+e.replace(/([A-Z])/g,(function(t){return "-"+t.toLowerCase()}));h.enableTransition=function(){if(!this.isTransitioning){var t=this.layout.options.transitionDuration;t="number"==typeof t?t+"ms":t,this.css({transitionProperty:l,transitionDuration:t,transitionDelay:this.staggerDelay||0}),this.element.addEventListener(s,this,!1);}},h.onwebkitTransitionEnd=function(t){this.ontransitionend(t);},h.onotransitionend=function(t){this.ontransitionend(t);};var p={"-webkit-transform":"transform"};h.ontransitionend=function(t){if(t.target===this.element){var i=this._transn,n=p[t.propertyName]||t.propertyName;if(delete i.ingProperties[n],function(t){for(var i in t)return !1;return !0}(i.ingProperties)&&this.disableTransition(),n in i.clean&&(this.element.style[t.propertyName]="",delete i.clean[n]),n in i.onEnd)i.onEnd[n].call(this),delete i.onEnd[n];this.emitEvent("transitionEnd",[this]);}},h.disableTransition=function(){this.removeTransitionStyles(),this.element.removeEventListener(s,this,!1),this.isTransitioning=!1;},h._removeStyles=function(t){var i={};for(var n in t)i[n]="";this.css(i);};var u={transitionProperty:"",transitionDuration:"",transitionDelay:""};return h.removeTransitionStyles=function(){this.css(u);},h.stagger=function(t){t=isNaN(t)?0:t,this.staggerDelay=t+"ms";},h.removeElem=function(){this.element.parentNode.removeChild(this.element),this.css({display:""}),this.emitEvent("remove",[this]);},h.remove=function(){o&&parseFloat(this.layout.options.transitionDuration)?(this.once("transitionEnd",(function(){this.removeElem();})),this.hide()):this.removeElem();},h.reveal=function(){delete this.isHidden,this.css({display:""});var t=this.layout.options,i={};i[this.getHideRevealTransitionEndProperty("visibleStyle")]=this.onRevealTransitionEnd,this.transition({from:t.hiddenStyle,to:t.visibleStyle,isCleaning:!0,onTransitionEnd:i});},h.onRevealTransitionEnd=function(){this.isHidden||this.emitEvent("reveal");},h.getHideRevealTransitionEndProperty=function(t){var i=this.layout.options[t];if(i.opacity)return "opacity";for(var n in i)return n},h.hide=function(){this.isHidden=!0,this.css({display:""});var t=this.layout.options,i={};i[this.getHideRevealTransitionEndProperty("hiddenStyle")]=this.onHideTransitionEnd,this.transition({from:t.visibleStyle,to:t.hiddenStyle,isCleaning:!0,onTransitionEnd:i});},h.onHideTransitionEnd=function(){this.isHidden&&(this.css({display:"none"}),this.emitEvent("hide"));},h.destroy=function(){this.css({position:"",left:"",right:"",top:"",bottom:"",transition:"",transform:""});},a}));}));var outlayer=createCommonjsModule((function(t){
/*!
 * Outlayer v2.1.1
 * the brains and guts of a layout library
 * MIT license
 */
!function(e,i){t.exports?t.exports=i(e,evEmitter,getSize,utils,item):e.Outlayer=i(e,e.EvEmitter,e.getSize,e.fizzyUIUtils,e.Outlayer.Item);}(window,(function(t,e,i,n,o){var s=t.console,r=t.jQuery,a=function(){},h=0,u={};function m(t,e){var i=n.getQueryElement(t);if(i){this.element=i,r&&(this.$element=r(this.element)),this.options=n.extend({},this.constructor.defaults),this.option(e);var o=++h;this.element.outlayerGUID=o,u[o]=this,this._create(),this._getOption("initLayout")&&this.layout();}else s&&s.error("Bad element for "+this.constructor.namespace+": "+(i||t));}m.namespace="outlayer",m.Item=o,m.defaults={containerStyle:{position:"relative"},initLayout:!0,originLeft:!0,originTop:!0,resize:!0,resizeContainer:!0,transitionDuration:"0.4s",hiddenStyle:{opacity:0,transform:"scale(0.001)"},visibleStyle:{opacity:1,transform:"scale(1)"}};var c=m.prototype;function l(t){function e(){t.apply(this,arguments);}return e.prototype=Object.create(t.prototype),e.prototype.constructor=e,e}n.extend(c,e.prototype),c.option=function(t){n.extend(this.options,t);},c._getOption=function(t){var e=this.constructor.compatOptions[t];return e&&void 0!==this.options[e]?this.options[e]:this.options[t]},m.compatOptions={initLayout:"isInitLayout",horizontal:"isHorizontal",layoutInstant:"isLayoutInstant",originLeft:"isOriginLeft",originTop:"isOriginTop",resize:"isResizeBound",resizeContainer:"isResizingContainer"},c._create=function(){this.reloadItems(),this.stamps=[],this.stamp(this.options.stamp),n.extend(this.element.style,this.options.containerStyle),this._getOption("resize")&&this.bindResize();},c.reloadItems=function(){this.items=this._itemize(this.element.children);},c._itemize=function(t){for(var e=this._filterFindItemElements(t),i=this.constructor.Item,n=[],o=0;o<e.length;o++){var s=new i(e[o],this);n.push(s);}return n},c._filterFindItemElements=function(t){return n.filterFindElements(t,this.options.itemSelector)},c.getItemElements=function(){return this.items.map((function(t){return t.element}))},c.layout=function(){this._resetLayout(),this._manageStamps();var t=this._getOption("layoutInstant"),e=void 0!==t?t:!this._isLayoutInited;this.layoutItems(this.items,e),this._isLayoutInited=!0;},c._init=c.layout,c._resetLayout=function(){this.getSize();},c.getSize=function(){this.size=i(this.element);},c._getMeasurement=function(t,e){var n,o=this.options[t];o?("string"==typeof o?n=this.element.querySelector(o):o instanceof HTMLElement&&(n=o),this[t]=n?i(n)[e]:o):this[t]=0;},c.layoutItems=function(t,e){t=this._getItemsForLayout(t),this._layoutItems(t,e),this._postLayout();},c._getItemsForLayout=function(t){return t.filter((function(t){return !t.isIgnored}))},c._layoutItems=function(t,e){if(this._emitCompleteOnItems("layout",t),t&&t.length){var i=[];t.forEach((function(t){var n=this._getItemLayoutPosition(t);n.item=t,n.isInstant=e||t.isLayoutInstant,i.push(n);}),this),this._processLayoutQueue(i);}},c._getItemLayoutPosition=function(){return {x:0,y:0}},c._processLayoutQueue=function(t){this.updateStagger(),t.forEach((function(t,e){this._positionItem(t.item,t.x,t.y,t.isInstant,e);}),this);},c.updateStagger=function(){var t=this.options.stagger;if(null!=t)return this.stagger=function(t){if("number"==typeof t)return t;var e=t.match(/(^\d*\.?\d*)(\w*)/),i=e&&e[1],n=e&&e[2];if(!i.length)return 0;return (i=parseFloat(i))*(f[n]||1)}(t),this.stagger;this.stagger=0;},c._positionItem=function(t,e,i,n,o){n?t.goTo(e,i):(t.stagger(o*this.stagger),t.moveTo(e,i));},c._postLayout=function(){this.resizeContainer();},c.resizeContainer=function(){if(this._getOption("resizeContainer")){var t=this._getContainerSize();t&&(this._setContainerMeasure(t.width,!0),this._setContainerMeasure(t.height,!1));}},c._getContainerSize=a,c._setContainerMeasure=function(t,e){if(void 0!==t){var i=this.size;i.isBorderBox&&(t+=e?i.paddingLeft+i.paddingRight+i.borderLeftWidth+i.borderRightWidth:i.paddingBottom+i.paddingTop+i.borderTopWidth+i.borderBottomWidth),t=Math.max(t,0),this.element.style[e?"width":"height"]=t+"px";}},c._emitCompleteOnItems=function(t,e){var i=this;function n(){i.dispatchEvent(t+"Complete",null,[e]);}var o=e.length;if(e&&o){var s=0;e.forEach((function(e){e.once(t,r);}));}else n();function r(){++s==o&&n();}},c.dispatchEvent=function(t,e,i){var n=e?[e].concat(i):i;if(this.emitEvent(t,n),r)if(this.$element=this.$element||r(this.element),e){var o=r.Event(e);o.type=t,this.$element.trigger(o,i);}else this.$element.trigger(t,i);},c.ignore=function(t){var e=this.getItem(t);e&&(e.isIgnored=!0);},c.unignore=function(t){var e=this.getItem(t);e&&delete e.isIgnored;},c.stamp=function(t){(t=this._find(t))&&(this.stamps=this.stamps.concat(t),t.forEach(this.ignore,this));},c.unstamp=function(t){(t=this._find(t))&&t.forEach((function(t){n.removeFrom(this.stamps,t),this.unignore(t);}),this);},c._find=function(t){if(t)return "string"==typeof t&&(t=this.element.querySelectorAll(t)),t=n.makeArray(t)},c._manageStamps=function(){this.stamps&&this.stamps.length&&(this._getBoundingRect(),this.stamps.forEach(this._manageStamp,this));},c._getBoundingRect=function(){var t=this.element.getBoundingClientRect(),e=this.size;this._boundingRect={left:t.left+e.paddingLeft+e.borderLeftWidth,top:t.top+e.paddingTop+e.borderTopWidth,right:t.right-(e.paddingRight+e.borderRightWidth),bottom:t.bottom-(e.paddingBottom+e.borderBottomWidth)};},c._manageStamp=a,c._getElementOffset=function(t){var e=t.getBoundingClientRect(),n=this._boundingRect,o=i(t);return {left:e.left-n.left-o.marginLeft,top:e.top-n.top-o.marginTop,right:n.right-e.right-o.marginRight,bottom:n.bottom-e.bottom-o.marginBottom}},c.handleEvent=n.handleEvent,c.bindResize=function(){t.addEventListener("resize",this),this.isResizeBound=!0;},c.unbindResize=function(){t.removeEventListener("resize",this),this.isResizeBound=!1;},c.onresize=function(){this.resize();},n.debounceMethod(m,"onresize",100),c.resize=function(){this.isResizeBound&&this.needsResizeLayout()&&this.layout();},c.needsResizeLayout=function(){var t=i(this.element);return this.size&&t&&t.innerWidth!==this.size.innerWidth},c.addItems=function(t){var e=this._itemize(t);return e.length&&(this.items=this.items.concat(e)),e},c.appended=function(t){var e=this.addItems(t);e.length&&(this.layoutItems(e,!0),this.reveal(e));},c.prepended=function(t){var e=this._itemize(t);if(e.length){var i=this.items.slice(0);this.items=e.concat(i),this._resetLayout(),this._manageStamps(),this.layoutItems(e,!0),this.reveal(e),this.layoutItems(i);}},c.reveal=function(t){if(this._emitCompleteOnItems("reveal",t),t&&t.length){var e=this.updateStagger();t.forEach((function(t,i){t.stagger(i*e),t.reveal();}));}},c.hide=function(t){if(this._emitCompleteOnItems("hide",t),t&&t.length){var e=this.updateStagger();t.forEach((function(t,i){t.stagger(i*e),t.hide();}));}},c.revealItemElements=function(t){var e=this.getItems(t);this.reveal(e);},c.hideItemElements=function(t){var e=this.getItems(t);this.hide(e);},c.getItem=function(t){for(var e=0;e<this.items.length;e++){var i=this.items[e];if(i.element==t)return i}},c.getItems=function(t){t=n.makeArray(t);var e=[];return t.forEach((function(t){var i=this.getItem(t);i&&e.push(i);}),this),e},c.remove=function(t){var e=this.getItems(t);this._emitCompleteOnItems("remove",e),e&&e.length&&e.forEach((function(t){t.remove(),n.removeFrom(this.items,t);}),this);},c.destroy=function(){var t=this.element.style;t.height="",t.position="",t.width="",this.items.forEach((function(t){t.destroy();})),this.unbindResize();var e=this.element.outlayerGUID;delete u[e],delete this.element.outlayerGUID,r&&r.removeData(this.element,this.constructor.namespace);},m.data=function(t){var e=(t=n.getQueryElement(t))&&t.outlayerGUID;return e&&u[e]},m.create=function(t,e){var i=l(m);return i.defaults=n.extend({},m.defaults),n.extend(i.defaults,e),i.compatOptions=n.extend({},m.compatOptions),i.namespace=t,i.data=m.data,i.Item=l(o),n.htmlInit(i,t),r&&r.bridget&&r.bridget(t,i),i};var f={ms:1,s:1e3};return m.Item=o,m}));}));var masonry=createCommonjsModule((function(t){
/*!
 * Masonry v4.2.2
 * Cascading grid layout library
 * https://masonry.desandro.com
 * MIT License
 * by David DeSandro
 */
!function(i,o){t.exports?t.exports=o(outlayer,getSize):i.Masonry=o(i.Outlayer,i.getSize);}(window,(function(t,i){var o=t.create("masonry");o.compatOptions.fitWidth="isFitWidth";var e=o.prototype;return e._resetLayout=function(){this.getSize(),this._getMeasurement("columnWidth","outerWidth"),this._getMeasurement("gutter","outerWidth"),this.measureColumns(),this.colYs=[];for(var t=0;t<this.cols;t++)this.colYs.push(0);this.maxY=0,this.horizontalColIndex=0;},e.measureColumns=function(){if(this.getContainerWidth(),!this.columnWidth){var t=this.items[0],o=t&&t.element;this.columnWidth=o&&i(o).outerWidth||this.containerWidth;}var e=this.columnWidth+=this.gutter,r=this.containerWidth+this.gutter,s=r/e,n=e-r%e;s=Math[n&&n<1?"round":"floor"](s),this.cols=Math.max(s,1);},e.getContainerWidth=function(){var t=this._getOption("fitWidth")?this.element.parentNode:this.element,o=i(t);this.containerWidth=o&&o.innerWidth;},e._getItemLayoutPosition=function(t){t.getSize();var i=t.size.outerWidth%this.columnWidth,o=Math[i&&i<1?"round":"ceil"](t.size.outerWidth/this.columnWidth);o=Math.min(o,this.cols);for(var e=this[this.options.horizontalOrder?"_getHorizontalColPosition":"_getTopColPosition"](o,t),r={x:this.columnWidth*e.col,y:e.y},s=e.y+t.size.outerHeight,n=o+e.col,h=e.col;h<n;h++)this.colYs[h]=s;return r},e._getTopColPosition=function(t){var i=this._getTopColGroup(t),o=Math.min.apply(Math,i);return {col:i.indexOf(o),y:o}},e._getTopColGroup=function(t){if(t<2)return this.colYs;for(var i=[],o=this.cols+1-t,e=0;e<o;e++)i[e]=this._getColGroupY(e,t);return i},e._getColGroupY=function(t,i){if(i<2)return this.colYs[t];var o=this.colYs.slice(t,t+i);return Math.max.apply(Math,o)},e._getHorizontalColPosition=function(t,i){var o=this.horizontalColIndex%this.cols;o=t>1&&o+t>this.cols?0:o;var e=i.size.outerWidth&&i.size.outerHeight;return this.horizontalColIndex=e?o+t:this.horizontalColIndex,{col:o,y:this._getColGroupY(o,t)}},e._manageStamp=function(t){var o=i(t),e=this._getElementOffset(t),r=this._getOption("originLeft")?e.left:e.right,s=r+o.outerWidth,n=Math.floor(r/this.columnWidth);n=Math.max(0,n);var h=Math.floor(s/this.columnWidth);h-=s%this.columnWidth?0:1,h=Math.min(this.cols-1,h);for(var a=(this._getOption("originTop")?e.top:e.bottom)+o.outerHeight,l=n;l<=h;l++)this.colYs[l]=Math.max(a,this.colYs[l]);},e._getContainerSize=function(){this.maxY=Math.max.apply(Math,this.colYs);var t={height:this.maxY};return this._getOption("fitWidth")&&(t.width=this._getContainerFitWidth()),t},e._getContainerFitWidth=function(){for(var t=0,i=this.cols;--i&&0===this.colYs[i];)t++;return (this.cols-t)*this.columnWidth-this.gutter},e.needsResizeLayout=function(){var t=this.containerWidth;return this.getContainerWidth(),t!=this.containerWidth},o}));}));const NAME$2="masonry",SELECTOR_DATA_TOGGLE='[data-bs-toggle="masonry"]',SELECTOR_LOADER=".masonry-loader",Default={percentPosition:!0};class Masonry extends BaseComponent{constructor(e,t){super(e),this._config=this._getConfig(t),this._masonry=null,this._images=SelectorEngine$1.find("img",this._element),this._loadCounter=0,this._init();}static get NAME(){return NAME$2}dispose(){this._masonry&&(this._masonry.destroy(),this._masonry=null),super.dispose();}_getConfig(e){return e={...Default,...Manipulator.getDataAttributes(this._element),..."object"==typeof e?e:{}}}_init(){this._images.length>0?this._images.forEach((e=>{const t=new Image;t.onload=()=>this._onLoadEnd(),t.src=e.src;})):this._initMasonry();}_onLoadEnd(){this._loadCounter++,this._loadCounter>=this._images.length&&this._initMasonry();}_initMasonry(){this._masonry=new masonry(this._element,this._config);}_createLoader(){const e=document.createElement("div");return e.classList.add("masonry-loader","fade","d-flex","justify-content-center","align-items-center"),e.innerHTML='<div class="progress-spinner progress-spinner-active"><span class="visually-hidden">Caricamento...</span></div>',this._element.appendChild(e),e}_getOrCreateLoader(){const e=SelectorEngine$1.findOne(SELECTOR_LOADER,this._element);return e||this._createLoader()}_destroyLoader(){const e=SelectorEngine$1.findOne(SELECTOR_LOADER,this._element);e&&e.remove();}_showLoader(){this._getOrCreateLoader().classList.add("show");}_hideLoader(){this._destroyLoader();}}const masonries=SelectorEngine$1.find(SELECTOR_DATA_TOGGLE);masonries.length>0&&masonries.forEach((e=>{Masonry.getOrCreateInstance(e);}));var Masonry$1 = Masonry;const NAME$1="list",EVENT_CLICK$1="click.bs.list",EVENT_CLICK_DATA_API="click.bs.list.data-api",SELECTOR_LIST="[data-bs-list-checkbox]";class List extends BaseComponent{constructor(e){super(e),this._init();}static get NAME(){return NAME$1}toggleCheckbox(e){const t=SelectorEngine$1.findOne("input",e);t&&(t.checked?(t.checked=!1,e.classList.remove("active")):(t.checked=!0,e.classList.add("active")));}_init(){this._initCheckbox();}_initCheckbox(){SelectorEngine$1.find("input[type=checkbox]",this._element).forEach((e=>{EventHandler$1.on(e.closest("a"),EVENT_CLICK$1,(t=>{t.preventDefault(),this.toggleCheckbox(e.closest("a"));}));}));}}SelectorEngine$1.find(SELECTOR_LIST).forEach((e=>{SelectorEngine$1.find("input[type=checkbox]",e).forEach((t=>{EventHandler$1.one(t.closest("a"),EVENT_CLICK_DATA_API,(t=>{if(!List.getInstance(e)){t.preventDefault();List.getOrCreateInstance(e).toggleCheckbox(t.currentTarget);}}));}));}));var List$1 = List;const NAME="transfer",EVENT_CLICK="click.bs.transfer",SELECTOR_BLOCK="[data-bs-transfer]",SELECTOR_HEAD=".transfer-header",SELECTOR_HEAD_INPUT=".transfer-header input",SELECTOR_HEAD_LABEL=".transfer-header span.num",SELECTOR_LIST_INPUT=".transfer-group input",SELECTOR_SOURCE=".it-transfer-wrapper.source",SELECTOR_TARGET=".it-transfer-wrapper.target";class Transfer extends BaseComponent{constructor(e){super(e),this._addBtnElement=SelectorEngine$1.findOne("a.transfer",this._element),this._invBtnElement=SelectorEngine$1.findOne("a.backtransfer",this._element),this._resetBtnElement=SelectorEngine$1.findOne("a.reset",this._element),this._listDefault={source:SelectorEngine$1.find(SELECTOR_SOURCE+" .transfer-group .form-check",this._element),target:SelectorEngine$1.find(SELECTOR_TARGET+" .transfer-group .form-check",this._element)},this._bindEvents();}static get NAME(){return NAME}_bindEvents(){SelectorEngine$1.find(SELECTOR_HEAD_INPUT,this._element).forEach((e=>{EventHandler$1.on(e,EVENT_CLICK,(()=>{this._checkListHeader(e.closest(".it-transfer-wrapper"));}));})),SelectorEngine$1.find(SELECTOR_LIST_INPUT,this._element).forEach((e=>{EventHandler$1.on(e,EVENT_CLICK,(()=>{this._checkList(e.closest(".it-transfer-wrapper"));}));})),EventHandler$1.on(this._addBtnElement,EVENT_CLICK,(e=>{e.preventDefault(),this._disableElement(this._addBtnElement),this._addItems();})),EventHandler$1.on(this._invBtnElement,EVENT_CLICK,(e=>{e.preventDefault(),this._disableElement(this._invBtnElement),this._addItems(!0);})),EventHandler$1.on(this._resetBtnElement,EVENT_CLICK,(e=>{e.preventDefault(),this._disableElement(this._addBtnElement),this._disableElement(this._invBtnElement),this._disableElement(this._resetBtnElement),this._resetAll();}));}_disableElement(e){e.classList.remove("active"),e.setAttribute("disabled","disabled"),e.setAttribute("aria-disabled","true");}_enableElement(e){e.classList.add("active"),e.removeAttribute("disabled"),e.removeAttribute("aria-disabled");}_getScopeData(e){return {scope:e,list:SelectorEngine$1.find(SELECTOR_LIST_INPUT,e),listChecked:SelectorEngine$1.find(SELECTOR_LIST_INPUT+":checked",e),head:SelectorEngine$1.findOne(SELECTOR_HEAD,e),inputHead:SelectorEngine$1.findOne(SELECTOR_HEAD_INPUT,e),labelNumHead:SelectorEngine$1.findOne(SELECTOR_HEAD_LABEL,e),group:SelectorEngine$1.findOne(".transfer-group",e)}}_checkList(e){const t=this._getScopeData(e);0==t.listChecked.length?(t.inputHead.classList.remove("semi-checked"),t.inputHead.checked=!0,e.classList.contains("source")?this._disableElement(this._addBtnElement):this._disableElement(this._invBtnElement)):(t.listChecked.length==t.list.length?(t.inputHead.classList.remove("semi-checked"),t.inputHead.checked=!0):(t.inputHead.classList.add("semi-checked"),t.inputHead.checked=!1),e.classList.contains("source")?this._enableElement(this._addBtnElement):this._enableElement(this._invBtnElement));}_checkListHeader(e){const t=this._getScopeData(e);t.listChecked.length>0?(t.list.forEach((e=>{e.checked=!1;})),t.inputHead.classList.remove("semi-checked"),t.inputHead.checked=!1,e.classList.contains("source")?this._disableElement(this._addBtnElement):this._disableElement(this._invBtnElement)):(t.list.forEach((e=>{e.checked=!0;})),e.classList.contains("source")?this._enableElement(this._addBtnElement):this._enableElement(this._invBtnElement));}_addItems(e){const t=this._getScopeData(SelectorEngine$1.findOne(e?SELECTOR_TARGET:SELECTOR_SOURCE,this._element)),n=this._getScopeData(SelectorEngine$1.findOne(e?SELECTOR_SOURCE:SELECTOR_TARGET,this._element)),s=t.listChecked,i=t.inputHead,r=t.labelNumHead,a=s.length,E=t.list.length,l=n.group,c=n.list.length+a,d=n.labelNumHead,_=n.inputHead;s.forEach((e=>{const t=e.closest(".form-check");t.remove(),l.appendChild(t),e.checked=!1;}));const h=E-a,o=c;r.innerText=h,d.innerText=o,0==h&&i.setAttribute("disabled",!0),o>0&&_.removeAttribute("disabled"),i.classList.remove("semi-checked"),i.checked=!1,this._enableElement(this._resetBtnElement);}_resetAll(){const e={source:this._getScopeData(SelectorEngine$1.findOne(SELECTOR_SOURCE,this._element)),target:this._getScopeData(SelectorEngine$1.findOne(SELECTOR_TARGET,this._element))};Object.keys(e).forEach((t=>{e[t].list.forEach((e=>e.closest(".form-check").remove()));})),Object.keys(e).forEach((t=>{this._listDefault[t].forEach((n=>{n.checked=!1,e[t].group.appendChild(n);})),e[t].labelNumHead.innerText=this._listDefault[t].length,e[t].inputHead.removeAttribute("disabled"),e[t].inputHead.classList.remove("semi-checked"),e[t].inputHead.checked=!1;}));}}SelectorEngine$1.find(SELECTOR_BLOCK).forEach((e=>{Transfer.getOrCreateInstance(e);}));var Transfer$1 = Transfer;loadPlugin(icons),loadPlugin(fontsLoader),loadPlugin(headerSticky);window.BOOTSTRAP_ITALIA_VERSION=BOOTSTRAP_ITALIA_VERSION,window.bootstrap={Alert:Alert,Button:Button,Carousel:Carousel,Collapse:Collapse,Dropdown:Dropdown,Modal:Modal,Offcanvas:Offcanvas,Popover:Popover,ScrollSpy:ScrollSpy,Tab:Tab,Toast:Toast,Tooltip:Tooltip,Accordion:Accordion$1,BackToTop:BackToTop$1,CarouselBI:CarouselBI$1,Cookiebar:Cookiebar$1,Dimmer:Dimmer$1,FormValidate:FormValidate,Forward:Forward$1,HistoryBack:HistoryBack$1,Input:Input$1,InputNumber:InputNumber$1,InputPassword:InputPassword$1,InputSearchAutocomplete:InputSearchAutocomplete,List:List$1,Masonry:Masonry$1,NavBarCollapsible:NavBarCollapsible$1,NavScroll:NavScroll$1,Notification:Notification$1,ProgressDonut:ProgressDonut$1,SelectAutocomplete:SelectAutocomplete$1,Sticky:Sticky$1,TrackFocus:TrackFocus$1,Transfer:Transfer$1,UploadDragDrop:UploadDragDrop$1,ValidatorSelectAutocomplete:ValidatorSelectAutocomplete};})();