import type { AriaInvalid, ButtonVariant, Size } from '../types';
import { type MaybeRefOrGetter } from 'vue';
interface ClassesItemsInput {
    plain?: boolean;
    button?: boolean;
    inline?: boolean;
    switch?: boolean;
    size?: Size;
}
declare const getClasses: (items: MaybeRefOrGetter<ClassesItemsInput>) => import("vue").ComputedRef<{
    [x: string]: boolean;
    'form-check': boolean;
    'form-check-inline': boolean;
    'form-switch': boolean;
}>;
interface InputClassesItemsInput {
    plain?: boolean;
    button?: boolean;
    state?: boolean | null;
}
declare const getInputClasses: (items: MaybeRefOrGetter<InputClassesItemsInput>) => import("vue").ComputedRef<(string | {
    'form-check-input': boolean;
    'btn-check': boolean;
} | null)[]>;
interface LabelClasesItemsInput {
    plain?: boolean;
    button?: boolean;
    buttonVariant?: ButtonVariant | null;
    size?: Size;
}
declare const getLabelClasses: (items: MaybeRefOrGetter<LabelClasesItemsInput>) => import("vue").ComputedRef<{
    [x: string]: boolean | undefined;
    'form-check-label': boolean;
    btn: boolean;
}>;
interface GroupAttrItemsInput {
    required?: boolean;
    ariaInvalid?: AriaInvalid;
    state?: boolean | null;
}
declare const getGroupAttr: (items: MaybeRefOrGetter<GroupAttrItemsInput>) => import("vue").ComputedRef<{
    'aria-invalid': boolean | "true" | "false" | "grammar" | "spelling" | undefined;
    'aria-required': boolean | undefined;
}>;
interface GroupClassesItemsInput {
    validated?: boolean;
    buttons?: boolean;
    stacked?: boolean;
    size?: Size;
}
declare const getGroupClasses: (items: MaybeRefOrGetter<GroupClassesItemsInput>) => import("vue").ComputedRef<{
    [x: string]: boolean;
    'was-validated': boolean;
    'btn-group': boolean;
    'btn-group-vertical': boolean;
}>;
export { getClasses, getInputClasses, getLabelClasses, getGroupAttr, getGroupClasses };
