/**
 * SSR safe types
 */
export declare const WINDOW: {};
export declare const DOCUMENT: {};
export type AnimationFrame = typeof requestAnimationFrame;
declare global {
    interface Window {
        requestAnimationFrame: AnimationFrame;
        webkitRequestAnimationFrame: AnimationFrame;
        mozRequestAnimationFrame: AnimationFrame;
        msRequestAnimationFrame: AnimationFrame;
        oRequestAnimationFrame: AnimationFrame;
    }
}
export declare const Element: {
    new (): Element;
    prototype: Element;
} | {
    new (value?: any): {
        constructor: Function;
        toString(): string;
        toLocaleString(): string;
        valueOf(): Object;
        hasOwnProperty(v: PropertyKey): boolean;
        isPrototypeOf(v: Object): boolean;
        propertyIsEnumerable(v: PropertyKey): boolean;
        should: Chai.Assertion;
    };
    getPrototypeOf(o: any): any;
    getOwnPropertyDescriptor(o: any, p: PropertyKey): PropertyDescriptor | undefined;
    getOwnPropertyNames(o: any): string[];
    create(o: object | null): any;
    create(o: object | null, properties: PropertyDescriptorMap & ThisType<any>): any;
    defineProperty<T>(o: T, p: PropertyKey, attributes: PropertyDescriptor & ThisType<any>): T;
    defineProperties<T_1>(o: T_1, properties: PropertyDescriptorMap & ThisType<any>): T_1;
    seal<T_2>(o: T_2): T_2;
    freeze<T_3 extends Function>(f: T_3): T_3;
    freeze<T_4 extends {
        [idx: string]: object | U | null | undefined;
    }, U extends string | number | bigint | boolean | symbol>(o: T_4): Readonly<T_4>;
    freeze<T_5>(o: T_5): Readonly<T_5>;
    preventExtensions<T_6>(o: T_6): T_6;
    isSealed(o: any): boolean;
    isFrozen(o: any): boolean;
    isExtensible(o: any): boolean;
    keys(o: object): string[];
    keys(o: {}): string[];
    assign<T_7 extends {}, U_1>(target: T_7, source: U_1): T_7 & U_1;
    assign<T_8 extends {}, U_2, V>(target: T_8, source1: U_2, source2: V): T_8 & U_2 & V;
    assign<T_9 extends {}, U_3, V_1, W>(target: T_9, source1: U_3, source2: V_1, source3: W): T_9 & U_3 & V_1 & W;
    assign(target: object, ...sources: any[]): any;
    getOwnPropertySymbols(o: any): symbol[];
    is(value1: any, value2: any): boolean;
    setPrototypeOf(o: any, proto: object | null): any;
    values<T_10>(o: {
        [s: string]: T_10;
    } | ArrayLike<T_10>): T_10[];
    values(o: {}): any[];
    entries<T_11>(o: {
        [s: string]: T_11;
    } | ArrayLike<T_11>): [string, T_11][];
    entries(o: {}): [string, any][];
    getOwnPropertyDescriptors<T_12>(o: T_12): { [P in keyof T_12]: TypedPropertyDescriptor<T_12[P]>; } & {
        [x: string]: PropertyDescriptor;
    };
    fromEntries<T_13 = any>(entries: Iterable<readonly [PropertyKey, T_13]>): {
        [k: string]: T_13;
    };
    fromEntries(entries: Iterable<readonly any[]>): any;
};
export declare const HTMLElement: {
    new (): {};
    new (value?: any): {};
};
export declare const SVGElement: {
    new (): {};
    new (value?: any): {};
};
export declare const File: {
    new (fileBits: BlobPart[], fileName: string, options?: FilePropertyBag | undefined): File;
    prototype: File;
} | {
    new (value?: any): {
        constructor: Function;
        toString(): string;
        toLocaleString(): string;
        valueOf(): Object;
        hasOwnProperty(v: PropertyKey): boolean;
        isPrototypeOf(v: Object): boolean;
        propertyIsEnumerable(v: PropertyKey): boolean;
        should: Chai.Assertion;
    };
    getPrototypeOf(o: any): any;
    getOwnPropertyDescriptor(o: any, p: PropertyKey): PropertyDescriptor | undefined;
    getOwnPropertyNames(o: any): string[];
    create(o: object | null): any;
    create(o: object | null, properties: PropertyDescriptorMap & ThisType<any>): any;
    defineProperty<T>(o: T, p: PropertyKey, attributes: PropertyDescriptor & ThisType<any>): T;
    defineProperties<T_1>(o: T_1, properties: PropertyDescriptorMap & ThisType<any>): T_1;
    seal<T_2>(o: T_2): T_2;
    freeze<T_3 extends Function>(f: T_3): T_3;
    freeze<T_4 extends {
        [idx: string]: object | U | null | undefined;
    }, U extends string | number | bigint | boolean | symbol>(o: T_4): Readonly<T_4>;
    freeze<T_5>(o: T_5): Readonly<T_5>;
    preventExtensions<T_6>(o: T_6): T_6;
    isSealed(o: any): boolean;
    isFrozen(o: any): boolean;
    isExtensible(o: any): boolean;
    keys(o: object): string[];
    keys(o: {}): string[];
    assign<T_7 extends {}, U_1>(target: T_7, source: U_1): T_7 & U_1;
    assign<T_8 extends {}, U_2, V>(target: T_8, source1: U_2, source2: V): T_8 & U_2 & V;
    assign<T_9 extends {}, U_3, V_1, W>(target: T_9, source1: U_3, source2: V_1, source3: W): T_9 & U_3 & V_1 & W;
    assign(target: object, ...sources: any[]): any;
    getOwnPropertySymbols(o: any): symbol[];
    is(value1: any, value2: any): boolean;
    setPrototypeOf(o: any, proto: object | null): any;
    values<T_10>(o: {
        [s: string]: T_10;
    } | ArrayLike<T_10>): T_10[];
    values(o: {}): any[];
    entries<T_11>(o: {
        [s: string]: T_11;
    } | ArrayLike<T_11>): [string, T_11][];
    entries(o: {}): [string, any][];
    getOwnPropertyDescriptors<T_12>(o: T_12): { [P in keyof T_12]: TypedPropertyDescriptor<T_12[P]>; } & {
        [x: string]: PropertyDescriptor;
    };
    fromEntries<T_13 = any>(entries: Iterable<readonly [PropertyKey, T_13]>): {
        [k: string]: T_13;
    };
    fromEntries(entries: Iterable<readonly any[]>): any;
};
