import type { Booleanish } from '../types';
import { type MaybeRefOrGetter, type Ref } from 'vue';
/**
 * Resolves a Booleanish type reactively to type boolean
 */
declare function useBooleanish(el: MaybeRefOrGetter<Booleanish>): Readonly<Ref<boolean>>;
declare function useBooleanish(el: MaybeRefOrGetter<Booleanish | null>): Readonly<Ref<boolean | null>>;
declare function useBooleanish(el: MaybeRefOrGetter<Booleanish | undefined>): Readonly<Ref<boolean | undefined>>;
declare function useBooleanish(el: MaybeRefOrGetter<Booleanish | undefined | null>): Readonly<Ref<boolean | undefined | null>>;
export default useBooleanish;
