import type { InjectionKey, Ref } from 'vue';
import type { ButtonVariant, ColorVariant, Size } from '../types';
export declare const carouselInjectionKey: InjectionKey<{
    background: Readonly<Ref<string | undefined>>;
    width: Readonly<Ref<string | undefined>>;
    height: Readonly<Ref<string | undefined>>;
}>;
export declare const tabsInjectionKey: InjectionKey<{
    lazy: Readonly<Ref<boolean>>;
    card: Readonly<Ref<boolean>>;
}>;
export declare const progressInjectionKey: InjectionKey<{
    animated: Readonly<Ref<boolean>>;
    max: Readonly<Ref<number | string>>;
    showProgress: Readonly<Ref<boolean>>;
    showValue: Readonly<Ref<boolean>>;
    striped: Readonly<Ref<boolean>>;
}>;
export declare const listGroupInjectionKey: InjectionKey<{
    numbered: Readonly<Ref<boolean>>;
}>;
export declare const avatarGroupInjectionKey: InjectionKey<{
    overlapScale: Readonly<Ref<number>>;
    size: Readonly<Ref<Size | string | undefined>>;
    square: Readonly<Ref<boolean>>;
    rounded: Readonly<Ref<boolean | string>>;
    variant: Readonly<Ref<ColorVariant | null>>;
}>;
export declare const accordionInjectionKey: InjectionKey<{
    openItem: Readonly<Ref<string | undefined>>;
    free: Readonly<Ref<boolean>>;
    setOpenItem: (id: string) => void;
}>;
export declare const checkboxGroupKey: InjectionKey<{
    set: (payload: unknown[] | Set<unknown> | boolean | string | Record<string, unknown> | number | null) => void;
    remove: (payload: unknown[] | Set<unknown> | boolean | string | Record<string, unknown> | number | null) => void;
    modelValue: Readonly<Ref<(unknown[] | Set<unknown> | boolean | string | Record<string, unknown> | number | null)[]>>;
    switch: Readonly<Ref<boolean>>;
    buttonVariant: Readonly<Ref<ButtonVariant | null>>;
    form: Readonly<Ref<string | undefined>>;
    name: Readonly<Ref<string>>;
    state: Readonly<Ref<boolean | undefined | null>>;
    plain: Readonly<Ref<boolean>>;
    size: Readonly<Ref<Size>>;
    inline: Readonly<Ref<boolean>>;
    required: Readonly<Ref<boolean>>;
    buttons: Readonly<Ref<boolean>>;
    disabled: Readonly<Ref<boolean>>;
}>;
export declare const radioGroupKey: InjectionKey<{
    set: (value: string | boolean | unknown[] | Record<string, unknown> | number | null) => void;
    modelValue: Readonly<Ref<string | boolean | unknown[] | Record<string, unknown> | number | null>>;
    buttonVariant: Readonly<Ref<ButtonVariant | null>>;
    form: Readonly<Ref<string | undefined>>;
    name: Readonly<Ref<string>>;
    buttons: Readonly<Ref<boolean>>;
    state: Readonly<Ref<boolean | undefined | null>>;
    plain: Readonly<Ref<boolean>>;
    size: Readonly<Ref<Size>>;
    inline: Readonly<Ref<boolean>>;
    required: Readonly<Ref<boolean>>;
    disabled: Readonly<Ref<boolean>>;
}>;
export declare const collapseInjectionKey: InjectionKey<{
    id?: Readonly<Ref<string>>;
    readonly close?: () => void;
    readonly open?: () => void;
    readonly toggle?: () => void;
    visible?: Readonly<Ref<boolean>>;
    isNav?: Readonly<Ref<boolean>>;
}>;
export declare const dropdownInjectionKey: InjectionKey<{
    id?: Readonly<Ref<string>>;
    readonly close?: () => void;
    readonly open?: () => void;
    readonly toggle?: () => void;
    visible?: Readonly<Ref<boolean>>;
    isNav?: Readonly<Ref<boolean>>;
}>;
export declare const navbarInjectionKey: InjectionKey<{
    tag?: Readonly<Ref<string>>;
    autoClose?: Readonly<Ref<boolean>>;
}>;
