import { ComponentPublicInstance, MaybeRefOrGetter, Ref } from 'vue';

type ScrollspyList = {
    id: string | null;
    el: HTMLElement | null;
    visible: boolean;
    text: string | null;
}[];
interface ScrollspyReturn {
    current: Readonly<Ref<string | null>>;
    list: Readonly<Ref<ScrollspyList>>;
    content: Ref<HTMLElement | undefined>;
    target: Ref<HTMLElement | undefined>;
    scrollIntoView: (event: MouseEvent) => void;
    updateList: () => void;
    cleanup: () => void;
}
interface ScrollspyOptions {
    contentQuery: string;
    targetQuery: string;
    manual: boolean;
    root: string | ComponentPublicInstance | HTMLElement | null;
    rootMargin: string;
    threshold: number | number[];
    watchChanges: boolean;
}
declare const _default: (content: MaybeRefOrGetter<string | ComponentPublicInstance | HTMLElement | null>, target: MaybeRefOrGetter<string | ComponentPublicInstance | HTMLElement | null>, options?: Readonly<Partial<ScrollspyOptions>>) => ScrollspyReturn;
export default _default;
