import { defineComponent, mergeModels, useModel, computed, provide, readonly, toRef, openBlock, createElementBlock, unref, normalizeClass, renderSlot, useAttrs, inject, onMounted, watch, mergeProps, createVNode, withCtx, createBlock, resolveDynamicComponent, createElementVNode, createTextVNode, toDisplayString } from "vue";
import { g as accordionInjectionKey } from "./keys-CLEaYsGj.mjs";
import { u as useId } from "./useId-BrAgQfKM.mjs";
import { u as useDefaults } from "./useDefaults-BYx9NNxn.mjs";
import { _ as _sfc_main$2 } from "./BCollapse.vue_vue_type_script_setup_true_lang-DQFE_wBf.mjs";
const _hoisted_1$1 = ["id"];
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BAccordion",
  props: /* @__PURE__ */ mergeModels({
    flush: { type: Boolean, default: false },
    free: { type: Boolean, default: false },
    id: { default: void 0 }
  }, {
    "modelValue": {
      default: void 0
    },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BAccordion");
    const modelValue = useModel(__props, "modelValue");
    const computedId = useId(() => props.id, "accordion");
    const computedClasses = computed(() => ({
      "accordion-flush": props.flush
    }));
    provide(accordionInjectionKey, {
      openItem: readonly(modelValue),
      free: toRef(() => props.free),
      setOpenItem: (id) => {
        modelValue.value = id;
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        id: unref(computedId),
        class: normalizeClass(["accordion", computedClasses.value])
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 10, _hoisted_1$1);
    };
  }
});
const _hoisted_1 = ["aria-expanded", "aria-controls", "onClick"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BAccordionItem",
  props: /* @__PURE__ */ mergeModels({
    bodyAttrs: { default: void 0 },
    bodyClass: { default: void 0 },
    buttonAttrs: { default: void 0 },
    buttonClass: { default: void 0 },
    collapseClass: { default: void 0 },
    headerAttrs: { default: void 0 },
    headerClass: { default: void 0 },
    headerTag: { default: "h2" },
    horizontal: { type: Boolean, default: void 0 },
    id: { default: void 0 },
    isNav: { type: Boolean, default: void 0 },
    tag: { default: void 0 },
    title: { default: void 0 },
    toggle: { type: Boolean, default: void 0 },
    visible: { type: Boolean, default: false },
    wrapperAttrs: { default: void 0 }
  }, {
    "modelValue": { type: Boolean, ...{
      default: false
    } },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["hidden", "hide", "hide-prevented", "show", "show-prevented", "shown"], ["update:modelValue"]),
  setup(__props, { emit: __emit }) {
    const { class: wrapperClass, ...collapseAttrs } = useAttrs();
    const _props = __props;
    const props = useDefaults(_props, "BAccordionItem");
    const emit = __emit;
    const modelValue = useModel(__props, "modelValue");
    const parentData = inject(accordionInjectionKey, null);
    const computedId = useId(() => props.id, "accordion_item");
    onMounted(() => {
      if (modelValue.value && !(parentData == null ? void 0 : parentData.free.value)) {
        parentData == null ? void 0 : parentData.setOpenItem(computedId.value);
      }
      if (!modelValue.value && (parentData == null ? void 0 : parentData.openItem.value) === computedId.value) {
        modelValue.value = true;
      }
    });
    watch(
      () => parentData == null ? void 0 : parentData.openItem.value,
      () => modelValue.value = (parentData == null ? void 0 : parentData.openItem.value) === computedId.value && !(parentData == null ? void 0 : parentData.free.value)
    );
    watch(modelValue, () => {
      if (modelValue.value && !(parentData == null ? void 0 : parentData.free.value)) parentData == null ? void 0 : parentData.setOpenItem(computedId.value);
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", mergeProps({ class: "accordion-item" }, unref(props).wrapperAttrs, { class: unref(wrapperClass) }), [
        createVNode(_sfc_main$2, mergeProps({
          id: unref(computedId),
          modelValue: modelValue.value,
          "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => modelValue.value = $event),
          class: ["accordion-collapse", unref(props).collapseClass],
          "aria-labelledby": `${unref(computedId)}-heading`
        }, collapseAttrs, {
          tag: unref(props).tag,
          toggle: unref(props).toggle,
          horizontal: unref(props).horizontal,
          visible: unref(props).visible,
          "is-nav": unref(props).isNav,
          onShow: _cache[1] || (_cache[1] = ($event) => emit("show", $event)),
          onShown: _cache[2] || (_cache[2] = ($event) => emit("shown")),
          onHide: _cache[3] || (_cache[3] = ($event) => emit("hide", $event)),
          onHidden: _cache[4] || (_cache[4] = ($event) => emit("hidden")),
          onHidePrevented: _cache[5] || (_cache[5] = ($event) => emit("hide-prevented")),
          onShowPrevented: _cache[6] || (_cache[6] = ($event) => emit("show-prevented"))
        }), {
          header: withCtx(({ visible: toggleVisible, toggle: slotToggle }) => [
            (openBlock(), createBlock(resolveDynamicComponent(unref(props).headerTag), mergeProps({
              id: `${unref(computedId)}-heading`,
              class: ["accordion-header", unref(props).headerClass]
            }, unref(props).headerAttrs), {
              default: withCtx(() => [
                createElementVNode("button", mergeProps({ class: "accordion-button" }, unref(props).buttonAttrs, {
                  class: [{ collapsed: !toggleVisible }, unref(props).buttonClass],
                  type: "button",
                  "aria-expanded": toggleVisible ? "true" : "false",
                  "aria-controls": unref(computedId),
                  onClick: slotToggle
                }), [
                  renderSlot(_ctx.$slots, "title", {}, () => [
                    createTextVNode(toDisplayString(unref(props).title), 1)
                  ])
                ], 16, _hoisted_1)
              ]),
              _: 2
            }, 1040, ["id", "class"]))
          ]),
          default: withCtx(() => [
            createElementVNode("div", mergeProps({ class: "accordion-body" }, unref(props).bodyAttrs, {
              class: unref(props).bodyClass
            }), [
              renderSlot(_ctx.$slots, "default")
            ], 16)
          ]),
          _: 3
        }, 16, ["id", "modelValue", "class", "aria-labelledby", "tag", "toggle", "horizontal", "visible", "is-nav"])
      ], 16);
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BAccordionItem.vue_vue_type_script_setup_true_lang-CGL4HjQ5.mjs.map
