import { defineComponent, mergeModels, useSlots, ref, useModel, computed, watchEffect, openBlock, createBlock, unref, withCtx, createElementBlock, normalizeClass, renderSlot, Fragment, mergeProps, createTextVNode, toDisplayString, createCommentVNode } from "vue";
import { _ as _sfc_main$1 } from "./BTransition.vue_vue_type_style_index_0_lang-X5a8jq3A.mjs";
import { _ as _sfc_main$3 } from "./BCloseButton.vue_vue_type_script_setup_true_lang-B9g9XRA_.mjs";
import { _ as _sfc_main$2 } from "./BButton.vue_vue_type_script_setup_true_lang-VSdlVuWr.mjs";
import { u as useCountdown, a as useCountdownHover } from "./useCountdownHover-Ds0unFZR.mjs";
import { u as useDefaults } from "./useDefaults-BYx9NNxn.mjs";
import { i as isEmptySlot } from "./dom-B-SQyhbA.mjs";
import { _ as _export_sfc } from "./_plugin-vue_export-helper-1tPrXgE0.mjs";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BAlert",
  props: /* @__PURE__ */ mergeModels({
    closeClass: { default: void 0 },
    closeContent: { default: void 0 },
    closeLabel: { default: "Close" },
    closeVariant: { default: "secondary" },
    dismissible: { type: Boolean, default: false },
    fade: { type: Boolean, default: false },
    immediate: { type: Boolean, default: true },
    interval: { default: "requestAnimationFrame" },
    noHoverPause: { type: Boolean, default: false },
    noResumeOnHoverLeave: { type: Boolean, default: false },
    showOnPause: { type: Boolean, default: true },
    variant: { default: "info" }
  }, {
    "modelValue": { type: [Boolean, Number], ...{ default: false } },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["close", "close-countdown", "closed"], ["update:modelValue"]),
  setup(__props, { expose: __expose, emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BAlert");
    const emit = __emit;
    const slots = useSlots();
    const element = ref(null);
    const modelValue = useModel(__props, "modelValue");
    const hasCloseSlot = computed(() => !isEmptySlot(slots.close));
    const countdownLength = computed(
      () => typeof modelValue.value === "boolean" ? 0 : modelValue.value
    );
    const computedClasses = computed(() => ({
      [`alert-${props.variant}`]: props.variant !== null,
      "alert-dismissible": props.dismissible
    }));
    const closeClasses = computed(() => [props.closeClass, { "btn-close-custom": hasCloseSlot.value }]);
    const {
      isActive,
      pause,
      resume,
      stop,
      isPaused,
      restart,
      value: remainingMs
    } = useCountdown(countdownLength, props.interval, {
      immediate: typeof modelValue.value === "number" && props.immediate
    });
    useCountdownHover(
      element,
      computed(() => ({
        noHoverPause: props.noHoverPause,
        noResumeOnHoverLeave: props.noResumeOnHoverLeave
      })),
      { pause, resume }
    );
    const isAlertVisible = computed(
      () => typeof modelValue.value === "boolean" ? modelValue.value : isActive.value || props.showOnPause && isPaused.value
    );
    const closeAttrs = computed(() => ({
      variant: hasCloseSlot.value ? props.closeVariant : void 0,
      class: closeClasses.value
    }));
    watchEffect(() => {
      emit("close-countdown", remainingMs.value);
    });
    const hide = () => {
      emit("close");
      if (typeof modelValue.value === "boolean") {
        modelValue.value = false;
      } else {
        modelValue.value = 0;
        stop();
      }
      emit("closed");
    };
    __expose({
      pause,
      resume,
      stop,
      restart
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$1, {
        "no-fade": !unref(props).fade,
        "trans-props": { enterToClass: "show" }
      }, {
        default: withCtx(() => [
          isAlertVisible.value ? (openBlock(), createElementBlock("div", {
            key: 0,
            ref_key: "element",
            ref: element,
            class: normalizeClass(["alert", computedClasses.value]),
            role: "alert",
            "aria-live": "polite",
            "aria-atomic": "true"
          }, [
            renderSlot(_ctx.$slots, "default", {}, void 0, true),
            unref(props).dismissible ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
              hasCloseSlot.value || unref(props).closeContent ? (openBlock(), createBlock(_sfc_main$2, mergeProps({ key: 0 }, closeAttrs.value, { onClick: hide }), {
                default: withCtx(() => [
                  renderSlot(_ctx.$slots, "close", {}, () => [
                    createTextVNode(toDisplayString(unref(props).closeContent), 1)
                  ], true)
                ]),
                _: 3
              }, 16)) : (openBlock(), createBlock(_sfc_main$3, mergeProps({
                key: 1,
                "aria-label": unref(props).closeLabel
              }, closeAttrs.value, { onClick: hide }), null, 16, ["aria-label"]))
            ], 64)) : createCommentVNode("", true)
          ], 2)) : createCommentVNode("", true)
        ]),
        _: 3
      }, 8, ["no-fade"]);
    };
  }
});
const BAlert = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-d1c92ab3"]]);
export {
  BAlert as B
};
//# sourceMappingURL=BAlert-zaujoJkK.mjs.map
