import { defineComponent, useSlots, inject, computed, openBlock, createBlock, resolveDynamicComponent, mergeProps, unref, withCtx, createElementBlock, renderSlot, createElementVNode, normalizeStyle, toDisplayString, createTextVNode, createCommentVNode, provide, toRef } from "vue";
import { h as avatarGroupInjectionKey } from "./keys-CLEaYsGj.mjs";
import { _ as _sfc_main$2 } from "./BLink.vue_vue_type_script_setup_true_lang-C39-ereM.mjs";
import { _ as _sfc_main$3 } from "./BBadge.vue_vue_type_script_setup_true_lang-DMBOUNsT.mjs";
import { u as useBLinkHelper } from "./useBLinkHelper-Bvtov_sk.mjs";
import { i as isEmptySlot } from "./dom-B-SQyhbA.mjs";
import { u as useNumberishToStyle } from "./useNumberishToStyle-BWrWARZP.mjs";
import { u as useRadiusElementClasses } from "./useRadiusElementClasses-DtKYQuWz.mjs";
import { u as useColorVariantClasses } from "./useColorVariantClasses-BDBjYQXI.mjs";
import { u as useDefaults } from "./useDefaults-BYx9NNxn.mjs";
import { u as useToNumber } from "./index-DlGgXMQF.mjs";
const _hoisted_1 = {
  key: 0,
  class: "b-avatar-custom"
};
const _hoisted_2 = {
  key: 1,
  class: "b-avatar-img"
};
const _hoisted_3 = ["src", "alt"];
const _hoisted_4 = {
  key: 3,
  class: "b-avatar-img"
};
const FONT_SIZE_SCALE = 0.4;
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BAvatar",
  props: {
    alt: { default: "avatar" },
    badge: { type: [Boolean, String], default: false },
    badgeBgVariant: { default: null },
    badgePlacement: { default: "bottom-end" },
    badgeTextVariant: { default: null },
    badgeVariant: { default: "primary" },
    badgePill: { type: Boolean, default: false },
    badgeDotIndicator: { type: Boolean, default: false },
    button: { type: Boolean, default: false },
    buttonType: { default: "button" },
    size: { default: void 0 },
    square: { type: Boolean, default: false },
    src: { default: void 0 },
    text: { default: void 0 },
    active: { type: Boolean, default: void 0 },
    activeClass: { default: void 0 },
    disabled: { type: Boolean, default: void 0 },
    exactActiveClass: { default: void 0 },
    href: { default: void 0 },
    noRel: { type: Boolean },
    opacity: { default: void 0 },
    opacityHover: { default: void 0 },
    rel: { default: void 0 },
    replace: { type: Boolean, default: void 0 },
    routerComponentName: { default: void 0 },
    stretched: { type: Boolean, default: false },
    target: { default: void 0 },
    to: {},
    underlineOffset: { default: void 0 },
    underlineOffsetHover: { default: void 0 },
    underlineOpacity: { default: void 0 },
    underlineOpacityHover: { default: void 0 },
    underlineVariant: { default: void 0 },
    variant: { default: "secondary" },
    bgVariant: { default: null },
    textVariant: { default: null },
    rounded: { type: [Boolean, String, Number], default: "circle" },
    roundedTop: { type: [Boolean, String, Number], default: void 0 },
    roundedBottom: { type: [Boolean, String, Number], default: void 0 },
    roundedStart: { type: [Boolean, String, Number], default: void 0 },
    roundedEnd: { type: [Boolean, String, Number], default: void 0 }
  },
  emits: ["click", "img-error"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const slots = useSlots();
    const { computedLink, computedLinkProps } = useBLinkHelper(props);
    const parentData = inject(avatarGroupInjectionKey, null);
    const SIZES = ["sm", null, "lg"];
    const BADGE_FONT_SIZE_SCALE = FONT_SIZE_SCALE * 0.7;
    const hasDefaultSlot = computed(() => !isEmptySlot(slots.default));
    const hasBadgeSlot = computed(() => !isEmptySlot(slots.badge));
    const showBadge = computed(() => !!props.badge || props.badge === "" || hasBadgeSlot.value);
    const computedSquare = computed(() => (parentData == null ? void 0 : parentData.square.value) || props.square);
    const computedPropSize = useNumberishToStyle(() => props.size);
    const computedParentSize = useNumberishToStyle(() => parentData == null ? void 0 : parentData.size.value);
    const computedSize = computed(() => computedParentSize.value ?? computedPropSize.value);
    const computedVariant = computed(() => (parentData == null ? void 0 : parentData.variant.value) ?? props.variant);
    const computedRounded = computed(() => (parentData == null ? void 0 : parentData.rounded.value) ?? props.rounded);
    const computedRoundedTop = computed(() => (parentData == null ? void 0 : parentData.roundedTop.value) ?? props.roundedTop);
    const computedRoundedBottom = computed(() => (parentData == null ? void 0 : parentData.roundedBottom.value) ?? props.roundedBottom);
    const computedRoundedStart = computed(() => (parentData == null ? void 0 : parentData.roundedStart.value) ?? props.roundedStart);
    const computedRoundedEnd = computed(() => (parentData == null ? void 0 : parentData.roundedEnd.value) ?? props.roundedEnd);
    const radiusElementClasses = useRadiusElementClasses(() => ({
      rounded: computedRounded.value,
      roundedTop: computedRoundedTop.value,
      roundedBottom: computedRoundedBottom.value,
      roundedStart: computedRoundedStart.value,
      roundedEnd: computedRoundedEnd.value
    }));
    const badgeText = computed(() => props.badge === true ? "" : props.badge);
    const badgeImplicitlyDot = computed(() => !badgeText.value && !hasBadgeSlot.value);
    const computedTextVariant = computed(() => (parentData == null ? void 0 : parentData.textVariant.value) ?? props.textVariant);
    const computedBgVariant = computed(() => (parentData == null ? void 0 : parentData.bgVariant.value) ?? props.bgVariant);
    const resolvedBackgroundClasses = useColorVariantClasses(() => ({
      bgVariant: computedBgVariant.value,
      textVariant: computedTextVariant.value,
      variant: computedVariant.value
    }));
    const computedClasses = computed(() => [
      resolvedBackgroundClasses.value,
      // Square overwrites all else
      computedSquare.value === true ? void 0 : radiusElementClasses.value,
      {
        [`b-avatar-${props.size}`]: !!props.size && SIZES.indexOf(computedPropSize.value) !== -1,
        [`btn-${computedVariant.value}`]: props.button ? computedVariant.value !== null : false,
        "badge": !props.button && computedVariant.value !== null && hasDefaultSlot.value,
        "btn": props.button,
        // Square is the same as rounded-0 class
        "rounded-0": computedSquare.value === true
      }
    ]);
    const badgeStyle = computed(() => ({
      fontSize: (SIZES.indexOf(computedSize.value || null) === -1 ? `calc(${computedSize.value} * ${BADGE_FONT_SIZE_SCALE})` : "") || ""
    }));
    const textFontStyle = computed(() => {
      const fontSize = SIZES.indexOf(computedSize.value || null) === -1 ? `calc(${computedSize.value} * ${FONT_SIZE_SCALE})` : null;
      return fontSize ? { fontSize } : {};
    });
    const marginStyle = computed(() => {
      var _a;
      const overlapScale = ((_a = parentData == null ? void 0 : parentData.overlapScale) == null ? void 0 : _a.value) || 0;
      const value = computedSize.value && overlapScale ? `calc(${computedSize.value} * -${overlapScale})` : null;
      return value ? { marginLeft: value, marginRight: value } : {};
    });
    const computedTag = computed(() => computedLink.value ? _sfc_main$2 : props.button ? "button" : "span");
    const computedStyle = computed(() => ({
      ...marginStyle.value,
      width: computedSize.value ?? void 0,
      height: computedSize.value ?? void 0
    }));
    const clicked = (e) => {
      if (!props.disabled && (computedLink.value || props.button)) emit("click", e);
    };
    const onImgError = (e) => {
      emit("img-error", e);
    };
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(computedTag.value), mergeProps({
        class: ["b-avatar", computedClasses.value],
        style: computedStyle.value
      }, unref(computedLinkProps), {
        type: props.button && !unref(computedLink) ? props.buttonType : void 0,
        disabled: props.disabled || null,
        onClick: clicked
      }), {
        default: withCtx(() => [
          hasDefaultSlot.value ? (openBlock(), createElementBlock("span", _hoisted_1, [
            renderSlot(_ctx.$slots, "default")
          ])) : !!props.src ? (openBlock(), createElementBlock("span", _hoisted_2, [
            createElementVNode("img", {
              src: props.src,
              alt: props.alt,
              onError: onImgError
            }, null, 40, _hoisted_3)
          ])) : !!props.text ? (openBlock(), createElementBlock("span", {
            key: 2,
            class: "b-avatar-text",
            style: normalizeStyle(textFontStyle.value)
          }, toDisplayString(props.text), 5)) : (openBlock(), createElementBlock("span", _hoisted_4, _cache[0] || (_cache[0] = [
            createElementVNode("svg", {
              xmlns: "http://www.w3.org/2000/svg",
              width: "80%",
              height: "80%",
              fill: "currentColor",
              class: "bi bi-person-fill",
              viewBox: "0 0 16 16"
            }, [
              createElementVNode("path", { d: "M3 14s-1 0-1-1 1-4 6-4 6 3 6 4-1 1-1 1zm5-6a3 3 0 1 0 0-6 3 3 0 0 0 0 6" })
            ], -1)
          ]))),
          showBadge.value ? (openBlock(), createBlock(_sfc_main$3, {
            key: 4,
            pill: props.badgePill,
            "dot-indicator": props.badgeDotIndicator || badgeImplicitlyDot.value,
            variant: props.badgeVariant,
            "bg-variant": props.badgeBgVariant,
            "text-variant": props.badgeTextVariant,
            style: normalizeStyle(badgeStyle.value),
            placement: props.badgePlacement
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "badge", {}, () => [
                createTextVNode(toDisplayString(badgeText.value), 1)
              ])
            ]),
            _: 3
          }, 8, ["pill", "dot-indicator", "variant", "bg-variant", "text-variant", "style", "placement"])) : createCommentVNode("", true)
        ]),
        _: 3
      }, 16, ["class", "style", "type", "disabled"]);
    };
  }
});
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BAvatarGroup",
  props: {
    overlap: { default: 0.3 },
    size: { default: void 0 },
    square: { type: Boolean, default: false },
    tag: { default: "div" },
    variant: { default: null },
    bgVariant: { default: null },
    textVariant: { default: null },
    rounded: { type: [Boolean, String, Number], default: "circle" },
    roundedTop: { type: [Boolean, String, Number], default: void 0 },
    roundedBottom: { type: [Boolean, String, Number], default: void 0 },
    roundedStart: { type: [Boolean, String, Number], default: void 0 },
    roundedEnd: { type: [Boolean, String, Number], default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BAvatarGroup");
    const overlapNumber = useToNumber(() => props.overlap);
    const computedSize = useNumberishToStyle(() => props.size);
    const overlapScale = computed(() => Math.min(Math.max(overlapNumber.value, 0), 1) / 2);
    const paddingStyle = computed(() => {
      const value = computedSize.value ? `calc(${computedSize.value} * ${overlapScale.value})` : null;
      return value ? { paddingLeft: value, paddingRight: value } : {};
    });
    provide(avatarGroupInjectionKey, {
      overlapScale,
      size: toRef(() => props.size),
      square: toRef(() => props.square),
      rounded: toRef(() => props.rounded),
      roundedTop: toRef(() => props.roundedTop),
      roundedBottom: toRef(() => props.roundedBottom),
      roundedStart: toRef(() => props.roundedStart),
      roundedEnd: toRef(() => props.roundedEnd),
      variant: toRef(() => props.variant),
      bgVariant: toRef(() => props.bgVariant),
      textVariant: toRef(() => props.textVariant)
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        class: "b-avatar-group",
        role: "group"
      }, {
        default: withCtx(() => [
          createElementVNode("div", {
            class: "b-avatar-group-inner",
            style: normalizeStyle(paddingStyle.value)
          }, [
            renderSlot(_ctx.$slots, "default")
          ], 4)
        ]),
        _: 3
      });
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BAvatarGroup.vue_vue_type_script_setup_true_lang-CHSj79Ia.mjs.map
