import { defineComponent, computed, openBlock, createBlock, mergeProps, resolveDynamicComponent, normalizeClass, withCtx, createElementBlock, renderSlot, createTextVNode, toDisplayString, unref, useSlots, createCommentVNode, createVNode, normalizeProps } from "vue";
import { i as isEmptySlot } from "./dom-B-SQyhbA.mjs";
import { u as useColorVariantClasses } from "./useColorVariantClasses-BDBjYQXI.mjs";
import { u as useDefaults } from "./useDefaults-BYx9NNxn.mjs";
import { _ as _sfc_main$8 } from "./BImg.vue_vue_type_script_setup_true_lang-CZ0wmkG3.mjs";
import { o as omit } from "./object-DIbMZaP9.mjs";
import { j as createReusableTemplate } from "./index-DngH9Pjm.mjs";
const _sfc_main$7 = /* @__PURE__ */ defineComponent({
  __name: "BCardImg",
  props: {
    placement: { default: "top" },
    blank: { type: Boolean, default: void 0 },
    blankColor: { default: void 0 },
    block: { type: Boolean, default: void 0 },
    fluid: { type: Boolean, default: void 0 },
    fluidGrow: { type: Boolean, default: void 0 },
    height: { default: void 0 },
    tag: {},
    lazy: { type: Boolean, default: void 0 },
    sizes: { default: void 0 },
    src: { default: void 0 },
    srcset: { default: void 0 },
    thumbnail: { type: Boolean, default: void 0 },
    width: { default: void 0 },
    rounded: { type: [Boolean, String, Number], default: void 0 },
    roundedTop: { type: [Boolean, String, Number], default: void 0 },
    roundedBottom: { type: [Boolean, String, Number], default: void 0 },
    roundedStart: { type: [Boolean, String, Number], default: void 0 },
    roundedEnd: { type: [Boolean, String, Number], default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BCardImg");
    const baseAlignmentClasses = computed(() => ({
      "card-img-top": props.placement === "top",
      // TODO implement this class
      "card-img-end": props.placement === "end",
      "card-img-bottom": props.placement === "bottom",
      // TODO implement this class
      "card-img-start": props.placement === "start",
      "card-img": props.placement === "overlay"
    }));
    const computedImgProps = computed(() => omit(props, ["placement"]));
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$8, mergeProps(computedImgProps.value, { class: baseAlignmentClasses.value }), null, 16, ["class"]);
    };
  }
});
const _hoisted_1 = ["innerHTML"];
const _sfc_main$6 = /* @__PURE__ */ defineComponent({
  __name: "BCardHeadFoot",
  props: {
    borderVariant: { default: null },
    html: { default: void 0 },
    tag: { default: "div" },
    text: { default: void 0 },
    variant: { default: null },
    bgVariant: { default: null },
    textVariant: { default: null }
  },
  setup(__props) {
    const props = __props;
    const resolvedBackgroundClasses = useColorVariantClasses(props);
    const computedClasses = computed(() => [
      resolvedBackgroundClasses.value,
      {
        [`border-${props.borderVariant}`]: props.borderVariant !== null
      }
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(_ctx.tag), {
        class: normalizeClass(computedClasses.value)
      }, {
        default: withCtx(() => [
          !!_ctx.html ? (openBlock(), createElementBlock("div", {
            key: 0,
            innerHTML: _ctx.html
          }, null, 8, _hoisted_1)) : renderSlot(_ctx.$slots, "default", { key: 1 }, () => [
            createTextVNode(toDisplayString(_ctx.text), 1)
          ])
        ]),
        _: 3
      }, 8, ["class"]);
    };
  }
});
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "BCardHeader",
  props: {
    borderVariant: { default: void 0 },
    html: { default: void 0 },
    tag: { default: "div" },
    text: { default: void 0 },
    variant: { default: void 0 },
    bgVariant: { default: void 0 },
    textVariant: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BCardHeader");
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$6, mergeProps({ class: "card-header" }, unref(props)), {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 16);
    };
  }
});
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "BCardTitle",
  props: {
    tag: { default: "h4" },
    text: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BCardTitle");
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), { class: "card-title" }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default", {}, () => [
            createTextVNode(toDisplayString(unref(props).text), 1)
          ])
        ]),
        _: 3
      });
    };
  }
});
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "BCardSubtitle",
  props: {
    text: { default: void 0 },
    tag: { default: "h6" },
    textVariant: { default: "body-secondary" }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BCardSubtitle");
    const computedClasses = computed(() => ({
      [`text-${props.textVariant}`]: props.textVariant !== null
    }));
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        class: normalizeClass(["card-subtitle mb-2", computedClasses.value])
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default", {}, () => [
            createTextVNode(toDisplayString(unref(props).text), 1)
          ])
        ]),
        _: 3
      }, 8, ["class"]);
    };
  }
});
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "BCardBody",
  props: {
    overlay: { type: Boolean, default: false },
    subtitle: { default: void 0 },
    subtitleTag: { default: "h4" },
    subtitleTextVariant: { default: void 0 },
    tag: { default: "div" },
    text: { default: void 0 },
    title: { default: void 0 },
    titleTag: { default: "h4" },
    variant: { default: null },
    bgVariant: { default: null },
    textVariant: { default: null }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BCardBody");
    const slots = useSlots();
    const resolvedBackgroundClasses = useColorVariantClasses(props);
    const hasTitleSlot = computed(() => !isEmptySlot(slots.title));
    const hasSubtitleSlot = computed(() => !isEmptySlot(slots.subtitle));
    const computedClasses = computed(() => [
      resolvedBackgroundClasses.value,
      props.overlay ? "card-img-overlay" : "card-body"
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        class: normalizeClass(computedClasses.value)
      }, {
        default: withCtx(() => [
          !!unref(props).title || hasTitleSlot.value ? (openBlock(), createBlock(_sfc_main$4, {
            key: 0,
            tag: unref(props).titleTag
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "title", {}, () => [
                createTextVNode(toDisplayString(unref(props).title), 1)
              ])
            ]),
            _: 3
          }, 8, ["tag"])) : createCommentVNode("", true),
          !!unref(props).subtitle || hasSubtitleSlot.value ? (openBlock(), createBlock(_sfc_main$3, {
            key: 1,
            tag: unref(props).subtitleTag,
            "text-variant": unref(props).subtitleTextVariant
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "subtitle", {}, () => [
                createTextVNode(toDisplayString(unref(props).subtitle), 1)
              ])
            ]),
            _: 3
          }, 8, ["tag", "text-variant"])) : createCommentVNode("", true),
          renderSlot(_ctx.$slots, "default", {}, () => [
            createTextVNode(toDisplayString(unref(props).text), 1)
          ])
        ]),
        _: 3
      }, 8, ["class"]);
    };
  }
});
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BCardFooter",
  props: {
    borderVariant: { default: void 0 },
    html: { default: void 0 },
    tag: { default: "div" },
    text: { default: void 0 },
    variant: { default: void 0 },
    bgVariant: { default: void 0 },
    textVariant: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BCardFooter");
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$6, mergeProps({ class: "card-footer" }, unref(props)), {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default", {}, () => [
            createTextVNode(toDisplayString(unref(props).text), 1)
          ])
        ]),
        _: 3
      }, 16);
    };
  }
});
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BCard",
  props: {
    align: { default: void 0 },
    bodyBgVariant: { default: void 0 },
    bodyClass: { default: void 0 },
    bodyTag: { default: "div" },
    bodyText: { default: "" },
    bodyTextVariant: { default: void 0 },
    borderVariant: { default: null },
    footer: { default: void 0 },
    footerBgVariant: { default: void 0 },
    footerBorderVariant: { default: void 0 },
    footerClass: { default: void 0 },
    footerHtml: { default: "" },
    footerTag: { default: "div" },
    footerTextVariant: { default: void 0 },
    footerVariant: { default: null },
    header: { default: void 0 },
    headerBgVariant: { default: void 0 },
    headerBorderVariant: { default: void 0 },
    headerClass: { default: void 0 },
    headerHtml: { default: "" },
    headerTag: { default: "div" },
    headerTextVariant: { default: void 0 },
    headerVariant: { default: null },
    imgAlt: { default: void 0 },
    imgPlacement: { default: "top" },
    imgHeight: { default: void 0 },
    imgSrc: { default: void 0 },
    imgWidth: { default: void 0 },
    noBody: { type: Boolean, default: false },
    subtitle: { default: void 0 },
    subtitleTag: { default: "h6" },
    subtitleTextVariant: { default: "body-secondary" },
    tag: { default: "div" },
    title: { default: void 0 },
    titleTag: { default: "h4" },
    variant: { default: null },
    bgVariant: { default: null },
    textVariant: { default: null }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BCard");
    const slots = useSlots();
    const hasHeaderSlot = computed(() => !isEmptySlot(slots.header));
    const hasFooterSlot = computed(() => !isEmptySlot(slots.footer));
    const resolvedBackgroundClasses = useColorVariantClasses(props);
    const computedClasses = computed(() => [
      resolvedBackgroundClasses.value,
      {
        [`text-${props.align}`]: props.align !== void 0,
        [`border-${props.borderVariant}`]: props.borderVariant !== null,
        "flex-row": props.imgPlacement === "start",
        "flex-row-reverse": props.imgPlacement === "end"
      }
    ]);
    const imgAttr = computed(() => ({
      src: props.imgSrc,
      alt: props.imgAlt,
      height: props.imgHeight,
      width: props.imgWidth,
      placement: props.imgPlacement
    }));
    const ReusableImg = createReusableTemplate();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        class: normalizeClass(["card", computedClasses.value])
      }, {
        default: withCtx(() => [
          createVNode(unref(ReusableImg).define, null, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "img", {}, () => [
                unref(props).imgSrc ? (openBlock(), createBlock(_sfc_main$7, normalizeProps(mergeProps({ key: 0 }, imgAttr.value)), null, 16)) : createCommentVNode("", true)
              ])
            ]),
            _: 3
          }),
          unref(props).imgPlacement !== "bottom" ? (openBlock(), createBlock(unref(ReusableImg).reuse, { key: 0 })) : createCommentVNode("", true),
          unref(props).header || hasHeaderSlot.value || unref(props).headerHtml ? (openBlock(), createBlock(_sfc_main$5, {
            key: 1,
            "bg-variant": unref(props).headerBgVariant,
            variant: unref(props).headerVariant,
            "border-variant": unref(props).headerBorderVariant,
            html: unref(props).headerHtml,
            tag: unref(props).headerTag,
            "text-variant": unref(props).headerTextVariant,
            class: normalizeClass(unref(props).headerClass)
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "header", {}, () => [
                createTextVNode(toDisplayString(unref(props).header), 1)
              ])
            ]),
            _: 3
          }, 8, ["bg-variant", "variant", "border-variant", "html", "tag", "text-variant", "class"])) : createCommentVNode("", true),
          !unref(props).noBody ? (openBlock(), createBlock(_sfc_main$2, {
            key: 2,
            overlay: unref(props).imgPlacement === "overlay",
            "bg-variant": unref(props).bodyBgVariant,
            tag: unref(props).bodyTag,
            "text-variant": unref(props).bodyTextVariant,
            subtitle: unref(props).subtitle,
            "subtitle-tag": unref(props).subtitleTag,
            "subtitle-text-variant": unref(props).subtitleTextVariant,
            title: unref(props).title,
            "title-tag": unref(props).titleTag,
            class: normalizeClass(unref(props).bodyClass)
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "default", {}, () => [
                createTextVNode(toDisplayString(unref(props).bodyText), 1)
              ])
            ]),
            _: 3
          }, 8, ["overlay", "bg-variant", "tag", "text-variant", "subtitle", "subtitle-tag", "subtitle-text-variant", "title", "title-tag", "class"])) : renderSlot(_ctx.$slots, "default", { key: 3 }, () => [
            createTextVNode(toDisplayString(unref(props).bodyText), 1)
          ]),
          unref(props).footer || hasFooterSlot.value || unref(props).footerHtml ? (openBlock(), createBlock(_sfc_main$1, {
            key: 4,
            "bg-variant": unref(props).footerBgVariant,
            "border-variant": unref(props).footerBorderVariant,
            variant: unref(props).footerVariant,
            html: unref(props).footerHtml,
            tag: unref(props).footerTag,
            "text-variant": unref(props).footerTextVariant,
            class: normalizeClass(unref(props).footerClass)
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "footer", {}, () => [
                createTextVNode(toDisplayString(unref(props).footer), 1)
              ])
            ]),
            _: 3
          }, 8, ["bg-variant", "border-variant", "variant", "html", "tag", "text-variant", "class"])) : createCommentVNode("", true),
          unref(props).imgPlacement === "bottom" ? (openBlock(), createBlock(unref(ReusableImg).reuse, { key: 5 })) : createCommentVNode("", true)
        ]),
        _: 3
      }, 8, ["class"]);
    };
  }
});
export {
  _sfc_main as _,
  _sfc_main$2 as a,
  _sfc_main$1 as b,
  _sfc_main$5 as c,
  _sfc_main$7 as d,
  _sfc_main$3 as e,
  _sfc_main$4 as f
};
//# sourceMappingURL=BCard.vue_vue_type_script_setup_true_lang-D-O5edl8.mjs.map
