import { defineComponent, openBlock, createElementBlock, createBlock, resolveDynamicComponent, unref, createElementVNode, mergeProps, renderSlot, computed, normalizeClass, withCtx, createTextVNode, toDisplayString, useAttrs, inject } from "vue";
import { u as useDefaults } from "./useDefaults-BYx9NNxn.mjs";
import { _ as _sfc_main$7 } from "./BLink.vue_vue_type_script_setup_true_lang-C39-ereM.mjs";
import { u as useBLinkHelper } from "./useBLinkHelper-Bvtov_sk.mjs";
import { c as collapseInjectionKey, e as dropdownInjectionKey, n as navbarInjectionKey } from "./keys-CLEaYsGj.mjs";
const _hoisted_1$5 = { role: "presentation" };
const _sfc_main$6 = /* @__PURE__ */ defineComponent({
  __name: "BDropdownDivider",
  props: {
    tag: { default: "hr" }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BDropdownDivider");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", _hoisted_1$5, [
        (openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
          class: "dropdown-divider",
          role: "separator",
          "aria-orientation": "horizontal"
        }))
      ]);
    };
  }
});
const _hoisted_1$4 = { role: "presentation" };
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "BDropdownForm",
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", _hoisted_1$4, [
        createElementVNode("form", mergeProps({ class: "dropdown-item-text" }, _ctx.$attrs), [
          renderSlot(_ctx.$slots, "default")
        ], 16)
      ]);
    };
  }
});
const _hoisted_1$3 = { role: "presentation" };
const _hoisted_2 = ["id", "aria-describedby"];
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BDropdownGroup",
  props: {
    ariaDescribedby: { default: void 0 },
    header: { default: void 0 },
    headerClass: { default: void 0 },
    headerTag: { default: "header" },
    headerVariant: { default: null },
    id: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BDropdownGroup");
    const headerId = computed(() => props.id ? `${props.id}_group_dd_header` : void 0);
    const headerRole = computed(() => props.headerTag === "header" ? void 0 : "heading");
    const computedClasses = computed(() => [
      props.headerClass,
      {
        [`text-${props.headerVariant}`]: props.headerVariant !== null
      }
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", _hoisted_1$3, [
        (openBlock(), createBlock(resolveDynamicComponent(unref(props).headerTag), {
          id: headerId.value,
          class: normalizeClass(["dropdown-header", computedClasses.value]),
          role: headerRole.value
        }, {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "header", {}, () => [
              createTextVNode(toDisplayString(unref(props).header), 1)
            ])
          ]),
          _: 3
        }, 8, ["id", "class", "role"])),
        createElementVNode("ul", mergeProps({
          id: unref(props).id,
          role: "group",
          class: "list-unstyled"
        }, _ctx.$attrs, {
          "aria-describedby": unref(props).ariaDescribedby || headerId.value
        }), [
          renderSlot(_ctx.$slots, "default")
        ], 16, _hoisted_2)
      ]);
    };
  }
});
const _hoisted_1$2 = { class: "dropdown-header" };
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "BDropdownHeader",
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", null, [
        createElementVNode("h6", _hoisted_1$2, [
          renderSlot(_ctx.$slots, "default")
        ])
      ]);
    };
  }
});
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BDropdownItem",
  props: {
    linkClass: { default: void 0 },
    wrapperAttrs: { default: void 0 },
    active: { type: Boolean, default: void 0 },
    activeClass: { default: void 0 },
    disabled: { type: Boolean, default: void 0 },
    exactActiveClass: { default: void 0 },
    href: { default: void 0 },
    icon: { type: Boolean, default: void 0 },
    noRel: { type: Boolean },
    opacity: { default: void 0 },
    opacityHover: { default: void 0 },
    rel: { default: void 0 },
    replace: { type: Boolean, default: void 0 },
    routerComponentName: { default: void 0 },
    stretched: { type: Boolean, default: false },
    target: { default: void 0 },
    to: { default: void 0 },
    underlineOffset: { default: void 0 },
    underlineOffsetHover: { default: void 0 },
    underlineOpacity: { default: void 0 },
    underlineOpacityHover: { default: void 0 },
    underlineVariant: { default: void 0 },
    variant: { default: null }
  },
  emits: ["click"],
  setup(__props, { emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BDropdownItem");
    const emit = __emit;
    const { class: wrapperClass, ...attrs } = useAttrs();
    const { computedLink, computedLinkProps } = useBLinkHelper(props);
    const computedClasses = computed(() => [
      props.linkClass,
      {
        active: props.active,
        disabled: props.disabled,
        [`text-${props.variant}`]: props.variant !== null
      }
    ]);
    const computedTag = computed(() => computedLink.value ? _sfc_main$7 : props.href ? "a" : "button");
    const collapseData = inject(collapseInjectionKey, null);
    const dropdownData = inject(dropdownInjectionKey, null);
    const navbarData = inject(navbarInjectionKey, null);
    const clicked = (e) => {
      var _a, _b, _c;
      emit("click", e);
      if (navbarData !== null && ((_a = navbarData == null ? void 0 : navbarData.autoClose) == null ? void 0 : _a.value) === true) {
        (_b = collapseData == null ? void 0 : collapseData.hide) == null ? void 0 : _b.call(collapseData);
      }
      (_c = dropdownData == null ? void 0 : dropdownData.hide) == null ? void 0 : _c.call(dropdownData);
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", mergeProps({
        role: "presentation",
        class: unref(wrapperClass)
      }, unref(props).wrapperAttrs), [
        (openBlock(), createBlock(resolveDynamicComponent(computedTag.value), mergeProps({
          class: ["dropdown-item", computedClasses.value],
          disabled: unref(props).disabled,
          "aria-disabled": unref(props).disabled ? true : null,
          "aria-current": unref(props).active ? true : null,
          href: computedTag.value === "a" ? unref(props).href : null,
          rel: unref(props).rel,
          role: "menuitem",
          type: computedTag.value === "button" ? "button" : null,
          target: unref(props).target
        }, { ...unref(computedLinkProps), ...attrs }, { onClick: clicked }), {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default")
          ]),
          _: 3
        }, 16, ["class", "disabled", "aria-disabled", "aria-current", "href", "rel", "type", "target"]))
      ], 16);
    };
  }
});
const _hoisted_1$1 = ["disabled"];
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BDropdownItemButton",
  props: {
    active: { type: Boolean, default: false },
    activeClass: { default: "active" },
    buttonClass: { default: void 0 },
    wrapperAttrs: { default: void 0 },
    disabled: { type: Boolean, default: false },
    variant: { default: null }
  },
  emits: ["click"],
  setup(__props, { emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BDropdownItemButton");
    const emit = __emit;
    const { class: wrapperClass, ...attrs } = useAttrs();
    const computedClasses = computed(() => [
      props.buttonClass,
      {
        [props.activeClass]: props.active,
        disabled: props.disabled,
        [`text-${props.variant}`]: props.variant !== null
      }
    ]);
    const clicked = (e) => {
      emit("click", e);
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", mergeProps({
        role: "presentation",
        class: unref(wrapperClass)
      }, unref(props).wrapperAttrs), [
        createElementVNode("button", mergeProps({
          role: "menu",
          type: "button",
          class: ["dropdown-item", computedClasses.value],
          disabled: unref(props).disabled
        }, attrs, { onClick: clicked }), [
          renderSlot(_ctx.$slots, "default")
        ], 16, _hoisted_1$1)
      ], 16);
    };
  }
});
const _hoisted_1 = { role: "presentation" };
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BDropdownText",
  props: {
    text: { default: "" }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BDropdownText");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", _hoisted_1, [
        createElementVNode("span", mergeProps({ class: "dropdown-item-text" }, _ctx.$attrs), [
          renderSlot(_ctx.$slots, "default", {}, () => [
            createTextVNode(toDisplayString(unref(props).text), 1)
          ])
        ], 16)
      ]);
    };
  }
});
export {
  _sfc_main$6 as _,
  _sfc_main$5 as a,
  _sfc_main$4 as b,
  _sfc_main$3 as c,
  _sfc_main$2 as d,
  _sfc_main$1 as e,
  _sfc_main as f
};
//# sourceMappingURL=BDropdownText.vue_vue_type_script_setup_true_lang-BG9DP53V.mjs.map
