import { defineComponent, mergeModels, useSlots, useModel, ref, computed, watch, openBlock, createElementBlock, Fragment, unref, normalizeClass, renderSlot, createTextVNode, toDisplayString, createCommentVNode, createElementVNode, mergeProps } from "vue";
import { e as useFocus } from "./index-DngH9Pjm.mjs";
import { u as useDefaults } from "./useDefaults-BYx9NNxn.mjs";
import { u as useId } from "./useId-BrAgQfKM.mjs";
import { u as useStateClass } from "./useStateClass-BGbSLWFN.mjs";
import { i as isEmptySlot } from "./dom-B-SQyhbA.mjs";
const _hoisted_1 = ["for"];
const _hoisted_2 = ["id", "form", "name", "multiple", "disabled", "capture", "accept", "required", "aria-label", "aria-labelledby", "aria-required", "directory", "webkitdirectory"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BFormFile",
  props: /* @__PURE__ */ mergeModels({
    ariaLabel: { default: void 0 },
    ariaLabelledby: { default: void 0 },
    accept: { default: "" },
    autofocus: { type: Boolean, default: false },
    capture: { type: [Boolean, String], default: false },
    directory: { type: Boolean, default: false },
    disabled: { type: Boolean, default: false },
    form: { default: void 0 },
    id: { default: void 0 },
    label: { default: "" },
    labelClass: { default: void 0 },
    multiple: { type: Boolean, default: false },
    name: { default: void 0 },
    noButton: { type: Boolean, default: false },
    noDrop: { type: Boolean, default: false },
    noTraverse: { type: Boolean, default: false },
    plain: { type: Boolean, default: false },
    required: { type: Boolean, default: false },
    size: { default: void 0 },
    state: { type: [Boolean, null], default: null }
  }, {
    "modelValue": {
      default: null
    },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props, { expose: __expose }) {
    const slots = useSlots();
    const _props = __props;
    const props = useDefaults(_props, "BFormFile");
    const modelValue = useModel(__props, "modelValue");
    const computedId = useId(() => props.id);
    const stateClass = useStateClass(() => props.state);
    const input = ref(null);
    const { focused } = useFocus(input, { initialValue: props.autofocus });
    const hasLabelSlot = computed(() => !isEmptySlot(slots["label"]));
    const computedAccept = computed(
      () => typeof props.accept === "string" ? props.accept : props.accept.join(",")
    );
    const computedClasses = computed(() => [
      stateClass.value,
      {
        [`form-control-${props.size}`]: props.size !== void 0,
        "form-control": !props.plain,
        "form-control-input-file-hide-button": props.noButton
      }
    ]);
    const onChange = () => {
      var _a, _b;
      const value = ((_a = input.value) == null ? void 0 : _a.files) === null || ((_b = input.value) == null ? void 0 : _b.files) === void 0 ? null : [...input.value.files];
      modelValue.value = value === null ? null : props.multiple === true ? value : value[0];
    };
    const onDrop = (e) => {
      if (props.noDrop === true) {
        e.preventDefault();
      }
    };
    const reset = () => {
      modelValue.value = null;
    };
    watch(modelValue, (newValue) => {
      if (newValue === null && input.value !== null) {
        input.value.value = "";
      }
    });
    __expose({
      blur: () => {
        focused.value = false;
      },
      element: input,
      focus: () => {
        focused.value = true;
      },
      reset
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [
        hasLabelSlot.value || unref(props).label ? (openBlock(), createElementBlock("label", {
          key: 0,
          class: normalizeClass(["form-label", unref(props).labelClass]),
          for: unref(computedId)
        }, [
          renderSlot(_ctx.$slots, "label", {}, () => [
            createTextVNode(toDisplayString(unref(props).label), 1)
          ])
        ], 10, _hoisted_1)) : createCommentVNode("", true),
        createElementVNode("input", mergeProps({ id: unref(computedId) }, _ctx.$attrs, {
          ref_key: "input",
          ref: input,
          type: "file",
          class: computedClasses.value,
          form: unref(props).form,
          name: unref(props).name,
          multiple: unref(props).multiple,
          disabled: unref(props).disabled,
          capture: unref(props).capture,
          accept: computedAccept.value || void 0,
          required: unref(props).required || void 0,
          "aria-label": unref(props).ariaLabel,
          "aria-labelledby": unref(props).ariaLabelledby,
          "aria-required": unref(props).required || void 0,
          directory: unref(props).directory,
          webkitdirectory: unref(props).directory,
          onChange,
          onDrop
        }), null, 16, _hoisted_2)
      ], 64);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BFormFile.vue_vue_type_script_setup_true_lang-vYYrIhR7.mjs.map
