import { defineComponent, computed, openBlock, createElementBlock, unref, renderSlot, Fragment, renderList, createBlock, withCtx, createTextVNode, toDisplayString, createElementVNode } from "vue";
import { u as useFormSelect, _ as _sfc_main$2 } from "./useFormSelect-C5Ssz8Hc.mjs";
import { u as useDefaults } from "./useDefaults-BYx9NNxn.mjs";
import { u as useId } from "./useId-BrAgQfKM.mjs";
const _hoisted_1$1 = ["id"];
const _hoisted_2$1 = ["innerHTML"];
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BFormDatalist",
  props: {
    disabledField: { default: "disabled" },
    htmlField: { default: "html" },
    id: { default: void 0 },
    options: { default: () => [] },
    textField: { default: "text" },
    valueField: { default: "value" }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BFormDatalist");
    const computedId = useId(() => props.id, "datalist");
    const { normalizedOptions, isComplex } = useFormSelect(
      () => props.options,
      computed(() => ({ ...props, optionsField: "options", labelField: "label" }))
    );
    const normalizedOptsWrapper = computed(
      () => (
        // Datalist doesn't support complex options
        normalizedOptions.value.filter((opt) => !isComplex(opt))
      )
    );
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("datalist", { id: unref(computedId) }, [
        renderSlot(_ctx.$slots, "first"),
        (openBlock(true), createElementBlock(Fragment, null, renderList(normalizedOptsWrapper.value, (option, index) => {
          return openBlock(), createBlock(_sfc_main$2, {
            key: index,
            value: option.value,
            disabled: option.disabled
          }, {
            default: withCtx(() => [
              !!option.html ? (openBlock(), createElementBlock("span", {
                key: 0,
                innerHTML: option.html
              }, null, 8, _hoisted_2$1)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                createTextVNode(toDisplayString(option.text), 1)
              ], 64))
            ]),
            _: 2
          }, 1032, ["value", "disabled"]);
        }), 128)),
        renderSlot(_ctx.$slots, "default")
      ], 8, _hoisted_1$1);
    };
  }
});
const _hoisted_1 = { class: "form-floating" };
const _hoisted_2 = ["for"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BFormFloatingLabel",
  props: {
    label: { default: void 0 },
    labelFor: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BFormFloatingLabel");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1, [
        renderSlot(_ctx.$slots, "default"),
        createElementVNode("label", {
          for: unref(props).labelFor
        }, [
          renderSlot(_ctx.$slots, "label", {}, () => [
            createTextVNode(toDisplayString(unref(props).label), 1)
          ])
        ], 8, _hoisted_2)
      ]);
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BFormFloatingLabel.vue_vue_type_script_setup_true_lang-2jJXsB8X.mjs.map
