import { u as useAriaInvalid } from "./useAriaInvalid-BTUbGj3Y.mjs";
import { l as RX_SPACE_SPLIT } from "./constants-BdrZaBP8.mjs";
import { a as isVisible, b as attemptFocus } from "./dom-B-SQyhbA.mjs";
import { defineComponent, ref, computed, watch, onMounted, nextTick, h } from "vue";
import { _ as _sfc_main$1 } from "./BCol.vue_vue_type_script_setup_true_lang-DlKSUEf4.mjs";
import { _ as _sfc_main$2, a as _sfc_main$3, b as _sfc_main$4, c as _sfc_main$5 } from "./BFormValidFeedback.vue_vue_type_script_setup_true_lang-DSA6Ix_l.mjs";
import { u as upperFirst } from "./stringUtils-i6NkPGA1.mjs";
import { I as IS_BROWSER } from "./event-aFP-C_yt.mjs";
import { u as useStateClass } from "./useStateClass-BGbSLWFN.mjs";
import { u as useId } from "./useId-BrAgQfKM.mjs";
const suffixPropName = (suffix, value) => value + (suffix ? upperFirst(suffix) : "");
const normalizeSlot = (name, scope = {}, $slots = {}) => {
  const names = [name];
  let slot;
  for (let i = 0; i < names.length && !slot; i++) {
    const name2 = names[i];
    slot = $slots[name2];
  }
  return slot && typeof slot === "function" ? slot(scope) : slot;
};
const INPUTS = ["input", "select", "textarea"];
const INPUT_SELECTOR = INPUTS.map((v) => `${v}:not([disabled])`).join();
const LEGEND_INTERACTIVE_ELEMENTS = [...INPUTS, "a", "button", "label"];
const SLOT_NAME_LABEL = "label";
const SLOT_NAME_INVALID_FEEDBACK = "invalid-feedback";
const SLOT_NAME_VALID_FEEDBACK = "valid-feedback";
const SLOT_NAME_DESCRIPTION = "description";
const SLOT_NAME_DEFAULT = "default";
const _sfc_main = defineComponent({
  components: { BCol: _sfc_main$1, BFormInvalidFeedback: _sfc_main$2, BFormRow: _sfc_main$3, BFormText: _sfc_main$4, BFormValidFeedback: _sfc_main$5 },
  props: {
    ariaInvalid: { type: [Boolean, String], default: void 0 },
    contentCols: { type: [Boolean, String, Number], default: void 0 },
    contentColsLg: { type: [Boolean, String, Number], default: void 0 },
    contentColsMd: { type: [Boolean, String, Number], default: void 0 },
    contentColsSm: { type: [Boolean, String, Number], default: void 0 },
    contentColsXl: { type: [Boolean, String, Number], default: void 0 },
    description: { type: [String], default: void 0 },
    disabled: { type: Boolean, default: false },
    feedbackAriaLive: { type: String, default: "assertive" },
    floating: { type: Boolean, default: false },
    id: { type: String, default: void 0 },
    invalidFeedback: { type: String, default: void 0 },
    label: { type: String, default: void 0 },
    labelAlign: { type: [String], default: void 0 },
    labelAlignLg: { type: [String], default: void 0 },
    labelAlignMd: { type: [String], default: void 0 },
    labelAlignSm: { type: [String], default: void 0 },
    labelAlignXl: { type: [String], default: void 0 },
    labelClass: { type: [Array, Object, String], default: void 0 },
    labelCols: { type: [Boolean, String, Number], default: void 0 },
    labelColsLg: { type: [Boolean, String, Number], default: void 0 },
    labelColsMd: { type: [Boolean, String, Number], default: void 0 },
    labelColsSm: { type: [Boolean, String, Number], default: void 0 },
    labelColsXl: { type: [Boolean, String, Number], default: void 0 },
    labelFor: { type: String, default: void 0 },
    labelSize: { type: String, default: void 0 },
    labelVisuallyHidden: { type: Boolean, default: false },
    state: { type: Boolean, default: null },
    tooltip: { type: Boolean, default: false },
    validFeedback: { type: String, default: void 0 },
    validated: { type: Boolean, default: false }
  },
  setup(props) {
    const ariaDescribedby = null;
    const breakPoints = ["xs", "sm", "md", "lg", "xl"];
    const getAlignClasses = (props2, prefix) => breakPoints.reduce((result, breakpoint) => {
      const suffix = suffixPropName(breakpoint === "xs" ? "" : breakpoint, `${prefix}Align`);
      const propValue = props2[suffix] || null;
      if (propValue) {
        breakpoint === "xs" ? result.push(`text-${propValue}`) : result.push(`text-${breakpoint}-${propValue}`);
      }
      return result;
    }, []);
    const getColProps = (props2, prefix) => (
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      breakPoints.reduce((result, breakpoint) => {
        const suffix = suffixPropName(breakpoint === "xs" ? "" : breakpoint, `${prefix}Cols`);
        let propValue = props2[suffix];
        propValue = propValue === "" ? true : propValue || false;
        if (!(typeof propValue === "boolean") && propValue !== "auto") {
          const val = Number.parseInt(propValue);
          propValue = Number.isNaN(val) ? 0 : val;
          propValue = propValue > 0 ? propValue : false;
        }
        if (propValue) {
          if (breakpoint === "xs") {
            result[typeof propValue === "boolean" ? "col" : "cols"] = propValue;
          } else {
            result[breakpoint || (typeof propValue === "boolean" ? "col" : "cols")] = propValue;
          }
        }
        return result;
      }, {})
    );
    const content = ref(null);
    const updateAriaDescribedby = (newValue, oldValue = null) => {
      if (IS_BROWSER && props.labelFor && content.value !== null) {
        const $input = content.value.querySelector(`#${CSS.escape(props.labelFor)}`);
        if ($input) {
          const attr = "aria-describedby";
          const newIds = (newValue || "").split(RX_SPACE_SPLIT);
          const oldIds = (oldValue || "").split(RX_SPACE_SPLIT);
          const ids = ($input.getAttribute(attr) || "").split(RX_SPACE_SPLIT).filter((id) => !oldIds.includes(id)).concat(newIds).filter((id, index, ids2) => ids2.indexOf(id) === index).filter((x) => x).join(" ").trim();
          if (ids) {
            $input.setAttribute(attr, ids);
          } else {
            $input.removeAttribute(attr);
          }
        }
      }
    };
    const contentColProps = computed(() => getColProps(props, "content"));
    const labelAlignClasses = computed(() => getAlignClasses(props, "label"));
    const labelColProps = computed(() => getColProps(props, "label"));
    const isHorizontal = computed(
      () => (
        // Determine if the form group will be rendered horizontal
        // based on the existence of 'content-col' or 'label-col' props
        Object.keys(contentColProps.value).length > 0 || Object.keys(labelColProps.value).length > 0
      )
    );
    const stateClass = useStateClass(() => props.state);
    const computedAriaInvalid = useAriaInvalid(
      () => props.ariaInvalid,
      () => props.state
    );
    watch(
      () => ariaDescribedby,
      (newValue, oldValue) => {
        if (newValue !== oldValue) {
          updateAriaDescribedby(newValue, oldValue);
        }
      }
    );
    onMounted(() => {
      nextTick(() => {
        updateAriaDescribedby(ariaDescribedby);
      });
    });
    const onLegendClick = (event) => {
      if (props.labelFor || content.value === null) return;
      const { target } = event;
      const tagName = target ? target.tagName : "";
      if (LEGEND_INTERACTIVE_ELEMENTS.indexOf(tagName) !== -1) return;
      const inputs = [...content.value.querySelectorAll(INPUT_SELECTOR)].filter(isVisible);
      const [inp] = inputs;
      if (inputs.length === 1 && inp instanceof HTMLElement) {
        attemptFocus(inp);
      }
    };
    return {
      ariaDescribedby,
      computedAriaInvalid,
      contentColProps,
      isHorizontal,
      labelAlignClasses,
      labelColProps,
      onLegendClick,
      stateClass
    };
  },
  render() {
    const props = this.$props;
    const slots = this.$slots;
    const id = useId();
    const isFieldset = !props.labelFor;
    let $label = null;
    const labelContent = normalizeSlot(SLOT_NAME_LABEL, {}, slots) || props.label;
    const labelId = labelContent ? useId(void 0, "_BV_label_").value : null;
    if (labelContent || this.isHorizontal) {
      const labelTag = isFieldset ? "legend" : "label";
      if (props.labelVisuallyHidden) {
        if (labelContent) {
          $label = h(
            labelTag,
            {
              class: "visually-hidden",
              id: labelId,
              for: props.labelFor || null
            },
            labelContent
          );
        }
        if (this.isHorizontal) {
          $label = h(_sfc_main$1, this.labelColProps, { default: () => $label });
        } else {
          $label = h("div", {}, [$label]);
        }
      } else {
        const renderProps = {
          onClick: isFieldset ? this.onLegendClick : null,
          ...this.isHorizontal ? this.labelColProps : {},
          tag: this.isHorizontal ? labelTag : null,
          id: labelId,
          for: props.labelFor || null,
          tabIndex: isFieldset ? "-1" : null,
          class: [
            this.isHorizontal ? "col-form-label" : "form-label",
            {
              "bv-no-focus-ring": isFieldset,
              "col-form-label": this.isHorizontal || isFieldset,
              "pt-0": !this.isHorizontal && isFieldset,
              "d-block": !this.isHorizontal && !isFieldset,
              [`col-form-label-${props.labelSize}`]: !!props.labelSize
            },
            this.labelAlignClasses,
            props.labelClass
          ]
        };
        if (this.isHorizontal) {
          $label = h(_sfc_main$1, renderProps, { default: () => labelContent });
        } else {
          $label = h(labelTag, renderProps, labelContent);
        }
      }
    }
    let $invalidFeedback = null;
    const invalidFeedbackContent = normalizeSlot(SLOT_NAME_INVALID_FEEDBACK, {}, slots) || this.invalidFeedback;
    const invalidFeedbackId = invalidFeedbackContent ? useId(void 0, "_BV_feedback_invalid_").value : void 0;
    if (invalidFeedbackContent) {
      $invalidFeedback = h(
        _sfc_main$2,
        {
          ariaLive: props.feedbackAriaLive,
          id: invalidFeedbackId,
          state: props.state,
          tooltip: props.tooltip
        },
        { default: () => invalidFeedbackContent }
      );
    }
    let $validFeedback = null;
    const validFeedbackContent = normalizeSlot(SLOT_NAME_VALID_FEEDBACK, {}, slots) || this.validFeedback;
    const validFeedbackId = validFeedbackContent ? useId(void 0, "_BV_feedback_valid_").value : void 0;
    if (validFeedbackContent) {
      $validFeedback = h(
        _sfc_main$5,
        {
          ariaLive: props.feedbackAriaLive,
          id: validFeedbackId,
          state: props.state,
          tooltip: props.tooltip
        },
        { default: () => validFeedbackContent }
        // validFeedbackContent
      );
    }
    let $description = null;
    const descriptionContent = normalizeSlot(SLOT_NAME_DESCRIPTION, {}, slots) || this.description;
    const descriptionId = descriptionContent ? useId(void 0, "_BV_description_").value : void 0;
    if (descriptionContent) {
      $description = h(
        _sfc_main$4,
        {
          id: descriptionId
        },
        { default: () => descriptionContent }
      );
    }
    const ariaDescribedby = this.ariaDescribedby = [
      descriptionId,
      props.state === false ? invalidFeedbackId : null,
      props.state === true ? validFeedbackId : null
    ].filter((x) => x).join(" ") || null;
    const contentBlocks = [
      normalizeSlot(SLOT_NAME_DEFAULT, { ariaDescribedby, descriptionId, id, labelId }, slots) || "",
      $invalidFeedback,
      $validFeedback,
      $description
    ];
    if (!this.isHorizontal && props.floating) contentBlocks.push($label);
    let $content = h(
      "div",
      {
        ref: "content",
        class: [
          {
            "form-floating": !this.isHorizontal && props.floating
          }
        ]
      },
      contentBlocks
    );
    if (this.isHorizontal) {
      $content = h(_sfc_main$1, { ref: "content", ...this.contentColProps }, { default: () => contentBlocks });
    }
    const rowProps = {
      "class": [
        this.stateClass,
        {
          "was-validated": props.validated
        }
      ],
      "id": useId(() => props.id).value,
      "disabled": isFieldset ? props.disabled : null,
      "role": isFieldset ? null : "group",
      "aria-invalid": this.computedAriaInvalid,
      // Only apply `aria-labelledby` if we are a horizontal fieldset
      // as the legend is no longer a direct child of fieldset
      "aria-labelledby": isFieldset && this.isHorizontal ? labelId : null
    };
    if (this.isHorizontal && !isFieldset) {
      return h(_sfc_main$3, rowProps, { default: () => [$label, $content] });
    }
    return h(
      isFieldset ? "fieldset" : "div",
      rowProps,
      this.isHorizontal && isFieldset ? [h(_sfc_main$3, null, { default: () => [$label, $content] })] : this.isHorizontal || !props.floating ? [$label, $content] : [$content]
    );
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BFormGroup.vue_vue_type_script_lang-D1K-s0Ci.mjs.map
